/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.AbstractMemoryModel;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.BufferArraysImpl;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DataFile;
import net.algart.arrays.DataFileModel;
import net.algart.arrays.DataStorage;
import net.algart.arrays.DefaultDataFileModel;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IllegalInfoSyntaxException;
import net.algart.arrays.IntArray;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.MappedDataStorages;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MatrixInfo;
import net.algart.arrays.MutableArray;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.StandardIODataFileModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UnsupportedElementTypeException;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatableShortArray;
import net.algart.finalizing.Finalizer;

public final class LargeMemoryModel<P>
extends AbstractMemoryModel {
    static final Finalizer globalArrayFinalizer = new Finalizer();
    static final Finalizer globalMappingFinalizer = new Finalizer();
    static final Finalizer globalStorageFinalizer = new Finalizer();
    static final Logger LOGGER = Logger.getLogger(LargeMemoryModel.class.getName());
    private static final ReferenceQueue<DataFileModel<?>> reapedDataFileModels = new ReferenceQueue();
    static final Map<WeakReference<DataFileModel<?>>, Object> allUsedDataFileModelsWithAutoDeletion = new IdentityHashMap();
    static final int MAX_NUMBER_OF_BANKS_IN_LAZY_FILL_MAP = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.LargeMemoryModel.maxNumberOfBanksInLazyFillMap", 0x10000000));
    static final int DELETION_SLEEP_DELAY = 100;
    static final int DELETION_TIMEOUT_IN_DISPOSE = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.LargeMemoryModel.deletionTimeoutInDispose", 3000));
    static final int DELETION_TIMEOUT_IN_FINALIZATION = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.LargeMemoryModel.deletionTimeoutInFinalization", 5));
    static final int DELETION_TIMEOUT_IN_CLEANER = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.LargeMemoryModel.deletionTimeoutInCleaner", 100));
    static final int DELETION_LOOPS_IN_CLEANER = 4;
    static final int MAX_NUMBER_OF_DELETIONS_WHILE_FINALIZATION = 100;
    private static final DataFileModel<File> GLOBAL_DATA_FILE_MODEL;
    private static final LargeMemoryModel<File> DEFAULT_INSTANCE;
    private final DataFileModel<P> dataFileModel;
    public static final String CONSTANT_PROPERTY_NAME = "net.algart.arrays.MatrixProperty.constantValue";
    public static final String TILE_DIMENSIONS_PROPERTY_NAME = "net.algart.arrays.MatrixProperty.tileDimensions";
    public static final long ALL_FILE = -1L;
    private static final Object DUMMY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LargeMemoryModel(DataFileModel<P> dataFileModel) {
        Objects.requireNonNull(dataFileModel, "Null dataFileModel argument");
        int numberOfBanks = dataFileModel.recommendedNumberOfBanks();
        int bankSizeR = dataFileModel.recommendedBankSize(false);
        MappedDataStorages.MappingSettings.checkBankArguments(numberOfBanks, bankSizeR);
        int bankSizeU = dataFileModel.recommendedBankSize(true);
        MappedDataStorages.MappingSettings.checkBankArguments(numberOfBanks, bankSizeU);
        this.dataFileModel = dataFileModel;
        if (dataFileModel.isAutoDeletionRequested()) {
            MappedDataStorages.installTempCleaner();
            Map<WeakReference<DataFileModel<?>>, Object> map = allUsedDataFileModelsWithAutoDeletion;
            synchronized (map) {
                LargeMemoryModel.reapDataFileModels();
                allUsedDataFileModelsWithAutoDeletion.put(new WeakReference(dataFileModel, reapedDataFileModels), DUMMY);
            }
        }
    }

    public static LargeMemoryModel<File> getInstance() {
        return DEFAULT_INSTANCE;
    }

    public static <P> LargeMemoryModel<P> getInstance(DataFileModel<P> dataFileModel) {
        LargeMemoryModel<P> defInst = (LargeMemoryModel<P>)InternalUtils.cast(DEFAULT_INSTANCE);
        return dataFileModel == defInst.dataFileModel ? defInst : new LargeMemoryModel<P>(dataFileModel);
    }

    public DataFileModel<P> getDataFileModel() {
        return this.dataFileModel;
    }

    @Override
    public MutableArray newEmptyArray(Class<?> elementType) {
        return this.newArray(elementType, 0L, 0L);
    }

    @Override
    public MutableArray newEmptyArray(Class<?> elementType, long initialCapacity) {
        return this.newArray(elementType, initialCapacity, 0L);
    }

    @Override
    public MutableArray newArray(Class<?> elementType, long initialLength) {
        return this.newArray(elementType, initialLength, initialLength);
    }

    @Override
    public UpdatableArray newUnresizableArray(Class<?> elementType, long length) {
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (length < 0L) {
            throw new IllegalArgumentException("Negative array length");
        }
        if (elementType == Boolean.TYPE) {
            MappedDataStorages.MappedBitStorage storage = new MappedDataStorages.MappedBitStorage(this.getMappingSettings(elementType, true));
            BufferArraysImpl.UpdatableBufferBitArray result = new BufferArraysImpl.UpdatableBufferBitArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Character.TYPE) {
            MappedDataStorages.MappedCharStorage storage = new MappedDataStorages.MappedCharStorage(this.getMappingSettings(elementType, true));
            BufferArraysImpl.UpdatableBufferCharArray result = new BufferArraysImpl.UpdatableBufferCharArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Byte.TYPE) {
            MappedDataStorages.MappedByteStorage storage = new MappedDataStorages.MappedByteStorage(this.getMappingSettings(elementType, true));
            BufferArraysImpl.UpdatableBufferByteArray result = new BufferArraysImpl.UpdatableBufferByteArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Short.TYPE) {
            MappedDataStorages.MappedShortStorage storage = new MappedDataStorages.MappedShortStorage(this.getMappingSettings(elementType, true));
            BufferArraysImpl.UpdatableBufferShortArray result = new BufferArraysImpl.UpdatableBufferShortArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Integer.TYPE) {
            MappedDataStorages.MappedIntStorage storage = new MappedDataStorages.MappedIntStorage(this.getMappingSettings(elementType, true));
            BufferArraysImpl.UpdatableBufferIntArray result = new BufferArraysImpl.UpdatableBufferIntArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Long.TYPE) {
            MappedDataStorages.MappedLongStorage storage = new MappedDataStorages.MappedLongStorage(this.getMappingSettings(elementType, true));
            BufferArraysImpl.UpdatableBufferLongArray result = new BufferArraysImpl.UpdatableBufferLongArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Float.TYPE) {
            MappedDataStorages.MappedFloatStorage storage = new MappedDataStorages.MappedFloatStorage(this.getMappingSettings(elementType, true));
            BufferArraysImpl.UpdatableBufferFloatArray result = new BufferArraysImpl.UpdatableBufferFloatArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Double.TYPE) {
            MappedDataStorages.MappedDoubleStorage storage = new MappedDataStorages.MappedDoubleStorage(this.getMappingSettings(elementType, true));
            BufferArraysImpl.UpdatableBufferDoubleArray result = new BufferArraysImpl.UpdatableBufferDoubleArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        throw new UnsupportedElementTypeException("Only primitive element types are allowed in LargeMemoryModel (passed type: " + String.valueOf(elementType) + ")");
    }

    @Override
    public boolean isElementTypeSupported(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        return elementType.isPrimitive();
    }

    @Override
    public boolean areAllPrimitiveElementTypesSupported() {
        return true;
    }

    @Override
    public boolean areAllElementTypesSupported() {
        return false;
    }

    @Override
    public long maxSupportedLength(Class<?> elementType) {
        return DataStorage.maxSupportedLengthImpl(elementType);
    }

    @Override
    public boolean isCreatedBy(Array array) {
        return LargeMemoryModel.isLargeArray(array) && ((MappedDataStorages.MappedStorage)((BufferArraysImpl.AbstractBufferArray)array).storage).ms.dataFileModel == this.dataFileModel;
    }

    public static boolean isLargeArray(Array array) {
        return array instanceof BufferArraysImpl.AbstractBufferArray && ((BufferArraysImpl.AbstractBufferArray)array).storage instanceof MappedDataStorages.MappedStorage;
    }

    public static boolean isTemporary(Array largeArray) {
        Objects.requireNonNull(largeArray, "Null largeArray argument");
        if (!LargeMemoryModel.isLargeArray(largeArray)) {
            throw new IllegalArgumentException("The passed argument is not a large array");
        }
        return ((MappedDataStorages.MappedStorage)((BufferArraysImpl.AbstractBufferArray)largeArray).storage).isAutoDeleted();
    }

    public static void setTemporary(Array largeArray, boolean value) {
        Objects.requireNonNull(largeArray, "Null largeArray argument");
        if (!LargeMemoryModel.isLargeArray(largeArray)) {
            throw new IllegalArgumentException("The passed argument is not a large array");
        }
        ((MappedDataStorages.MappedStorage)((BufferArraysImpl.AbstractBufferArray)largeArray).storage).setAutoDeleted(value);
    }

    public static DataFileModel<?> getDataFileModel(Array largeArray) {
        Objects.requireNonNull(largeArray, "Null largeArray argument");
        if (!LargeMemoryModel.isLargeArray(largeArray)) {
            throw new IllegalArgumentException("The passed argument is not a large array");
        }
        return ((MappedDataStorages.MappedStorage)((BufferArraysImpl.AbstractBufferArray)largeArray).storage).getDataFileModel();
    }

    public P getDataFilePath(Array largeArray) {
        Objects.requireNonNull(largeArray, "Null largeArray argument");
        if (!LargeMemoryModel.isLargeArray(largeArray)) {
            throw new IllegalArgumentException("The passed argument is not a large array");
        }
        Object path = ((MappedDataStorages.MappedStorage)((BufferArraysImpl.AbstractBufferArray)largeArray).storage).getDataFilePath();
        return this.dataFileModel.pathClass().cast(path);
    }

    public <U> LargeMemoryModel<U> cast(Class<U> pathClass) {
        if (!pathClass.isAssignableFrom(this.dataFileModel.pathClass())) {
            throw new ClassCastException("Cannot cast " + LargeMemoryModel.class.getName() + "<" + this.dataFileModel.pathClass().getName() + "> to the type " + LargeMemoryModel.class.getName() + "<" + pathClass.getName() + ">");
        }
        return (LargeMemoryModel)InternalUtils.cast(this);
    }

    public static boolean isCreatedReadOnly(Array largeArray) {
        Objects.requireNonNull(largeArray, "Null largeArray argument");
        if (!LargeMemoryModel.isLargeArray(largeArray)) {
            throw new IllegalArgumentException("The passed argument is not a large array");
        }
        return ((MappedDataStorages.MappedStorage)((BufferArraysImpl.AbstractBufferArray)largeArray).storage).ms.readOnly;
    }

    public PArray asArray(P filePath, Class<?> elementType, long filePosition, long fileAreaSize, ByteOrder byteOrder) throws IOException {
        Objects.requireNonNull(filePath, "Null filePath argument");
        Objects.requireNonNull(elementType, "Null elementType argument");
        if (filePosition < 0L) {
            throw new IllegalArgumentException("Negative filePosition argument");
        }
        if (fileAreaSize < 0L && fileAreaSize != -1L) {
            throw new IllegalArgumentException("Negative fileAreaSize argument");
        }
        Objects.requireNonNull(byteOrder, "Null byteOrder argument");
        try {
            BufferArraysImpl.AbstractBufferArray result;
            DataFile file = this.dataFileModel.getDataFile(filePath, byteOrder);
            fileAreaSize = this.checkFilePositionAndAreaSize(file, filePosition, fileAreaSize, false, true);
            if (elementType == Boolean.TYPE && fileAreaSize > 0xFFFFFFFFFFFFFFFL) {
                throw new TooLargeArrayException("Too large desired bit array length: >2^63-1 bits (" + fileAreaSize + " bytes)");
            }
            if (elementType == Boolean.TYPE) {
                MappedDataStorages.MappedBitStorage storage = new MappedDataStorages.MappedBitStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, true, elementType));
                long length = fileAreaSize >> 3 << 6;
                result = new BufferArraysImpl.BufferBitArray((DataStorage)storage, length, length, 0L, false);
            } else if (elementType == Byte.TYPE) {
                MappedDataStorages.MappedByteStorage storage = new MappedDataStorages.MappedByteStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, true, elementType));
                result = new BufferArraysImpl.BufferByteArray((DataStorage)storage, fileAreaSize, fileAreaSize, 0L, false);
            } else if (elementType == Character.TYPE) {
                MappedDataStorages.MappedCharStorage storage = new MappedDataStorages.MappedCharStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, true, elementType));
                long length = fileAreaSize >> 1;
                result = new BufferArraysImpl.BufferCharArray((DataStorage)storage, length, length, 0L, false);
            } else if (elementType == Short.TYPE) {
                MappedDataStorages.MappedShortStorage storage = new MappedDataStorages.MappedShortStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, true, elementType));
                long length = fileAreaSize >> 1;
                result = new BufferArraysImpl.BufferShortArray((DataStorage)storage, length, length, 0L, false);
            } else if (elementType == Integer.TYPE) {
                MappedDataStorages.MappedIntStorage storage = new MappedDataStorages.MappedIntStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, true, elementType));
                long length = fileAreaSize >> 2;
                result = new BufferArraysImpl.BufferIntArray((DataStorage)storage, length, length, 0L, false);
            } else if (elementType == Long.TYPE) {
                MappedDataStorages.MappedLongStorage storage = new MappedDataStorages.MappedLongStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, true, elementType));
                long length = fileAreaSize >> 3;
                result = new BufferArraysImpl.BufferLongArray((DataStorage)storage, length, length, 0L, false);
            } else if (elementType == Float.TYPE) {
                MappedDataStorages.MappedFloatStorage storage = new MappedDataStorages.MappedFloatStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, true, elementType));
                long length = fileAreaSize >> 2;
                result = new BufferArraysImpl.BufferFloatArray((DataStorage)storage, length, length, 0L, false);
            } else if (elementType == Double.TYPE) {
                MappedDataStorages.MappedDoubleStorage storage = new MappedDataStorages.MappedDoubleStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, true, elementType));
                long length = fileAreaSize >> 3;
                result = new BufferArraysImpl.BufferDoubleArray((DataStorage)storage, length, length, 0L, false);
            } else {
                throw new UnsupportedElementTypeException("Only primitive element types are allowed in LargeMemoryModel (passed type: " + String.valueOf(elementType) + ")");
            }
            BufferArraysImpl.forgetOnDeallocation(result);
            if (filePosition == 0L) {
                result.setNewReadOnlyViewStatus();
            }
            return (PArray)((Object)result);
        }
        catch (IOError e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException ioException = (IOException)throwable;
                throw ioException;
            }
            throw e;
        }
    }

    public UpdatablePArray asUpdatableArray(P filePath, Class<?> elementType, long filePosition, long fileAreaSize, boolean truncate, ByteOrder byteOrder) throws IOException {
        Objects.requireNonNull(filePath, "Null filePath argument");
        Objects.requireNonNull(elementType, "Null elementType argument");
        if (filePosition < 0L) {
            throw new IllegalArgumentException("Negative filePosition argument");
        }
        if (fileAreaSize < 0L && fileAreaSize != -1L) {
            throw new IllegalArgumentException("Negative fileAreaSize argument");
        }
        try {
            BufferArraysImpl.AbstractBufferArray result;
            DataFile file = this.dataFileModel.getDataFile(filePath, byteOrder);
            fileAreaSize = this.checkFilePositionAndAreaSize(file, filePosition, fileAreaSize, truncate, false);
            if (elementType == Boolean.TYPE && fileAreaSize > 0xFFFFFFFFFFFFFFFL) {
                throw new TooLargeArrayException("Too large desired bit array length: >2^63-1 bits (" + fileAreaSize + " bytes)");
            }
            if (elementType == Boolean.TYPE) {
                MappedDataStorages.MappedBitStorage storage = new MappedDataStorages.MappedBitStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, false, elementType));
                long length = fileAreaSize >> 3 << 6;
                result = new BufferArraysImpl.UpdatableBufferBitArray((DataStorage)storage, length, length, 0L, false);
            } else if (elementType == Byte.TYPE) {
                MappedDataStorages.MappedByteStorage storage = new MappedDataStorages.MappedByteStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, false, elementType));
                result = new BufferArraysImpl.UpdatableBufferByteArray((DataStorage)storage, fileAreaSize, fileAreaSize, 0L, false);
            } else if (elementType == Character.TYPE) {
                MappedDataStorages.MappedCharStorage storage = new MappedDataStorages.MappedCharStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, false, elementType));
                long length = fileAreaSize >> 1;
                result = new BufferArraysImpl.UpdatableBufferCharArray((DataStorage)storage, length, length, 0L, false);
            } else if (elementType == Short.TYPE) {
                MappedDataStorages.MappedShortStorage storage = new MappedDataStorages.MappedShortStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, false, elementType));
                long length = fileAreaSize >> 1;
                result = new BufferArraysImpl.UpdatableBufferShortArray((DataStorage)storage, length, length, 0L, false);
            } else if (elementType == Integer.TYPE) {
                MappedDataStorages.MappedIntStorage storage = new MappedDataStorages.MappedIntStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, false, elementType));
                long length = fileAreaSize >> 2;
                result = new BufferArraysImpl.UpdatableBufferIntArray((DataStorage)storage, length, length, 0L, false);
            } else if (elementType == Long.TYPE) {
                MappedDataStorages.MappedLongStorage storage = new MappedDataStorages.MappedLongStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, false, elementType));
                long length = fileAreaSize >> 3;
                result = new BufferArraysImpl.UpdatableBufferLongArray((DataStorage)storage, length, length, 0L, false);
            } else if (elementType == Float.TYPE) {
                MappedDataStorages.MappedFloatStorage storage = new MappedDataStorages.MappedFloatStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, false, elementType));
                long length = fileAreaSize >> 2;
                result = new BufferArraysImpl.UpdatableBufferFloatArray((DataStorage)storage, length, length, 0L, false);
            } else if (elementType == Double.TYPE) {
                MappedDataStorages.MappedDoubleStorage storage = new MappedDataStorages.MappedDoubleStorage(this.getMappingSettings(this.dataFileModel, file, filePosition, filePosition + fileAreaSize, false, elementType));
                long length = fileAreaSize >> 3;
                result = new BufferArraysImpl.UpdatableBufferDoubleArray((DataStorage)storage, length, length, 0L, false);
            } else {
                throw new UnsupportedElementTypeException("Only primitive element types are allowed in LargeMemoryModel (passed type: " + String.valueOf(elementType) + ")");
            }
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        catch (Error e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException ioException = (IOException)throwable;
                throw ioException;
            }
            throw e;
        }
    }

    public BitArray asBitArray(P filePath, long filePosition, long fileAreaSize, ByteOrder byteOrder) throws IOException {
        return (BitArray)this.asArray(filePath, Boolean.TYPE, filePosition, fileAreaSize, byteOrder);
    }

    public UpdatableBitArray asUpdatableBitArray(P filePath, long filePosition, long fileAreaSize, boolean truncate, ByteOrder byteOrder) throws IOException {
        return (UpdatableBitArray)this.asUpdatableArray(filePath, Boolean.TYPE, filePosition, fileAreaSize, truncate, byteOrder);
    }

    public CharArray asCharArray(P filePath, long filePosition, long fileAreaSize, ByteOrder byteOrder) throws IOException {
        return (CharArray)this.asArray(filePath, Character.TYPE, filePosition, fileAreaSize, byteOrder);
    }

    public UpdatableCharArray asUpdatableCharArray(P filePath, long filePosition, long fileAreaSize, boolean truncate, ByteOrder byteOrder) throws IOException {
        return (UpdatableCharArray)this.asUpdatableArray(filePath, Character.TYPE, filePosition, fileAreaSize, truncate, byteOrder);
    }

    public ByteArray asByteArray(P filePath, long filePosition, long fileAreaSize, ByteOrder byteOrder) throws IOException {
        return (ByteArray)this.asArray(filePath, Byte.TYPE, filePosition, fileAreaSize, byteOrder);
    }

    public UpdatableByteArray asUpdatableByteArray(P filePath, long filePosition, long fileAreaSize, boolean truncate, ByteOrder byteOrder) throws IOException {
        return (UpdatableByteArray)this.asUpdatableArray(filePath, Byte.TYPE, filePosition, fileAreaSize, truncate, byteOrder);
    }

    public ShortArray asShortArray(P filePath, long filePosition, long fileAreaSize, ByteOrder byteOrder) throws IOException {
        return (ShortArray)this.asArray(filePath, Short.TYPE, filePosition, fileAreaSize, byteOrder);
    }

    public UpdatableShortArray asUpdatableShortArray(P filePath, long filePosition, long fileAreaSize, boolean truncate, ByteOrder byteOrder) throws IOException {
        return (UpdatableShortArray)this.asUpdatableArray(filePath, Short.TYPE, filePosition, fileAreaSize, truncate, byteOrder);
    }

    public IntArray asIntArray(P filePath, long filePosition, long fileAreaSize, ByteOrder byteOrder) throws IOException {
        return (IntArray)this.asArray(filePath, Integer.TYPE, filePosition, fileAreaSize, byteOrder);
    }

    public UpdatableIntArray asUpdatableIntArray(P filePath, long filePosition, long fileAreaSize, boolean truncate, ByteOrder byteOrder) throws IOException {
        return (UpdatableIntArray)this.asUpdatableArray(filePath, Integer.TYPE, filePosition, fileAreaSize, truncate, byteOrder);
    }

    public LongArray asLongArray(P filePath, long filePosition, long fileAreaSize, ByteOrder byteOrder) throws IOException {
        return (LongArray)this.asArray(filePath, Long.TYPE, filePosition, fileAreaSize, byteOrder);
    }

    public UpdatableLongArray asUpdatableLongArray(P filePath, long filePosition, long fileAreaSize, boolean truncate, ByteOrder byteOrder) throws IOException {
        return (UpdatableLongArray)this.asUpdatableArray(filePath, Long.TYPE, filePosition, fileAreaSize, truncate, byteOrder);
    }

    public FloatArray asFloatArray(P filePath, long filePosition, long fileAreaSize, ByteOrder byteOrder) throws IOException {
        return (FloatArray)this.asArray(filePath, Float.TYPE, filePosition, fileAreaSize, byteOrder);
    }

    public UpdatableFloatArray asUpdatableFloatArray(P filePath, long filePosition, long fileAreaSize, boolean truncate, ByteOrder byteOrder) throws IOException {
        return (UpdatableFloatArray)this.asUpdatableArray(filePath, Float.TYPE, filePosition, fileAreaSize, truncate, byteOrder);
    }

    public DoubleArray asDoubleArray(P filePath, long filePosition, long fileAreaSize, ByteOrder byteOrder) throws IOException {
        return (DoubleArray)this.asArray(filePath, Double.TYPE, filePosition, fileAreaSize, byteOrder);
    }

    public UpdatableDoubleArray asUpdatableDoubleArray(P filePath, long filePosition, long fileAreaSize, boolean truncate, ByteOrder byteOrder) throws IOException {
        return (UpdatableDoubleArray)this.asUpdatableArray(filePath, Double.TYPE, filePosition, fileAreaSize, truncate, byteOrder);
    }

    public static Matrix<? extends PArray> asConstantMatrix(MatrixInfo matrixInfo) throws IllegalInfoSyntaxException {
        Objects.requireNonNull(matrixInfo, "Null matrixInfo argument");
        return LargeMemoryModel.getNCopiesMatrix(matrixInfo, matrixInfo.additionalProperties());
    }

    public Matrix<? extends PArray> asMatrix(P filePath, MatrixInfo matrixInfo) throws IOException, IllegalInfoSyntaxException {
        Matrix<? extends PArray> matrix;
        long[] tileDimensions;
        Objects.requireNonNull(matrixInfo, "Null matrixInfo argument");
        Map<String, String> additionalProperties = matrixInfo.additionalProperties();
        Matrix<PArray> nCopiesMatrix = LargeMemoryModel.getNCopiesMatrix(matrixInfo, additionalProperties);
        if (nCopiesMatrix != null) {
            return nCopiesMatrix;
        }
        PArray array = this.asArray(filePath, matrixInfo.elementType(), matrixInfo.dataOffset(), -1L, matrixInfo.byteOrder());
        array = (PArray)array.subArr(0L, Math.min(array.length(), matrixInfo.size()));
        if (matrixInfo.dataOffset() == 0L) {
            ((AbstractArray)((Object)array)).setNewReadOnlyViewStatus();
        }
        if ((tileDimensions = LargeMemoryModel.getTileDimensions((matrix = array.matrix(matrixInfo.dimensions())).dimCount(), matrixInfo.additionalProperties())) != null) {
            matrix = matrix.tile(tileDimensions);
        }
        return matrix;
    }

    public Matrix<? extends UpdatablePArray> asUpdatableMatrix(P filePath, MatrixInfo matrixInfo) throws IOException, IllegalInfoSyntaxException {
        Objects.requireNonNull(matrixInfo, "Null matrixInfo argument");
        Map<String, String> additionalProperties = matrixInfo.additionalProperties();
        PArray nCopiesArray = LargeMemoryModel.getNCopiesArray(matrixInfo.elementType(), matrixInfo.size(), additionalProperties);
        if (nCopiesArray != null) {
            throw new IOException("Constant matrix cannot be loaded as updatable one");
        }
        UpdatablePArray array = this.asUpdatableArray(filePath, matrixInfo.elementType(), matrixInfo.dataOffset(), -1L, false, matrixInfo.byteOrder());
        Matrix<UpdatablePArray> matrix = Matrices.matrix(array = array.subArr(0L, Math.min(array.length(), matrixInfo.size())), matrixInfo.dimensions());
        long[] tileDimensions = LargeMemoryModel.getTileDimensions(matrix.dimCount(), additionalProperties);
        if (tileDimensions != null) {
            matrix = matrix.tile(tileDimensions);
        }
        return matrix;
    }

    public static MatrixInfo getMatrixInfoForSavingInFile(Matrix<? extends PArray> matrix, long dataOffset) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        MatrixInfo matrixInfo = MatrixInfo.valueOf(matrix, dataOffset);
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        if (Arrays.isNCopies(matrix.array())) {
            properties.put(CONSTANT_PROPERTY_NAME, LargeMemoryModel.getNCopiesArrayDescription(matrix.array()));
        }
        if (matrix.isTiled()) {
            properties.put(TILE_DIMENSIONS_PROPERTY_NAME, LargeMemoryModel.getTileDimensionsDescription(matrix.tileDimensions()));
        }
        if (!properties.isEmpty()) {
            matrixInfo = matrixInfo.cloneWithOtherAdditionalProperties(properties);
        }
        return matrixInfo;
    }

    public static PArray getRawArrayForSavingInFile(Matrix<? extends PArray> matrix) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        if (Arrays.isNCopies(matrix.array())) {
            return null;
        }
        if (matrix.isTiled()) {
            return matrix.tileParent().array();
        }
        return matrix.array();
    }

    @Override
    public MutableArray newLazyCopy(Array array) {
        Objects.requireNonNull(array, "Null array argument");
        Class<?> elementType = array.elementType();
        long length = array.length();
        if (elementType == Boolean.TYPE) {
            MappedDataStorages.MappedBitStorage storage = new MappedDataStorages.MappedBitStorage(this.getMappingSettings((PArray)array, false));
            BufferArraysImpl.MutableBufferBitArray result = new BufferArraysImpl.MutableBufferBitArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Character.TYPE) {
            MappedDataStorages.MappedCharStorage storage = new MappedDataStorages.MappedCharStorage(this.getMappingSettings((PArray)array, false));
            BufferArraysImpl.MutableBufferCharArray result = new BufferArraysImpl.MutableBufferCharArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Byte.TYPE) {
            MappedDataStorages.MappedByteStorage storage = new MappedDataStorages.MappedByteStorage(this.getMappingSettings((PArray)array, false));
            BufferArraysImpl.MutableBufferByteArray result = new BufferArraysImpl.MutableBufferByteArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Short.TYPE) {
            MappedDataStorages.MappedShortStorage storage = new MappedDataStorages.MappedShortStorage(this.getMappingSettings((PArray)array, false));
            BufferArraysImpl.MutableBufferShortArray result = new BufferArraysImpl.MutableBufferShortArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Integer.TYPE) {
            MappedDataStorages.MappedIntStorage storage = new MappedDataStorages.MappedIntStorage(this.getMappingSettings((PArray)array, false));
            BufferArraysImpl.MutableBufferIntArray result = new BufferArraysImpl.MutableBufferIntArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Long.TYPE) {
            MappedDataStorages.MappedLongStorage storage = new MappedDataStorages.MappedLongStorage(this.getMappingSettings((PArray)array, false));
            BufferArraysImpl.MutableBufferLongArray result = new BufferArraysImpl.MutableBufferLongArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Float.TYPE) {
            MappedDataStorages.MappedFloatStorage storage = new MappedDataStorages.MappedFloatStorage(this.getMappingSettings((PArray)array, false));
            BufferArraysImpl.MutableBufferFloatArray result = new BufferArraysImpl.MutableBufferFloatArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Double.TYPE) {
            MappedDataStorages.MappedDoubleStorage storage = new MappedDataStorages.MappedDoubleStorage(this.getMappingSettings((PArray)array, false));
            BufferArraysImpl.MutableBufferDoubleArray result = new BufferArraysImpl.MutableBufferDoubleArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        throw new UnsupportedElementTypeException("Only primitive element types are allowed in LargeMemoryModel (passed array: " + String.valueOf(array) + ")");
    }

    @Override
    public UpdatableArray newUnresizableLazyCopy(Array array) {
        Objects.requireNonNull(array, "Null array argument");
        Class<?> elementType = array.elementType();
        long length = array.length();
        if (elementType == Boolean.TYPE) {
            MappedDataStorages.MappedBitStorage storage = new MappedDataStorages.MappedBitStorage(this.getMappingSettings((PArray)array, true));
            BufferArraysImpl.UpdatableBufferBitArray result = new BufferArraysImpl.UpdatableBufferBitArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Character.TYPE) {
            MappedDataStorages.MappedCharStorage storage = new MappedDataStorages.MappedCharStorage(this.getMappingSettings((PArray)array, true));
            BufferArraysImpl.UpdatableBufferCharArray result = new BufferArraysImpl.UpdatableBufferCharArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Byte.TYPE) {
            MappedDataStorages.MappedByteStorage storage = new MappedDataStorages.MappedByteStorage(this.getMappingSettings((PArray)array, true));
            BufferArraysImpl.UpdatableBufferByteArray result = new BufferArraysImpl.UpdatableBufferByteArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Short.TYPE) {
            MappedDataStorages.MappedShortStorage storage = new MappedDataStorages.MappedShortStorage(this.getMappingSettings((PArray)array, true));
            BufferArraysImpl.UpdatableBufferShortArray result = new BufferArraysImpl.UpdatableBufferShortArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Integer.TYPE) {
            MappedDataStorages.MappedIntStorage storage = new MappedDataStorages.MappedIntStorage(this.getMappingSettings((PArray)array, true));
            BufferArraysImpl.UpdatableBufferIntArray result = new BufferArraysImpl.UpdatableBufferIntArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Long.TYPE) {
            MappedDataStorages.MappedLongStorage storage = new MappedDataStorages.MappedLongStorage(this.getMappingSettings((PArray)array, true));
            BufferArraysImpl.UpdatableBufferLongArray result = new BufferArraysImpl.UpdatableBufferLongArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Float.TYPE) {
            MappedDataStorages.MappedFloatStorage storage = new MappedDataStorages.MappedFloatStorage(this.getMappingSettings((PArray)array, true));
            BufferArraysImpl.UpdatableBufferFloatArray result = new BufferArraysImpl.UpdatableBufferFloatArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Double.TYPE) {
            MappedDataStorages.MappedDoubleStorage storage = new MappedDataStorages.MappedDoubleStorage(this.getMappingSettings((PArray)array, true));
            BufferArraysImpl.UpdatableBufferDoubleArray result = new BufferArraysImpl.UpdatableBufferDoubleArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        throw new UnsupportedElementTypeException("Only primitive element types are allowed in LargeMemoryModel (passed array: " + String.valueOf(array) + ")");
    }

    public static int activeFinalizationTasksCount() {
        return globalMappingFinalizer.activeTasksCount() + globalStorageFinalizer.activeTasksCount();
    }

    public static int activeArrayFinalizationTasksCount() {
        return globalArrayFinalizer.activeTasksCount();
    }

    public static int activeMappingFinalizationTasksCount() {
        return globalMappingFinalizer.activeTasksCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<DataFileModel<?>> allUsedDataFileModelsWithAutoDeletion() {
        HashSet result = new HashSet();
        Map<WeakReference<DataFileModel<?>>, Object> map = allUsedDataFileModelsWithAutoDeletion;
        synchronized (map) {
            LargeMemoryModel.reapDataFileModels();
            for (WeakReference<DataFileModel<?>> ref : allUsedDataFileModelsWithAutoDeletion.keySet()) {
                DataFileModel dfm = (DataFileModel)ref.get();
                if (dfm == null) continue;
                result.add(dfm);
            }
        }
        return result;
    }

    public String toString() {
        return "Large memory model [" + String.valueOf(this.getDataFileModel()) + "]";
    }

    private MappedDataStorages.MappingSettings<P> getMappingSettings(Class<?> elementClass, boolean unresizable) {
        return MappedDataStorages.MappingSettings.getInstanceForTemporaryFile(this.dataFileModel, elementClass, unresizable, null);
    }

    private MappedDataStorages.MappingSettings<P> getMappingSettings(DataFileModel<P> dataFileModel, DataFile dataFile, long dataFileStartOffset, long dataFileEndOffset, boolean readOnly, Class<?> elementClass) {
        return MappedDataStorages.MappingSettings.getInstanceForExistingFile(dataFileModel, dataFile, dataFileStartOffset, dataFileEndOffset, readOnly, elementClass);
    }

    private MappedDataStorages.MappingSettings<P> getMappingSettings(PArray lazyFillingPattern, boolean unresizable) {
        return MappedDataStorages.MappingSettings.getInstanceForTemporaryFile(this.dataFileModel, lazyFillingPattern.elementType(), unresizable, lazyFillingPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkFilePositionAndAreaSize(DataFile file, long filePosition, long fileAreaSize, boolean truncate, boolean readOnly) {
        assert (filePosition >= 0L);
        assert (fileAreaSize == -1L || fileAreaSize >= 0L);
        try {
            DataFile.OpenResult openResult = file.open(readOnly);
            if (readOnly) {
                assert (!truncate);
                assert (openResult == DataFile.OpenResult.OPENED);
                long fLen = file.length();
                if (filePosition > (fileAreaSize == -1L ? fLen : fLen - fileAreaSize)) {
                    throw new IndexOutOfBoundsException("The file is too short: the required area is " + filePosition + (String)(fileAreaSize != -1L ? ".." + (filePosition + fileAreaSize - 1L) : "..EndOfFile") + ", but the file length is " + fLen + " (file \"" + String.valueOf(file) + "\")");
                }
                if (fileAreaSize == -1L) {
                    fileAreaSize = fLen - filePosition;
                }
            } else {
                long fLen;
                long requiredLen = filePosition + (fileAreaSize == -1L ? 0L : fileAreaSize);
                if (requiredLen < 0L) {
                    throw new IllegalArgumentException("filePosition + fileAreaSize is too large (>9223372036854775807)");
                }
                long l = fLen = openResult == DataFile.OpenResult.CREATED || truncate ? -157L : file.length();
                if (fLen < requiredLen) {
                    fLen = requiredLen;
                    file.length(fLen);
                }
                if (fileAreaSize == -1L) {
                    fileAreaSize = fLen - filePosition;
                }
            }
        }
        finally {
            file.close();
        }
        return fileAreaSize;
    }

    private MutableArray newArray(Class<?> elementType, long initialCapacity, long initialLength) {
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (initialLength < 0L) {
            throw new IllegalArgumentException("Negative initial length");
        }
        if (initialCapacity < 0L) {
            throw new IllegalArgumentException("Negative initial capacity");
        }
        if (elementType == Boolean.TYPE) {
            MappedDataStorages.MappedBitStorage storage = new MappedDataStorages.MappedBitStorage(this.getMappingSettings(elementType, false));
            BufferArraysImpl.MutableBufferBitArray result = new BufferArraysImpl.MutableBufferBitArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Character.TYPE) {
            MappedDataStorages.MappedCharStorage storage = new MappedDataStorages.MappedCharStorage(this.getMappingSettings(elementType, false));
            BufferArraysImpl.MutableBufferCharArray result = new BufferArraysImpl.MutableBufferCharArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Byte.TYPE) {
            MappedDataStorages.MappedByteStorage storage = new MappedDataStorages.MappedByteStorage(this.getMappingSettings(elementType, false));
            BufferArraysImpl.MutableBufferByteArray result = new BufferArraysImpl.MutableBufferByteArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Short.TYPE) {
            MappedDataStorages.MappedShortStorage storage = new MappedDataStorages.MappedShortStorage(this.getMappingSettings(elementType, false));
            BufferArraysImpl.MutableBufferShortArray result = new BufferArraysImpl.MutableBufferShortArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Integer.TYPE) {
            MappedDataStorages.MappedIntStorage storage = new MappedDataStorages.MappedIntStorage(this.getMappingSettings(elementType, false));
            BufferArraysImpl.MutableBufferIntArray result = new BufferArraysImpl.MutableBufferIntArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Long.TYPE) {
            MappedDataStorages.MappedLongStorage storage = new MappedDataStorages.MappedLongStorage(this.getMappingSettings(elementType, false));
            BufferArraysImpl.MutableBufferLongArray result = new BufferArraysImpl.MutableBufferLongArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Float.TYPE) {
            MappedDataStorages.MappedFloatStorage storage = new MappedDataStorages.MappedFloatStorage(this.getMappingSettings(elementType, false));
            BufferArraysImpl.MutableBufferFloatArray result = new BufferArraysImpl.MutableBufferFloatArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Double.TYPE) {
            MappedDataStorages.MappedDoubleStorage storage = new MappedDataStorages.MappedDoubleStorage(this.getMappingSettings(elementType, false));
            BufferArraysImpl.MutableBufferDoubleArray result = new BufferArraysImpl.MutableBufferDoubleArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        throw new UnsupportedElementTypeException("Only primitive element types are allowed in LargeMemoryModel (passed type: " + String.valueOf(elementType) + ")");
    }

    private static String getNCopiesArrayDescription(PArray nCopiesArray) {
        if (nCopiesArray instanceof BitArray) {
            return nCopiesArray.isEmpty() ? "false" : String.valueOf(((BitArray)nCopiesArray).getBit(0L));
        }
        if (nCopiesArray instanceof CharArray) {
            return nCopiesArray.isEmpty() ? "u0" : "u" + ((CharArray)nCopiesArray).getInt(0L);
        }
        if (nCopiesArray instanceof ByteArray) {
            return nCopiesArray.isEmpty() ? "0" : String.valueOf(((ByteArray)nCopiesArray).getByte(0L));
        }
        if (nCopiesArray instanceof ShortArray) {
            return nCopiesArray.isEmpty() ? "0" : String.valueOf(((ShortArray)nCopiesArray).getShort(0L));
        }
        if (nCopiesArray instanceof IntArray) {
            return nCopiesArray.isEmpty() ? "0" : String.valueOf(((IntArray)nCopiesArray).getInt(0L));
        }
        if (nCopiesArray instanceof LongArray) {
            return nCopiesArray.isEmpty() ? "0" : String.valueOf(((LongArray)nCopiesArray).getLong(0L));
        }
        if (nCopiesArray instanceof FloatArray) {
            Object object;
            if (nCopiesArray.isEmpty()) {
                object = "0";
            } else {
                float v = ((FloatArray)nCopiesArray).getFloat(0L);
                object = v + "__" + Float.floatToRawIntBits(v);
            }
            return object;
        }
        if (nCopiesArray instanceof DoubleArray) {
            Object object;
            if (nCopiesArray.isEmpty()) {
                object = "0";
            } else {
                double v = nCopiesArray.getDouble(0L);
                object = v + "__" + Double.doubleToRawLongBits(v);
            }
            return object;
        }
        throw new AssertionError((Object)("Non-allowed type of passed array: " + String.valueOf(nCopiesArray.getClass())));
    }

    private static Matrix<? extends PArray> getNCopiesMatrix(MatrixInfo matrixInfo, Map<String, String> additionalProperties) throws IllegalInfoSyntaxException {
        PArray nCopiesArray = LargeMemoryModel.getNCopiesArray(matrixInfo.elementType(), matrixInfo.size(), additionalProperties);
        return nCopiesArray != null ? Matrices.matrix(nCopiesArray, matrixInfo.dimensions()) : null;
    }

    private static PArray getNCopiesArray(Class<?> elementType, long arrayLength, Map<String, String> additionalProperties) throws IllegalInfoSyntaxException {
        String s = additionalProperties.get(CONSTANT_PROPERTY_NAME);
        if (s == null) {
            return null;
        }
        try {
            if (elementType == Boolean.TYPE) {
                boolean value = Boolean.parseBoolean(s);
                return Arrays.nBitCopies(arrayLength, value);
            }
            if (elementType == Character.TYPE) {
                if (!s.startsWith("u")) {
                    throw new IllegalInfoSyntaxException("Starting 'u' expected in net.algart.arrays.MatrixProperty.constantValue property: \"" + s + "\"");
                }
                int value = Integer.parseInt(s.substring(1));
                if (value < 0 || value > 65535) {
                    throw new IllegalInfoSyntaxException("The constant value " + value + " is out of range 0..65535 in net.algart.arrays.MatrixProperty.constantValue property: \"" + s + "\"");
                }
                return Arrays.nCharCopies(arrayLength, (char)value);
            }
            if (elementType == Byte.TYPE) {
                int value = Integer.parseInt(s);
                if (value < 0 || value > 255) {
                    throw new IllegalInfoSyntaxException("The constant value " + value + " is out of range 0..255 in net.algart.arrays.MatrixProperty.constantValue property: \"" + s + "\"");
                }
                return Arrays.nByteCopies(arrayLength, (byte)value);
            }
            if (elementType == Short.TYPE) {
                int value = Integer.parseInt(s);
                if (value < 0 || value > 65535) {
                    throw new IllegalInfoSyntaxException("The constant value " + value + " is out of range  0..65535 in net.algart.arrays.MatrixProperty.constantValue property: \"" + s + "\"");
                }
                return Arrays.nShortCopies(arrayLength, (short)value);
            }
            if (elementType == Integer.TYPE) {
                int value = Integer.parseInt(s);
                return Arrays.nIntCopies(arrayLength, value);
            }
            if (elementType == Long.TYPE) {
                long value = Long.parseLong(s);
                return Arrays.nLongCopies(arrayLength, value);
            }
            if (elementType == Float.TYPE) {
                int p = s.indexOf("__");
                if (p == -1) {
                    return Arrays.nFloatCopies(arrayLength, Float.parseFloat(s));
                }
                int bits = Integer.parseInt(s.substring(p + 2));
                return Arrays.nFloatCopies(arrayLength, Float.intBitsToFloat(bits));
            }
            if (elementType == Double.TYPE) {
                int p = s.indexOf("__");
                if (p == -1) {
                    return Arrays.nDoubleCopies(arrayLength, Double.parseDouble(s));
                }
                long bits = Long.parseLong(s.substring(p + 2));
                return Arrays.nDoubleCopies(arrayLength, Double.longBitsToDouble(bits));
            }
            throw new AssertionError((Object)"Only primitive element types are allowed");
        }
        catch (NumberFormatException e) {
            IllegalInfoSyntaxException ex = new IllegalInfoSyntaxException("Illegal numeric format in the net.algart.arrays.MatrixProperty.constantValue property: \"" + s + "\"");
            ex.initCause(e);
            throw ex;
        }
    }

    private static String getTileDimensionsDescription(long[] tileDimensions) {
        return JArrays.toString(tileDimensions, "x", 10000);
    }

    private static long[] getTileDimensions(int dimCount, Map<String, String> additionalProperties) throws IllegalInfoSyntaxException {
        String s = additionalProperties.get(TILE_DIMENSIONS_PROPERTY_NAME);
        if (s == null) {
            return null;
        }
        String[] tileDimValues = s.split("x", dimCount + 1);
        if (tileDimValues.length != dimCount) {
            throw new IllegalInfoSyntaxException("The number of tile dimensions (in string \"" + s + "\") is not equal to the number of matrix dimensions " + dimCount);
        }
        try {
            long[] tileDimensions = new long[tileDimValues.length];
            for (int k = 0; k < tileDimValues.length; ++k) {
                tileDimensions[k] = Long.parseLong(tileDimValues[k]);
            }
            return tileDimensions;
        }
        catch (NumberFormatException e) {
            IllegalInfoSyntaxException ex = new IllegalInfoSyntaxException("Illegal numeric format in the net.algart.arrays.MatrixProperty.tileDimensions property: \"" + s + "\"");
            ex.initCause(e);
            throw ex;
        }
    }

    private static void reapDataFileModels() {
        WeakReference ref;
        while ((ref = (WeakReference)reapedDataFileModels.poll()) != null) {
            allUsedDataFileModelsWithAutoDeletion.remove(ref);
        }
    }

    static {
        DataFileModel dfm = InternalUtils.getClassInstance("net.algart.arrays.LargeMemoryModel.dataFileModel", DefaultDataFileModel.class.getName(), DataFileModel.class, LOGGER, "Default data file model will be used", "DEFAULT", DefaultDataFileModel.class.getName(), "STANDARD_IO", StandardIODataFileModel.class.getName());
        if (dfm.pathClass() != File.class) {
            LOGGER.severe("Illegal class specified by net.algart.arrays.LargeMemoryModel.dataFileModel: this data file model does not use java.io.File for describing file paths");
            LOGGER.severe("Default data file model will be used");
            dfm = new DefaultDataFileModel();
        }
        GLOBAL_DATA_FILE_MODEL = (DataFileModel)InternalUtils.cast(dfm);
        DEFAULT_INSTANCE = new LargeMemoryModel<File>(GLOBAL_DATA_FILE_MODEL);
        DUMMY = new Object();
    }
}

