/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contexts;

import java.util.Objects;
import net.algart.arrays.AbstractArrayContext;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.ThreadPoolFactory;
import net.algart.contexts.ArrayMemoryContext;
import net.algart.contexts.ArrayThreadPoolContext;
import net.algart.contexts.Context;
import net.algart.contexts.InterruptionContext;
import net.algart.contexts.ProgressUpdater;

public class DefaultArrayContext
extends AbstractArrayContext
implements ArrayContext {
    private final ArrayMemoryContext arrayMemoryContext;
    private final ArrayThreadPoolContext arrayThreadPoolContext;
    private final InterruptionContext interruptionContext;
    private final ProgressUpdater progressUpdater;
    private final ThreadPoolFactory threadPoolFactory;
    private final String parentContextString;

    public DefaultArrayContext(Context context) {
        Objects.requireNonNull(context, "Null context argument");
        this.arrayMemoryContext = context.as(ArrayMemoryContext.class);
        this.arrayThreadPoolContext = context.as(ArrayThreadPoolContext.class);
        this.interruptionContext = context.as(InterruptionContext.class);
        this.progressUpdater = context.as(ProgressUpdater.class);
        this.threadPoolFactory = null;
        this.parentContextString = context.toString();
    }

    public DefaultArrayContext(Context context, ThreadPoolFactory threadPoolFactory) {
        Objects.requireNonNull(context, "Null context argument");
        Objects.requireNonNull(threadPoolFactory, "Null threadPoolFactory argument");
        this.arrayMemoryContext = context.as(ArrayMemoryContext.class);
        this.arrayThreadPoolContext = null;
        this.interruptionContext = context.as(InterruptionContext.class);
        this.progressUpdater = context.as(ProgressUpdater.class);
        this.threadPoolFactory = threadPoolFactory;
        this.parentContextString = context.toString();
    }

    @Override
    public MemoryModel getMemoryModel() {
        return this.arrayMemoryContext.getMemoryModel();
    }

    @Override
    public ThreadPoolFactory getThreadPoolFactory() {
        return this.threadPoolFactory != null ? this.threadPoolFactory : this.arrayThreadPoolContext.getThreadPoolFactory();
    }

    @Override
    public void checkInterruption() throws RuntimeException {
        this.interruptionContext.checkInterruption();
    }

    @Override
    public void updateProgress(ArrayContext.Event event) {
        double part;
        this.progressUpdater.updateProgress(part, (part = event.readyPart()) == 1.0);
    }

    public String toString() {
        return "default array context based on " + this.parentContextString;
    }
}

