/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import java.util.Objects;
import net.algart.math.functions.ApertureFilterOperator;
import net.algart.math.functions.Func;

public class ApertureFilteredFunc
implements Func {
    private static final boolean OPTIMIZE_LITTLE_DIMENSIONS = true;
    final Func parent;
    final ApertureFilterOperator operator;

    private ApertureFilteredFunc(Func parent, ApertureFilterOperator operator) {
        this.parent = parent;
        this.operator = operator;
    }

    public static ApertureFilteredFunc getInstance(Func parent, ApertureFilterOperator operator) {
        Objects.requireNonNull(parent, "Null parent function");
        Objects.requireNonNull(operator, "Null operator");
        if (operator.apertureDim.length == 1) {
            final double step0 = operator.apertureSteps[0];
            final int n0 = (int)operator.apertureDim[0];
            if (operator.isNonweightedSum) {
                return new ApertureFilteredFunc(parent, operator){

                    @Override
                    public double get(double ... x) {
                        if (x.length != 1) {
                            return super.get(x);
                        }
                        double sum = 0.0;
                        double px0 = x[0] + this.operator.apertureFrom[0];
                        int i = 0;
                        while (i < n0) {
                            sum += this.parent.get(px0);
                            ++i;
                            px0 += step0;
                        }
                        return this.operator.a * sum + this.operator.b;
                    }

                    @Override
                    public double get(double x0) {
                        double sum = 0.0;
                        int i = 0;
                        while (i < n0) {
                            sum += this.parent.get(x0);
                            ++i;
                            x0 += step0;
                        }
                        return this.operator.a * sum + this.operator.b;
                    }
                };
            }
            return new ApertureFilteredFunc(parent, operator){

                @Override
                public double get(double ... x) {
                    if (x.length < 1) {
                        return super.get(x);
                    }
                    double[] probes = new double[this.operator.totalCount];
                    double px0 = x[0] + this.operator.apertureFrom[0];
                    int pointIndex = 0;
                    int i = 0;
                    while (i < n0) {
                        probes[pointIndex++] = this.parent.get(px0);
                        ++i;
                        px0 += step0;
                    }
                    return this.operator.apertureFunc().get(probes);
                }
            };
        }
        if (operator.apertureDim.length == 2) {
            final double step0 = operator.apertureSteps[0];
            final int n0 = (int)operator.apertureDim[0];
            final double step1 = operator.apertureSteps[1];
            final int n1 = (int)operator.apertureDim[1];
            if (operator.isNonweightedSum) {
                return new ApertureFilteredFunc(parent, operator){

                    @Override
                    public double get(double ... x) {
                        if (x.length != 2) {
                            return super.get(x);
                        }
                        double sum = 0.0;
                        double px0 = x[0] + this.operator.apertureFrom[0];
                        int i = 0;
                        while (i < n0) {
                            double px1 = x[1] + this.operator.apertureFrom[1];
                            int j = 0;
                            while (j < n1) {
                                sum += this.parent.get(px0, px1);
                                ++j;
                                px1 += step1;
                            }
                            ++i;
                            px0 += step0;
                        }
                        return this.operator.a * sum + this.operator.b;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        double sum = 0.0;
                        int i = 0;
                        while (i < n0) {
                            double px1 = x1 + this.operator.apertureFrom[1];
                            int j = 0;
                            while (j < n1) {
                                sum += this.parent.get(x0, px1);
                                ++j;
                                px1 += step1;
                            }
                            ++i;
                            x0 += step0;
                        }
                        return this.operator.a * sum + this.operator.b;
                    }
                };
            }
            return new ApertureFilteredFunc(parent, operator){

                @Override
                public double get(double ... x) {
                    if (x.length < 2) {
                        return super.get(x);
                    }
                    double[] probes = new double[this.operator.totalCount];
                    double px0 = x[0] + this.operator.apertureFrom[0];
                    int pointIndex = 0;
                    int i = 0;
                    while (i < n0) {
                        double px1 = x[1] + this.operator.apertureFrom[1];
                        int j = 0;
                        while (j < n1) {
                            probes[pointIndex++] = this.parent.get(px0, px1);
                            ++j;
                            px1 += step1;
                        }
                        ++i;
                        px0 += step0;
                    }
                    return this.operator.apertureFunc().get(probes);
                }
            };
        }
        if (operator.apertureDim.length == 3) {
            final double step0 = operator.apertureSteps[0];
            final int n0 = (int)operator.apertureDim[0];
            final double step1 = operator.apertureSteps[1];
            final int n1 = (int)operator.apertureDim[1];
            final double step2 = operator.apertureSteps[2];
            final int n2 = (int)operator.apertureDim[2];
            if (operator.isNonweightedSum) {
                return new ApertureFilteredFunc(parent, operator){

                    @Override
                    public double get(double ... x) {
                        if (x.length != 3) {
                            return super.get(x);
                        }
                        double sum = 0.0;
                        double px0 = x[0] + this.operator.apertureFrom[0];
                        int i = 0;
                        while (i < n0) {
                            double px1 = x[1] + this.operator.apertureFrom[1];
                            int j = 0;
                            while (j < n1) {
                                double px2 = x[2] + this.operator.apertureFrom[2];
                                int k = 0;
                                while (k < n2) {
                                    sum += this.parent.get(px0, px1, px2);
                                    ++k;
                                    px2 += step2;
                                }
                                ++j;
                                px1 += step1;
                            }
                            ++i;
                            px0 += step0;
                        }
                        return this.operator.a * sum + this.operator.b;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        double sum = 0.0;
                        int i = 0;
                        while (i < n0) {
                            double px1 = x1 + this.operator.apertureFrom[1];
                            int j = 0;
                            while (j < n1) {
                                double px2 = x2 + this.operator.apertureFrom[2];
                                int k = 0;
                                while (k < n2) {
                                    sum += this.parent.get(x0, px1, px2);
                                    ++k;
                                    px2 += step2;
                                }
                                ++j;
                                px1 += step1;
                            }
                            ++i;
                            x0 += step0;
                        }
                        return this.operator.a * sum + this.operator.b;
                    }
                };
            }
            return new ApertureFilteredFunc(parent, operator){

                @Override
                public double get(double ... x) {
                    if (x.length < 3) {
                        return super.get(x);
                    }
                    double[] probes = new double[this.operator.totalCount];
                    double px0 = x[0] + this.operator.apertureFrom[0];
                    int pointIndex = 0;
                    int i = 0;
                    while (i < n0) {
                        double px1 = x[1] + this.operator.apertureFrom[1];
                        int j = 0;
                        while (j < n1) {
                            double px2 = x[2] + this.operator.apertureFrom[2];
                            int k = 0;
                            while (k < n2) {
                                probes[pointIndex++] = this.parent.get(px0, px1, px2);
                                ++k;
                                px2 += step2;
                            }
                            ++j;
                            px1 += step1;
                        }
                        ++i;
                        px0 += step0;
                    }
                    return this.operator.apertureFunc().get(probes);
                }
            };
        }
        return new ApertureFilteredFunc(parent, operator);
    }

    public Func parent() {
        return this.parent;
    }

    public ApertureFilterOperator operator() {
        return this.operator;
    }

    @Override
    public double get(double ... x) {
        double[] probes = new double[this.operator.totalCount];
        this.fillProbes(x, (double[])x.clone(), probes, 0, 0);
        return this.operator.apertureFunc().get(probes);
    }

    @Override
    public double get() {
        return this.parent.get();
    }

    @Override
    public double get(double x0) {
        return this.get(new double[]{x0});
    }

    @Override
    public double get(double x0, double x1) {
        return this.get(new double[]{x0, x1});
    }

    @Override
    public double get(double x0, double x1, double x2) {
        return this.get(new double[]{x0, x1, x2});
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        return this.get(new double[]{x0, x1, x2, x3});
    }

    public String toString() {
        return String.valueOf(this.parent) + " transformed by " + String.valueOf(this.operator);
    }

    private int fillProbes(double[] x, double[] coordinates, double[] probes, int filledCount, int pointIndex) {
        assert (coordinates.length == x.length);
        double step = this.operator.apertureSteps[filledCount];
        int n = (int)this.operator.apertureDim[filledCount];
        if (filledCount < coordinates.length) {
            coordinates[filledCount] = x[filledCount] + this.operator.apertureFrom[filledCount];
            if (filledCount + 1 == this.operator.apertureDim.length) {
                for (int k = 0; k < n; ++k) {
                    probes[pointIndex++] = this.parent.get(coordinates);
                    int n2 = filledCount;
                    coordinates[n2] = coordinates[n2] + step;
                }
            } else {
                for (int k = 0; k < n; ++k) {
                    pointIndex = this.fillProbes(x, coordinates, probes, filledCount + 1, pointIndex);
                    int n3 = filledCount;
                    coordinates[n3] = coordinates[n3] + step;
                }
            }
        } else {
            int k = 0;
            while ((long)k < this.operator.apertureDim[filledCount]) {
                if (filledCount + 1 == this.operator.apertureDim.length) {
                    probes[pointIndex++] = this.parent.get(coordinates);
                } else {
                    pointIndex = this.fillProbes(x, coordinates, probes, filledCount + 1, pointIndex);
                }
                ++k;
            }
        }
        return pointIndex;
    }
}

