/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.filters3x3;

import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.matrices.filters3x3.PercentileBySquare3x3;

public abstract class MedianBySquare3x3
extends PercentileBySquare3x3 {
    private static final boolean USE_ANTI_DOZ_TABLE_FOR_BYTES = false;
    static final int[] ANTI_DOZ_TABLE_FOR_BYTES = MedianBySquare3x3.createAntiDozTable();

    MedianBySquare3x3(Class<?> elementType, long[] dimensions) {
        super(elementType, dimensions, 4);
    }

    public static MedianBySquare3x3 newInstance(Class<?> elementType, long dimX, long dimY) {
        return MedianBySquare3x3.newInstance(elementType, new long[]{dimX, dimY});
    }

    public static MedianBySquare3x3 newInstance(Class<?> elementType, long[] dimensions) {
        if (elementType == Character.TYPE) {
            return new ForChar(dimensions);
        }
        if (elementType == Boolean.TYPE) {
            return new ForBit(dimensions);
        }
        if (elementType == Byte.TYPE) {
            return new ForByte(dimensions);
        }
        if (elementType == Short.TYPE) {
            return new ForShort(dimensions);
        }
        if (elementType == Integer.TYPE) {
            return new ForInt(dimensions);
        }
        if (elementType == Long.TYPE) {
            return new ForLong(dimensions);
        }
        if (elementType == Float.TYPE) {
            return new ForFloat(dimensions);
        }
        if (elementType == Double.TYPE) {
            return new ForDouble(dimensions);
        }
        throw new UnsupportedOperationException("Non-primitive element type " + String.valueOf(elementType) + " is not supported");
    }

    public static Matrix<UpdatablePArray> apply(Matrix<? extends PArray> source) {
        Objects.requireNonNull(source, "Null source matrix");
        return MedianBySquare3x3.newInstance(source.elementType(), source.dimensions()).filter(source);
    }

    static int medianNoOverflow(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
        int temp = MedianBySquare3x3.antiDozNoOverflow(w1, w2);
        w1 += temp;
        w2 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w4, w5);
        w4 += temp;
        w5 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w7, w8);
        w7 += temp;
        w8 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w0, w1);
        w0 += temp;
        w1 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w3, w4);
        w3 += temp;
        w4 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w6, w7);
        w6 += temp;
        w7 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w1, w2);
        w1 += temp;
        w2 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w4, w5);
        w4 += temp;
        w5 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w7, w8);
        w7 += temp;
        w8 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w0, w3);
        w3 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w5, w8);
        w5 += temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w4, w7);
        w4 += temp;
        w7 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w3, w6);
        w6 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w1, w4);
        w4 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w2, w5);
        w2 += temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w4, w7);
        w4 += temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w4, w2);
        w4 += temp;
        w2 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w6, w4);
        w4 -= temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w4, w2);
        return w4 += temp;
    }

    static void medianNoOverflow(int[] w) {
        int temp = MedianBySquare3x3.antiDozNoOverflow(w[1], w[2]);
        w[1] = w[1] + temp;
        w[2] = w[2] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[4], w[5]);
        w[4] = w[4] + temp;
        w[5] = w[5] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[7], w[8]);
        w[7] = w[7] + temp;
        w[8] = w[8] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[0], w[1]);
        w[0] = w[0] + temp;
        w[1] = w[1] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[3], w[4]);
        w[3] = w[3] + temp;
        w[4] = w[4] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[6], w[7]);
        w[6] = w[6] + temp;
        w[7] = w[7] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[1], w[2]);
        w[1] = w[1] + temp;
        w[2] = w[2] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[4], w[5]);
        w[4] = w[4] + temp;
        w[5] = w[5] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[7], w[8]);
        w[7] = w[7] + temp;
        w[8] = w[8] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[0], w[3]);
        w[0] = w[0] + temp;
        w[3] = w[3] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[5], w[8]);
        w[5] = w[5] + temp;
        w[8] = w[8] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[4], w[7]);
        w[4] = w[4] + temp;
        w[7] = w[7] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[3], w[6]);
        w[3] = w[3] + temp;
        w[6] = w[6] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[1], w[4]);
        w[1] = w[1] + temp;
        w[4] = w[4] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[2], w[5]);
        w[2] = w[2] + temp;
        w[5] = w[5] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[4], w[7]);
        w[4] = w[4] + temp;
        w[7] = w[7] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[4], w[2]);
        w[4] = w[4] + temp;
        w[2] = w[2] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[6], w[4]);
        w[6] = w[6] + temp;
        w[4] = w[4] - temp;
        temp = MedianBySquare3x3.antiDozNoOverflow(w[4], w[2]);
        w[4] = w[4] + temp;
        w[2] = w[2] - temp;
    }

    static int dozNoOverflow(int a, int b) {
        int c = a - b;
        return c & ~(c >> 31);
    }

    static int antiDozNoOverflow(int a, int b) {
        int c = b - a;
        return c & c >> 31;
    }

    static int antiDozForBytes(int a, int b) {
        return ANTI_DOZ_TABLE_FOR_BYTES[256 + b - a];
    }

    static int[] createAntiDozTable() {
        int[] table = new int[512];
        for (int k = -256; k <= 255; ++k) {
            table[256 + k] = Math.min(k, 0);
        }
        return table;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10000; ++i) {
            for (int j = 0; j < 10000; ++j) {
                int a = i;
                int b = j;
                if (MedianBySquare3x3.dozNoOverflow(a, b) != Math.max(a - b, 0)) {
                    throw new AssertionError((Object)"Invalid doz");
                }
                int antiDoz = MedianBySquare3x3.antiDozNoOverflow(a, b);
                if (antiDoz != Math.min(b - a, 0)) {
                    throw new AssertionError((Object)"Invalid anti-doz");
                }
                if (i < 256 && j < 256 && antiDoz != MedianBySquare3x3.antiDozForBytes(a, b)) {
                    throw new AssertionError((Object)"Invalid anti-doz table");
                }
                int max = b - antiDoz;
                int min = a + antiDoz;
                if (min != Math.min(a, b) || max != Math.max(a, b)) {
                    throw new AssertionError((Object)"Invalid min/max");
                }
                if ((a += antiDoz) != min || (b -= antiDoz) != max) {
                    throw new AssertionError((Object)"Invalid min/max");
                }
            }
        }
        int max = 100;
        Random rnd = new Random(22L);
        int[] v = new int[9];
        int testCount = 0x1000000;
        for (int test = 1; test <= testCount; ++test) {
            if ((test & 0xFF) == 0) {
                System.out.print("\r" + test);
            }
            Arrays.setAll(v, k -> rnd.nextInt(100));
            int[] vSorted = (int[])v.clone();
            Arrays.sort(vSorted);
            int medianSimple = vSorted[4];
            int median = ForInt.median(v[0], v[1], v[2], v[3], v[4], v[5], v[6], v[7], v[8]);
            if (median != medianSimple) {
                throw new AssertionError((Object)(test + ": Invalid median: " + median + " instead of " + medianSimple + " for " + Arrays.toString(v)));
            }
            int medianNoOverflow = MedianBySquare3x3.medianNoOverflow(v[0], v[1], v[2], v[3], v[4], v[5], v[6], v[7], v[8]);
            if (medianNoOverflow != medianSimple) {
                throw new AssertionError((Object)(test + ": Invalid median for byte: " + medianNoOverflow + " instead of " + medianSimple + " for " + Arrays.toString(v)));
            }
            MedianBySquare3x3.medianNoOverflow(v);
            if (v[4] != medianSimple) {
                throw new AssertionError((Object)(test + ": Invalid median for byte (array): " + medianNoOverflow + " instead of " + medianSimple + " for " + Arrays.toString(v)));
            }
        }
    }

    private static class ForChar
    extends MedianBySquare3x3 {
        private ForChar(long[] dimensions) {
            super(Character.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            char[] result = (char[])resultJavaArray;
            char[] source = (char[])sourceJavaArray;
            char v0 = source[firstLineOffset + this.dimXm1];
            char v1 = source[firstLineOffset];
            char v2 = source[firstLineOffset + this.rem1ForDimX];
            char v3 = source[middleLineOffset + this.dimXm1];
            char v4 = source[middleLineOffset];
            char v5 = source[middleLineOffset + this.rem1ForDimX];
            char v6 = source[lastLineOffset + this.dimXm1];
            char v7 = source[lastLineOffset];
            char v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = (char)ForChar.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                char temp;
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                char w0 = v0;
                char w1 = v1;
                char w2 = v2;
                char w3 = v3;
                char w4 = v4;
                char w5 = v5;
                char w6 = v6;
                char w7 = v7;
                char w8 = v8;
                if (w1 > w2) {
                    temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                if (w4 > w5) {
                    temp = w4;
                    w4 = w5;
                    w5 = temp;
                }
                if (w7 > w8) {
                    temp = w7;
                    w7 = w8;
                    w8 = temp;
                }
                if (w0 > w1) {
                    temp = w0;
                    w0 = w1;
                    w1 = temp;
                }
                if (w3 > w4) {
                    temp = w3;
                    w3 = w4;
                    w4 = temp;
                }
                if (w6 > w7) {
                    temp = w6;
                    w6 = w7;
                    w7 = temp;
                }
                if (w1 > w2) {
                    temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                if (w4 > w5) {
                    temp = w4;
                    w4 = w5;
                    w5 = temp;
                }
                if (w7 > w8) {
                    temp = w7;
                    w7 = w8;
                    w8 = temp;
                }
                if (w0 > w3) {
                    w3 = w0;
                }
                if (w5 > w8) {
                    w5 = w8;
                }
                if (w4 > w7) {
                    temp = w4;
                    w4 = w7;
                    w7 = temp;
                }
                if (w3 > w6) {
                    w6 = w3;
                }
                if (w1 > w4) {
                    w4 = w1;
                }
                if (w2 > w5) {
                    w2 = w5;
                }
                if (w4 > w7) {
                    w4 = w7;
                }
                if (w4 > w2) {
                    temp = w4;
                    w4 = w2;
                    w2 = temp;
                }
                if (w6 > w4) {
                    w4 = w6;
                }
                if (w4 > w2) {
                    w4 = w2;
                }
                result[++resultLineOffset] = w4;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = (char)ForChar.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private static int median(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
            int temp;
            if (w1 > w2) {
                temp = w1;
                w1 = w2;
                w2 = temp;
            }
            if (w4 > w5) {
                temp = w4;
                w4 = w5;
                w5 = temp;
            }
            if (w7 > w8) {
                temp = w7;
                w7 = w8;
                w8 = temp;
            }
            if (w0 > w1) {
                temp = w0;
                w0 = w1;
                w1 = temp;
            }
            if (w3 > w4) {
                temp = w3;
                w3 = w4;
                w4 = temp;
            }
            if (w6 > w7) {
                temp = w6;
                w6 = w7;
                w7 = temp;
            }
            if (w1 > w2) {
                temp = w1;
                w1 = w2;
                w2 = temp;
            }
            if (w4 > w5) {
                temp = w4;
                w4 = w5;
                w5 = temp;
            }
            if (w7 > w8) {
                temp = w7;
                w7 = w8;
                w8 = temp;
            }
            if (w0 > w3) {
                w3 = w0;
            }
            if (w5 > w8) {
                w5 = w8;
            }
            if (w4 > w7) {
                temp = w4;
                w4 = w7;
                w7 = temp;
            }
            if (w3 > w6) {
                w6 = w3;
            }
            if (w1 > w4) {
                w4 = w1;
            }
            if (w2 > w5) {
                w2 = w5;
            }
            if (w4 > w7) {
                w4 = w7;
            }
            if (w4 > w2) {
                temp = w4;
                w4 = w2;
                w2 = temp;
            }
            if (w6 > w4) {
                w4 = w6;
            }
            if (w4 > w2) {
                w4 = w2;
            }
            return w4;
        }
    }

    private static class ForBit
    extends MedianBySquare3x3 {
        private ForBit(long[] dimensions) {
            super(Boolean.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            boolean[] result = (boolean[])resultJavaArray;
            boolean[] source = (boolean[])sourceJavaArray;
            boolean v0 = source[firstLineOffset + this.dimXm1];
            boolean v1 = source[firstLineOffset];
            boolean v2 = source[firstLineOffset + this.rem1ForDimX];
            boolean v3 = source[middleLineOffset + this.dimXm1];
            boolean v4 = source[middleLineOffset];
            boolean v5 = source[middleLineOffset + this.rem1ForDimX];
            boolean v6 = source[lastLineOffset + this.dimXm1];
            boolean v7 = source[lastLineOffset];
            boolean v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = this.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                result[++resultLineOffset] = this.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = this.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private boolean median(boolean v0, boolean v1, boolean v2, boolean v3, boolean v4, boolean v5, boolean v6, boolean v7, boolean v8) {
            return PercentileBySquare3x3.ForBit.percentile(4, v0, v1, v2, v3, v4, v5, v6, v7, v8);
        }
    }

    private static class ForByte
    extends MedianBySquare3x3 {
        private ForByte(long[] dimensions) {
            super(Byte.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            byte[] result = (byte[])resultJavaArray;
            byte[] source = (byte[])sourceJavaArray;
            int v0 = source[firstLineOffset + this.dimXm1] & 0xFF;
            int v1 = source[firstLineOffset] & 0xFF;
            int v2 = source[firstLineOffset + this.rem1ForDimX] & 0xFF;
            int v3 = source[middleLineOffset + this.dimXm1] & 0xFF;
            int v4 = source[middleLineOffset] & 0xFF;
            int v5 = source[middleLineOffset + this.rem1ForDimX] & 0xFF;
            int v6 = source[lastLineOffset + this.dimXm1] & 0xFF;
            int v7 = source[lastLineOffset] & 0xFF;
            int v8 = source[lastLineOffset + this.rem1ForDimX] & 0xFF;
            result[resultLineOffset] = (byte)ForByte.medianNoOverflow(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset] & 0xFF;
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset] & 0xFF;
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset] & 0xFF;
                int w0 = v0;
                int w1 = v1;
                int w2 = v2;
                int w3 = v3;
                int w4 = v4;
                int w5 = v5;
                int w6 = v6;
                int w7 = v7;
                int w8 = v8;
                int temp = ForByte.antiDozNoOverflow(w1, w2);
                w1 += temp;
                w2 -= temp;
                temp = ForByte.antiDozNoOverflow(w4, w5);
                w4 += temp;
                w5 -= temp;
                temp = ForByte.antiDozNoOverflow(w7, w8);
                w7 += temp;
                w8 -= temp;
                temp = ForByte.antiDozNoOverflow(w0, w1);
                w0 += temp;
                w1 -= temp;
                temp = ForByte.antiDozNoOverflow(w3, w4);
                w3 += temp;
                w4 -= temp;
                temp = ForByte.antiDozNoOverflow(w6, w7);
                w6 += temp;
                w7 -= temp;
                temp = ForByte.antiDozNoOverflow(w1, w2);
                w1 += temp;
                w2 -= temp;
                temp = ForByte.antiDozNoOverflow(w4, w5);
                w4 += temp;
                w5 -= temp;
                temp = ForByte.antiDozNoOverflow(w7, w8);
                w7 += temp;
                w3 = Math.max(w0, w3);
                w5 = Math.min(w5, w8 -= temp);
                temp = ForByte.antiDozNoOverflow(w4, w7);
                w4 += temp;
                w6 = Math.max(w3, w6);
                w4 = Math.max(w1, w4);
                w2 = Math.min(w2, w5);
                w4 = Math.min(w4, w7 -= temp);
                temp = ForByte.antiDozNoOverflow(w4, w2);
                w4 += temp;
                w4 = Math.max(w6, w4);
                w4 = Math.min(w4, w2 -= temp);
                result[++resultLineOffset] = (byte)w4;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1] & 0xFF;
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1] & 0xFF;
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1] & 0xFF;
                result[++resultLineOffset] = (byte)ForByte.medianNoOverflow(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }
    }

    private static class ForShort
    extends MedianBySquare3x3 {
        private ForShort(long[] dimensions) {
            super(Short.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            short[] result = (short[])resultJavaArray;
            short[] source = (short[])sourceJavaArray;
            int v0 = source[firstLineOffset + this.dimXm1] & 0xFFFF;
            int v1 = source[firstLineOffset] & 0xFFFF;
            int v2 = source[firstLineOffset + this.rem1ForDimX] & 0xFFFF;
            int v3 = source[middleLineOffset + this.dimXm1] & 0xFFFF;
            int v4 = source[middleLineOffset] & 0xFFFF;
            int v5 = source[middleLineOffset + this.rem1ForDimX] & 0xFFFF;
            int v6 = source[lastLineOffset + this.dimXm1] & 0xFFFF;
            int v7 = source[lastLineOffset] & 0xFFFF;
            int v8 = source[lastLineOffset + this.rem1ForDimX] & 0xFFFF;
            result[resultLineOffset] = (short)ForShort.medianNoOverflow(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset] & 0xFFFF;
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset] & 0xFFFF;
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset] & 0xFFFF;
                int w0 = v0;
                int w1 = v1;
                int w2 = v2;
                int w3 = v3;
                int w4 = v4;
                int w5 = v5;
                int w6 = v6;
                int w7 = v7;
                int w8 = v8;
                int temp = ForShort.antiDozNoOverflow(w1, w2);
                w1 += temp;
                w2 -= temp;
                temp = ForShort.antiDozNoOverflow(w4, w5);
                w4 += temp;
                w5 -= temp;
                temp = ForShort.antiDozNoOverflow(w7, w8);
                w7 += temp;
                w8 -= temp;
                temp = ForShort.antiDozNoOverflow(w0, w1);
                w0 += temp;
                w1 -= temp;
                temp = ForShort.antiDozNoOverflow(w3, w4);
                w3 += temp;
                w4 -= temp;
                temp = ForShort.antiDozNoOverflow(w6, w7);
                w6 += temp;
                w7 -= temp;
                temp = ForShort.antiDozNoOverflow(w1, w2);
                w1 += temp;
                w2 -= temp;
                temp = ForShort.antiDozNoOverflow(w4, w5);
                w4 += temp;
                w5 -= temp;
                temp = ForShort.antiDozNoOverflow(w7, w8);
                w7 += temp;
                w3 = Math.max(w0, w3);
                w5 = Math.min(w5, w8 -= temp);
                temp = ForShort.antiDozNoOverflow(w4, w7);
                w4 += temp;
                w6 = Math.max(w3, w6);
                w4 = Math.max(w1, w4);
                w2 = Math.min(w2, w5);
                w4 = Math.min(w4, w7 -= temp);
                temp = ForShort.antiDozNoOverflow(w4, w2);
                w4 += temp;
                w4 = Math.max(w6, w4);
                w4 = Math.min(w4, w2 -= temp);
                result[++resultLineOffset] = (short)w4;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1] & 0xFFFF;
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1] & 0xFFFF;
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1] & 0xFFFF;
                result[++resultLineOffset] = (short)ForShort.medianNoOverflow(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }
    }

    private static class ForInt
    extends MedianBySquare3x3 {
        private ForInt(long[] dimensions) {
            super(Integer.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            int[] result = (int[])resultJavaArray;
            int[] source = (int[])sourceJavaArray;
            int v0 = source[firstLineOffset + this.dimXm1];
            int v1 = source[firstLineOffset];
            int v2 = source[firstLineOffset + this.rem1ForDimX];
            int v3 = source[middleLineOffset + this.dimXm1];
            int v4 = source[middleLineOffset];
            int v5 = source[middleLineOffset + this.rem1ForDimX];
            int v6 = source[lastLineOffset + this.dimXm1];
            int v7 = source[lastLineOffset];
            int v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = ForInt.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                int temp;
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                int w0 = v0;
                int w1 = v1;
                int w2 = v2;
                int w3 = v3;
                int w4 = v4;
                int w5 = v5;
                int w6 = v6;
                int w7 = v7;
                int w8 = v8;
                if (w1 > w2) {
                    temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                if (w4 > w5) {
                    temp = w4;
                    w4 = w5;
                    w5 = temp;
                }
                if (w7 > w8) {
                    temp = w7;
                    w7 = w8;
                    w8 = temp;
                }
                if (w0 > w1) {
                    temp = w0;
                    w0 = w1;
                    w1 = temp;
                }
                if (w3 > w4) {
                    temp = w3;
                    w3 = w4;
                    w4 = temp;
                }
                if (w6 > w7) {
                    temp = w6;
                    w6 = w7;
                    w7 = temp;
                }
                if (w1 > w2) {
                    temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                if (w4 > w5) {
                    temp = w4;
                    w4 = w5;
                    w5 = temp;
                }
                if (w7 > w8) {
                    temp = w7;
                    w7 = w8;
                    w8 = temp;
                }
                if (w0 > w3) {
                    w3 = w0;
                }
                if (w5 > w8) {
                    w5 = w8;
                }
                if (w4 > w7) {
                    temp = w4;
                    w4 = w7;
                    w7 = temp;
                }
                if (w3 > w6) {
                    w6 = w3;
                }
                if (w1 > w4) {
                    w4 = w1;
                }
                if (w2 > w5) {
                    w2 = w5;
                }
                if (w4 > w7) {
                    w4 = w7;
                }
                if (w4 > w2) {
                    temp = w4;
                    w4 = w2;
                    w2 = temp;
                }
                if (w6 > w4) {
                    w4 = w6;
                }
                if (w4 > w2) {
                    w4 = w2;
                }
                result[++resultLineOffset] = w4;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = ForInt.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private static int median(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
            int temp;
            if (w1 > w2) {
                temp = w1;
                w1 = w2;
                w2 = temp;
            }
            if (w4 > w5) {
                temp = w4;
                w4 = w5;
                w5 = temp;
            }
            if (w7 > w8) {
                temp = w7;
                w7 = w8;
                w8 = temp;
            }
            if (w0 > w1) {
                temp = w0;
                w0 = w1;
                w1 = temp;
            }
            if (w3 > w4) {
                temp = w3;
                w3 = w4;
                w4 = temp;
            }
            if (w6 > w7) {
                temp = w6;
                w6 = w7;
                w7 = temp;
            }
            if (w1 > w2) {
                temp = w1;
                w1 = w2;
                w2 = temp;
            }
            if (w4 > w5) {
                temp = w4;
                w4 = w5;
                w5 = temp;
            }
            if (w7 > w8) {
                temp = w7;
                w7 = w8;
                w8 = temp;
            }
            if (w0 > w3) {
                w3 = w0;
            }
            if (w5 > w8) {
                w5 = w8;
            }
            if (w4 > w7) {
                temp = w4;
                w4 = w7;
                w7 = temp;
            }
            if (w3 > w6) {
                w6 = w3;
            }
            if (w1 > w4) {
                w4 = w1;
            }
            if (w2 > w5) {
                w2 = w5;
            }
            if (w4 > w7) {
                w4 = w7;
            }
            if (w4 > w2) {
                temp = w4;
                w4 = w2;
                w2 = temp;
            }
            if (w6 > w4) {
                w4 = w6;
            }
            if (w4 > w2) {
                w4 = w2;
            }
            return w4;
        }
    }

    private static class ForLong
    extends MedianBySquare3x3 {
        private ForLong(long[] dimensions) {
            super(Long.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            long[] result = (long[])resultJavaArray;
            long[] source = (long[])sourceJavaArray;
            long v0 = source[firstLineOffset + this.dimXm1];
            long v1 = source[firstLineOffset];
            long v2 = source[firstLineOffset + this.rem1ForDimX];
            long v3 = source[middleLineOffset + this.dimXm1];
            long v4 = source[middleLineOffset];
            long v5 = source[middleLineOffset + this.rem1ForDimX];
            long v6 = source[lastLineOffset + this.dimXm1];
            long v7 = source[lastLineOffset];
            long v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = ForLong.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                long temp;
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                long w0 = v0;
                long w1 = v1;
                long w2 = v2;
                long w3 = v3;
                long w4 = v4;
                long w5 = v5;
                long w6 = v6;
                long w7 = v7;
                long w8 = v8;
                if (w1 > w2) {
                    temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                if (w4 > w5) {
                    temp = w4;
                    w4 = w5;
                    w5 = temp;
                }
                if (w7 > w8) {
                    temp = w7;
                    w7 = w8;
                    w8 = temp;
                }
                if (w0 > w1) {
                    temp = w0;
                    w0 = w1;
                    w1 = temp;
                }
                if (w3 > w4) {
                    temp = w3;
                    w3 = w4;
                    w4 = temp;
                }
                if (w6 > w7) {
                    temp = w6;
                    w6 = w7;
                    w7 = temp;
                }
                if (w1 > w2) {
                    temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                if (w4 > w5) {
                    temp = w4;
                    w4 = w5;
                    w5 = temp;
                }
                if (w7 > w8) {
                    temp = w7;
                    w7 = w8;
                    w8 = temp;
                }
                if (w0 > w3) {
                    w3 = w0;
                }
                if (w5 > w8) {
                    w5 = w8;
                }
                if (w4 > w7) {
                    temp = w4;
                    w4 = w7;
                    w7 = temp;
                }
                if (w3 > w6) {
                    w6 = w3;
                }
                if (w1 > w4) {
                    w4 = w1;
                }
                if (w2 > w5) {
                    w2 = w5;
                }
                if (w4 > w7) {
                    w4 = w7;
                }
                if (w4 > w2) {
                    temp = w4;
                    w4 = w2;
                    w2 = temp;
                }
                if (w6 > w4) {
                    w4 = w6;
                }
                if (w4 > w2) {
                    w4 = w2;
                }
                result[++resultLineOffset] = w4;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = ForLong.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private static long median(long w0, long w1, long w2, long w3, long w4, long w5, long w6, long w7, long w8) {
            long temp;
            if (w1 > w2) {
                temp = w1;
                w1 = w2;
                w2 = temp;
            }
            if (w4 > w5) {
                temp = w4;
                w4 = w5;
                w5 = temp;
            }
            if (w7 > w8) {
                temp = w7;
                w7 = w8;
                w8 = temp;
            }
            if (w0 > w1) {
                temp = w0;
                w0 = w1;
                w1 = temp;
            }
            if (w3 > w4) {
                temp = w3;
                w3 = w4;
                w4 = temp;
            }
            if (w6 > w7) {
                temp = w6;
                w6 = w7;
                w7 = temp;
            }
            if (w1 > w2) {
                temp = w1;
                w1 = w2;
                w2 = temp;
            }
            if (w4 > w5) {
                temp = w4;
                w4 = w5;
                w5 = temp;
            }
            if (w7 > w8) {
                temp = w7;
                w7 = w8;
                w8 = temp;
            }
            if (w0 > w3) {
                w3 = w0;
            }
            if (w5 > w8) {
                w5 = w8;
            }
            if (w4 > w7) {
                temp = w4;
                w4 = w7;
                w7 = temp;
            }
            if (w3 > w6) {
                w6 = w3;
            }
            if (w1 > w4) {
                w4 = w1;
            }
            if (w2 > w5) {
                w2 = w5;
            }
            if (w4 > w7) {
                w4 = w7;
            }
            if (w4 > w2) {
                temp = w4;
                w4 = w2;
                w2 = temp;
            }
            if (w6 > w4) {
                w4 = w6;
            }
            if (w4 > w2) {
                w4 = w2;
            }
            return w4;
        }
    }

    private static class ForFloat
    extends MedianBySquare3x3 {
        private ForFloat(long[] dimensions) {
            super(Float.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            float[] result = (float[])resultJavaArray;
            float[] source = (float[])sourceJavaArray;
            float v0 = source[firstLineOffset + this.dimXm1];
            float v1 = source[firstLineOffset];
            float v2 = source[firstLineOffset + this.rem1ForDimX];
            float v3 = source[middleLineOffset + this.dimXm1];
            float v4 = source[middleLineOffset];
            float v5 = source[middleLineOffset + this.rem1ForDimX];
            float v6 = source[lastLineOffset + this.dimXm1];
            float v7 = source[lastLineOffset];
            float v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = ForFloat.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                float temp;
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                float w0 = v0;
                float w1 = v1;
                float w2 = v2;
                float w3 = v3;
                float w4 = v4;
                float w5 = v5;
                float w6 = v6;
                float w7 = v7;
                float w8 = v8;
                if (w1 > w2) {
                    temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                if (w4 > w5) {
                    temp = w4;
                    w4 = w5;
                    w5 = temp;
                }
                if (w7 > w8) {
                    temp = w7;
                    w7 = w8;
                    w8 = temp;
                }
                if (w0 > w1) {
                    temp = w0;
                    w0 = w1;
                    w1 = temp;
                }
                if (w3 > w4) {
                    temp = w3;
                    w3 = w4;
                    w4 = temp;
                }
                if (w6 > w7) {
                    temp = w6;
                    w6 = w7;
                    w7 = temp;
                }
                if (w1 > w2) {
                    temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                if (w4 > w5) {
                    temp = w4;
                    w4 = w5;
                    w5 = temp;
                }
                if (w7 > w8) {
                    temp = w7;
                    w7 = w8;
                    w8 = temp;
                }
                if (w0 > w3) {
                    w3 = w0;
                }
                if (w5 > w8) {
                    w5 = w8;
                }
                if (w4 > w7) {
                    temp = w4;
                    w4 = w7;
                    w7 = temp;
                }
                if (w3 > w6) {
                    w6 = w3;
                }
                if (w1 > w4) {
                    w4 = w1;
                }
                if (w2 > w5) {
                    w2 = w5;
                }
                if (w4 > w7) {
                    w4 = w7;
                }
                if (w4 > w2) {
                    temp = w4;
                    w4 = w2;
                    w2 = temp;
                }
                if (w6 > w4) {
                    w4 = w6;
                }
                if (w4 > w2) {
                    w4 = w2;
                }
                result[++resultLineOffset] = w4;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = ForFloat.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private static float median(float w0, float w1, float w2, float w3, float w4, float w5, float w6, float w7, float w8) {
            float temp;
            if (w1 > w2) {
                temp = w1;
                w1 = w2;
                w2 = temp;
            }
            if (w4 > w5) {
                temp = w4;
                w4 = w5;
                w5 = temp;
            }
            if (w7 > w8) {
                temp = w7;
                w7 = w8;
                w8 = temp;
            }
            if (w0 > w1) {
                temp = w0;
                w0 = w1;
                w1 = temp;
            }
            if (w3 > w4) {
                temp = w3;
                w3 = w4;
                w4 = temp;
            }
            if (w6 > w7) {
                temp = w6;
                w6 = w7;
                w7 = temp;
            }
            if (w1 > w2) {
                temp = w1;
                w1 = w2;
                w2 = temp;
            }
            if (w4 > w5) {
                temp = w4;
                w4 = w5;
                w5 = temp;
            }
            if (w7 > w8) {
                temp = w7;
                w7 = w8;
                w8 = temp;
            }
            if (w0 > w3) {
                w3 = w0;
            }
            if (w5 > w8) {
                w5 = w8;
            }
            if (w4 > w7) {
                temp = w4;
                w4 = w7;
                w7 = temp;
            }
            if (w3 > w6) {
                w6 = w3;
            }
            if (w1 > w4) {
                w4 = w1;
            }
            if (w2 > w5) {
                w2 = w5;
            }
            if (w4 > w7) {
                w4 = w7;
            }
            if (w4 > w2) {
                temp = w4;
                w4 = w2;
                w2 = temp;
            }
            if (w6 > w4) {
                w4 = w6;
            }
            if (w4 > w2) {
                w4 = w2;
            }
            return w4;
        }
    }

    private static class ForDouble
    extends MedianBySquare3x3 {
        private ForDouble(long[] dimensions) {
            super(Double.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            double[] result = (double[])resultJavaArray;
            double[] source = (double[])sourceJavaArray;
            double v0 = source[firstLineOffset + this.dimXm1];
            double v1 = source[firstLineOffset];
            double v2 = source[firstLineOffset + this.rem1ForDimX];
            double v3 = source[middleLineOffset + this.dimXm1];
            double v4 = source[middleLineOffset];
            double v5 = source[middleLineOffset + this.rem1ForDimX];
            double v6 = source[lastLineOffset + this.dimXm1];
            double v7 = source[lastLineOffset];
            double v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = ForDouble.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                double temp;
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                double w0 = v0;
                double w1 = v1;
                double w2 = v2;
                double w3 = v3;
                double w4 = v4;
                double w5 = v5;
                double w6 = v6;
                double w7 = v7;
                double w8 = v8;
                if (w1 > w2) {
                    temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                if (w4 > w5) {
                    temp = w4;
                    w4 = w5;
                    w5 = temp;
                }
                if (w7 > w8) {
                    temp = w7;
                    w7 = w8;
                    w8 = temp;
                }
                if (w0 > w1) {
                    temp = w0;
                    w0 = w1;
                    w1 = temp;
                }
                if (w3 > w4) {
                    temp = w3;
                    w3 = w4;
                    w4 = temp;
                }
                if (w6 > w7) {
                    temp = w6;
                    w6 = w7;
                    w7 = temp;
                }
                if (w1 > w2) {
                    temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                if (w4 > w5) {
                    temp = w4;
                    w4 = w5;
                    w5 = temp;
                }
                if (w7 > w8) {
                    temp = w7;
                    w7 = w8;
                    w8 = temp;
                }
                if (w0 > w3) {
                    w3 = w0;
                }
                if (w5 > w8) {
                    w5 = w8;
                }
                if (w4 > w7) {
                    temp = w4;
                    w4 = w7;
                    w7 = temp;
                }
                if (w3 > w6) {
                    w6 = w3;
                }
                if (w1 > w4) {
                    w4 = w1;
                }
                if (w2 > w5) {
                    w2 = w5;
                }
                if (w4 > w7) {
                    w4 = w7;
                }
                if (w4 > w2) {
                    temp = w4;
                    w4 = w2;
                    w2 = temp;
                }
                if (w6 > w4) {
                    w4 = w6;
                }
                if (w4 > w2) {
                    w4 = w2;
                }
                result[++resultLineOffset] = w4;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = ForDouble.median(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private static double median(double w0, double w1, double w2, double w3, double w4, double w5, double w6, double w7, double w8) {
            double temp;
            if (w1 > w2) {
                temp = w1;
                w1 = w2;
                w2 = temp;
            }
            if (w4 > w5) {
                temp = w4;
                w4 = w5;
                w5 = temp;
            }
            if (w7 > w8) {
                temp = w7;
                w7 = w8;
                w8 = temp;
            }
            if (w0 > w1) {
                temp = w0;
                w0 = w1;
                w1 = temp;
            }
            if (w3 > w4) {
                temp = w3;
                w3 = w4;
                w4 = temp;
            }
            if (w6 > w7) {
                temp = w6;
                w6 = w7;
                w7 = temp;
            }
            if (w1 > w2) {
                temp = w1;
                w1 = w2;
                w2 = temp;
            }
            if (w4 > w5) {
                temp = w4;
                w4 = w5;
                w5 = temp;
            }
            if (w7 > w8) {
                temp = w7;
                w7 = w8;
                w8 = temp;
            }
            if (w0 > w3) {
                w3 = w0;
            }
            if (w5 > w8) {
                w5 = w8;
            }
            if (w4 > w7) {
                temp = w4;
                w4 = w7;
                w7 = temp;
            }
            if (w3 > w6) {
                w6 = w3;
            }
            if (w1 > w4) {
                w4 = w1;
            }
            if (w2 > w5) {
                w2 = w5;
            }
            if (w4 > w7) {
                w4 = w7;
            }
            if (w4 > w2) {
                temp = w4;
                w4 = w2;
                w2 = temp;
            }
            if (w6 > w4) {
                w4 = w6;
            }
            if (w4 > w2) {
                w4 = w2;
            }
            return w4;
        }
    }

    private static class ForByteTableBased
    extends MedianBySquare3x3 {
        private ForByteTableBased(long[] dimensions) {
            super(Byte.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            byte[] result = (byte[])resultJavaArray;
            byte[] source = (byte[])sourceJavaArray;
            int v0 = source[firstLineOffset + this.dimXm1] & 0xFF;
            int v1 = source[firstLineOffset] & 0xFF;
            int v2 = source[firstLineOffset + this.rem1ForDimX] & 0xFF;
            int v3 = source[middleLineOffset + this.dimXm1] & 0xFF;
            int v4 = source[middleLineOffset] & 0xFF;
            int v5 = source[middleLineOffset + this.rem1ForDimX] & 0xFF;
            int v6 = source[lastLineOffset + this.dimXm1] & 0xFF;
            int v7 = source[lastLineOffset] & 0xFF;
            int v8 = source[lastLineOffset + this.rem1ForDimX] & 0xFF;
            result[resultLineOffset] = (byte)ForByteTableBased.medianNoOverflow(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset] & 0xFF;
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset] & 0xFF;
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset] & 0xFF;
                int w0 = v0;
                int w1 = v1;
                int w2 = v2;
                int w3 = v3;
                int w4 = v4;
                int w5 = v5;
                int w6 = v6;
                int w7 = v7;
                int w8 = v8;
                int temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w2 - w1];
                w1 += temp;
                w2 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w5 - w4];
                w4 += temp;
                w5 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w8 - w7];
                w7 += temp;
                w8 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w1 - w0];
                w0 += temp;
                w1 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w4 - w3];
                w3 += temp;
                w4 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w7 - w6];
                w6 += temp;
                w7 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w2 - w1];
                w1 += temp;
                w2 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w5 - w4];
                w4 += temp;
                w5 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w8 - w7];
                w7 += temp;
                w8 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w3 - w0];
                w3 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w8 - w5];
                w5 += temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w7 - w4];
                w4 += temp;
                w7 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w6 - w3];
                w6 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w4 - w1];
                w4 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w5 - w2];
                w2 += temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w7 - w4];
                w4 += temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w2 - w4];
                w4 += temp;
                w2 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w4 - w6];
                w4 -= temp;
                temp = ANTI_DOZ_TABLE_FOR_BYTES[256 + w2 - w4];
                result[++resultLineOffset] = (byte)(w4 += temp);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1] & 0xFF;
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1] & 0xFF;
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1] & 0xFF;
                result[++resultLineOffset] = (byte)ForByteTableBased.medianNoOverflow(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }
    }
}

