/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.linearfiltering;

import java.util.Objects;
import net.algart.arrays.AbstractArrayProcessorWithContextSwitching;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.patterns.WeightedPattern;
import net.algart.matrices.linearfiltering.Convolution;

public abstract class AbstractConvolution
extends AbstractArrayProcessorWithContextSwitching
implements Convolution {
    protected final boolean incrementForUnsigned;
    protected final boolean incrementByHalfForInteger;

    protected AbstractConvolution(ArrayContext context, boolean incrementForUnsigned, boolean incrementByHalfForInteger) {
        super(context);
        this.incrementForUnsigned = incrementForUnsigned;
        this.incrementByHalfForInteger = incrementByHalfForInteger;
    }

    @Override
    public Convolution context(ArrayContext newContext) {
        return (Convolution)super.context(newContext);
    }

    @Override
    public abstract boolean isPseudoCyclic();

    @Override
    public double increment(Class<?> elementType) {
        if (this.incrementForUnsigned) {
            if (elementType == Byte.TYPE) {
                return this.incrementByHalfForInteger ? 128.5 : 128.0;
            }
            if (elementType == Short.TYPE || elementType == Character.TYPE) {
                return this.incrementByHalfForInteger ? 32768.5 : 32768.0;
            }
        }
        if (this.incrementByHalfForInteger && (elementType == Boolean.TYPE || elementType == Character.TYPE || elementType == Byte.TYPE || elementType == Short.TYPE || elementType == Integer.TYPE || elementType == Long.TYPE)) {
            return 0.5;
        }
        return 0.0;
    }

    @Override
    public Matrix<? extends PArray> asConvolution(Matrix<? extends PArray> src, WeightedPattern pattern) {
        return this.asConvolution(src.type(PArray.class), src, pattern);
    }

    @Override
    public abstract <T extends PArray> Matrix<T> asConvolution(Class<? extends T> var1, Matrix<? extends PArray> var2, WeightedPattern var3);

    @Override
    public Matrix<? extends UpdatablePArray> convolution(Matrix<? extends PArray> src, WeightedPattern pattern) {
        return this.convolution(src.updatableType(UpdatablePArray.class), src, pattern).cast(UpdatablePArray.class);
    }

    @Override
    public <T extends PArray> Matrix<? extends T> convolution(Class<? extends T> requiredType, Matrix<? extends PArray> src, WeightedPattern pattern) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(pattern, "Null pattern argument");
        Class<?> elementType = Arrays.elementType(requiredType);
        Matrices.checkNewMatrixType(requiredType, elementType);
        Matrix<UpdatablePArray> dest = this.memoryModel().newMatrix(UpdatablePArray.class, elementType, src.dimensions());
        this.convolution(dest, src, pattern);
        return dest.cast(requiredType);
    }

    @Override
    public void convolution(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, WeightedPattern pattern) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(pattern, "Null pattern argument");
        Matrices.copy(this.context(), dest, this.asConvolution(dest.type(PArray.class), src, pattern));
    }
}

