/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.Objects;
import net.algart.arrays.AbstractDoubleArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayPool;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.SummingHistogram;
import net.algart.arrays.UpdatablePArray;
import net.algart.matrices.morphology.HistogramCache;
import net.algart.matrices.morphology.RankOperationProcessor;

class AveragerBetweenValues
extends RankOperationProcessor {
    private static final boolean DEBUG_MODE = false;
    private final boolean optimizeGetData = OPTIMIZE_GET_DATA;
    private final boolean optimizeDirectArrays = OPTIMIZE_DIRECT_ARRAYS;
    private final boolean inlineOneLevel = INLINE_ONE_LEVEL;
    private final double filler;
    private final boolean fillUsual;
    private final boolean fillMin;
    private final boolean fillMax;
    private final boolean fillNearest;
    private final boolean interpolated;

    AveragerBetweenValues(ArrayContext context, double filler, boolean interpolated, int[] bitLevels) {
        super(context, bitLevels);
        this.filler = filler;
        this.fillMin = filler == Double.NEGATIVE_INFINITY;
        this.fillMax = filler == Double.POSITIVE_INFINITY;
        this.fillNearest = Double.isNaN(filler);
        this.fillUsual = !this.fillMin && !this.fillMax && !this.fillNearest;
        this.interpolated = interpolated;
    }

    @Override
    PArray asProcessed(Class<? extends PArray> desiredType, PArray src, PArray[] additional, long[] dimensions, final long[] shifts, final long[] left, final long[] right) {
        ArrayPool ap2;
        if (additional.length < 2) {
            throw new IllegalArgumentException("Two additional matrices are required (percentile indexes)");
        }
        assert (shifts.length > 0);
        assert (left.length == right.length);
        boolean direct = this.optimizeDirectArrays && src instanceof DirectAccessible && ((DirectAccessible)((Object)src)).hasJavaArray();
        final PArray minV = additional[0];
        final ArrayPool ap1 = this.optimizeDirectArrays && (Arrays.isNCopies(minV) || SimpleMemoryModel.isSimpleArray(minV)) ? null : ArrayPool.getInstance(Arrays.SMM, minV.elementType(), 65536L);
        final PArray maxV = additional[1];
        ArrayPool arrayPool = ap2 = this.optimizeDirectArrays && (Arrays.isNCopies(maxV) || SimpleMemoryModel.isSimpleArray(maxV)) ? null : ArrayPool.getInstance(Arrays.SMM, maxV.elementType(), 65536L);
        if (src instanceof BitArray) {
            final BitArray a = (BitArray)src;
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double v1 = minV.getDouble(index);
                    AveragerBetweenValues.checkNaN(v1);
                    double v2 = maxV.getDouble(index);
                    AveragerBetweenValues.checkNaN(v2);
                    if (v1 < 0.0) {
                        v1 = 0.0;
                    }
                    if (v2 > 2.0) {
                        v2 = 2.0;
                    }
                    if (v2 <= v1) {
                        return AveragerBetweenValues.this.fillMin ? v1 : (AveragerBetweenValues.this.fillMax ? v2 : (AveragerBetweenValues.this.fillNearest ? 0.5 * (v1 + v2) : AveragerBetweenValues.this.filler));
                    }
                    int b = 0;
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if (a.getBit(i)) continue;
                        ++b;
                    }
                    if (v2 <= 1.0) {
                        if (b == 0) {
                            return AveragerBetweenValues.this.fillMin ? v1 : (AveragerBetweenValues.this.fillMax ? v2 : (AveragerBetweenValues.this.fillNearest ? v2 : AveragerBetweenValues.this.filler));
                        }
                        return 0.5 * (v1 + v2);
                    }
                    if (v1 >= 1.0) {
                        if (b == shifts.length) {
                            return AveragerBetweenValues.this.fillMin ? v1 : (AveragerBetweenValues.this.fillMax ? v2 : (AveragerBetweenValues.this.fillNearest ? v1 : AveragerBetweenValues.this.filler));
                        }
                        return 0.5 * (v1 + v2);
                    }
                    assert (v1 < 1.0 && 1.0 < v2);
                    double n1 = b == 0 ? 0.0 : (1.0 - v1) * (double)b;
                    double i1 = b == 0 ? 0.0 : 0.5 * (v1 + 1.0) * n1;
                    double n2 = b == shifts.length ? 0.0 : (v2 - 1.0) * (double)(shifts.length - b);
                    double i2 = b == shifts.length ? 0.0 : 0.5 * (1.0 + v2) * n2;
                    return (i1 + i2) / (n1 + n2);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenValues.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    int[] hist = (int[])histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = new int[1];
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if (a.getBit(i)) continue;
                            hist[0] = hist[0] + 1;
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(minV.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(maxV.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            double w;
                            double v1 = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(v1);
                            double v2 = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(v2);
                            if (v1 < 0.0) {
                                v1 = 0.0;
                            }
                            if (v2 > 2.0) {
                                v2 = 2.0;
                            }
                            double d = AveragerBetweenValues.this.fillMin ? v1 : (AveragerBetweenValues.this.fillMax ? v2 : (w = AveragerBetweenValues.this.fillNearest ? 0.5 * (v1 + v2) : AveragerBetweenValues.this.filler));
                            if (v2 > v1) {
                                int b = hist[0];
                                if (v2 <= 1.0) {
                                    if (b == 0) {
                                        if (AveragerBetweenValues.this.fillNearest) {
                                            w = v2;
                                        }
                                    } else {
                                        w = 0.5 * (v1 + v2);
                                    }
                                } else if (v1 >= 1.0) {
                                    if (b == shifts.length) {
                                        if (AveragerBetweenValues.this.fillNearest) {
                                            w = v1;
                                        }
                                    } else {
                                        w = 0.5 * (v1 + v2);
                                    }
                                } else {
                                    assert (v1 < 1.0 && 1.0 < v2);
                                    double n1 = b == 0 ? 0.0 : (1.0 - v1) * (double)b;
                                    double i1 = b == 0 ? 0.0 : 0.5 * (v1 + 1.0) * n1;
                                    double n2 = b == shifts.length ? 0.0 : (v2 - 1.0) * (double)(shifts.length - b);
                                    double i2 = b == shifts.length ? 0.0 : 0.5 * (1.0 + v2) * n2;
                                    w = (i1 + i2) / (n1 + n2);
                                }
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if (a.getBit(i)) continue;
                                hist[0] = hist[0] - 1;
                                assert (hist[0] >= 0) : "Unbalanced 0 and 1 bits";
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if (a.getBit(i)) continue;
                                hist[0] = hist[0] + 1;
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof CharArray) {
            final CharArray a = (CharArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 16);
            final int bs = 16 - nab;
            final double multiplierInv = 1 << bs;
            final double multiplier = 1.0 / multiplierInv;
            if (direct) {
                boolean implementHere;
                final char[] ja = (char[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && !this.interpolated) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double minValue = minV.getDouble(index);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = maxV.getDouble(index);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 <= v1) {
                                return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                            double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                            double n = c.count();
                            if (n <= 0.0) {
                                return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                            }
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenValues.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue1 = 0;
                            int currentIRank1 = 0;
                            long currentSum1 = 0L;
                            int currentIValue2 = 0;
                            int currentIRank2 = 0;
                            long currentSum2 = 0L;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(minV.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(maxV.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(minValue);
                                    double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(maxValue);
                                    double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                    double value1 = minValue * multiplier;
                                    double value2 = maxValue * multiplier;
                                    if (value1 < 0.0) {
                                        value1 = 0.0;
                                    }
                                    if (value2 > (double)hist.length) {
                                        value2 = hist.length;
                                    }
                                    if (value2 > value1) {
                                        double correction2;
                                        double rank2;
                                        int b2;
                                        double correction1;
                                        double rank1;
                                        double d;
                                        assert (0.0 <= value1 && value2 <= (double)hist.length);
                                        int v1 = (int)value1;
                                        if (v1 < currentIValue1) {
                                            for (j = currentIValue1 - 1; j >= v1; --j) {
                                                b = hist[j];
                                                currentIRank1 -= b;
                                                currentSum1 -= (long)b * (long)j;
                                            }
                                            assert (currentIRank1 >= 0);
                                        } else if (v1 > currentIValue1) {
                                            for (j = currentIValue1; j < v1; ++j) {
                                                b = hist[j];
                                                currentIRank1 += b;
                                                currentSum1 += (long)b * (long)j;
                                            }
                                            assert (currentIRank1 <= shifts.length);
                                        }
                                        currentIValue1 = v1;
                                        int v2 = (int)value2;
                                        if (v2 < currentIValue2) {
                                            for (j = currentIValue2 - 1; j >= v2; --j) {
                                                int b = hist[j];
                                                currentIRank2 -= b;
                                                currentSum2 -= (long)b * (long)j;
                                            }
                                            assert (currentIRank2 >= 0);
                                        } else if (v2 > currentIValue2) {
                                            for (j = currentIValue2; j < v2; ++j) {
                                                int b = hist[j];
                                                currentIRank2 += b;
                                                currentSum2 += (long)b * (long)j;
                                            }
                                            assert (currentIRank2 <= shifts.length);
                                        }
                                        currentIValue2 = v2;
                                        int b1 = 0;
                                        if (v1 == hist.length || (b1 = hist[v1]) == 0 || (d = value1 - (double)v1) == 0.0) {
                                            rank1 = currentIRank1;
                                            correction1 = 0.0;
                                        } else {
                                            double indexInBar = b1 == 1 ? d : d * (double)b1;
                                            rank1 = (double)currentIRank1 + indexInBar;
                                            correction1 = indexInBar * ((double)v1 + 0.5 * d);
                                        }
                                        if (v2 == hist.length || (b2 = hist[v2]) == 0 || (d = value2 - (double)v2) == 0.0) {
                                            rank2 = currentIRank2;
                                            correction2 = 0.0;
                                        } else {
                                            double indexInBar = b2 == 1 ? d : d * (double)b2;
                                            rank2 = (double)currentIRank2 + indexInBar;
                                            correction2 = indexInBar * ((double)v2 + 0.5 * d);
                                        }
                                        double i2 = (double)(currentSum2 - currentSum1) + 0.5 * (double)(currentIRank2 - currentIRank1) + (correction2 - correction1);
                                        if (i2 < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative integral = " + i2));
                                        }
                                        double n = rank2 - rank1;
                                        if (n < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative rank difference= " + n + " = " + rank2 + " - " + rank1));
                                        }
                                        if (n > 0.0) {
                                            w = i2 / n * multiplierInv;
                                        } else if (AveragerBetweenValues.this.fillNearest) {
                                            if (currentIRank2 == 0) {
                                                w = maxValue;
                                            } else if (currentIRank1 + b1 == shifts.length) {
                                                w = minValue;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = w;
                                    for (long shift : right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value < currentIValue1) {
                                            --currentIRank1;
                                            currentSum1 -= (long)value;
                                        }
                                        if (value >= currentIValue2) continue;
                                        --currentIRank2;
                                        currentSum2 -= (long)value;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value < currentIValue1) {
                                            ++currentIRank1;
                                            currentSum1 += (long)value;
                                        }
                                        if (value >= currentIValue2) continue;
                                        ++currentIRank2;
                                        currentSum2 += (long)value;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                if (!this.interpolated) {
                    final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double minValue = minV.getDouble(index);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = maxV.getDouble(index);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 <= v1) {
                                return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                            double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                            double n = c.count();
                            if (n <= 0.0) {
                                return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                            }
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenValues.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenValues.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(minV.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(maxV.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int j;
                                    double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(minValue);
                                    double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(maxValue);
                                    double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                    double v1 = minValue * multiplier;
                                    double v2 = maxValue * multiplier;
                                    if (v2 > v1) {
                                        hist1.moveToValue(v1);
                                        hist2.moveToValue(v2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        double n = hist2.currentRank() - hist1.currentRank();
                                        if (n < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                        }
                                        if (n > 0.0) {
                                            w = i2 / n * multiplierInv;
                                        } else if (AveragerBetweenValues.this.fillNearest) {
                                            if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                                w = maxValue;
                                            } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                                w = minValue;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int j;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                    }
                                    double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = a.getInt(i) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    double n = hist2.currentRank() - hist1.currentRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.exclude(a.getInt(i) >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include(a.getInt(i) >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double minValue = minV.getDouble(index);
                    AveragerBetweenValues.checkNaN(minValue);
                    double maxValue = maxV.getDouble(index);
                    AveragerBetweenValues.checkNaN(maxValue);
                    double v1 = minValue * multiplier;
                    double v2 = maxValue * multiplier;
                    if (v2 <= v1) {
                        return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                    }
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = a.getInt(i) >> bs;
                        hist[n] = hist[n] + 1;
                    }
                    SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                    double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                    double n = c.count();
                    if (n <= 0.0) {
                        return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                    }
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenValues.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenValues.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist1.include(a.getInt(i) >> bs);
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(minV.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(maxV.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 > v1) {
                                hist1.moveToValue(v1);
                                hist2.moveToValue(v2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                }
                                double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                if (n < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                }
                                if (n > 0.0) {
                                    w = i2 / n * multiplierInv;
                                } else if (AveragerBetweenValues.this.fillNearest) {
                                    if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                        w = maxValue;
                                    } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                        w = minValue;
                                    }
                                }
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.exclude(a.getInt(i) >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof ByteArray) {
            final ByteArray a = (ByteArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 8);
            final int bs = 8 - nab;
            final double multiplierInv = 1 << bs;
            final double multiplier = 1.0 / multiplierInv;
            if (direct) {
                boolean implementHere;
                final byte[] ja = (byte[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && !this.interpolated) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double minValue = minV.getDouble(index);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = maxV.getDouble(index);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 <= v1) {
                                return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                            double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                            double n = c.count();
                            if (n <= 0.0) {
                                return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                            }
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenValues.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue1 = 0;
                            int currentIRank1 = 0;
                            long currentSum1 = 0L;
                            int currentIValue2 = 0;
                            int currentIRank2 = 0;
                            long currentSum2 = 0L;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(minV.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(maxV.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(minValue);
                                    double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(maxValue);
                                    double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                    double value1 = minValue * multiplier;
                                    double value2 = maxValue * multiplier;
                                    if (value1 < 0.0) {
                                        value1 = 0.0;
                                    }
                                    if (value2 > (double)hist.length) {
                                        value2 = hist.length;
                                    }
                                    if (value2 > value1) {
                                        double correction2;
                                        double rank2;
                                        int b2;
                                        double correction1;
                                        double rank1;
                                        double d;
                                        assert (0.0 <= value1 && value2 <= (double)hist.length);
                                        int v1 = (int)value1;
                                        if (v1 < currentIValue1) {
                                            for (j = currentIValue1 - 1; j >= v1; --j) {
                                                b = hist[j];
                                                currentIRank1 -= b;
                                                currentSum1 -= (long)b * (long)j;
                                            }
                                            assert (currentIRank1 >= 0);
                                        } else if (v1 > currentIValue1) {
                                            for (j = currentIValue1; j < v1; ++j) {
                                                b = hist[j];
                                                currentIRank1 += b;
                                                currentSum1 += (long)b * (long)j;
                                            }
                                            assert (currentIRank1 <= shifts.length);
                                        }
                                        currentIValue1 = v1;
                                        int v2 = (int)value2;
                                        if (v2 < currentIValue2) {
                                            for (j = currentIValue2 - 1; j >= v2; --j) {
                                                int b = hist[j];
                                                currentIRank2 -= b;
                                                currentSum2 -= (long)b * (long)j;
                                            }
                                            assert (currentIRank2 >= 0);
                                        } else if (v2 > currentIValue2) {
                                            for (j = currentIValue2; j < v2; ++j) {
                                                int b = hist[j];
                                                currentIRank2 += b;
                                                currentSum2 += (long)b * (long)j;
                                            }
                                            assert (currentIRank2 <= shifts.length);
                                        }
                                        currentIValue2 = v2;
                                        int b1 = 0;
                                        if (v1 == hist.length || (b1 = hist[v1]) == 0 || (d = value1 - (double)v1) == 0.0) {
                                            rank1 = currentIRank1;
                                            correction1 = 0.0;
                                        } else {
                                            double indexInBar = b1 == 1 ? d : d * (double)b1;
                                            rank1 = (double)currentIRank1 + indexInBar;
                                            correction1 = indexInBar * ((double)v1 + 0.5 * d);
                                        }
                                        if (v2 == hist.length || (b2 = hist[v2]) == 0 || (d = value2 - (double)v2) == 0.0) {
                                            rank2 = currentIRank2;
                                            correction2 = 0.0;
                                        } else {
                                            double indexInBar = b2 == 1 ? d : d * (double)b2;
                                            rank2 = (double)currentIRank2 + indexInBar;
                                            correction2 = indexInBar * ((double)v2 + 0.5 * d);
                                        }
                                        double i2 = (double)(currentSum2 - currentSum1) + 0.5 * (double)(currentIRank2 - currentIRank1) + (correction2 - correction1);
                                        if (i2 < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative integral = " + i2));
                                        }
                                        double n = rank2 - rank1;
                                        if (n < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative rank difference= " + n + " = " + rank2 + " - " + rank1));
                                        }
                                        if (n > 0.0) {
                                            w = i2 / n * multiplierInv;
                                        } else if (AveragerBetweenValues.this.fillNearest) {
                                            if (currentIRank2 == 0) {
                                                w = maxValue;
                                            } else if (currentIRank1 + b1 == shifts.length) {
                                                w = minValue;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = w;
                                    for (long shift : right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value < currentIValue1) {
                                            --currentIRank1;
                                            currentSum1 -= (long)value;
                                        }
                                        if (value >= currentIValue2) continue;
                                        --currentIRank2;
                                        currentSum2 -= (long)value;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value < currentIValue1) {
                                            ++currentIRank1;
                                            currentSum1 += (long)value;
                                        }
                                        if (value >= currentIValue2) continue;
                                        ++currentIRank2;
                                        currentSum2 += (long)value;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                if (!this.interpolated) {
                    final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double minValue = minV.getDouble(index);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = maxV.getDouble(index);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 <= v1) {
                                return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                            double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                            double n = c.count();
                            if (n <= 0.0) {
                                return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                            }
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenValues.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenValues.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include((ja[jaOfs + (int)i] & 0xFF) >> bs);
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(minV.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(maxV.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int j;
                                    double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(minValue);
                                    double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(maxValue);
                                    double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                    double v1 = minValue * multiplier;
                                    double v2 = maxValue * multiplier;
                                    if (v2 > v1) {
                                        hist1.moveToValue(v1);
                                        hist2.moveToValue(v2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        double n = hist2.currentRank() - hist1.currentRank();
                                        if (n < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                        }
                                        if (n > 0.0) {
                                            w = i2 / n * multiplierInv;
                                        } else if (AveragerBetweenValues.this.fillNearest) {
                                            if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                                w = maxValue;
                                            } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                                w = minValue;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include((ja[jaOfs + (int)i] & 0xFF) >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int j;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                    }
                                    double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = a.getInt(i) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    double n = hist2.currentRank() - hist1.currentRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.exclude(a.getInt(i) >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include(a.getInt(i) >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double minValue = minV.getDouble(index);
                    AveragerBetweenValues.checkNaN(minValue);
                    double maxValue = maxV.getDouble(index);
                    AveragerBetweenValues.checkNaN(maxValue);
                    double v1 = minValue * multiplier;
                    double v2 = maxValue * multiplier;
                    if (v2 <= v1) {
                        return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                    }
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = a.getInt(i) >> bs;
                        hist[n] = hist[n] + 1;
                    }
                    SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                    double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                    double n = c.count();
                    if (n <= 0.0) {
                        return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                    }
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenValues.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenValues.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist1.include(a.getInt(i) >> bs);
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(minV.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(maxV.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 > v1) {
                                hist1.moveToValue(v1);
                                hist2.moveToValue(v2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                }
                                double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                if (n < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                }
                                if (n > 0.0) {
                                    w = i2 / n * multiplierInv;
                                } else if (AveragerBetweenValues.this.fillNearest) {
                                    if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                        w = maxValue;
                                    } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                        w = minValue;
                                    }
                                }
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.exclude(a.getInt(i) >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof ShortArray) {
            final ShortArray a = (ShortArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 16);
            final int bs = 16 - nab;
            final double multiplierInv = 1 << bs;
            final double multiplier = 1.0 / multiplierInv;
            if (direct) {
                boolean implementHere;
                final short[] ja = (short[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && !this.interpolated) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double minValue = minV.getDouble(index);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = maxV.getDouble(index);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 <= v1) {
                                return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                            double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                            double n = c.count();
                            if (n <= 0.0) {
                                return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                            }
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenValues.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue1 = 0;
                            int currentIRank1 = 0;
                            long currentSum1 = 0L;
                            int currentIValue2 = 0;
                            int currentIRank2 = 0;
                            long currentSum2 = 0L;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(minV.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(maxV.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(minValue);
                                    double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(maxValue);
                                    double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                    double value1 = minValue * multiplier;
                                    double value2 = maxValue * multiplier;
                                    if (value1 < 0.0) {
                                        value1 = 0.0;
                                    }
                                    if (value2 > (double)hist.length) {
                                        value2 = hist.length;
                                    }
                                    if (value2 > value1) {
                                        double correction2;
                                        double rank2;
                                        int b2;
                                        double correction1;
                                        double rank1;
                                        double d;
                                        assert (0.0 <= value1 && value2 <= (double)hist.length);
                                        int v1 = (int)value1;
                                        if (v1 < currentIValue1) {
                                            for (j = currentIValue1 - 1; j >= v1; --j) {
                                                b = hist[j];
                                                currentIRank1 -= b;
                                                currentSum1 -= (long)b * (long)j;
                                            }
                                            assert (currentIRank1 >= 0);
                                        } else if (v1 > currentIValue1) {
                                            for (j = currentIValue1; j < v1; ++j) {
                                                b = hist[j];
                                                currentIRank1 += b;
                                                currentSum1 += (long)b * (long)j;
                                            }
                                            assert (currentIRank1 <= shifts.length);
                                        }
                                        currentIValue1 = v1;
                                        int v2 = (int)value2;
                                        if (v2 < currentIValue2) {
                                            for (j = currentIValue2 - 1; j >= v2; --j) {
                                                int b = hist[j];
                                                currentIRank2 -= b;
                                                currentSum2 -= (long)b * (long)j;
                                            }
                                            assert (currentIRank2 >= 0);
                                        } else if (v2 > currentIValue2) {
                                            for (j = currentIValue2; j < v2; ++j) {
                                                int b = hist[j];
                                                currentIRank2 += b;
                                                currentSum2 += (long)b * (long)j;
                                            }
                                            assert (currentIRank2 <= shifts.length);
                                        }
                                        currentIValue2 = v2;
                                        int b1 = 0;
                                        if (v1 == hist.length || (b1 = hist[v1]) == 0 || (d = value1 - (double)v1) == 0.0) {
                                            rank1 = currentIRank1;
                                            correction1 = 0.0;
                                        } else {
                                            double indexInBar = b1 == 1 ? d : d * (double)b1;
                                            rank1 = (double)currentIRank1 + indexInBar;
                                            correction1 = indexInBar * ((double)v1 + 0.5 * d);
                                        }
                                        if (v2 == hist.length || (b2 = hist[v2]) == 0 || (d = value2 - (double)v2) == 0.0) {
                                            rank2 = currentIRank2;
                                            correction2 = 0.0;
                                        } else {
                                            double indexInBar = b2 == 1 ? d : d * (double)b2;
                                            rank2 = (double)currentIRank2 + indexInBar;
                                            correction2 = indexInBar * ((double)v2 + 0.5 * d);
                                        }
                                        double i2 = (double)(currentSum2 - currentSum1) + 0.5 * (double)(currentIRank2 - currentIRank1) + (correction2 - correction1);
                                        if (i2 < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative integral = " + i2));
                                        }
                                        double n = rank2 - rank1;
                                        if (n < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative rank difference= " + n + " = " + rank2 + " - " + rank1));
                                        }
                                        if (n > 0.0) {
                                            w = i2 / n * multiplierInv;
                                        } else if (AveragerBetweenValues.this.fillNearest) {
                                            if (currentIRank2 == 0) {
                                                w = maxValue;
                                            } else if (currentIRank1 + b1 == shifts.length) {
                                                w = minValue;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = w;
                                    for (long shift : right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value < currentIValue1) {
                                            --currentIRank1;
                                            currentSum1 -= (long)value;
                                        }
                                        if (value >= currentIValue2) continue;
                                        --currentIRank2;
                                        currentSum2 -= (long)value;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value < currentIValue1) {
                                            ++currentIRank1;
                                            currentSum1 += (long)value;
                                        }
                                        if (value >= currentIValue2) continue;
                                        ++currentIRank2;
                                        currentSum2 += (long)value;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                if (!this.interpolated) {
                    final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double minValue = minV.getDouble(index);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = maxV.getDouble(index);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 <= v1) {
                                return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                            double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                            double n = c.count();
                            if (n <= 0.0) {
                                return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                            }
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenValues.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenValues.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(minV.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(maxV.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int j;
                                    double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(minValue);
                                    double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(maxValue);
                                    double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                    double v1 = minValue * multiplier;
                                    double v2 = maxValue * multiplier;
                                    if (v2 > v1) {
                                        hist1.moveToValue(v1);
                                        hist2.moveToValue(v2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        double n = hist2.currentRank() - hist1.currentRank();
                                        if (n < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                        }
                                        if (n > 0.0) {
                                            w = i2 / n * multiplierInv;
                                        } else if (AveragerBetweenValues.this.fillNearest) {
                                            if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                                w = maxValue;
                                            } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                                w = minValue;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int j;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                    }
                                    double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = a.getInt(i) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    double n = hist2.currentRank() - hist1.currentRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.exclude(a.getInt(i) >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist1.include(a.getInt(i) >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double minValue = minV.getDouble(index);
                    AveragerBetweenValues.checkNaN(minValue);
                    double maxValue = maxV.getDouble(index);
                    AveragerBetweenValues.checkNaN(maxValue);
                    double v1 = minValue * multiplier;
                    double v2 = maxValue * multiplier;
                    if (v2 <= v1) {
                        return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                    }
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = a.getInt(i) >> bs;
                        hist[n] = hist[n] + 1;
                    }
                    SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                    double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                    double n = c.count();
                    if (n <= 0.0) {
                        return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                    }
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenValues.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenValues.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist1.include(a.getInt(i) >> bs);
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(minV.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(maxV.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 > v1) {
                                hist1.moveToValue(v1);
                                hist2.moveToValue(v2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                }
                                double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                if (n < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                }
                                if (n > 0.0) {
                                    w = i2 / n * multiplierInv;
                                } else if (AveragerBetweenValues.this.fillNearest) {
                                    if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                        w = maxValue;
                                    } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                        w = minValue;
                                    }
                                }
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.exclude(a.getInt(i) >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist1.include(a.getInt(i) >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof IntArray) {
            final IntArray a = (IntArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 30);
            final int bs = 31 - nab;
            final double multiplierInv = 1L << bs;
            final double multiplier = 1.0 / multiplierInv;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final int[] ja = (int[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double minValue = minV.getDouble(index);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = maxV.getDouble(index);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 <= v1) {
                                return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                int v;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0) {
                                    v = 0;
                                }
                                int n = v >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                            double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                            double n = c.count();
                            if (n <= 0.0) {
                                return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                            }
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenValues.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenValues.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    int v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    hist1.include(v >> bs);
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(minV.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(maxV.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int v;
                                    long i;
                                    int j;
                                    double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(minValue);
                                    double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(maxValue);
                                    double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                    double v1 = minValue * multiplier;
                                    double v2 = maxValue * multiplier;
                                    if (v2 > v1) {
                                        hist1.moveToValue(v1);
                                        hist2.moveToValue(v2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        double n = hist2.currentRank() - hist1.currentRank();
                                        if (n < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                        }
                                        if (n > 0.0) {
                                            w = i2 / n * multiplierInv;
                                        } else if (AveragerBetweenValues.this.fillNearest) {
                                            if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                                w = maxValue;
                                            } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                                w = minValue;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0) {
                                            v = 0;
                                        }
                                        barIndexes[j] = v >> bs;
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0) {
                                            v = 0;
                                        }
                                        barIndexes[j] = v >> bs;
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            int v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = ja[jaOfs + (int)i]) < 0) {
                                v = 0;
                            }
                            int n = v >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                int v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0) {
                                    v = 0;
                                }
                                hist1.include(v >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int v;
                                long i;
                                int j;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                    }
                                    double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    barIndexes[j] = v >> bs;
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    barIndexes[j] = v >> bs;
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            int v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getInt(i)) < 0) {
                                v = 0;
                            }
                            int n = v >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                int v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist1.include(v >> bs);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int v;
                                long i;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    double n = hist2.currentRank() - hist1.currentRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getInt(i)) < 0) {
                                        v = 0;
                                    }
                                    hist1.exclude(v >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getInt(i)) < 0) {
                                        v = 0;
                                    }
                                    hist1.include(v >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double minValue = minV.getDouble(index);
                    AveragerBetweenValues.checkNaN(minValue);
                    double maxValue = maxV.getDouble(index);
                    AveragerBetweenValues.checkNaN(maxValue);
                    double v1 = minValue * multiplier;
                    double v2 = maxValue * multiplier;
                    if (v2 <= v1) {
                        return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                    }
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        int v;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((v = a.getInt(i)) < 0) {
                            v = 0;
                        }
                        int n = v >> bs;
                        hist[n] = hist[n] + 1;
                    }
                    SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                    double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                    double n = c.count();
                    if (n <= 0.0) {
                        return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                    }
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenValues.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenValues.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            int v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getInt(i)) < 0) {
                                v = 0;
                            }
                            hist1.include(v >> bs);
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(minV.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(maxV.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int v;
                            long i;
                            double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 > v1) {
                                hist1.moveToValue(v1);
                                hist2.moveToValue(v2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                }
                                double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                if (n < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                }
                                if (n > 0.0) {
                                    w = i2 / n * multiplierInv;
                                } else if (AveragerBetweenValues.this.fillNearest) {
                                    if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                        w = maxValue;
                                    } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                        w = minValue;
                                    }
                                }
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist1.exclude(v >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist1.include(v >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof LongArray) {
            final LongArray a = (LongArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 30);
            final int bs = 63 - nab;
            final double multiplierInv = 1L << bs;
            final double multiplier = 1.0 / multiplierInv;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final long[] ja = (long[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double minValue = minV.getDouble(index);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = maxV.getDouble(index);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 <= v1) {
                                return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            }
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long v;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0L) {
                                    v = 0L;
                                }
                                int n = (int)(v >> bs);
                                hist[n] = hist[n] + 1;
                            }
                            SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                            double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                            double n = c.count();
                            if (n <= 0.0) {
                                return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                            }
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenValues.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenValues.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    long v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    hist1.include((int)(v >> bs));
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(minV.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(maxV.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long v;
                                    long i;
                                    int j;
                                    double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(minValue);
                                    double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(maxValue);
                                    double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                    double v1 = minValue * multiplier;
                                    double v2 = maxValue * multiplier;
                                    if (v2 > v1) {
                                        hist1.moveToValue(v1);
                                        hist2.moveToValue(v2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        double n = hist2.currentRank() - hist1.currentRank();
                                        if (n < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                        }
                                        if (n > 0.0) {
                                            w = i2 / n * multiplierInv;
                                        } else if (AveragerBetweenValues.this.fillNearest) {
                                            if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                                w = maxValue;
                                            } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                                w = minValue;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0L) {
                                            v = 0L;
                                        }
                                        barIndexes[j] = (int)(v >> bs);
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0L) {
                                            v = 0L;
                                        }
                                        barIndexes[j] = (int)(v >> bs);
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = ja[jaOfs + (int)i]) < 0L) {
                                v = 0L;
                            }
                            int n = (int)(v >> bs);
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0L) {
                                    v = 0L;
                                }
                                hist1.include((int)(v >> bs));
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long v;
                                long i;
                                int j;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                    }
                                    double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    barIndexes[j] = (int)(v >> bs);
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    barIndexes[j] = (int)(v >> bs);
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getLong(i)) < 0L) {
                                v = 0L;
                            }
                            int n = (int)(v >> bs);
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, true, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                long v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist1.include((int)(v >> bs));
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long v;
                                long i;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    double n = hist2.currentRank() - hist1.currentRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getLong(i)) < 0L) {
                                        v = 0L;
                                    }
                                    hist1.exclude((int)(v >> bs));
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getLong(i)) < 0L) {
                                        v = 0L;
                                    }
                                    hist1.include((int)(v >> bs));
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double minValue = minV.getDouble(index);
                    AveragerBetweenValues.checkNaN(minValue);
                    double maxValue = maxV.getDouble(index);
                    AveragerBetweenValues.checkNaN(maxValue);
                    double v1 = minValue * multiplier;
                    double v2 = maxValue * multiplier;
                    if (v2 <= v1) {
                        return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                    }
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long v;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((v = a.getLong(i)) < 0L) {
                            v = 0L;
                        }
                        int n = (int)(v >> bs);
                        hist[n] = hist[n] + 1;
                    }
                    SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                    double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                    double n = c.count();
                    if (n <= 0.0) {
                        return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                    }
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenValues.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(1 << nab, false, AveragerBetweenValues.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            long v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getLong(i)) < 0L) {
                                v = 0L;
                            }
                            hist1.include((int)(v >> bs));
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(minV.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(maxV.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long v;
                            long i;
                            double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 > v1) {
                                hist1.moveToValue(v1);
                                hist2.moveToValue(v2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                }
                                double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                if (n < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                }
                                if (n > 0.0) {
                                    w = i2 / n * multiplierInv;
                                } else if (AveragerBetweenValues.this.fillNearest) {
                                    if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                        w = maxValue;
                                    } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                        w = minValue;
                                    }
                                }
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist1.exclude((int)(v >> bs));
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist1.include((int)(v >> bs));
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof FloatArray) {
            final FloatArray a = (FloatArray)src;
            final int histLength = 1 << this.numberOfAnalyzedBits;
            final double multiplier = histLength - 1;
            final double multiplierInv = 1.0 / multiplier;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final float[] ja = (float[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double minValue = minV.getDouble(index);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = maxV.getDouble(index);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 <= v1) {
                                return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            }
                            int[] hist = new int[histLength];
                            for (long shift : shifts) {
                                double v;
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist[n] = hist[n] + 1;
                            }
                            SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                            double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                            double n = c.count();
                            if (n <= 0.0) {
                                return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                            }
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenValues.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(histLength, true, AveragerBetweenValues.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    double v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.include(histIndex);
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(minV.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(maxV.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double v;
                                    long i;
                                    int j;
                                    double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(minValue);
                                    double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(maxValue);
                                    double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                    double v1 = minValue * multiplier;
                                    double v2 = maxValue * multiplier;
                                    if (v2 > v1) {
                                        hist1.moveToValue(v1);
                                        hist2.moveToValue(v2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        double n = hist2.currentRank() - hist1.currentRank();
                                        if (n < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                        }
                                        if (n > 0.0) {
                                            w = i2 / n * multiplierInv;
                                        } else if (AveragerBetweenValues.this.fillNearest) {
                                            if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                                w = maxValue;
                                            } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                                w = minValue;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(histLength, false, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                double v;
                                long i;
                                int j;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                    }
                                    double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(histLength, true, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int histIndex;
                                double v;
                                long i;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    double n = hist2.currentRank() - hist1.currentRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.exclude(histIndex);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.include(histIndex);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double minValue = minV.getDouble(index);
                    AveragerBetweenValues.checkNaN(minValue);
                    double maxValue = maxV.getDouble(index);
                    AveragerBetweenValues.checkNaN(maxValue);
                    double v1 = minValue * multiplier;
                    double v2 = maxValue * multiplier;
                    if (v2 <= v1) {
                        return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                    }
                    int[] hist = new int[histLength];
                    for (long shift : shifts) {
                        double v;
                        int histIndex;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                        hist[n] = hist[n] + 1;
                    }
                    SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                    double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                    double n = c.count();
                    if (n <= 0.0) {
                        return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                    }
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenValues.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(histLength, false, AveragerBetweenValues.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            double v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist1.include(histIndex);
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(minV.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(maxV.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int histIndex;
                            double v;
                            long i;
                            double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 > v1) {
                                hist1.moveToValue(v1);
                                hist2.moveToValue(v2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                }
                                double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                if (n < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                }
                                if (n > 0.0) {
                                    w = i2 / n * multiplierInv;
                                } else if (AveragerBetweenValues.this.fillNearest) {
                                    if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                        w = maxValue;
                                    } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                        w = minValue;
                                    }
                                }
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.exclude(histIndex);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        if (src instanceof DoubleArray) {
            final DoubleArray a = (DoubleArray)src;
            final int histLength = 1 << this.numberOfAnalyzedBits;
            final double multiplier = histLength - 1;
            final double multiplierInv = 1.0 / multiplier;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final double[] ja = (double[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double minValue = minV.getDouble(index);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = maxV.getDouble(index);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 <= v1) {
                                return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            }
                            int[] hist = new int[histLength];
                            for (long shift : shifts) {
                                double v;
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist[n] = hist[n] + 1;
                            }
                            SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                            double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                            double n = c.count();
                            if (n <= 0.0) {
                                return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                            }
                            return i / n * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!AveragerBetweenValues.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                            UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                            int bufLen = ap1 == null && ap2 == null ? count : 65536;
                            SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                            if (hist1 == null) {
                                hist1 = SummingHistogram.newSummingIntHistogram(histLength, true, AveragerBetweenValues.this.bitLevels);
                                hist1.share();
                                for (long shift : shifts) {
                                    double v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.include(histIndex);
                                }
                            }
                            SummingHistogram hist2 = hist1.nextSharing();
                            assert (hist1.shareCount() == 2L);
                            assert (hist2.shareCount() == 2L);
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap1 != null) {
                                    buf1.copy(minV.subArr(arrayPos, len));
                                }
                                if (ap2 != null) {
                                    buf2.copy(maxV.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double v;
                                    long i;
                                    int j;
                                    double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(minValue);
                                    double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                    AveragerBetweenValues.checkNaN(maxValue);
                                    double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                    double v1 = minValue * multiplier;
                                    double v2 = maxValue * multiplier;
                                    if (v2 > v1) {
                                        hist1.moveToValue(v1);
                                        hist2.moveToValue(v2);
                                        double i2 = hist1.currentIntegralBetweenSharing();
                                        if (i2 < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                        }
                                        double n = hist2.currentRank() - hist1.currentRank();
                                        if (n < -1.0E-5) {
                                            throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                        }
                                        if (n > 0.0) {
                                            w = i2 / n * multiplierInv;
                                        } else if (AveragerBetweenValues.this.fillNearest) {
                                            if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                                w = maxValue;
                                            } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                                w = minValue;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = w;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist1.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist1.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist1);
                            if (ap2 != null) {
                                ap2.releaseArray(buf2);
                            }
                            if (ap1 != null) {
                                ap1.releaseArray(buf1);
                            }
                        }
                    };
                }
                assert (this.interpolated);
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(histLength, false, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                double v;
                                long i;
                                int j;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                    }
                                    double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist1.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist1.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double minValue = minV.getDouble(index);
                        AveragerBetweenValues.checkNaN(minValue);
                        double maxValue = maxV.getDouble(index);
                        AveragerBetweenValues.checkNaN(maxValue);
                        double v1 = minValue * multiplier;
                        double v2 = maxValue * multiplier;
                        if (v2 <= v1) {
                            return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                        }
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n] = hist[n] + 1;
                        }
                        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                        double i = SummingHistogram.integralBetweenValues(hist, v1, v2, c);
                        double n = c.count();
                        if (n <= 0.0) {
                            return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                        }
                        return i / n * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!AveragerBetweenValues.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                        UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                        int bufLen = ap1 == null && ap2 == null ? count : 65536;
                        SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                        if (hist1 == null) {
                            hist1 = SummingHistogram.newSummingIntHistogram(histLength, true, AveragerBetweenValues.this.bitLevels);
                            hist1.share();
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                        }
                        SummingHistogram hist2 = hist1.nextSharing();
                        assert (hist1.shareCount() == 2L);
                        assert (hist2.shareCount() == 2L);
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap1 != null) {
                                buf1.copy(minV.subArr(arrayPos, len));
                            }
                            if (ap2 != null) {
                                buf2.copy(maxV.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int histIndex;
                                double v;
                                long i;
                                double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(minValue);
                                double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                                AveragerBetweenValues.checkNaN(maxValue);
                                double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                                double v1 = minValue * multiplier;
                                double v2 = maxValue * multiplier;
                                if (v2 > v1) {
                                    hist1.moveToValue(v1);
                                    hist2.moveToValue(v2);
                                    double i2 = hist1.currentIntegralBetweenSharing();
                                    if (i2 < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral()));
                                    }
                                    double n = hist2.currentRank() - hist1.currentRank();
                                    if (n < -1.0E-5) {
                                        throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentRank() + " - " + hist1.currentRank()));
                                    }
                                    if (n > 0.0) {
                                        w = i2 / n * multiplierInv;
                                    } else if (AveragerBetweenValues.this.fillNearest) {
                                        if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                            w = maxValue;
                                        } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                            w = minValue;
                                        }
                                    }
                                }
                                dest[destArrayOffset] = w;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.exclude(histIndex);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist1.include(histIndex);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist1);
                        if (ap2 != null) {
                            ap2.releaseArray(buf2);
                        }
                        if (ap1 != null) {
                            ap1.releaseArray(buf1);
                        }
                    }
                };
            }
            assert (this.interpolated);
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double minValue = minV.getDouble(index);
                    AveragerBetweenValues.checkNaN(minValue);
                    double maxValue = maxV.getDouble(index);
                    AveragerBetweenValues.checkNaN(maxValue);
                    double v1 = minValue * multiplier;
                    double v2 = maxValue * multiplier;
                    if (v2 <= v1) {
                        return AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                    }
                    int[] hist = new int[histLength];
                    for (long shift : shifts) {
                        double v;
                        int histIndex;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                        hist[n] = hist[n] + 1;
                    }
                    SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
                    double i = SummingHistogram.preciseIntegralBetweenValues(hist, v1, v2, c);
                    double n = c.count();
                    if (n <= 0.0) {
                        return AveragerBetweenValues.this.fillUsual ? AveragerBetweenValues.this.filler : (AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (c.isLeftBound() ? maxValue : (c.isRightBound() ? minValue : 0.5 * (minValue + maxValue)))));
                    }
                    return i / n * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!AveragerBetweenValues.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    AveragerBetweenValues.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf1 = ap1 == null ? null : (UpdatablePArray)ap1.requestArray();
                    UpdatablePArray buf2 = ap2 == null ? null : (UpdatablePArray)ap2.requestArray();
                    int bufLen = ap1 == null && ap2 == null ? count : 65536;
                    SummingHistogram hist1 = (SummingHistogram)histogramCache.get(arrayPos);
                    if (hist1 == null) {
                        hist1 = SummingHistogram.newSummingIntHistogram(histLength, false, AveragerBetweenValues.this.bitLevels);
                        hist1.share();
                        for (long shift : shifts) {
                            double v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist1.include(histIndex);
                        }
                    }
                    SummingHistogram hist2 = hist1.nextSharing();
                    assert (hist1.shareCount() == 2L);
                    assert (hist2.shareCount() == 2L);
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap1 != null) {
                            buf1.copy(minV.subArr(arrayPos, len));
                        }
                        if (ap2 != null) {
                            buf2.copy(maxV.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int histIndex;
                            double v;
                            long i;
                            double minValue = ap1 != null ? buf1.getDouble(k) : minV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(minValue);
                            double maxValue = ap2 != null ? buf2.getDouble(k) : maxV.getDouble(arrayPos);
                            AveragerBetweenValues.checkNaN(maxValue);
                            double w = AveragerBetweenValues.this.fillMin ? minValue : (AveragerBetweenValues.this.fillMax ? maxValue : (AveragerBetweenValues.this.fillNearest ? 0.5 * (minValue + maxValue) : AveragerBetweenValues.this.filler));
                            double v1 = minValue * multiplier;
                            double v2 = maxValue * multiplier;
                            if (v2 > v1) {
                                hist1.moveToValue(v1);
                                hist2.moveToValue(v2);
                                double i2 = hist1.currentPreciseIntegralBetweenSharing();
                                if (i2 < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative integral = " + i2 + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral()));
                                }
                                double n = hist2.currentPreciseRank() - hist1.currentPreciseRank();
                                if (n < -1.0E-5) {
                                    throw new AssertionError((Object)("Negative rank difference= " + n + " = " + hist2.currentPreciseRank() + " - " + hist1.currentPreciseRank()));
                                }
                                if (n > 0.0) {
                                    w = i2 / n * multiplierInv;
                                } else if (AveragerBetweenValues.this.fillNearest) {
                                    if (hist2.leftFromOrAtBoundOfNonZeroPart()) {
                                        w = maxValue;
                                    } else if (hist1.rightFromOrAtBoundOfNonZeroPart()) {
                                        w = minValue;
                                    }
                                }
                            }
                            dest[destArrayOffset] = w;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.exclude(histIndex);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist1.include(histIndex);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist1);
                    if (ap2 != null) {
                        ap2.releaseArray(buf2);
                    }
                    if (ap1 != null) {
                        ap1.releaseArray(buf1);
                    }
                }
            };
        }
        throw new AssertionError((Object)("Illegal array type (" + String.valueOf(src.getClass()) + "): it must implement one of primitive XxxArray interfaces"));
    }

    private static void checkRanges(long length, long arrayPos, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw new IndexOutOfBoundsException("arrayPos = " + arrayPos + " < 0");
        }
        if (arrayPos > length - (long)count) {
            throw new IndexOutOfBoundsException("arrayPos+count = " + arrayPos + "+" + count + " > length=" + length);
        }
    }

    private static void checkNaN(double rank) {
        if (Double.isNaN(rank)) {
            throw new IllegalArgumentException("Illegal value (NaN) in some elements of minValues or maxValues");
        }
    }

    private static void debugIntegral(long arrayPos, double v1, double v2, SummingHistogram hist1, SummingHistogram hist2, double n, double i) {
        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
        assert (!c.isInitialized());
        if (Math.abs(i - SummingHistogram.integralBetweenValues(hist1.bars(), v1, v2, c)) > 0.01) {
            throw new AssertionError((Object)("Bug: at index " + arrayPos + ", integral between " + v1 + " and " + v2 + " is " + i + " = " + hist2.currentIntegral() + " - " + hist1.currentIntegral() + " instead of " + SummingHistogram.integralBetweenValues(hist1.bars(), v1, v2, c) + ", histogram is " + JArrays.toString(hist1.bars(), ",", 2048)));
        }
        if (Math.abs(c.count() - n) > 0.001) {
            throw new AssertionError((Object)("Bug: at index " + arrayPos + ", rank difference between " + v1 + " and " + v2 + " is " + n + " = " + hist2.currentRank() + "-" + hist1.currentRank() + " instead of " + c.count() + ", integral = " + SummingHistogram.integralBetweenValues(hist1.bars(), v1, v2, c) + ", histogram is " + JArrays.toString(hist1.bars(), ",", 2048)));
        }
        if (n <= 0.0 && (c.isRightBound() != hist1.rightFromOrAtBoundOfNonZeroPart() || c.isLeftBound() != hist2.leftFromOrAtBoundOfNonZeroPart())) {
            throw new AssertionError((Object)("Bug: at index " + arrayPos + ", between " + v1 + " and " + v2 + ", left bound = " + hist2.leftFromOrAtBoundOfNonZeroPart() + " and right bound = " + hist1.rightFromOrAtBoundOfNonZeroPart() + " instead of " + String.valueOf(c) + ", integral = " + SummingHistogram.integralBetweenValues(hist1.bars(), v1, v2, c) + ", histogram is " + JArrays.toString(hist1.bars(), ",", 2048)));
        }
    }

    private static void debugPreciseIntegral(long arrayPos, double v1, double v2, SummingHistogram hist1, SummingHistogram hist2, double n, double i) {
        SummingHistogram.CountOfValues c = new SummingHistogram.CountOfValues();
        assert (!c.isInitialized());
        if (Math.abs(i - SummingHistogram.preciseIntegralBetweenValues(hist1.bars(), v1, v2, c)) > 0.01) {
            throw new AssertionError((Object)("Bug: at index " + arrayPos + ", integral between " + v1 + " and " + v2 + " is " + i + " = " + hist2.currentPreciseIntegral() + " - " + hist1.currentPreciseIntegral() + " instead of " + SummingHistogram.preciseIntegralBetweenValues(hist1.bars(), v1, v2, c) + ", histogram is " + JArrays.toString(hist1.bars(), ",", 2048)));
        }
        if (Math.abs(c.count() - n) > 0.001) {
            throw new AssertionError((Object)("Bug: at index " + arrayPos + ", rank difference between " + v1 + " and " + v2 + " is " + n + " = " + hist2.currentPreciseRank() + "-" + hist1.currentPreciseRank() + " instead of " + c.count() + ", precise integral = " + SummingHistogram.preciseIntegralBetweenValues(hist1.bars(), v1, v2, c) + ", histogram is " + JArrays.toString(hist1.bars(), ",", 2048)));
        }
        if (n <= 0.0 && (c.isRightBound() != hist1.rightFromOrAtBoundOfNonZeroPart() || c.isLeftBound() != hist2.leftFromOrAtBoundOfNonZeroPart())) {
            throw new AssertionError((Object)("Bug: at index " + arrayPos + ", between " + v1 + " and " + v2 + ", left bound = " + hist2.leftFromOrAtBoundOfNonZeroPart() + " and right bound = " + hist1.rightFromOrAtBoundOfNonZeroPart() + " instead of " + String.valueOf(c) + ", precise integral = " + SummingHistogram.preciseIntegralBetweenValues(hist1.bars(), v1, v2, c) + ", histogram is " + JArrays.toString(hist1.bars(), ",", 2048)));
        }
    }
}

