/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.ArrayList;
import java.util.List;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.DependenceApertureBuilder;
import net.algart.matrices.morphology.RankMorphology;

class Continuer {
    private final Matrix<? extends UpdatablePArray> continuedDest;
    private final List<Matrix<? extends PArray>> continuedArguments;
    private final IRectangularArea aperture;

    public Continuer(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern, RankMorphology parent, Matrix.ContinuationMode continuationMode) {
        this(dest, Matrices.several(PArray.class, src), pattern, parent, continuationMode);
    }

    public Continuer(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src1, Matrix<? extends PArray> src2, Pattern pattern, RankMorphology parent, Matrix.ContinuationMode continuationMode) {
        this(dest, Matrices.several(PArray.class, src1, src2), pattern, parent, continuationMode);
    }

    public Continuer(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src1, Matrix<? extends PArray> src2, Matrix<? extends PArray> src3, Pattern pattern, RankMorphology parent, Matrix.ContinuationMode continuationMode) {
        this(dest, Matrices.several(PArray.class, src1, src2, src3), pattern, parent, continuationMode);
    }

    public Continuer(Matrix<? extends UpdatablePArray> dest, List<Matrix<? extends PArray>> arguments, Pattern pattern, RankMorphology parent, Matrix.ContinuationMode continuationMode) {
        arguments = new ArrayList<Matrix<? extends PArray>>(arguments);
        Matrix<? extends PArray> mainArgument = arguments.get(0);
        if (dest != null) {
            Matrices.checkDimensionEquality(dest, mainArgument);
        }
        Matrices.checkDimensionEquality(arguments);
        arguments.remove(0);
        DependenceApertureBuilder builder = dest == null && parent.isPseudoCyclic() ? DependenceApertureBuilder.SUM : DependenceApertureBuilder.SUM_MAX_0;
        this.aperture = builder.getAperture(mainArgument.dimCount(), pattern, false);
        Matrix<? extends PArray> continuedSrc = DependenceApertureBuilder.extend(mainArgument, this.aperture, continuationMode);
        this.continuedArguments = this.extendAdditionalMatrices(arguments);
        this.continuedArguments.add(0, continuedSrc);
        this.continuedDest = dest == null ? null : DependenceApertureBuilder.extend(dest, this.aperture, Matrix.ContinuationMode.ZERO_CONSTANT);
    }

    public Matrix<? extends PArray> get(int index) {
        return this.continuedArguments.get(index);
    }

    public Matrix<? extends UpdatablePArray> continuedDest() {
        assert (this.continuedDest != null);
        return this.continuedDest;
    }

    public <T extends PArray> Matrix<T> reduce(Matrix<T> matrix) {
        assert (this.continuedDest == null);
        return DependenceApertureBuilder.reduce(matrix, this.aperture);
    }

    private List<Matrix<? extends PArray>> extendAdditionalMatrices(List<Matrix<? extends PArray>> matrices) {
        if (matrices.isEmpty()) {
            return matrices;
        }
        ArrayList<Matrix<? extends PArray>> continued = new ArrayList<Matrix<? extends PArray>>();
        for (Matrix<? extends PArray> m : matrices) {
            long[] from = this.aperture.min().coordinates();
            long[] to = IPoint.valueOf(m.dimensions()).add(this.aperture.max()).coordinates();
            continued.add(m.isEmpty() ? m : m.subMatrix(from, to, Matrix.ContinuationMode.ZERO_CONSTANT));
        }
        return continued;
    }
}

