/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.skeletons;

import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayProcessor;
import net.algart.arrays.BitArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PIntegerArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatableBitArray;
import net.algart.matrices.skeletons.BasicSkeletonPixelClassifier2D;
import net.algart.matrices.skeletons.ErodingSkeleton;
import net.algart.matrices.skeletons.SkeletonPixelClassifier;

public final class SkeletonScanner
implements ArrayProcessor {
    final ArrayContext context;
    final MemoryModel memoryModel;
    final Matrix<? extends BitArray> skeleton;
    final SkeletonPixelClassifier pixelClassifier;
    private final int dimCount;
    private final int numberOfNeighbours;
    private final BitArray skeletonArray;
    private final UpdatableBitArray visitedArray;
    private final Matrix<? extends PIntegerArray> pixelTypesOrAttachingBranches;
    private final Matrix<? extends PIntegerArray> pixelTypesOrAttachedNodes;
    private final PIntegerArray pixelTypesOrAttachingBranchesArray;
    private final PIntegerArray pixelTypesOrAttachedNodesArray;
    private final long arrayLength;
    private final long[] neighbourOffsetsInArray;
    private long currentIndexInArray = -1L;
    private int previousBranchStepDirection = -1;
    private long startIndexInArray = -1L;

    SkeletonScanner(ArrayContext context, Matrix<? extends BitArray> skeleton, SkeletonPixelClassifier pixelClassifier, boolean rememberVisitedPixels) {
        Objects.requireNonNull(skeleton, "Null skeleton matrix");
        Objects.requireNonNull(pixelClassifier, "Null pixel classifier");
        if (pixelClassifier.dimCount() != skeleton.dimCount()) {
            throw new IllegalArgumentException("pixelClassifier has " + pixelClassifier.dimCount() + " dimensions, but the skeleton matrix has " + skeleton.dimCount() + " dimensions");
        }
        this.context = context;
        this.memoryModel = context == null ? SimpleMemoryModel.getInstance() : context.getMemoryModel();
        this.skeleton = skeleton;
        this.skeletonArray = this.skeleton.array();
        this.pixelClassifier = pixelClassifier;
        this.dimCount = pixelClassifier.dimCount;
        this.numberOfNeighbours = pixelClassifier.numberOfNeighbours;
        this.neighbourOffsetsInArray = new long[this.numberOfNeighbours];
        long[] no = new long[this.dimCount];
        for (int k = 0; k < this.numberOfNeighbours; ++k) {
            pixelClassifier.neighbourOffset(no, k);
            this.neighbourOffsetsInArray[k] = skeleton.pseudoCyclicIndex(no);
        }
        this.arrayLength = this.skeletonArray.length();
        this.pixelTypesOrAttachingBranches = pixelClassifier.asPixelTypes(this.skeleton, SkeletonPixelClassifier.AttachmentInformation.NEIGHBOUR_INDEX_OF_ATTACHING_BRANCH);
        this.pixelTypesOrAttachingBranchesArray = this.pixelTypesOrAttachingBranches.array();
        this.pixelTypesOrAttachedNodes = pixelClassifier.asPixelTypes(this.skeleton, SkeletonPixelClassifier.AttachmentInformation.NEIGHBOUR_INDEX_OF_ATTACHED_NODE);
        this.pixelTypesOrAttachedNodesArray = this.pixelTypesOrAttachedNodes.array();
        if (rememberVisitedPixels) {
            Matrix<UpdatableBitArray> visitedMatrix = ErodingSkeleton.mm(this.memoryModel, skeleton, 1).newBitMatrix(skeleton.dimensions());
            if (!SimpleMemoryModel.isSimpleArray(visitedMatrix.array())) {
                visitedMatrix = visitedMatrix.structureLike(skeleton);
            }
            this.visitedArray = visitedMatrix.array();
        } else {
            this.visitedArray = null;
        }
    }

    public static SkeletonScanner getRememberingInstance(ArrayContext context, Matrix<? extends BitArray> skeleton, SkeletonPixelClassifier pixelClassifier) {
        return new SkeletonScanner(context, skeleton, pixelClassifier, true);
    }

    public static SkeletonScanner getRememberingOctupleThinningInstance2D(ArrayContext context, Matrix<? extends BitArray> skeleton) {
        return SkeletonScanner.getRememberingInstance(context, skeleton, BasicSkeletonPixelClassifier2D.getOctupleThinningInstance());
    }

    public static SkeletonScanner getRememberingQuadruple3x5ThinningInstance2D(ArrayContext context, Matrix<? extends BitArray> skeleton) {
        return SkeletonScanner.getRememberingInstance(context, skeleton, BasicSkeletonPixelClassifier2D.getQuadruple3x5ThinningInstance());
    }

    public static SkeletonScanner getRememberingStrongQuadruple3x5ThinningInstance2D(ArrayContext context, Matrix<? extends BitArray> skeleton) {
        return SkeletonScanner.getRememberingInstance(context, skeleton, BasicSkeletonPixelClassifier2D.getStrongQuadruple3x5ThinningInstance());
    }

    public static SkeletonScanner getLightweightInstance(ArrayContext context, Matrix<? extends BitArray> skeleton, SkeletonPixelClassifier pixelClassifier) {
        return new SkeletonScanner(context, skeleton, pixelClassifier, false);
    }

    public static SkeletonScanner getLightweightOctupleThinningInstance2D(ArrayContext context, Matrix<? extends BitArray> skeleton) {
        return SkeletonScanner.getLightweightInstance(context, skeleton, BasicSkeletonPixelClassifier2D.getOctupleThinningInstance());
    }

    public static SkeletonScanner getLightweightQuadruple3x5ThinningInstance2D(ArrayContext context, Matrix<? extends BitArray> skeleton) {
        return SkeletonScanner.getLightweightInstance(context, skeleton, BasicSkeletonPixelClassifier2D.getQuadruple3x5ThinningInstance());
    }

    public static SkeletonScanner getLightweightStrongQuadruple3x5ThinningInstance2D(ArrayContext context, Matrix<? extends BitArray> skeleton) {
        return SkeletonScanner.getLightweightInstance(context, skeleton, BasicSkeletonPixelClassifier2D.getStrongQuadruple3x5ThinningInstance());
    }

    @Override
    public ArrayContext context() {
        return this.context;
    }

    public SkeletonScanner getCompatibleRememberingInstance() {
        return new SkeletonScanner(this.context, this.skeleton, this.pixelClassifier, true);
    }

    public SkeletonScanner getCompatibleLightweightInstance() {
        return new SkeletonScanner(this.context, this.skeleton, this.pixelClassifier, false);
    }

    public Matrix<? extends BitArray> skeleton() {
        return this.skeleton;
    }

    public SkeletonPixelClassifier pixelClassifier() {
        return this.pixelClassifier;
    }

    public int dimCount() {
        return this.dimCount;
    }

    public int numberOfNeighbours() {
        return this.numberOfNeighbours;
    }

    public long neighbourOffsetInArray(int neighbourIndex) {
        this.checkNeighbourIndex(neighbourIndex);
        return this.neighbourOffsetsInArray[neighbourIndex];
    }

    public Matrix<? extends PIntegerArray> asPixelTypes(SkeletonPixelClassifier.AttachmentInformation attachmentInformation) {
        Objects.requireNonNull(attachmentInformation, "Null attachmentInformation");
        return switch (attachmentInformation) {
            case SkeletonPixelClassifier.AttachmentInformation.NEIGHBOUR_INDEX_OF_ATTACHING_BRANCH -> this.pixelTypesOrAttachingBranches;
            case SkeletonPixelClassifier.AttachmentInformation.NEIGHBOUR_INDEX_OF_ATTACHED_NODE -> this.pixelTypesOrAttachedNodes;
            default -> throw new AssertionError((Object)("Unknown attachmentInformation: " + String.valueOf((Object)attachmentInformation)));
        };
    }

    public boolean isInitialized() {
        return this.currentIndexInArray != -1L;
    }

    public long[] currentCoordinates() {
        this.checkInitialized();
        return this.skeleton.coordinates(this.currentIndexInArray, null);
    }

    public long currentIndexInArray() {
        this.checkInitialized();
        return this.currentIndexInArray;
    }

    public boolean currentPixelValue() {
        this.checkInitialized();
        return this.skeletonArray.getBit(this.currentIndexInArray);
    }

    public int currentPixelTypeOrAttachingBranch() {
        this.checkInitialized();
        return this.pixelTypesOrAttachingBranchesArray.getInt(this.currentIndexInArray);
    }

    public int currentPixelTypeOrAttachedNode() {
        this.checkInitialized();
        return this.pixelTypesOrAttachedNodesArray.getInt(this.currentIndexInArray);
    }

    public long[] neighbourCoordinates(int neighbourIndex) {
        return this.skeleton.coordinates(this.neighbourIndexInArray(neighbourIndex), null);
    }

    public long neighbourIndexInArray(int neighbourIndex) {
        this.checkInitialized();
        this.checkNeighbourIndex(neighbourIndex);
        long index = this.currentIndexInArray + this.neighbourOffsetInArray(neighbourIndex);
        if (index >= this.arrayLength) {
            index -= this.arrayLength;
        }
        assert (index <= this.arrayLength) : index + " > " + this.arrayLength + ", currentIndexInArray=" + this.currentIndexInArray + ": " + String.valueOf(this);
        return index;
    }

    public boolean neighbourValue(int neighbourIndex) {
        return this.skeletonArray.getBit(this.neighbourIndexInArray(neighbourIndex));
    }

    public int neighbourTypeOrAttachingBranch(int neighbourIndex) {
        return this.pixelTypesOrAttachingBranchesArray.getInt(this.neighbourIndexInArray(neighbourIndex));
    }

    public int neighbourTypeOrAttachedNode(int neighbourIndex) {
        return this.pixelTypesOrAttachedNodesArray.getInt(this.neighbourIndexInArray(neighbourIndex));
    }

    public boolean isNode() {
        this.checkInitialized();
        return SkeletonPixelClassifier.isNodePixelType(this.pixelTypesOrAttachingBranchesArray.getInt(this.currentIndexInArray));
    }

    public boolean isUsualBranch() {
        this.checkInitialized();
        return SkeletonPixelClassifier.isUsualBranchPixelType(this.pixelTypesOrAttachingBranchesArray.getInt(this.currentIndexInArray));
    }

    public boolean isFreeBranchEnd() {
        this.checkInitialized();
        return SkeletonPixelClassifier.isFreeBranchEndPixelType(this.pixelTypesOrAttachingBranchesArray.getInt(this.currentIndexInArray));
    }

    public boolean isAttachableBranchEnd() {
        this.checkInitialized();
        return SkeletonPixelClassifier.isAttachableBranchEndPixelType(this.pixelTypesOrAttachingBranchesArray.getInt(this.currentIndexInArray));
    }

    public boolean isNodeOrFreeBranchEnd() {
        this.checkInitialized();
        return SkeletonPixelClassifier.isNodeOrFreeBranchEndPixelType(this.pixelTypesOrAttachingBranchesArray.getInt(this.currentIndexInArray));
    }

    public boolean isBranch() {
        this.checkInitialized();
        return SkeletonPixelClassifier.isBranchPixelType(this.pixelTypesOrAttachingBranchesArray.getInt(this.currentIndexInArray));
    }

    public boolean isIllegal() {
        this.checkInitialized();
        return SkeletonPixelClassifier.isIllegalPixelType(this.pixelTypesOrAttachingBranchesArray.getInt(this.currentIndexInArray));
    }

    public boolean isNeighbourNodeOrFreeBranchEnd(int neighbourIndex) {
        return SkeletonPixelClassifier.isNodeOrFreeBranchEndPixelType(this.pixelTypesOrAttachingBranchesArray.getInt(this.neighbourIndexInArray(neighbourIndex)));
    }

    public void goTo(long ... newCurrentCoordinates) {
        this.checkCoordinates(newCurrentCoordinates);
        this.currentIndexInArray = this.skeleton.index((long[])newCurrentCoordinates.clone());
        this.previousBranchStepDirection = -1;
    }

    public void goToIndexInArray(long newIndexInArray) {
        if (newIndexInArray < 0L || newIndexInArray >= this.arrayLength) {
            throw new IndexOutOfBoundsException("Index in array " + newIndexInArray + " is out of range 0.." + this.arrayLength);
        }
        this.currentIndexInArray = newIndexInArray;
        this.previousBranchStepDirection = -1;
    }

    public void goToNeighbour(int neighbourIndex) {
        this.checkInitialized();
        long index = this.currentIndexInArray + this.neighbourOffsetInArray(neighbourIndex);
        if (index >= this.arrayLength) {
            index -= this.arrayLength;
        }
        assert (index <= this.arrayLength) : index + " > " + this.arrayLength + ", currentIndexInArray=" + this.currentIndexInArray + ": " + String.valueOf(this);
        this.currentIndexInArray = index;
    }

    public boolean nextNodeOrBranch() {
        return this.nextNodeOrBranchPixelType() != null;
    }

    public Integer nextNodeOrBranchPixelType() {
        int pixelType;
        long index = this.currentIndexInArray;
        do {
            if ((index = this.skeletonArray.indexOf(index + 1L, this.arrayLength, true)) != -1L) continue;
            return null;
        } while ((pixelType = this.pixelTypesOrAttachedNodesArray.getInt(index)) == -5);
        this.currentIndexInArray = index;
        this.previousBranchStepDirection = -1;
        return pixelType;
    }

    public int[] adjacentBranches() throws IllegalStateException {
        int[] neighbourIndexes = new int[this.numberOfNeighbours];
        int n = this.adjacentBranches(neighbourIndexes);
        return JArrays.copyOfRange(neighbourIndexes, 0, n);
    }

    public int adjacentBranches(int[] result) throws IllegalStateException {
        Objects.requireNonNull(result, "Null result argument");
        if (result.length < this.numberOfNeighbours) {
            throw new IllegalArgumentException("Length of result array  is less than the number of neighbours of every pixel " + this.numberOfNeighbours);
        }
        if (!this.isNode()) {
            throw new IllegalStateException("adjacentBranches() must be called at nodes only: " + String.valueOf(this));
        }
        for (int k = 0; k < this.numberOfNeighbours; ++k) {
            result[k] = this.neighbourTypeOrAttachingBranch(k);
        }
        this.pixelClassifier.markNeighbouringNodesNotConnectedViaDegeneratedBranches(result);
        int count = 0;
        for (int k = 0; k < this.numberOfNeighbours; ++k) {
            int reverseStepDirection;
            int neighbourType = result[k];
            if (SkeletonPixelClassifier.isAttachableBranchEndPixelType(neighbourType) && neighbourType != (reverseStepDirection = this.pixelClassifier.reverseNeighbourIndex(k)) && this.neighbourTypeOrAttachedNode(k) != reverseStepDirection || !SkeletonPixelClassifier.isBranchPixelType(neighbourType) && !SkeletonPixelClassifier.isNodePixelType(neighbourType)) continue;
            result[count++] = k;
        }
        return count;
    }

    public boolean firstStep(int neighbourIndex, boolean onlyToUnvisited) throws IllegalStateException {
        int reverseStepDirection;
        if (!this.isNode()) {
            throw new IllegalStateException("Cannot perform first branch step with direction (" + neighbourIndex + ") from a pixel of the type " + this.currentPixelTypeOrAttachingBranch() + " - it must be a node or isolated pixel: " + String.valueOf(this));
        }
        if (onlyToUnvisited && this.neighbourVisitRemembered(neighbourIndex)) {
            return false;
        }
        int neighbourType = this.neighbourTypeOrAttachingBranch(neighbourIndex);
        if (SkeletonPixelClassifier.isBranchPixelType(neighbourType) ? SkeletonPixelClassifier.isAttachableBranchEndPixelType(neighbourType) && neighbourType != (reverseStepDirection = this.pixelClassifier.reverseNeighbourIndex(neighbourIndex)) && this.neighbourTypeOrAttachedNode(neighbourIndex) != reverseStepDirection : !SkeletonPixelClassifier.isNodePixelType(neighbourType)) {
            return false;
        }
        this.startIndexInArray = this.currentIndexInArray;
        this.shiftAlongBranch(neighbourIndex);
        return true;
    }

    public boolean firstStepFromBranch(boolean onlyToUnvisited) throws IllegalStateException {
        int nextNeighbourIndex = this.firstStepFromBranchNeighbourIndex(onlyToUnvisited);
        if (nextNeighbourIndex == -1) {
            return false;
        }
        this.startIndexInArray = this.currentIndexInArray;
        this.shiftAlongBranch(nextNeighbourIndex);
        return true;
    }

    public int firstStepFromBranchNeighbourIndex(boolean onlyToUnvisited) throws IllegalStateException {
        int pixelType = this.currentPixelTypeOrAttachedNode();
        if (SkeletonPixelClassifier.isAttachableBranchEndPixelType(pixelType)) {
            if (!onlyToUnvisited || !this.neighbourVisitRemembered(pixelType)) {
                return pixelType;
            }
            pixelType = this.currentPixelTypeOrAttachingBranch();
            if (!this.neighbourVisitRemembered(pixelType)) {
                return pixelType;
            }
            return -1;
        }
        switch (pixelType) {
            case -4: 
            case -3: {
                int neighbourCount = 0;
                for (int k = 0; k < this.numberOfNeighbours; ++k) {
                    if (!this.neighbourValue(k)) continue;
                    ++neighbourCount;
                    if (onlyToUnvisited && this.neighbourVisitRemembered(k)) continue;
                    return k;
                }
                if (neighbourCount != (pixelType == -3 ? 1 : 2)) {
                    throw new AssertionError((Object)("Illegal detection of " + pixelType + ": there are no neighbours in " + String.valueOf(this)));
                }
                return -1;
            }
        }
        throw new IllegalStateException("Cannot perform first branch step without direction from a pixel of the type " + pixelType + " - it must be a branch element: " + String.valueOf(this));
    }

    public boolean nextStep() throws IllegalStateException {
        this.checkInitialized();
        if (this.previousBranchStepDirection == -1) {
            throw new IllegalStateException("nextStep() must be called after successful firstStep/firstStepFromBranch or another nextStep() only");
        }
        if (this.currentIndexInArray == this.startIndexInArray) {
            return false;
        }
        int reverseStepDirection = this.pixelClassifier.reverseNeighbourIndex(this.previousBranchStepDirection);
        int nextDirection = 157;
        int neighbourCount = 1;
        for (int k = 0; k < this.numberOfNeighbours; ++k) {
            if (k == reverseStepDirection || !this.neighbourValue(k)) continue;
            nextDirection = k;
            ++neighbourCount;
        }
        if (neighbourCount == 2) {
            this.shiftAlongBranch(nextDirection);
            return true;
        }
        if (neighbourCount == 1) {
            return false;
        }
        int pixelType = this.currentPixelTypeOrAttachingBranch();
        if (pixelType >= 0) {
            this.shiftAlongBranch(pixelType != reverseStepDirection ? pixelType : this.currentPixelTypeOrAttachedNode());
            return true;
        }
        return switch (pixelType) {
            case -1 -> false;
            case -2 -> throw new AssertionError((Object)("Illegal detection of an isolated pixel at a branch: " + String.valueOf(this)));
            case -3 -> throw new AssertionError((Object)("Illegal detection of TYPE_FREE_BRANCH_END: here is at least " + neighbourCount + " neighbours in " + String.valueOf(this)));
            case -4 -> throw new AssertionError((Object)("Illegal detection of TYPE_USUAL_BRANCH: here is at least " + neighbourCount + " neighbours in " + String.valueOf(this)));
            case -5 -> false;
            case -6 -> throw new AssertionError((Object)("Illegal detection of a zero pixel at a branch: " + String.valueOf(this)));
            default -> throw new AssertionError((Object)("Unknown pixel type " + pixelType + " detected at a branch: " + String.valueOf(this)));
        };
    }

    public void scanBranch(int neighbourIndex, boolean onlyToUnvisited, boolean withVisiting) throws IllegalStateException {
        if (this.firstStep(neighbourIndex, onlyToUnvisited)) {
            long counter = 0L;
            do {
                if (withVisiting) {
                    this.visitPreviousBranchPixel();
                }
                if (this.context == null || (++counter & 0xFFFFL) != 0L) continue;
                this.context.checkInterruption();
            } while (this.nextStep());
        }
    }

    public void scanBranchFromBranch(boolean onlyToUnvisited, boolean withVisiting) throws IllegalStateException {
        if (this.firstStepFromBranch(onlyToUnvisited)) {
            long counter = 0L;
            do {
                if (withVisiting) {
                    this.visitPreviousBranchPixel();
                }
                if (this.context == null || (++counter & 0xFFFFL) != 0L) continue;
                this.context.checkInterruption();
            } while (this.nextStep());
        }
    }

    public int previousBranchStepDirection() {
        this.checkInitialized();
        return this.previousBranchStepDirection;
    }

    public long[] previousCoordinates() {
        this.checkInitialized();
        if (this.previousBranchStepDirection == -1) {
            throw new IllegalStateException("previousCoordinates() must be called after successful firstStep/firstStepFromBranch or another nextStep() only");
        }
        return this.skeleton.coordinates(this.previousIndexInArray(), null);
    }

    public long previousIndexInArray() {
        this.checkInitialized();
        if (this.previousBranchStepDirection == -1) {
            throw new IllegalStateException("previousIndexInArray() must be called after successful firstStep/firstStepFromBranch or another nextStep() only");
        }
        long index = this.currentIndexInArray - this.neighbourOffsetInArray(this.previousBranchStepDirection);
        if (index < 0L) {
            index += this.arrayLength;
        }
        return index;
    }

    public boolean isRemembering() {
        return this.visitedArray != null;
    }

    public boolean pixelVisitRemembered() {
        this.checkInitialized();
        return this.visitedArray != null && this.visitedArray.getBit(this.currentIndexInArray);
    }

    public boolean neighbourVisitRemembered(int neighbourIndex) {
        this.checkInitialized();
        this.checkNeighbourIndex(neighbourIndex);
        long index = this.currentIndexInArray + this.neighbourOffsetInArray(neighbourIndex);
        if (index >= this.arrayLength) {
            index -= this.arrayLength;
        }
        assert (index <= this.arrayLength) : index + " > " + this.arrayLength + ", currentIndexInArray=" + this.currentIndexInArray + ": " + String.valueOf(this);
        return this.visitedArray != null && this.visitedArray.getBit(index);
    }

    public void visit() {
        this.checkInitialized();
        if (this.visitedArray != null) {
            this.visitedArray.setBit(this.currentIndexInArray);
        }
    }

    public void visitPreviousBranchPixel() {
        this.checkInitialized();
        if (this.previousBranchStepDirection == -1) {
            throw new IllegalStateException("visitPreviousBranchPixel() must be called after successful firstStep/firstStepFromBranch or another nextStep() only");
        }
        if (this.visitedArray != null) {
            long index = this.currentIndexInArray - this.neighbourOffsetInArray(this.previousBranchStepDirection);
            if (index < 0L) {
                index += this.arrayLength;
            }
            this.visitedArray.setBit(index);
        }
    }

    public void reset() {
        if (this.visitedArray != null && this.isInitialized()) {
            this.visitedArray.fill(false);
        }
        this.currentIndexInArray = -1L;
        this.previousBranchStepDirection = -1;
    }

    public void updateProgress() {
        if (this.context != null) {
            this.context.updateProgress(new ArrayContext.Event(Boolean.TYPE, this.currentIndexInArray(), this.skeleton.size()));
        }
    }

    public void checkInterruption() {
        if (this.context != null) {
            this.context.checkInterruption();
        }
    }

    public String toString() {
        return "skeleton scanner, " + (String)(this.isInitialized() ? "position (" + JArrays.toString(this.currentCoordinates(), ",", 100) + ")" : "not initialized") + (String)(this.previousBranchStepDirection >= 0 ? ", last branch step " + this.previousBranchStepDirection : "") + " for " + String.valueOf(this.skeleton);
    }

    private void checkInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("The skeleton scanner is not positioned yet");
        }
    }

    private void checkCoordinates(long[] coordinates) {
        Objects.requireNonNull(coordinates, "Null list of coordinates");
        if (coordinates.length != this.dimCount) {
            throw new IllegalArgumentException("Number of coordinates " + coordinates.length + " is not equal to the number of matrix dimensions " + this.dimCount);
        }
    }

    private void checkNeighbourIndex(int neighbourIndex) {
        if (neighbourIndex < 0 || neighbourIndex >= this.numberOfNeighbours) {
            throw new IndexOutOfBoundsException("Illegal neighbourIndex = " + neighbourIndex + ": must be in 0.." + (this.numberOfNeighbours - 1) + " range");
        }
    }

    private void shiftAlongBranch(int neighbourIndex) {
        long index = this.currentIndexInArray + this.neighbourOffsetInArray(neighbourIndex);
        if (index >= this.arrayLength) {
            index -= this.arrayLength;
        }
        assert (index <= this.arrayLength) : index + " > " + this.arrayLength + ", currentIndexInArray=" + this.currentIndexInArray + ": " + String.valueOf(this);
        this.currentIndexInArray = index;
        this.previousBranchStepDirection = neighbourIndex;
    }
}

