/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.spectra;

import java.util.concurrent.atomic.AtomicLong;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataDoubleBuffer;
import net.algart.arrays.DataFloatBuffer;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.JArrays;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;
import net.algart.matrices.spectra.AbstractSpectralTransform;
import net.algart.matrices.spectra.Conversions;

class SpectraOfConvolution {
    private static final boolean OPTIMIZE_1D_FOURIER_SPECTRUM_OF_CONVOLUTION = true;
    private static final boolean OPTIMIZE_1D_HARTLEY_SPECTRUM_OF_CONVOLUTION = true;
    private static final boolean OPTIMIZE_2D_HARTLEY_SPECTRUM_OF_CONVOLUTION = true;
    private static final int BUF_CAP = 8192;
    private static final Func XY_MINUS_XY_PLUS_XY_MINUS_XY = new AbstractFunc(){

        @Override
        public double get(double ... x) {
            return x[0] * x[1] - x[2] * x[3] + x[4] * x[5] - x[6] * x[7];
        }
    };
    private static final Func XY_MINUS_XY_MINUS_XY_PLUS_XY = new AbstractFunc(){

        @Override
        public double get(double ... x) {
            return x[0] * x[1] - x[2] * x[3] - x[4] * x[5] + x[6] * x[7];
        }
    };
    private static final Func XY_PLUS_XY_PLUS_XY_PLUS_XY = new AbstractFunc(){

        @Override
        public double get(double ... x) {
            return x[0] * x[1] + x[2] * x[3] + x[4] * x[5] + x[6] * x[7];
        }
    };
    private static final Func XY_PLUS_XY_MINUS_XY_MINUS_XY = new AbstractFunc(){

        @Override
        public double get(double ... x) {
            return x[0] * x[1] + x[2] * x[3] - x[4] * x[5] - x[6] * x[7];
        }
    };

    SpectraOfConvolution() {
    }

    static void fourierSpectrumOfConvolution(ArrayContext context, UpdatablePNumberArray cRe, UpdatablePNumberArray cIm, PNumberArray pRe, PNumberArray pIm, PNumberArray qRe, PNumberArray qIm) {
        if (Conversions.allFloat(cRe, cIm, pRe, pIm, qRe, qIm)) {
            SpectraOfConvolution.fourierSpectrumOfConvolutionOfFloatArrays(context, cRe, cIm, pRe, pIm, qRe, qIm, cRe.length());
            return;
        }
        if (Conversions.allDouble(cRe, cIm, pRe, pIm, qRe, qIm)) {
            SpectraOfConvolution.fourierSpectrumOfConvolutionOfDoubleArrays(context, cRe, cIm, pRe, pIm, qRe, qIm, cRe.length());
            return;
        }
        long n = cRe.length();
        for (long k = 0L; k < n; ++k) {
            double pReV = pRe.getDouble(k);
            double pImV = pIm.getDouble(k);
            double qReV = qRe.getDouble(k);
            double qImV = qIm.getDouble(k);
            cRe.setDouble(k, pReV * qReV - pImV * qImV);
            cIm.setDouble(k, pReV * qImV + pImV * qReV);
            if (context == null || (k & 0xFFFFL) != 65535L) continue;
            context.checkInterruptionAndUpdateProgress(cRe.elementType(), k, n);
        }
    }

    static void separableHartleySpectrumOfConvolution(ArrayContext context, long maxTempJavaMemory, UpdatablePNumberArray cRe, UpdatablePNumberArray cIm, PNumberArray pRe, PNumberArray pIm, PNumberArray qRe, PNumberArray qIm, long[] dimensions, int numberOfTasks) {
        long n = dimensions[dimensions.length - 1];
        assert (n >= 0L);
        if (n == 0L) {
            return;
        }
        assert (cIm == null == (pIm == null));
        assert (cIm == null == (qIm == null));
        if (dimensions.length == 1) {
            assert (n == pRe.length());
            if (Conversions.allFloat(cRe, cIm, pRe, pIm, qRe, qIm)) {
                if (cIm != null) {
                    SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfComplexFloatArrays(context, cRe, cIm, pRe, pIm, qRe, qIm, n);
                } else {
                    SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfRealFloatArrays(context, cRe, pRe, qRe, n);
                }
                return;
            }
            if (Conversions.allDouble(cRe, cIm, pRe, pIm, qRe, qIm)) {
                if (cIm != null) {
                    SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfComplexDoubleArrays(context, cRe, cIm, pRe, pIm, qRe, qIm, n);
                } else {
                    SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfRealDoubleArrays(context, cRe, pRe, qRe, n);
                }
                return;
            }
            if (cIm != null) {
                SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfComplexArrays(context, cRe, cIm, pRe, pIm, qRe, qIm, n);
            } else {
                SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfRealArrays(context, cRe, pRe, qRe, n);
            }
            return;
        }
        long nDiv2 = n / 2L;
        long[] layerDims = JArrays.copyOfRange(dimensions, 0, dimensions.length - 1);
        long layerLen = Arrays.longMul(layerDims);
        long totalLen = layerLen * n;
        double layerSize = (double)layerLen * (double)(cRe.bitsPerElement() + (cIm == null ? 0L : cIm.bitsPerElement())) / 8.0;
        long progressMask = layerLen >= 128L ? 255L : (layerLen >= 16L ? 4095L : 65535L);
        boolean cDirect = AbstractSpectralTransform.areDirect(cRe, cIm);
        boolean pqDirect = AbstractSpectralTransform.areDirect(pRe, pIm) && AbstractSpectralTransform.areDirect(qRe, qIm);
        int n2 = numberOfTasks = cDirect && pqDirect ? (int)Math.min((long)numberOfTasks, nDiv2 + 1L) : 1;
        SimpleMemoryModel mm = context == null ? Arrays.SMM : (layerSize * (pqDirect ? 12.0 * (double)numberOfTasks : (cIm == null ? 16.0 : 20.0)) <= (double)Math.max(maxTempJavaMemory, 0L) ? Arrays.SMM : context.getMemoryModel());
        boolean fast2D = dimensions.length == 2 && (cDirect && pqDirect || mm instanceof SimpleMemoryModel) && (Conversions.allFloat(cRe, cIm, pRe, pIm, qRe, qIm) || Conversions.allDouble(cRe, cIm, pRe, pIm, qRe, qIm));
        UpdatablePNumberArray pRe1 = pqDirect ? null : Conversions.newArr(mm, pRe, layerLen);
        UpdatablePNumberArray pIm1 = pqDirect || pIm == null ? null : Conversions.newArr(mm, pIm, layerLen);
        UpdatablePNumberArray pRe2 = pqDirect ? null : Conversions.newArr(mm, pRe, layerLen);
        UpdatablePNumberArray pIm2 = pqDirect || pIm == null ? null : Conversions.newArr(mm, pIm, layerLen);
        UpdatablePNumberArray qRe1 = pqDirect ? null : Conversions.newArr(mm, qRe, layerLen);
        UpdatablePNumberArray qIm1 = pqDirect || qIm == null ? null : Conversions.newArr(mm, qIm, layerLen);
        UpdatablePNumberArray qRe2 = pqDirect ? null : Conversions.newArr(mm, qRe, layerLen);
        UpdatablePNumberArray qIm2 = pqDirect || qIm == null ? null : Conversions.newArr(mm, qIm, layerLen);
        Runnable[] tasks = new Runnable[numberOfTasks];
        AtomicLong readyLayers = new AtomicLong(0L);
        int threadIndex = 0;
        while (threadIndex < tasks.length) {
            UpdatablePNumberArray dRe;
            UpdatablePNumberArray sRe;
            UpdatablePNumberArray wqRe2;
            UpdatablePNumberArray wqRe1;
            UpdatablePNumberArray wpRe2;
            UpdatablePNumberArray wpRe1;
            UpdatablePNumberArray updatablePNumberArray = wpRe1 = fast2D ? null : Conversions.newArr(mm, pRe, layerLen);
            UpdatablePNumberArray wpIm1 = fast2D ? null : Conversions.newArr(mm, pIm != null ? pIm : pRe, layerLen);
            UpdatablePNumberArray updatablePNumberArray2 = wpRe2 = fast2D ? null : Conversions.newArr(mm, pRe, layerLen);
            UpdatablePNumberArray wpIm2 = fast2D ? null : Conversions.newArr(mm, pIm != null ? pIm : pRe, layerLen);
            UpdatablePNumberArray updatablePNumberArray3 = wqRe1 = fast2D ? null : Conversions.newArr(mm, qRe, layerLen);
            UpdatablePNumberArray wqIm1 = fast2D ? null : Conversions.newArr(mm, qIm != null ? qIm : qRe, layerLen);
            UpdatablePNumberArray updatablePNumberArray4 = wqRe2 = fast2D ? null : Conversions.newArr(mm, qRe, layerLen);
            UpdatablePNumberArray wqIm2 = fast2D ? null : Conversions.newArr(mm, qIm != null ? qIm : qRe, layerLen);
            UpdatablePNumberArray wcRe1 = Conversions.newArr(mm, cRe, layerLen);
            UpdatablePNumberArray wcIm1 = Conversions.newArr(mm, cIm != null ? cIm : cRe, layerLen);
            UpdatablePNumberArray wcRe2 = Conversions.newArr(mm, cRe, layerLen);
            UpdatablePNumberArray wcIm2 = Conversions.newArr(mm, cIm != null ? cIm : cRe, layerLen);
            UpdatablePNumberArray updatablePNumberArray5 = sRe = fast2D ? null : Conversions.newArr(mm, cRe, layerLen);
            UpdatablePNumberArray sIm = fast2D ? null : Conversions.newArr(mm, cIm != null ? cIm : cRe, layerLen);
            UpdatablePNumberArray updatablePNumberArray6 = dRe = fast2D ? null : Conversions.newArr(mm, cRe, layerLen);
            UpdatablePNumberArray dIm = fast2D ? null : Conversions.newArr(mm, cIm != null ? cIm : cRe, layerLen);
            int ti = threadIndex++;
            tasks[ti] = () -> {
                long layerStep = (long)tasks.length * layerLen;
                long k1 = ti;
                long disp1 = (long)ti * layerLen;
                while (k1 <= nDiv2) {
                    long rl;
                    long disp2 = k1 == 0L ? 0L : totalLen - disp1;
                    PNumberArray pRe1Local = Conversions.subArrOrCopy(pqDirect ? null : pRe1, pRe, disp1, layerLen);
                    PNumberArray pIm1Local = Conversions.subArrOrCopy(pqDirect ? null : pIm1, pIm, disp1, layerLen);
                    PNumberArray pRe2Local = Conversions.subArrOrCopy(pqDirect ? null : pRe2, pRe, disp2, layerLen);
                    PNumberArray pIm2Local = Conversions.subArrOrCopy(pqDirect ? null : pIm2, pIm, disp2, layerLen);
                    PNumberArray qRe1Local = Conversions.subArrOrCopy(pqDirect ? null : qRe1, qRe, disp1, layerLen);
                    PNumberArray qIm1Local = Conversions.subArrOrCopy(pqDirect ? null : qIm1, qIm, disp1, layerLen);
                    PNumberArray qRe2Local = Conversions.subArrOrCopy(pqDirect ? null : qRe2, qRe, disp2, layerLen);
                    PNumberArray qIm2Local = Conversions.subArrOrCopy(pqDirect ? null : qIm2, qIm, disp2, layerLen);
                    if (fast2D) {
                        if (cDirect) {
                            if (cIm == null) {
                                SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfDirectReal2D((UpdatablePArray)cRe.subArr(disp1, layerLen), (UpdatablePArray)cRe.subArr(disp2, layerLen), pRe1Local, pRe2Local, qRe1Local, qRe2Local, cRe.elementType());
                            } else {
                                SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfDirectComplex2D((UpdatablePArray)cRe.subArr(disp1, layerLen), (UpdatablePArray)cIm.subArr(disp1, layerLen), (UpdatablePArray)cRe.subArr(disp2, layerLen), (UpdatablePArray)cIm.subArr(disp2, layerLen), pRe1Local, pIm1Local, pRe2Local, pIm2Local, qRe1Local, qIm1Local, qRe2Local, qIm2Local, cRe.elementType());
                            }
                        } else {
                            if (cIm == null) {
                                SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfDirectReal2D(wcRe1, wcRe2, pRe1Local, pRe2Local, qRe1Local, qRe2Local, cRe.elementType());
                            } else {
                                SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfDirectComplex2D(wcRe1, wcIm1, wcRe2, wcIm2, pRe1Local, pIm1Local, pRe2Local, pIm2Local, qRe1Local, qIm1Local, qRe2Local, qIm2Local, cRe.elementType());
                            }
                            cRe.subArr(disp1, layerLen).copy(wcRe1);
                            cRe.subArr(disp2, layerLen).copy(wcRe2);
                            if (cIm != null) {
                                cIm.subArr(disp1, layerLen).copy(wcIm1);
                                cIm.subArr(disp2, layerLen).copy(wcIm2);
                            }
                        }
                    } else {
                        UpdatablePNumberArray cIm1;
                        UpdatablePNumberArray cRe2;
                        Conversions.separableHartleyToFourierRecoursive(null, maxTempJavaMemory, wpRe1, wpIm1, pRe1Local, pIm1Local, layerDims, 1);
                        Conversions.separableHartleyToFourierRecoursive(null, maxTempJavaMemory, wpRe2, wpIm2, pRe2Local, pIm2Local, layerDims, 1);
                        Conversions.separableHartleyToFourierRecoursive(null, maxTempJavaMemory, wqRe1, wqIm1, qRe1Local, qIm1Local, layerDims, 1);
                        Conversions.separableHartleyToFourierRecoursive(null, maxTempJavaMemory, wqRe2, wqIm2, qRe2Local, qIm2Local, layerDims, 1);
                        Arrays.applyFunc(null, false, 1, true, Func.HALF_X_PLUS_Y, sRe, wpRe1, wpRe2);
                        Arrays.applyFunc(null, false, 1, true, Func.HALF_X_PLUS_Y, sIm, wpIm1, wpIm2);
                        Arrays.applyFunc(null, false, 1, true, Func.HALF_X_MINUS_Y, dRe, wpRe1, wpRe2);
                        Arrays.applyFunc(null, false, 1, true, Func.HALF_X_MINUS_Y, dIm, wpIm1, wpIm2);
                        Arrays.applyFunc(null, false, 1, true, XY_MINUS_XY_PLUS_XY_MINUS_XY, wcRe1, wqRe1, sRe, wqIm1, sIm, wqRe2, dRe, wqIm2, dIm);
                        Arrays.applyFunc(null, false, 1, true, XY_MINUS_XY_MINUS_XY_PLUS_XY, wcRe2, wqRe2, sRe, wqIm2, sIm, wqRe1, dRe, wqIm1, dIm);
                        Arrays.applyFunc(null, false, 1, true, XY_PLUS_XY_PLUS_XY_PLUS_XY, wcIm1, wqRe1, sIm, wqIm1, sRe, wqRe2, dIm, wqIm2, dRe);
                        Arrays.applyFunc(null, false, 1, true, XY_PLUS_XY_MINUS_XY_MINUS_XY, wcIm2, wqRe2, sIm, wqIm2, sRe, wqRe1, dIm, wqIm1, dRe);
                        UpdatablePNumberArray cRe1 = cDirect ? (UpdatablePNumberArray)cRe.subArr(disp1, layerLen) : wcRe1;
                        UpdatablePNumberArray updatablePNumberArray = cRe2 = cDirect ? (UpdatablePNumberArray)cRe.subArr(disp2, layerLen) : wcRe2;
                        UpdatablePNumberArray updatablePNumberArray2 = cIm == null ? null : (cIm1 = cDirect ? (UpdatablePNumberArray)cIm.subArr(disp1, layerLen) : wcIm1);
                        UpdatablePNumberArray cIm2 = cIm == null ? null : (cDirect ? (UpdatablePNumberArray)cIm.subArr(disp2, layerLen) : wcIm2);
                        Conversions.fourierToSeparableHartleyRecursive(null, maxTempJavaMemory, cRe1, cIm1, wcRe1, wcIm1, layerDims, 1);
                        Conversions.fourierToSeparableHartleyRecursive(null, maxTempJavaMemory, cRe2, cIm2, wcRe2, wcIm2, layerDims, 1);
                        if (!cDirect) {
                            cRe.subArr(disp1, layerLen).copy(wcRe1);
                            cRe.subArr(disp2, layerLen).copy(wcRe2);
                            if (cIm != null) {
                                cIm.subArr(disp1, layerLen).copy(wcIm1);
                                cIm.subArr(disp2, layerLen).copy(wcIm2);
                            }
                        }
                    }
                    long l = rl = context == null ? 0L : readyLayers.getAndIncrement();
                    if (context != null && (rl & progressMask) == 0L) {
                        context.checkInterruptionAndUpdateProgress(cRe.elementType(), rl + 1L, nDiv2 + 1L);
                    }
                    k1 += (long)tasks.length;
                    disp1 += layerStep;
                }
            };
        }
        Arrays.getThreadPoolFactory(context).performTasks(tasks);
    }

    private static void fourierSpectrumOfConvolutionOfFloatArrays(ArrayContext context, UpdatablePNumberArray cRe, UpdatablePNumberArray cIm, PNumberArray pRe, PNumberArray pIm, PNumberArray qRe, PNumberArray qIm, long n) {
        DataFloatBuffer cReBuf = (DataFloatBuffer)cRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
        DataFloatBuffer cImBuf = (DataFloatBuffer)cIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
        DataFloatBuffer pReBuf = (DataFloatBuffer)pRe.buffer(DataBuffer.AccessMode.READ, 8192L);
        DataFloatBuffer pImBuf = (DataFloatBuffer)pIm.buffer(DataBuffer.AccessMode.READ, 8192L);
        DataFloatBuffer qReBuf = (DataFloatBuffer)qRe.buffer(DataBuffer.AccessMode.READ, 8192L);
        DataFloatBuffer qImBuf = (DataFloatBuffer)qIm.buffer(DataBuffer.AccessMode.READ, 8192L);
        for (long disp = 0L; disp < n; disp += 8192L) {
            cReBuf.map(disp);
            cImBuf.map(disp);
            pReBuf.map(disp);
            pImBuf.map(disp);
            qReBuf.map(disp);
            qImBuf.map(disp);
            float[] cReJA = cReBuf.data();
            float[] cImJA = cImBuf.data();
            float[] pReJA = pReBuf.data();
            float[] pImJA = pImBuf.data();
            float[] qReJA = qReBuf.data();
            float[] qImJA = qImBuf.data();
            int cReOfs = cReBuf.from();
            int cImOfs = cImBuf.from();
            int pReOfs = pReBuf.from();
            int pImOfs = pImBuf.from();
            int qReOfs = qReBuf.from();
            int qImOfs = qImBuf.from();
            int len = (int)Math.min(n - disp, 8192L);
            for (int k = 0; k < len; ++k) {
                double pReV = pReJA[pReOfs + k];
                double pImV = pImJA[pImOfs + k];
                double qReV = qReJA[qReOfs + k];
                double qImV = qImJA[qImOfs + k];
                cReJA[cReOfs + k] = (float)(pReV * qReV - pImV * qImV);
                cImJA[cImOfs + k] = (float)(pReV * qImV + pImV * qReV);
            }
            cReBuf.force();
            cImBuf.force();
            if (context == null) continue;
            context.checkInterruptionAndUpdateProgress(cRe.elementType(), disp + (long)len, n);
        }
    }

    private static void fourierSpectrumOfConvolutionOfDoubleArrays(ArrayContext context, UpdatablePNumberArray cRe, UpdatablePNumberArray cIm, PNumberArray pRe, PNumberArray pIm, PNumberArray qRe, PNumberArray qIm, long n) {
        DataDoubleBuffer cReBuf = (DataDoubleBuffer)cRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
        DataDoubleBuffer cImBuf = (DataDoubleBuffer)cIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
        DataDoubleBuffer pReBuf = (DataDoubleBuffer)pRe.buffer(DataBuffer.AccessMode.READ, 8192L);
        DataDoubleBuffer pImBuf = (DataDoubleBuffer)pIm.buffer(DataBuffer.AccessMode.READ, 8192L);
        DataDoubleBuffer qReBuf = (DataDoubleBuffer)qRe.buffer(DataBuffer.AccessMode.READ, 8192L);
        DataDoubleBuffer qImBuf = (DataDoubleBuffer)qIm.buffer(DataBuffer.AccessMode.READ, 8192L);
        for (long disp = 0L; disp < n; disp += 8192L) {
            cReBuf.map(disp);
            cImBuf.map(disp);
            pReBuf.map(disp);
            pImBuf.map(disp);
            qReBuf.map(disp);
            qImBuf.map(disp);
            double[] cReJA = cReBuf.data();
            double[] cImJA = cImBuf.data();
            double[] pReJA = pReBuf.data();
            double[] pImJA = pImBuf.data();
            double[] qReJA = qReBuf.data();
            double[] qImJA = qImBuf.data();
            int cReOfs = cReBuf.from();
            int cImOfs = cImBuf.from();
            int pReOfs = pReBuf.from();
            int pImOfs = pImBuf.from();
            int qReOfs = qReBuf.from();
            int qImOfs = qImBuf.from();
            int len = (int)Math.min(n - disp, 8192L);
            for (int k = 0; k < len; ++k) {
                double pReV = pReJA[pReOfs + k];
                double pImV = pImJA[pImOfs + k];
                double qReV = qReJA[qReOfs + k];
                double qImV = qImJA[qImOfs + k];
                cReJA[cReOfs + k] = pReV * qReV - pImV * qImV;
                cImJA[cImOfs + k] = pReV * qImV + pImV * qReV;
            }
            cReBuf.force();
            cImBuf.force();
            if (context == null) continue;
            context.checkInterruptionAndUpdateProgress(cRe.elementType(), disp + (long)len, n);
        }
    }

    private static void separableHartleySpectrumOfConvolutionOfDirectComplex2D(UpdatablePArray cRe1, UpdatablePArray cIm1, UpdatablePArray cRe2, UpdatablePArray cIm2, PArray pRe1, PArray pIm1, PArray pRe2, PArray pIm2, PArray qRe1, PArray qIm1, PArray qRe2, PArray qIm2, Class<?> elementType) {
        if (elementType == Float.TYPE) {
            SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfDirectComplex2DFloat((DirectAccessible)((Object)cRe1), (DirectAccessible)((Object)cIm1), (DirectAccessible)((Object)cRe2), (DirectAccessible)((Object)cIm2), (DirectAccessible)((Object)pRe1), (DirectAccessible)((Object)pIm1), (DirectAccessible)((Object)pRe2), (DirectAccessible)((Object)pIm2), (DirectAccessible)((Object)qRe1), (DirectAccessible)((Object)qIm1), (DirectAccessible)((Object)qRe2), (DirectAccessible)((Object)qIm2));
        } else if (elementType == Double.TYPE) {
            SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfDirectComplex2DDouble((DirectAccessible)((Object)cRe1), (DirectAccessible)((Object)cIm1), (DirectAccessible)((Object)cRe2), (DirectAccessible)((Object)cIm2), (DirectAccessible)((Object)pRe1), (DirectAccessible)((Object)pIm1), (DirectAccessible)((Object)pRe2), (DirectAccessible)((Object)pIm2), (DirectAccessible)((Object)qRe1), (DirectAccessible)((Object)qIm1), (DirectAccessible)((Object)qRe2), (DirectAccessible)((Object)qIm2));
        } else {
            throw new AssertionError((Object)"Unsupported element type for 2D optimization");
        }
    }

    private static void separableHartleySpectrumOfConvolutionOfDirectReal2D(UpdatablePArray c1, UpdatablePArray c2, PArray p1, PArray p2, PArray q1, PArray q2, Class<?> elementType) {
        if (elementType == Float.TYPE) {
            SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfDirectReal2DFloat((DirectAccessible)((Object)c1), (DirectAccessible)((Object)c2), (DirectAccessible)((Object)p1), (DirectAccessible)((Object)p2), (DirectAccessible)((Object)q1), (DirectAccessible)((Object)q2));
        } else if (elementType == Double.TYPE) {
            SpectraOfConvolution.separableHartleySpectrumOfConvolutionOfDirectReal2DDouble((DirectAccessible)((Object)c1), (DirectAccessible)((Object)c2), (DirectAccessible)((Object)p1), (DirectAccessible)((Object)p2), (DirectAccessible)((Object)q1), (DirectAccessible)((Object)q2));
        } else {
            throw new AssertionError((Object)"Unsupported element type for 2D optimization");
        }
    }

    private static void separableHartleySpectrumOfConvolutionOfComplexFloatArrays(ArrayContext context, UpdatablePNumberArray cRe, UpdatablePNumberArray cIm, PNumberArray pRe, PNumberArray pIm, PNumberArray qRe, PNumberArray qIm, long n) {
        block13: {
            assert (n > 0L);
            double pRe0 = pRe.getDouble(0L);
            double qRe0 = qRe.getDouble(0L);
            double pIm0 = pIm.getDouble(0L);
            double qIm0 = qIm.getDouble(0L);
            cRe.setDouble(0L, pRe0 * qRe0 - pIm0 * qIm0);
            cIm.setDouble(0L, pRe0 * qIm0 + pIm0 * qRe0);
            if (n == 1L) {
                return;
            }
            DataFloatBuffer cReBuf1 = (DataFloatBuffer)cRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer cReBuf2 = (DataFloatBuffer)cRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer cImBuf1 = (DataFloatBuffer)cIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer cImBuf2 = (DataFloatBuffer)cIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer pReBuf1 = (DataFloatBuffer)pRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer pReBuf2 = (DataFloatBuffer)pRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer pImBuf1 = (DataFloatBuffer)pIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer pImBuf2 = (DataFloatBuffer)pIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer qReBuf1 = (DataFloatBuffer)qRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer qReBuf2 = (DataFloatBuffer)qRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer qImBuf1 = (DataFloatBuffer)qIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer qImBuf2 = (DataFloatBuffer)qIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            int len = (int)Math.min(8192L, (n + 1L) / 2L);
            long disp1 = 1L;
            long disp2 = n - (long)len;
            long count = 0L;
            while (true) {
                assert (len >= 1);
                assert (disp1 >= 1L);
                assert (disp1 + (long)len <= ((n & 1L) == 0L ? disp2 + 1L : disp2)) : "shscc bug 1: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                assert (disp2 + (long)len <= n);
                cReBuf1.map(disp1, len);
                cReBuf2.map(disp2, len);
                cImBuf1.map(disp1, len);
                cImBuf2.map(disp2, len);
                pReBuf1.map(disp1, len);
                pReBuf2.map(disp2, len);
                pImBuf1.map(disp1, len);
                pImBuf2.map(disp2, len);
                qReBuf1.map(disp1, len);
                qReBuf2.map(disp2, len);
                qImBuf1.map(disp1, len);
                qImBuf2.map(disp2, len);
                float[] cReJA1 = cReBuf1.data();
                float[] cReJA2 = cReBuf2.data();
                float[] cImJA1 = cImBuf1.data();
                float[] cImJA2 = cImBuf2.data();
                float[] pReJA1 = pReBuf1.data();
                float[] pReJA2 = pReBuf2.data();
                float[] pImJA1 = pImBuf1.data();
                float[] pImJA2 = pImBuf2.data();
                float[] qReJA1 = qReBuf1.data();
                float[] qReJA2 = qReBuf2.data();
                float[] qImJA1 = qImBuf1.data();
                float[] qImJA2 = qImBuf2.data();
                int cReOfs1 = cReBuf1.from();
                int cReOfs2 = cReBuf2.from();
                int cImOfs1 = cImBuf1.from();
                int cImOfs2 = cImBuf2.from();
                int pReOfs1 = pReBuf1.from();
                int pReOfs2 = pReBuf2.from();
                int pImOfs1 = pImBuf1.from();
                int pImOfs2 = pImBuf2.from();
                int qReOfs1 = qReBuf1.from();
                int qReOfs2 = qReBuf2.from();
                int qImOfs1 = qImBuf1.from();
                int qImOfs2 = qImBuf2.from();
                for (int k1 = 0; k1 < len; ++k1) {
                    int k2 = len - 1 - k1;
                    double pRe1 = pReJA1[pReOfs1 + k1];
                    double pRe2 = pReJA2[pReOfs2 + k2];
                    double pIm1 = pImJA1[pImOfs1 + k1];
                    double pIm2 = pImJA2[pImOfs2 + k2];
                    double qRe1 = qReJA1[qReOfs1 + k1];
                    double qRe2 = qReJA2[qReOfs2 + k2];
                    double qIm1 = qImJA1[qImOfs1 + k1];
                    double qIm2 = qImJA2[qImOfs2 + k2];
                    double sRe = 0.5 * (pRe1 + pRe2);
                    double sIm = 0.5 * (pIm1 + pIm2);
                    double dRe = 0.5 * (pRe1 - pRe2);
                    double dIm = 0.5 * (pIm1 - pIm2);
                    cReJA1[cReOfs1 + k1] = (float)(sRe * qRe1 - sIm * qIm1 + dRe * qRe2 - dIm * qIm2);
                    cImJA1[cImOfs1 + k1] = (float)(sRe * qIm1 + sIm * qRe1 + dRe * qIm2 + dIm * qRe2);
                    cReJA2[cReOfs2 + k2] = (float)(sRe * qRe2 - sIm * qIm2 - dRe * qRe1 + dIm * qIm1);
                    cImJA2[cImOfs2 + k2] = (float)(sRe * qIm2 + sIm * qRe2 - dRe * qIm1 - dIm * qRe1);
                }
                count += disp1 + (long)len == disp2 + 1L ? (long)(2 * len - 1) : (long)(2 * len);
                cReBuf1.force();
                cImBuf1.force();
                cReBuf2.force();
                cImBuf2.force();
                if (context != null) {
                    context.checkInterruptionAndUpdateProgress(cRe.elementType(), count, n);
                }
                if (disp1 + (long)len >= disp2) {
                    assert (disp1 + (long)len == disp2 || disp1 + (long)len == disp2 + 1L);
                    break block13;
                }
                if (disp2 - disp1 >= (long)(3 * len)) {
                    disp1 += (long)len;
                    disp2 -= (long)len;
                    continue;
                }
                len = (int)((disp2 - (disp1 += (long)len) + 1L) / 2L);
                assert (len > 0) : "shscc bug 2: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                if (!$assertionsDisabled && disp1 + (long)len != (disp2 -= (long)len) && disp1 + (long)len != disp2 + 1L) break;
            }
            throw new AssertionError((Object)("shscc bug 3: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n));
        }
    }

    private static void separableHartleySpectrumOfConvolutionOfRealFloatArrays(ArrayContext context, UpdatablePNumberArray c, PNumberArray p, PNumberArray q, long n) {
        block13: {
            assert (n > 0L);
            c.setDouble(0L, p.getDouble(0L) * q.getDouble(0L));
            if (n == 1L) {
                return;
            }
            DataFloatBuffer cBuf1 = (DataFloatBuffer)c.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer cBuf2 = (DataFloatBuffer)c.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer pBuf1 = (DataFloatBuffer)p.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer pBuf2 = (DataFloatBuffer)p.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer qBuf1 = (DataFloatBuffer)q.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer qBuf2 = (DataFloatBuffer)q.buffer(DataBuffer.AccessMode.READ, 8192L);
            int len = (int)Math.min(8192L, (n + 1L) / 2L);
            long disp1 = 1L;
            long disp2 = n - (long)len;
            long count = 0L;
            while (true) {
                assert (len >= 1);
                assert (disp1 >= 1L);
                assert (disp1 + (long)len <= ((n & 1L) == 0L ? disp2 + 1L : disp2)) : "shscr bug 1: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                assert (disp2 + (long)len <= n);
                cBuf1.map(disp1, len);
                cBuf2.map(disp2, len);
                pBuf1.map(disp1, len);
                pBuf2.map(disp2, len);
                qBuf1.map(disp1, len);
                qBuf2.map(disp2, len);
                float[] cJA1 = cBuf1.data();
                float[] cJA2 = cBuf2.data();
                float[] pJA1 = pBuf1.data();
                float[] pJA2 = pBuf2.data();
                float[] qJA1 = qBuf1.data();
                float[] qJA2 = qBuf2.data();
                int cOfs1 = cBuf1.from();
                int cOfs2 = cBuf2.from();
                int pOfs1 = pBuf1.from();
                int pOfs2 = pBuf2.from();
                int qOfs1 = qBuf1.from();
                int qOfs2 = qBuf2.from();
                for (int k1 = 0; k1 < len; ++k1) {
                    int k2 = len - 1 - k1;
                    double p1 = pJA1[pOfs1 + k1];
                    double p2 = pJA2[pOfs2 + k2];
                    double q1 = qJA1[qOfs1 + k1];
                    double q2 = qJA2[qOfs2 + k2];
                    double s = 0.5 * (p1 + p2);
                    double d = 0.5 * (p1 - p2);
                    cJA1[cOfs1 + k1] = (float)(s * q1 + d * q2);
                    cJA2[cOfs2 + k2] = (float)(s * q2 - d * q1);
                }
                count += disp1 + (long)len == disp2 + 1L ? (long)(2 * len - 1) : (long)(2 * len);
                cBuf1.force();
                cBuf2.force();
                if (context != null) {
                    context.checkInterruptionAndUpdateProgress(c.elementType(), count, n);
                }
                if (disp1 + (long)len >= disp2) {
                    assert (disp1 + (long)len == disp2 || disp1 + (long)len == disp2 + 1L);
                    break block13;
                }
                if (disp2 - disp1 >= (long)(3 * len)) {
                    disp1 += (long)len;
                    disp2 -= (long)len;
                    continue;
                }
                len = (int)((disp2 - (disp1 += (long)len) + 1L) / 2L);
                assert (len > 0) : "shscr bug 2: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                if (!$assertionsDisabled && disp1 + (long)len != (disp2 -= (long)len) && disp1 + (long)len != disp2 + 1L) break;
            }
            throw new AssertionError((Object)("shscr bug 3: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n));
        }
    }

    private static void separableHartleySpectrumOfConvolutionOfDirectComplex2DFloat(DirectAccessible cRe1, DirectAccessible cIm1, DirectAccessible cRe2, DirectAccessible cIm2, DirectAccessible pRe1, DirectAccessible pIm1, DirectAccessible pRe2, DirectAccessible pIm2, DirectAccessible qRe1, DirectAccessible qIm1, DirectAccessible qRe2, DirectAccessible qIm2) {
        float[] pReJA1 = (float[])pRe1.javaArray();
        float[] pReJA2 = (float[])pRe2.javaArray();
        float[] pImJA1 = (float[])pIm1.javaArray();
        float[] pImJA2 = (float[])pIm2.javaArray();
        float[] qReJA1 = (float[])qRe1.javaArray();
        float[] qReJA2 = (float[])qRe2.javaArray();
        float[] qImJA1 = (float[])qIm1.javaArray();
        float[] qImJA2 = (float[])qIm2.javaArray();
        float[] cReJA1 = (float[])cRe1.javaArray();
        float[] cReJA2 = (float[])cRe2.javaArray();
        float[] cImJA1 = (float[])cIm1.javaArray();
        float[] cImJA2 = (float[])cIm2.javaArray();
        int pReOfs1 = pRe1.javaArrayOffset();
        int pReOfs2 = pRe2.javaArrayOffset();
        int pImOfs1 = pIm1.javaArrayOffset();
        int pImOfs2 = pIm2.javaArrayOffset();
        int qReOfs1 = qRe1.javaArrayOffset();
        int qReOfs2 = qRe2.javaArrayOffset();
        int qImOfs1 = qIm1.javaArrayOffset();
        int qImOfs2 = qIm2.javaArrayOffset();
        int cReOfs1 = cRe1.javaArrayOffset();
        int cReOfs2 = cRe2.javaArrayOffset();
        int cImOfs1 = cIm1.javaArrayOffset();
        int cImOfs2 = cIm2.javaArrayOffset();
        int n = pRe1.javaArrayLength();
        assert (pRe2.javaArrayLength() == n);
        assert (pIm1.javaArrayLength() == n);
        assert (pIm2.javaArrayLength() == n);
        assert (qRe1.javaArrayLength() == n);
        assert (qRe2.javaArrayLength() == n);
        assert (qIm1.javaArrayLength() == n);
        assert (qIm2.javaArrayLength() == n);
        assert (cRe1.javaArrayLength() == n);
        assert (cRe2.javaArrayLength() == n);
        assert (cIm1.javaArrayLength() == n);
        assert (cIm2.javaArrayLength() == n);
        int nDiv2 = n / 2;
        for (int kL = 0; kL <= nDiv2; ++kL) {
            int kR = kL == 0 ? 0 : n - kL;
            double pLRe1 = pReJA1[pReOfs1 + kL];
            double pRRe1 = pReJA1[pReOfs1 + kR];
            double pLRe2 = pReJA2[pReOfs2 + kL];
            double pRRe2 = pReJA2[pReOfs2 + kR];
            double pLIm1 = pImJA1[pImOfs1 + kL];
            double pRIm1 = pImJA1[pImOfs1 + kR];
            double pLIm2 = pImJA2[pImOfs2 + kL];
            double pRIm2 = pImJA2[pImOfs2 + kR];
            double qLRe1 = qReJA1[qReOfs1 + kL];
            double qRRe1 = qReJA1[qReOfs1 + kR];
            double qLRe2 = qReJA2[qReOfs2 + kL];
            double qRRe2 = qReJA2[qReOfs2 + kR];
            double qLIm1 = qImJA1[qImOfs1 + kL];
            double qRIm1 = qImJA1[qImOfs1 + kR];
            double qLIm2 = qImJA2[qImOfs2 + kL];
            double qRIm2 = qImJA2[qImOfs2 + kR];
            double psLRRe = pLRe1 + pRRe2;
            double qsLRRe = qLRe1 + qRRe2;
            double psRLRe = pRRe1 + pLRe2;
            double qsRLRe = qRRe1 + qLRe2;
            double psLRIm = pLIm1 + pRIm2;
            double qsLRIm = qLIm1 + qRIm2;
            double psRLIm = pRIm1 + pLIm2;
            double qsRLIm = qRIm1 + qLIm2;
            double pdLRRe = pLRe1 - pRRe2;
            double qdLRRe = qLRe1 - qRRe2;
            double pdRLRe = pRRe1 - pLRe2;
            double qdRLRe = qRRe1 - qLRe2;
            double pdLRIm = pLIm1 - pRIm2;
            double qdLRIm = qLIm1 - qRIm2;
            double pdRLIm = pRIm1 - pLIm2;
            double qdRLIm = qRIm1 - qLIm2;
            cReJA1[cReOfs1 + kL] = (float)(0.25 * (psLRRe * qsLRRe - psLRIm * qsLRIm + pdLRRe * qsRLRe - pdLRIm * qsRLIm + psRLRe * qdLRRe - psRLIm * qdLRIm - pdRLRe * qdRLRe + pdRLIm * qdRLIm));
            cImJA1[cImOfs1 + kL] = (float)(0.25 * (psLRRe * qsLRIm + psLRIm * qsLRRe + pdLRRe * qsRLIm + pdLRIm * qsRLRe + psRLRe * qdLRIm + psRLIm * qdLRRe - pdRLRe * qdRLIm - pdRLIm * qdRLRe));
            cReJA1[cReOfs1 + kR] = (float)(0.25 * (psRLRe * qsRLRe - psRLIm * qsRLIm + pdRLRe * qsLRRe - pdRLIm * qsLRIm + psLRRe * qdRLRe - psLRIm * qdRLIm - pdLRRe * qdLRRe + pdLRIm * qdLRIm));
            cImJA1[cImOfs1 + kR] = (float)(0.25 * (psRLRe * qsRLIm + psRLIm * qsRLRe + pdRLRe * qsLRIm + pdRLIm * qsLRRe + psLRRe * qdRLIm + psLRIm * qdRLRe - pdLRRe * qdLRIm - pdLRIm * qdLRRe));
            cReJA2[cReOfs2 + kL] = (float)(0.25 * (psRLRe * qsRLRe - psRLIm * qsRLIm - pdRLRe * qsLRRe + pdRLIm * qsLRIm - psLRRe * qdRLRe + psLRIm * qdRLIm - pdLRRe * qdLRRe + pdLRIm * qdLRIm));
            cImJA2[cImOfs2 + kL] = (float)(0.25 * (psRLRe * qsRLIm + psRLIm * qsRLRe - pdRLRe * qsLRIm - pdRLIm * qsLRRe - psLRRe * qdRLIm - psLRIm * qdRLRe - pdLRRe * qdLRIm - pdLRIm * qdLRRe));
            cReJA2[cReOfs2 + kR] = (float)(0.25 * (psLRRe * qsLRRe - psLRIm * qsLRIm - pdLRRe * qsRLRe + pdLRIm * qsRLIm - psRLRe * qdLRRe + psRLIm * qdLRIm - pdRLRe * qdRLRe + pdRLIm * qdRLIm));
            cImJA2[cImOfs2 + kR] = (float)(0.25 * (psLRRe * qsLRIm + psLRIm * qsLRRe - pdLRRe * qsRLIm - pdLRIm * qsRLRe - psRLRe * qdLRIm - psRLIm * qdLRRe - pdRLRe * qdRLIm - pdRLIm * qdRLRe));
        }
    }

    private static void separableHartleySpectrumOfConvolutionOfDirectReal2DFloat(DirectAccessible c1, DirectAccessible c2, DirectAccessible p1, DirectAccessible p2, DirectAccessible q1, DirectAccessible q2) {
        float[] pJA1 = (float[])p1.javaArray();
        float[] pJA2 = (float[])p2.javaArray();
        float[] qJA1 = (float[])q1.javaArray();
        float[] qJA2 = (float[])q2.javaArray();
        float[] cJA1 = (float[])c1.javaArray();
        float[] cJA2 = (float[])c2.javaArray();
        int pOfs1 = p1.javaArrayOffset();
        int pOfs2 = p2.javaArrayOffset();
        int qOfs1 = q1.javaArrayOffset();
        int qOfs2 = q2.javaArrayOffset();
        int cOfs1 = c1.javaArrayOffset();
        int cOfs2 = c2.javaArrayOffset();
        int n = p1.javaArrayLength();
        assert (p2.javaArrayLength() == n);
        assert (q1.javaArrayLength() == n);
        assert (q2.javaArrayLength() == n);
        assert (c1.javaArrayLength() == n);
        assert (c2.javaArrayLength() == n);
        int nDiv2 = n / 2;
        for (int kL = 0; kL <= nDiv2; ++kL) {
            int kR = kL == 0 ? 0 : n - kL;
            double pL1 = pJA1[pOfs1 + kL];
            double pR1 = pJA1[pOfs1 + kR];
            double pL2 = pJA2[pOfs2 + kL];
            double pR2 = pJA2[pOfs2 + kR];
            double qL1 = qJA1[qOfs1 + kL];
            double qR1 = qJA1[qOfs1 + kR];
            double qL2 = qJA2[qOfs2 + kL];
            double qR2 = qJA2[qOfs2 + kR];
            double psLR = pL1 + pR2;
            double qsLR = qL1 + qR2;
            double psRL = pR1 + pL2;
            double qsRL = qR1 + qL2;
            double pdLR = pL1 - pR2;
            double qdLR = qL1 - qR2;
            double pdRL = pR1 - pL2;
            double qdRL = qR1 - qL2;
            cJA1[cOfs1 + kL] = (float)(0.25 * (psLR * qsLR + pdLR * qsRL + psRL * qdLR - pdRL * qdRL));
            cJA1[cOfs1 + kR] = (float)(0.25 * (psRL * qsRL + pdRL * qsLR + psLR * qdRL - pdLR * qdLR));
            cJA2[cOfs2 + kL] = (float)(0.25 * (psRL * qsRL - pdRL * qsLR - psLR * qdRL - pdLR * qdLR));
            cJA2[cOfs2 + kR] = (float)(0.25 * (psLR * qsLR - pdLR * qsRL - psRL * qdLR - pdRL * qdRL));
        }
    }

    private static void separableHartleySpectrumOfConvolutionOfComplexDoubleArrays(ArrayContext context, UpdatablePNumberArray cRe, UpdatablePNumberArray cIm, PNumberArray pRe, PNumberArray pIm, PNumberArray qRe, PNumberArray qIm, long n) {
        block13: {
            assert (n > 0L);
            double pRe0 = pRe.getDouble(0L);
            double qRe0 = qRe.getDouble(0L);
            double pIm0 = pIm.getDouble(0L);
            double qIm0 = qIm.getDouble(0L);
            cRe.setDouble(0L, pRe0 * qRe0 - pIm0 * qIm0);
            cIm.setDouble(0L, pRe0 * qIm0 + pIm0 * qRe0);
            if (n == 1L) {
                return;
            }
            DataDoubleBuffer cReBuf1 = (DataDoubleBuffer)cRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer cReBuf2 = (DataDoubleBuffer)cRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer cImBuf1 = (DataDoubleBuffer)cIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer cImBuf2 = (DataDoubleBuffer)cIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer pReBuf1 = (DataDoubleBuffer)pRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer pReBuf2 = (DataDoubleBuffer)pRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer pImBuf1 = (DataDoubleBuffer)pIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer pImBuf2 = (DataDoubleBuffer)pIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer qReBuf1 = (DataDoubleBuffer)qRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer qReBuf2 = (DataDoubleBuffer)qRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer qImBuf1 = (DataDoubleBuffer)qIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer qImBuf2 = (DataDoubleBuffer)qIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            int len = (int)Math.min(8192L, (n + 1L) / 2L);
            long disp1 = 1L;
            long disp2 = n - (long)len;
            long count = 0L;
            while (true) {
                assert (len >= 1);
                assert (disp1 >= 1L);
                assert (disp1 + (long)len <= ((n & 1L) == 0L ? disp2 + 1L : disp2)) : "shscc bug 1: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                assert (disp2 + (long)len <= n);
                cReBuf1.map(disp1, len);
                cReBuf2.map(disp2, len);
                cImBuf1.map(disp1, len);
                cImBuf2.map(disp2, len);
                pReBuf1.map(disp1, len);
                pReBuf2.map(disp2, len);
                pImBuf1.map(disp1, len);
                pImBuf2.map(disp2, len);
                qReBuf1.map(disp1, len);
                qReBuf2.map(disp2, len);
                qImBuf1.map(disp1, len);
                qImBuf2.map(disp2, len);
                double[] cReJA1 = cReBuf1.data();
                double[] cReJA2 = cReBuf2.data();
                double[] cImJA1 = cImBuf1.data();
                double[] cImJA2 = cImBuf2.data();
                double[] pReJA1 = pReBuf1.data();
                double[] pReJA2 = pReBuf2.data();
                double[] pImJA1 = pImBuf1.data();
                double[] pImJA2 = pImBuf2.data();
                double[] qReJA1 = qReBuf1.data();
                double[] qReJA2 = qReBuf2.data();
                double[] qImJA1 = qImBuf1.data();
                double[] qImJA2 = qImBuf2.data();
                int cReOfs1 = cReBuf1.from();
                int cReOfs2 = cReBuf2.from();
                int cImOfs1 = cImBuf1.from();
                int cImOfs2 = cImBuf2.from();
                int pReOfs1 = pReBuf1.from();
                int pReOfs2 = pReBuf2.from();
                int pImOfs1 = pImBuf1.from();
                int pImOfs2 = pImBuf2.from();
                int qReOfs1 = qReBuf1.from();
                int qReOfs2 = qReBuf2.from();
                int qImOfs1 = qImBuf1.from();
                int qImOfs2 = qImBuf2.from();
                for (int k1 = 0; k1 < len; ++k1) {
                    int k2 = len - 1 - k1;
                    double pRe1 = pReJA1[pReOfs1 + k1];
                    double pRe2 = pReJA2[pReOfs2 + k2];
                    double pIm1 = pImJA1[pImOfs1 + k1];
                    double pIm2 = pImJA2[pImOfs2 + k2];
                    double qRe1 = qReJA1[qReOfs1 + k1];
                    double qRe2 = qReJA2[qReOfs2 + k2];
                    double qIm1 = qImJA1[qImOfs1 + k1];
                    double qIm2 = qImJA2[qImOfs2 + k2];
                    double sRe = 0.5 * (pRe1 + pRe2);
                    double sIm = 0.5 * (pIm1 + pIm2);
                    double dRe = 0.5 * (pRe1 - pRe2);
                    double dIm = 0.5 * (pIm1 - pIm2);
                    cReJA1[cReOfs1 + k1] = sRe * qRe1 - sIm * qIm1 + dRe * qRe2 - dIm * qIm2;
                    cImJA1[cImOfs1 + k1] = sRe * qIm1 + sIm * qRe1 + dRe * qIm2 + dIm * qRe2;
                    cReJA2[cReOfs2 + k2] = sRe * qRe2 - sIm * qIm2 - dRe * qRe1 + dIm * qIm1;
                    cImJA2[cImOfs2 + k2] = sRe * qIm2 + sIm * qRe2 - dRe * qIm1 - dIm * qRe1;
                }
                count += disp1 + (long)len == disp2 + 1L ? (long)(2 * len - 1) : (long)(2 * len);
                cReBuf1.force();
                cImBuf1.force();
                cReBuf2.force();
                cImBuf2.force();
                if (context != null) {
                    context.checkInterruptionAndUpdateProgress(cRe.elementType(), count, n);
                }
                if (disp1 + (long)len >= disp2) {
                    assert (disp1 + (long)len == disp2 || disp1 + (long)len == disp2 + 1L);
                    break block13;
                }
                if (disp2 - disp1 >= (long)(3 * len)) {
                    disp1 += (long)len;
                    disp2 -= (long)len;
                    continue;
                }
                len = (int)((disp2 - (disp1 += (long)len) + 1L) / 2L);
                assert (len > 0) : "shscc bug 2: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                if (!$assertionsDisabled && disp1 + (long)len != (disp2 -= (long)len) && disp1 + (long)len != disp2 + 1L) break;
            }
            throw new AssertionError((Object)("shscc bug 3: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n));
        }
    }

    private static void separableHartleySpectrumOfConvolutionOfRealDoubleArrays(ArrayContext context, UpdatablePNumberArray c, PNumberArray p, PNumberArray q, long n) {
        block13: {
            assert (n > 0L);
            c.setDouble(0L, p.getDouble(0L) * q.getDouble(0L));
            if (n == 1L) {
                return;
            }
            DataDoubleBuffer cBuf1 = (DataDoubleBuffer)c.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer cBuf2 = (DataDoubleBuffer)c.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer pBuf1 = (DataDoubleBuffer)p.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer pBuf2 = (DataDoubleBuffer)p.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer qBuf1 = (DataDoubleBuffer)q.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer qBuf2 = (DataDoubleBuffer)q.buffer(DataBuffer.AccessMode.READ, 8192L);
            int len = (int)Math.min(8192L, (n + 1L) / 2L);
            long disp1 = 1L;
            long disp2 = n - (long)len;
            long count = 0L;
            while (true) {
                assert (len >= 1);
                assert (disp1 >= 1L);
                assert (disp1 + (long)len <= ((n & 1L) == 0L ? disp2 + 1L : disp2)) : "shscr bug 1: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                assert (disp2 + (long)len <= n);
                cBuf1.map(disp1, len);
                cBuf2.map(disp2, len);
                pBuf1.map(disp1, len);
                pBuf2.map(disp2, len);
                qBuf1.map(disp1, len);
                qBuf2.map(disp2, len);
                double[] cJA1 = cBuf1.data();
                double[] cJA2 = cBuf2.data();
                double[] pJA1 = pBuf1.data();
                double[] pJA2 = pBuf2.data();
                double[] qJA1 = qBuf1.data();
                double[] qJA2 = qBuf2.data();
                int cOfs1 = cBuf1.from();
                int cOfs2 = cBuf2.from();
                int pOfs1 = pBuf1.from();
                int pOfs2 = pBuf2.from();
                int qOfs1 = qBuf1.from();
                int qOfs2 = qBuf2.from();
                for (int k1 = 0; k1 < len; ++k1) {
                    int k2 = len - 1 - k1;
                    double p1 = pJA1[pOfs1 + k1];
                    double p2 = pJA2[pOfs2 + k2];
                    double q1 = qJA1[qOfs1 + k1];
                    double q2 = qJA2[qOfs2 + k2];
                    double s = 0.5 * (p1 + p2);
                    double d = 0.5 * (p1 - p2);
                    cJA1[cOfs1 + k1] = s * q1 + d * q2;
                    cJA2[cOfs2 + k2] = s * q2 - d * q1;
                }
                count += disp1 + (long)len == disp2 + 1L ? (long)(2 * len - 1) : (long)(2 * len);
                cBuf1.force();
                cBuf2.force();
                if (context != null) {
                    context.checkInterruptionAndUpdateProgress(c.elementType(), count, n);
                }
                if (disp1 + (long)len >= disp2) {
                    assert (disp1 + (long)len == disp2 || disp1 + (long)len == disp2 + 1L);
                    break block13;
                }
                if (disp2 - disp1 >= (long)(3 * len)) {
                    disp1 += (long)len;
                    disp2 -= (long)len;
                    continue;
                }
                len = (int)((disp2 - (disp1 += (long)len) + 1L) / 2L);
                assert (len > 0) : "shscr bug 2: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                if (!$assertionsDisabled && disp1 + (long)len != (disp2 -= (long)len) && disp1 + (long)len != disp2 + 1L) break;
            }
            throw new AssertionError((Object)("shscr bug 3: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n));
        }
    }

    private static void separableHartleySpectrumOfConvolutionOfDirectComplex2DDouble(DirectAccessible cRe1, DirectAccessible cIm1, DirectAccessible cRe2, DirectAccessible cIm2, DirectAccessible pRe1, DirectAccessible pIm1, DirectAccessible pRe2, DirectAccessible pIm2, DirectAccessible qRe1, DirectAccessible qIm1, DirectAccessible qRe2, DirectAccessible qIm2) {
        double[] pReJA1 = (double[])pRe1.javaArray();
        double[] pReJA2 = (double[])pRe2.javaArray();
        double[] pImJA1 = (double[])pIm1.javaArray();
        double[] pImJA2 = (double[])pIm2.javaArray();
        double[] qReJA1 = (double[])qRe1.javaArray();
        double[] qReJA2 = (double[])qRe2.javaArray();
        double[] qImJA1 = (double[])qIm1.javaArray();
        double[] qImJA2 = (double[])qIm2.javaArray();
        double[] cReJA1 = (double[])cRe1.javaArray();
        double[] cReJA2 = (double[])cRe2.javaArray();
        double[] cImJA1 = (double[])cIm1.javaArray();
        double[] cImJA2 = (double[])cIm2.javaArray();
        int pReOfs1 = pRe1.javaArrayOffset();
        int pReOfs2 = pRe2.javaArrayOffset();
        int pImOfs1 = pIm1.javaArrayOffset();
        int pImOfs2 = pIm2.javaArrayOffset();
        int qReOfs1 = qRe1.javaArrayOffset();
        int qReOfs2 = qRe2.javaArrayOffset();
        int qImOfs1 = qIm1.javaArrayOffset();
        int qImOfs2 = qIm2.javaArrayOffset();
        int cReOfs1 = cRe1.javaArrayOffset();
        int cReOfs2 = cRe2.javaArrayOffset();
        int cImOfs1 = cIm1.javaArrayOffset();
        int cImOfs2 = cIm2.javaArrayOffset();
        int n = pRe1.javaArrayLength();
        assert (pRe2.javaArrayLength() == n);
        assert (pIm1.javaArrayLength() == n);
        assert (pIm2.javaArrayLength() == n);
        assert (qRe1.javaArrayLength() == n);
        assert (qRe2.javaArrayLength() == n);
        assert (qIm1.javaArrayLength() == n);
        assert (qIm2.javaArrayLength() == n);
        assert (cRe1.javaArrayLength() == n);
        assert (cRe2.javaArrayLength() == n);
        assert (cIm1.javaArrayLength() == n);
        assert (cIm2.javaArrayLength() == n);
        int nDiv2 = n / 2;
        for (int kL = 0; kL <= nDiv2; ++kL) {
            int kR = kL == 0 ? 0 : n - kL;
            double pLRe1 = pReJA1[pReOfs1 + kL];
            double pRRe1 = pReJA1[pReOfs1 + kR];
            double pLRe2 = pReJA2[pReOfs2 + kL];
            double pRRe2 = pReJA2[pReOfs2 + kR];
            double pLIm1 = pImJA1[pImOfs1 + kL];
            double pRIm1 = pImJA1[pImOfs1 + kR];
            double pLIm2 = pImJA2[pImOfs2 + kL];
            double pRIm2 = pImJA2[pImOfs2 + kR];
            double qLRe1 = qReJA1[qReOfs1 + kL];
            double qRRe1 = qReJA1[qReOfs1 + kR];
            double qLRe2 = qReJA2[qReOfs2 + kL];
            double qRRe2 = qReJA2[qReOfs2 + kR];
            double qLIm1 = qImJA1[qImOfs1 + kL];
            double qRIm1 = qImJA1[qImOfs1 + kR];
            double qLIm2 = qImJA2[qImOfs2 + kL];
            double qRIm2 = qImJA2[qImOfs2 + kR];
            double psLRRe = pLRe1 + pRRe2;
            double qsLRRe = qLRe1 + qRRe2;
            double psRLRe = pRRe1 + pLRe2;
            double qsRLRe = qRRe1 + qLRe2;
            double psLRIm = pLIm1 + pRIm2;
            double qsLRIm = qLIm1 + qRIm2;
            double psRLIm = pRIm1 + pLIm2;
            double qsRLIm = qRIm1 + qLIm2;
            double pdLRRe = pLRe1 - pRRe2;
            double qdLRRe = qLRe1 - qRRe2;
            double pdRLRe = pRRe1 - pLRe2;
            double qdRLRe = qRRe1 - qLRe2;
            double pdLRIm = pLIm1 - pRIm2;
            double qdLRIm = qLIm1 - qRIm2;
            double pdRLIm = pRIm1 - pLIm2;
            double qdRLIm = qRIm1 - qLIm2;
            cReJA1[cReOfs1 + kL] = 0.25 * (psLRRe * qsLRRe - psLRIm * qsLRIm + pdLRRe * qsRLRe - pdLRIm * qsRLIm + psRLRe * qdLRRe - psRLIm * qdLRIm - pdRLRe * qdRLRe + pdRLIm * qdRLIm);
            cImJA1[cImOfs1 + kL] = 0.25 * (psLRRe * qsLRIm + psLRIm * qsLRRe + pdLRRe * qsRLIm + pdLRIm * qsRLRe + psRLRe * qdLRIm + psRLIm * qdLRRe - pdRLRe * qdRLIm - pdRLIm * qdRLRe);
            cReJA1[cReOfs1 + kR] = 0.25 * (psRLRe * qsRLRe - psRLIm * qsRLIm + pdRLRe * qsLRRe - pdRLIm * qsLRIm + psLRRe * qdRLRe - psLRIm * qdRLIm - pdLRRe * qdLRRe + pdLRIm * qdLRIm);
            cImJA1[cImOfs1 + kR] = 0.25 * (psRLRe * qsRLIm + psRLIm * qsRLRe + pdRLRe * qsLRIm + pdRLIm * qsLRRe + psLRRe * qdRLIm + psLRIm * qdRLRe - pdLRRe * qdLRIm - pdLRIm * qdLRRe);
            cReJA2[cReOfs2 + kL] = 0.25 * (psRLRe * qsRLRe - psRLIm * qsRLIm - pdRLRe * qsLRRe + pdRLIm * qsLRIm - psLRRe * qdRLRe + psLRIm * qdRLIm - pdLRRe * qdLRRe + pdLRIm * qdLRIm);
            cImJA2[cImOfs2 + kL] = 0.25 * (psRLRe * qsRLIm + psRLIm * qsRLRe - pdRLRe * qsLRIm - pdRLIm * qsLRRe - psLRRe * qdRLIm - psLRIm * qdRLRe - pdLRRe * qdLRIm - pdLRIm * qdLRRe);
            cReJA2[cReOfs2 + kR] = 0.25 * (psLRRe * qsLRRe - psLRIm * qsLRIm - pdLRRe * qsRLRe + pdLRIm * qsRLIm - psRLRe * qdLRRe + psRLIm * qdLRIm - pdRLRe * qdRLRe + pdRLIm * qdRLIm);
            cImJA2[cImOfs2 + kR] = 0.25 * (psLRRe * qsLRIm + psLRIm * qsLRRe - pdLRRe * qsRLIm - pdLRIm * qsRLRe - psRLRe * qdLRIm - psRLIm * qdLRRe - pdRLRe * qdRLIm - pdRLIm * qdRLRe);
        }
    }

    private static void separableHartleySpectrumOfConvolutionOfDirectReal2DDouble(DirectAccessible c1, DirectAccessible c2, DirectAccessible p1, DirectAccessible p2, DirectAccessible q1, DirectAccessible q2) {
        double[] pJA1 = (double[])p1.javaArray();
        double[] pJA2 = (double[])p2.javaArray();
        double[] qJA1 = (double[])q1.javaArray();
        double[] qJA2 = (double[])q2.javaArray();
        double[] cJA1 = (double[])c1.javaArray();
        double[] cJA2 = (double[])c2.javaArray();
        int pOfs1 = p1.javaArrayOffset();
        int pOfs2 = p2.javaArrayOffset();
        int qOfs1 = q1.javaArrayOffset();
        int qOfs2 = q2.javaArrayOffset();
        int cOfs1 = c1.javaArrayOffset();
        int cOfs2 = c2.javaArrayOffset();
        int n = p1.javaArrayLength();
        assert (p2.javaArrayLength() == n);
        assert (q1.javaArrayLength() == n);
        assert (q2.javaArrayLength() == n);
        assert (c1.javaArrayLength() == n);
        assert (c2.javaArrayLength() == n);
        int nDiv2 = n / 2;
        for (int kL = 0; kL <= nDiv2; ++kL) {
            int kR = kL == 0 ? 0 : n - kL;
            double pL1 = pJA1[pOfs1 + kL];
            double pR1 = pJA1[pOfs1 + kR];
            double pL2 = pJA2[pOfs2 + kL];
            double pR2 = pJA2[pOfs2 + kR];
            double qL1 = qJA1[qOfs1 + kL];
            double qR1 = qJA1[qOfs1 + kR];
            double qL2 = qJA2[qOfs2 + kL];
            double qR2 = qJA2[qOfs2 + kR];
            double psLR = pL1 + pR2;
            double qsLR = qL1 + qR2;
            double psRL = pR1 + pL2;
            double qsRL = qR1 + qL2;
            double pdLR = pL1 - pR2;
            double qdLR = qL1 - qR2;
            double pdRL = pR1 - pL2;
            double qdRL = qR1 - qL2;
            cJA1[cOfs1 + kL] = 0.25 * (psLR * qsLR + pdLR * qsRL + psRL * qdLR - pdRL * qdRL);
            cJA1[cOfs1 + kR] = 0.25 * (psRL * qsRL + pdRL * qsLR + psLR * qdRL - pdLR * qdLR);
            cJA2[cOfs2 + kL] = 0.25 * (psRL * qsRL - pdRL * qsLR - psLR * qdRL - pdLR * qdLR);
            cJA2[cOfs2 + kR] = 0.25 * (psLR * qsLR - pdLR * qsRL - psRL * qdLR - pdRL * qdRL);
        }
    }

    private static void separableHartleySpectrumOfConvolutionOfComplexArrays(ArrayContext context, UpdatablePNumberArray cRe, UpdatablePNumberArray cIm, PNumberArray pRe, PNumberArray pIm, PNumberArray qRe, PNumberArray qIm, long n) {
        long k1 = 0L;
        long k2 = 0L;
        long nDiv2 = n / 2L;
        while (k1 <= nDiv2) {
            double pRe1 = pRe.getDouble(k1);
            double pRe2 = pRe.getDouble(k2);
            double pIm1 = pIm.getDouble(k1);
            double pIm2 = pIm.getDouble(k2);
            double qRe1 = qRe.getDouble(k1);
            double qRe2 = qRe.getDouble(k2);
            double qIm1 = qIm.getDouble(k1);
            double qIm2 = qIm.getDouble(k2);
            double sRe = 0.5 * (pRe1 + pRe2);
            double sIm = 0.5 * (pIm1 + pIm2);
            double dRe = 0.5 * (pRe1 - pRe2);
            double dIm = 0.5 * (pIm1 - pIm2);
            cRe.setDouble(k1, sRe * qRe1 - sIm * qIm1 + dRe * qRe2 - dIm * qIm2);
            cIm.setDouble(k1, sRe * qIm1 + sIm * qRe1 + dRe * qIm2 + dIm * qRe2);
            cRe.setDouble(k2, sRe * qRe2 - sIm * qIm2 - dRe * qRe1 + dIm * qIm1);
            cIm.setDouble(k2, sRe * qIm2 + sIm * qRe2 - dRe * qIm1 - dIm * qRe1);
            if (context != null && (k1 & 0xFFFFL) == 0L) {
                context.checkInterruptionAndUpdateProgress(pRe.elementType(), k1 + 1L, nDiv2 + 1L);
            }
            k2 = n - ++k1;
        }
    }

    private static void separableHartleySpectrumOfConvolutionOfRealArrays(ArrayContext context, UpdatablePNumberArray c, PNumberArray p, PNumberArray q, long n) {
        long k1 = 0L;
        long k2 = 0L;
        long nDiv2 = n / 2L;
        while (k1 <= nDiv2) {
            double p1 = p.getDouble(k1);
            double p2 = p.getDouble(k2);
            double q1 = q.getDouble(k1);
            double q2 = q.getDouble(k2);
            double s = 0.5 * (p1 + p2);
            double d = 0.5 * (p1 - p2);
            c.setDouble(k1, s * q1 + d * q2);
            c.setDouble(k2, s * q2 - d * q1);
            if (context != null && (k1 & 0xFFFFL) == 0L) {
                context.checkInterruptionAndUpdateProgress(p.elementType(), k1 + 1L, nDiv2 + 1L);
            }
            k2 = n - ++k1;
        }
    }
}

