/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.stitching;

import net.algart.math.functions.Func;

public class AverageExceptingNaN
implements Func {
    private final double defaultValue;

    private AverageExceptingNaN(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static AverageExceptingNaN getInstance(double defaultValue) {
        return new AverageExceptingNaN(defaultValue);
    }

    @Override
    public double get(double ... x) {
        int n = 0;
        double sum = 0.0;
        for (double v : x) {
            if (v != v) continue;
            sum += v;
            ++n;
        }
        return n == 0 ? this.defaultValue : sum / (double)n;
    }

    @Override
    public double get() {
        return this.defaultValue;
    }

    @Override
    public double get(double x0) {
        return x0 == x0 ? x0 : this.defaultValue;
    }

    @Override
    public double get(double x0, double x1) {
        return x0 == x0 ? (x1 == x1 ? 0.5 * (x0 + x1) : x0) : (x1 == x1 ? x1 : this.defaultValue);
    }

    @Override
    public double get(double x0, double x1, double x2) {
        double sum;
        int n = x0 == x0 ? 1 : 0;
        double d = sum = x0 == x0 ? x0 : 0.0;
        if (x1 == x1) {
            sum += x1;
            ++n;
        }
        if (x2 == x2) {
            sum += x2;
            ++n;
        }
        return n == 0 ? this.defaultValue : sum / (double)n;
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        double sum;
        int n = x0 == x0 ? 1 : 0;
        double d = sum = x0 == x0 ? x0 : 0.0;
        if (x1 == x1) {
            sum += x1;
            ++n;
        }
        if (x2 == x2) {
            sum += x2;
            ++n;
        }
        if (x3 == x3) {
            sum += x3;
            ++n;
        }
        return n == 0 ? this.defaultValue : sum / (double)n;
    }

    public String toString() {
        return "average function skipping NaN arguments";
    }
}

