/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.camera;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import net.algart.arrays.FloatArray;
import net.algart.executors.api.Executor;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.executors.modules.cv.matrices.camera.reflectance.ReflectanceSettings;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;

public final class IntensityToReflectance
extends MultiMatrixFilter {
    public static final String OUTPUT_REFLECTANCE_SETTINGS = "reflectance_settings";
    private String reflectanceSettingsFile = "";
    private boolean maximalPrecision = false;

    public IntensityToReflectance() {
        this.addOutputScalar(OUTPUT_REFLECTANCE_SETTINGS);
    }

    public String getReflectanceSettingsFile() {
        return this.reflectanceSettingsFile;
    }

    public IntensityToReflectance setReflectanceSettingsFile(String reflectanceSettingsFile) {
        this.reflectanceSettingsFile = IntensityToReflectance.nonEmpty((String)reflectanceSettingsFile);
        return this;
    }

    public boolean isMaximalPrecision() {
        return this.maximalPrecision;
    }

    public void setMaximalPrecision(boolean maximalPrecision) {
        this.maximalPrecision = maximalPrecision;
    }

    public MultiMatrix process(MultiMatrix source) {
        ReflectanceSettings settings = IntensityToReflectance.loadReflectanceSettings((Executor)this, this.reflectanceSettingsFile);
        Func f = settings.intensityToReflectanceFunc(source.elementType(), this.maximalPrecision);
        return source.asMono().asFunc(f, FloatArray.class).clone();
    }

    public static Path translateReflectanceSettingsFile(Executor executor, String file) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(file, "Null file");
        file = file.trim();
        if (file.isEmpty()) {
            throw new IllegalArgumentException("Empty file name");
        }
        return PathPropertyReplacement.translatePropertiesAndCurrentDirectory((String)file, (Executor)executor);
    }

    public static ReflectanceSettings loadReflectanceSettings(Executor executor, String file) {
        Path path = IntensityToReflectance.translateReflectanceSettingsFile(executor, file);
        try {
            ReflectanceSettings settings = ReflectanceSettings.read(path);
            if (executor.hasOutputPort(OUTPUT_REFLECTANCE_SETTINGS)) {
                executor.getScalar(OUTPUT_REFLECTANCE_SETTINGS).setTo(settings.jsonString());
            }
            return settings;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

