/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.morphology;

import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.matrices.morphology.BasicRankMorphology;
import net.algart.matrices.morphology.ContinuedRankMorphology;
import net.algart.matrices.morphology.CustomRankPrecision;
import net.algart.matrices.morphology.RankMorphology;
import net.algart.matrices.morphology.RankPrecision;

public abstract class RankMorphologyFilter
extends MorphologyFilter {
    private boolean interpolatedHistogram = false;
    private double optimizingScale = 1.0;
    private long[] sourceMatrixDimensions = null;

    public boolean isInterpolatedHistogram() {
        return this.interpolatedHistogram;
    }

    public void setInterpolatedHistogram(boolean interpolatedHistogram) {
        this.interpolatedHistogram = interpolatedHistogram;
    }

    public double getOptimizingScale() {
        return this.optimizingScale;
    }

    public void setOptimizingScale(double optimizingScale) {
        if (optimizingScale < 1.0) {
            throw new IllegalArgumentException("Scale for faster processing " + optimizingScale + " must be >= 1.0");
        }
        this.optimizingScale = optimizingScale;
    }

    public RankMorphology createRankMorphology(Class<?> elementType, double level) {
        RankMorphology morphology = BasicRankMorphology.getInstance(null, (double)level, (CustomRankPrecision)this.rankPrecision(elementType));
        if (this.continuationMode != null) {
            morphology = ContinuedRankMorphology.getInstance((RankMorphology)morphology, (Matrix.ContinuationMode)this.continuationMode);
        }
        return morphology;
    }

    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        return this.uncompress(this.processCompressedChannel(this.compress(m)));
    }

    protected Matrix<? extends PArray> compress(Matrix<? extends PArray> m) {
        this.sourceMatrixDimensions = m.dimensions();
        if (this.optimizingScale == 1.0) {
            return m;
        }
        long[] newDimensions = new long[this.sourceMatrixDimensions.length];
        for (int k = 0; k < newDimensions.length; ++k) {
            newDimensions[k] = (long)((double)this.sourceMatrixDimensions[k] / this.optimizingScale);
        }
        Matrix result = Arrays.SMM.newMatrix(UpdatablePArray.class, m.elementType(), newDimensions);
        Matrices.resize(null, (Matrices.ResizingMethod)Matrices.ResizingMethod.AVERAGING, (Matrix)result, m);
        return result;
    }

    protected Matrix<? extends PArray> uncompress(Matrix<? extends PArray> m) {
        if (this.sourceMatrixDimensions == null) {
            throw new IllegalStateException("compress() method must be called at least once before uncompress");
        }
        if (this.optimizingScale == 1.0) {
            return m;
        }
        Matrix result = Arrays.SMM.newMatrix(UpdatablePArray.class, m.elementType(), this.sourceMatrixDimensions);
        Matrices.resize(null, (Matrices.ResizingMethod)Matrices.ResizingMethod.POLYLINEAR_INTERPOLATION, (Matrix)result, m);
        return result;
    }

    protected abstract Matrix<? extends PArray> processCompressedChannel(Matrix<? extends PArray> var1);

    protected final String rankMorphologyLogMessage() {
        return (this.interpolatedHistogram ? ", interpolated histogram" : "") + (String)(this.optimizingScale == 1.0 ? "" : ", compressed in " + this.optimizingScale + " times");
    }

    RankPrecision rankPrecision(Class<?> elementType) {
        long bitsPerElement = Arrays.bitsPerElement(elementType);
        RankPrecision result = bitsPerElement <= 8L ? RankPrecision.BITS_8 : (bitsPerElement <= 16L ? RankPrecision.BITS_16_PER_8 : RankPrecision.BITS_22_PER_7);
        result = result.otherInterpolation(this.interpolatedHistogram);
        return result;
    }
}

