/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.thresholds;

import net.algart.arrays.IntArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class SeveralThresholds
extends MultiMatrix2DFilter {
    public static final String INPUT_MASK = "mask";
    public static final String OUTPUT_LABELS = "labels";
    private double[] thresholds = new double[0];
    private int[] values = new int[]{1};
    private boolean rawValues = false;

    public SeveralThresholds() {
        this.addInputMat(INPUT_MASK);
        this.setDefaultOutputMat(OUTPUT_LABELS);
    }

    public SeveralThresholds setThresholds(double[] thresholds) {
        this.thresholds = (double[])((double[])SeveralThresholds.nonNull((Object)thresholds)).clone();
        return this;
    }

    public SeveralThresholds setThresholds(String thresholds) {
        this.thresholds = new SScalar((String)SeveralThresholds.nonNull((Object)thresholds)).toDoubles();
        return this;
    }

    public int[] getValues() {
        return (int[])this.values.clone();
    }

    public SeveralThresholds setValues(int[] values) {
        SeveralThresholds.nonNull((Object)values);
        if (values.length == 0) {
            throw new IllegalArgumentException("At least 1 value must be specifed");
        }
        this.values = (int[])values.clone();
        return this;
    }

    public SeveralThresholds setValues(String values) {
        return this.setValues(new SScalar((String)SeveralThresholds.nonNull((Object)values)).toInts());
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public SeveralThresholds setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    public MultiMatrix2D process(MultiMatrix2D source) {
        return this.process(source, this.getInputMat(INPUT_MASK, true).toMultiMatrix2D());
    }

    public MultiMatrix2D process(MultiMatrix2D source, MultiMatrix2D mask) {
        Matrix intensity = source.intensityChannel();
        double scale = this.rawValues ? 1.0 : ((PArray)intensity.array()).maxPossibleValue(1.0);
        final double[] scaledThresholds = new double[this.thresholds.length];
        for (int k = 0; k < scaledThresholds.length; ++k) {
            scaledThresholds[k] = scale * this.thresholds[k];
        }
        final int[] appendedValues = new int[this.thresholds.length + 1];
        for (int k = 0; k < appendedValues.length; ++k) {
            appendedValues[k] = k < this.values.length ? this.values[k] : k;
        }
        MultiMatrix2D result = MultiMatrix.of2DMono((Matrix)Matrices.asFuncMatrix((Func)new AbstractFunc(this){

            public double get(double ... x) {
                return this.get(x[0]);
            }

            public double get(double x0) {
                int result = appendedValues[0];
                for (int k = 0; k < scaledThresholds.length; ++k) {
                    if (!(x0 >= scaledThresholds[k])) continue;
                    result = appendedValues[k + 1];
                }
                return result;
            }
        }, IntArray.class, (Matrix)intensity));
        if (mask != null) {
            result = result.min(mask.nonZeroAnyChannel());
        }
        return result;
    }
}

