/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class EqualizeHist
extends VoidResultUMatFilter
implements ReadOnlyExecutionInput {
    private boolean autoConvertToGrayscale = false;

    public boolean isAutoConvertToGrayscale() {
        return this.autoConvertToGrayscale;
    }

    public void setAutoConvertToGrayscale(boolean autoConvertToGrayscale) {
        this.autoConvertToGrayscale = autoConvertToGrayscale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Mat result, Mat source) {
        Mat mat = source;
        try {
            if (this.autoConvertToGrayscale) {
                mat = OTools.toMono8UIfNot(mat);
            }
            opencv_imgproc.equalizeHist((Mat)mat, (Mat)result);
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(UMat result, UMat source) {
        UMat mat = source;
        try {
            if (this.autoConvertToGrayscale) {
                mat = OTools.toMono8UIfNot(mat);
            }
            opencv_imgproc.equalizeHist((UMat)mat, (UMat)result);
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }
}

