/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.opencv.util.enums.OBorderType;
import net.algart.executors.modules.opencv.util.enums.ODepthOrUnchanged;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class Sobel
extends UMatFilter {
    public static final int SCHARR_KERNEL_SIZE = -1;
    private ODepthOrUnchanged resultDepth = ODepthOrUnchanged.UNCHANGED;
    private int dx = 1;
    private int dy = 1;
    private int kernelSize = 3;
    private double scale = 1.0;
    private double delta = 0.0;
    private OBorderType borderType = OBorderType.BORDER_DEFAULT;

    public ODepthOrUnchanged getResultDepth() {
        return this.resultDepth;
    }

    public void setResultDepth(ODepthOrUnchanged resultDepth) {
        this.resultDepth = (ODepthOrUnchanged)((Object)Sobel.nonNull((Object)((Object)resultDepth)));
    }

    public int getDx() {
        return this.dx;
    }

    public void setDx(int dx) {
        this.dx = Sobel.nonNegative((int)dx);
    }

    public int getDy() {
        return this.dy;
    }

    public void setDy(int dy) {
        this.dy = Sobel.nonNegative((int)dy);
    }

    public int getKernelSize() {
        return this.kernelSize;
    }

    public void setKernelSize(int kernelSize) {
        if (kernelSize <= 0 && kernelSize != -1) {
            throw new IllegalArgumentException("Kernel size " + kernelSize + " must be positive or -1");
        }
        this.kernelSize = kernelSize;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public OBorderType getBorderType() {
        return this.borderType;
    }

    public void setBorderType(OBorderType borderType) {
        this.borderType = (OBorderType)((Object)Sobel.nonNull((Object)((Object)borderType)));
    }

    @Override
    public UMat process(UMat source) {
        opencv_imgproc.Sobel((UMat)source, (UMat)source, (int)this.resultDepth.code(), (int)this.dx, (int)this.dy, (int)this.kernelSize, (double)this.scale, (double)this.delta, (int)this.borderType.code());
        return source;
    }

    @Override
    public Mat process(Mat source) {
        opencv_imgproc.Sobel((Mat)source, (Mat)source, (int)this.resultDepth.code(), (int)this.dx, (int)this.dy, (int)this.kernelSize, (double)this.scale, (double)this.delta, (int)this.borderType.code());
        return source;
    }

    @Override
    public boolean useGPU() {
        if (this.delta != 0.0) {
            return false;
        }
        return super.useGPU();
    }
}

