/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.segmentation;

import net.algart.executors.modules.opencv.matrices.segmentation.AbstractSuperpixel;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class SuperpixelLSC
extends AbstractSuperpixel {
    private int regionSize = 10;
    private double ratio = 0.075;
    private int enforceLabelConnectivityMinElementSize = 0;
    private int numberOfIterations = 10;

    public int getRegionSize() {
        return this.regionSize;
    }

    public void setRegionSize(int regionSize) {
        this.regionSize = SuperpixelLSC.nonNegative((int)regionSize);
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = SuperpixelLSC.nonNegative((double)ratio);
    }

    public int getEnforceLabelConnectivityMinElementSize() {
        return this.enforceLabelConnectivityMinElementSize;
    }

    public void setEnforceLabelConnectivityMinElementSize(int enforceLabelConnectivityMinElementSize) {
        this.enforceLabelConnectivityMinElementSize = SuperpixelLSC.nonNegative((int)enforceLabelConnectivityMinElementSize);
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public void setNumberOfIterations(int numberOfIterations) {
        this.numberOfIterations = SuperpixelLSC.positive((int)numberOfIterations);
    }

    @Override
    public Mat process(Mat source) {
        Mat result = new Mat();
        try (org.bytedeco.opencv.opencv_ximgproc.SuperpixelLSC superpixel = opencv_ximgproc.createSuperpixelLSC((Mat)source, (int)this.regionSize, (float)((float)this.ratio));){
            superpixel.iterate(this.numberOfIterations);
            SuperpixelLSC.logDebug(() -> "Superpixel LSC found " + superpixel.getNumberOfSuperpixels() + " superpixels; regionSize " + this.regionSize + ", ratio " + this.ratio + " (source: " + String.valueOf(source) + ")");
            if (this.enforceLabelConnectivityMinElementSize > 0) {
                superpixel.enforceLabelConnectivity(this.enforceLabelConnectivityMinElementSize);
            }
            superpixel.getLabels(result);
            this.makeLabelsPositiveIfRequired(result);
            this.setToOutputBoundaries((Mat boundaries, Mat labels, boolean needThick) -> superpixel.getLabelContourMask(boundaries, this.drawingBoundariesStyle.thickBoundaries), source, result);
        }
        return result;
    }

    @Override
    public UMat process(UMat source) {
        UMat result = new UMat();
        try (org.bytedeco.opencv.opencv_ximgproc.SuperpixelLSC superpixel = opencv_ximgproc.createSuperpixelLSC((UMat)source, (int)this.regionSize, (float)((float)this.ratio));){
            superpixel.iterate(this.numberOfIterations);
            SuperpixelLSC.logDebug(() -> "Superpixel LSC found " + superpixel.getNumberOfSuperpixels() + " superpixels; regionSize " + this.regionSize + ", ratio " + this.ratio + " (source: " + String.valueOf(source) + ")");
            if (this.enforceLabelConnectivityMinElementSize > 0) {
                superpixel.enforceLabelConnectivity(this.enforceLabelConnectivityMinElementSize);
            }
            superpixel.getLabels(result);
            this.makeLabelsPositiveIfRequired(result);
            this.setToOutputBoundaries((Mat boundaries, Mat labels, boolean needThick) -> superpixel.getLabelContourMask(boundaries, this.drawingBoundariesStyle.thickBoundaries), source, result);
        }
        return result;
    }
}

