/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorBaseNode;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.BackwardDFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.CGTrackingDFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupTrackingData;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAFindInnerLiteralStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAInitialStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCG;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.SequentialMatchers;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorDebugRecorder;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorProperties;
import com.oracle.truffle.regex.tregex.nodes.input.InputOps;
import java.util.Arrays;

public final class TRegexDFAExecutorNode
extends TRegexExecutorNode {
    private static final int IP_TRANSITION_MARKER = 32768;
    public static final int NO_MATCH = -2;
    private final TRegexDFAExecutorProperties props;
    private final int maxNumberOfNFAStates;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TruffleString.CodePointSet[] indexOfParameters;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final DFAAbstractStateNode[] states;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] cgResultOrder;
    private final TRegexDFAExecutorDebugRecorder debugRecorder;
    @Node.Children
    private TruffleString.ByteIndexOfCodePointSetNode[] indexOfNodes;
    @Node.Child
    private TruffleString.ByteIndexOfStringNode indexOfStringNode;
    @Node.Child
    private TRegexExecutorBaseNode innerLiteralPrefixMatcher;

    public TRegexDFAExecutorNode(RegexSource source, TRegexDFAExecutorProperties props, int numberOfCaptureGroups, int maxNumberOfNFAStates, TruffleString.CodePointSet[] indexOfParameters, DFAAbstractStateNode[] states, TRegexDFAExecutorDebugRecorder debugRecorder, TRegexDFAExecutorNode innerLiteralPrefixMatcher) {
        this(source, props, numberOfCaptureGroups, TRegexDFAExecutorNode.calcNumberOfTransitions(source, states), maxNumberOfNFAStates, indexOfParameters, states, props.isGenericCG() && maxNumberOfNFAStates > 1 ? TRegexDFAExecutorNode.initResultOrder(maxNumberOfNFAStates, numberOfCaptureGroups, props) : null, debugRecorder, innerLiteralPrefixMatcher);
    }

    public TRegexDFAExecutorNode(RegexSource source, TRegexDFAExecutorProperties props, int numberOfCaptureGroups, int numberOfTransitions, int maxNumberOfNFAStates, TruffleString.CodePointSet[] indexOfParameters, DFAAbstractStateNode[] states, int[] cgResultOrder, TRegexDFAExecutorDebugRecorder debugRecorder, TRegexDFAExecutorNode innerLiteralPrefixMatcher) {
        super(source, numberOfCaptureGroups, numberOfTransitions);
        this.props = props;
        this.maxNumberOfNFAStates = maxNumberOfNFAStates;
        this.indexOfParameters = indexOfParameters;
        this.states = states;
        this.cgResultOrder = cgResultOrder;
        this.debugRecorder = debugRecorder;
        this.innerLiteralPrefixMatcher = innerLiteralPrefixMatcher;
    }

    private TRegexDFAExecutorNode(TRegexDFAExecutorNode copy, TRegexDFAExecutorNode innerLiteralPrefixMatcher) {
        this(copy.getSource(), copy.props, copy.getNumberOfCaptureGroups(), copy.getNumberOfTransitions(), copy.maxNumberOfNFAStates, copy.indexOfParameters, copy.states, copy.cgResultOrder, copy.debugRecorder, innerLiteralPrefixMatcher);
    }

    @Override
    public TRegexDFAExecutorNode shallowCopy() {
        return new TRegexDFAExecutorNode(this, this.innerLiteralPrefixMatcher == null ? null : (TRegexDFAExecutorNode)this.innerLiteralPrefixMatcher.shallowCopy());
    }

    private DFAInitialStateNode getInitialState() {
        return (DFAInitialStateNode)this.states[0];
    }

    public int getPrefixLength() {
        return this.getInitialState().getPrefixLength();
    }

    public boolean isAnchored() {
        return !this.getInitialState().hasUnAnchoredEntry();
    }

    @Override
    public String getName() {
        return "dfa";
    }

    @Override
    public boolean isForward() {
        return this.props.isForward();
    }

    @Override
    public boolean isTrivial() {
        return this.getNumberOfTransitions() < (this.isGenericCG() ? 75 : 100);
    }

    public boolean isBackward() {
        return !this.props.isForward();
    }

    public boolean isSearching() {
        return this.props.isSearching();
    }

    @Override
    public boolean isSimpleCG() {
        return this.props.isSimpleCG();
    }

    public boolean isGenericCG() {
        return this.props.isGenericCG();
    }

    public boolean canFindStart() {
        return this.props.canFindStart();
    }

    @Override
    public int getNumberOfStates() {
        return this.states.length;
    }

    private static int calcNumberOfTransitions(RegexSource source, DFAAbstractStateNode[] states) {
        int sum = 0;
        for (DFAAbstractStateNode state : states) {
            sum += state.getSuccessors().length;
            if (!(state instanceof DFAStateNode) || ((DFAStateNode)state).treeTransitionMatching() || ((DFAStateNode)state).getSequentialMatchers().getNoMatchSuccessor() < 0) continue;
            ++sum;
        }
        if (sum > source.getOptions().getMaxDFASize()) {
            throw new UnsupportedRegexException("too many transitions");
        }
        return sum;
    }

    public boolean recordExecution() {
        return this.debugRecorder != null;
    }

    public TRegexDFAExecutorDebugRecorder getDebugRecorder() {
        return this.debugRecorder;
    }

    TruffleString.ByteIndexOfCodePointSetNode getIndexOfNode(int index) {
        if (this.indexOfNodes == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            TruffleString.ByteIndexOfCodePointSetNode[] nodes = new TruffleString.ByteIndexOfCodePointSetNode[this.indexOfParameters.length];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = TruffleString.ByteIndexOfCodePointSetNode.create();
            }
            this.indexOfNodes = (TruffleString.ByteIndexOfCodePointSetNode[])this.insert((Node[])nodes);
        }
        return this.indexOfNodes[index];
    }

    TruffleString.ByteIndexOfStringNode getIndexOfStringNode() {
        if (this.indexOfStringNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.indexOfStringNode = (TruffleString.ByteIndexOfStringNode)this.insert((Node)TruffleString.ByteIndexOfStringNode.create());
        }
        return this.indexOfStringNode;
    }

    @Override
    public TRegexExecutorLocals createLocals(TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, int index) {
        return new TRegexDFAExecutorLocals(input, fromIndex, maxIndex, regionFrom, regionTo, index, this.createCGData());
    }

    @Override
    public boolean writesCaptureGroups() {
        return this.isSimpleCG();
    }

    private DFACaptureGroupTrackingData createCGData() {
        if (this.isSimpleCG()) {
            return new DFACaptureGroupTrackingData(null, TRegexDFAExecutorNode.createResultsArray(this.resultLength()), this.props.isSimpleCGMustCopy() ? new int[this.resultLength()] : null);
        }
        if (this.isGenericCG()) {
            return new DFACaptureGroupTrackingData(this.maxNumberOfNFAStates == 1 ? null : Arrays.copyOf(this.cgResultOrder, this.cgResultOrder.length), TRegexDFAExecutorNode.createResultsArray(this.maxNumberOfNFAStates * this.resultLength()), new int[this.resultLength()]);
        }
        return null;
    }

    private int resultLength() {
        return this.getNumberOfCaptureGroups() * 2 + (this.props.tracksLastGroup() ? 1 : 0);
    }

    private static int[] createResultsArray(int length) {
        int[] results = new int[length];
        Arrays.fill(results, -1);
        return results;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    public Object execute(VirtualFrame frame, TRegexExecutorLocals abstractLocals, TruffleString.CodeRange codeRange) {
        block93: {
            locals = (TRegexDFAExecutorLocals)abstractLocals;
            CompilerDirectives.ensureVirtualized((Object)locals);
            CompilerAsserts.partialEvaluationConstant((Object)this.states);
            CompilerAsserts.partialEvaluationConstant((int)this.states.length);
            CompilerAsserts.partialEvaluationConstant((Object)codeRange);
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (boolean)(TRegexDFAExecutorNode.validArgs(locals) == false))) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException(String.format("Got illegal args! (fromIndex %d, maxIndex %d, regionFrom: %d, regionTo: %d, initialIndex %d)", new Object[]{locals.getFromIndex(), locals.getMaxIndex(), locals.getRegionFrom(), locals.getRegionTo(), locals.getIndex()}));
            }
            if (this.isGenericCG() || this.isSimpleCG()) {
                CompilerDirectives.ensureVirtualized((Object)locals.getCGData());
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (boolean)(this.props.getMinResultLength() > 0 && (this.isForward() != false ? locals.getMaxIndex() - locals.getIndex() : locals.getIndex() - Math.max(locals.getRegionFrom(), locals.getFromIndex() - this.getPrefixLength())) < this.props.getMinResultLength()))) {
                return this.isGenericCG() != false || this.isSimpleCG() != false ? null : Long.valueOf(-2L);
            }
            if (this.recordExecution()) {
                this.debugRecorder.startRecording(locals);
            }
            if (this.isBackward()) {
                locals.setCurMinIndex(locals.getFromIndex());
            }
            ip = 0;
            block5: while (true) {
                block94: {
                    block96: {
                        block97: {
                            block98: {
                                block95: {
                                    if (CompilerDirectives.inInterpreter()) {
                                        RegexRootNode.checkThreadInterrupted();
                                    }
                                    CompilerAsserts.partialEvaluationConstant((int)ip);
                                    if (ip < 0) break block93;
                                    curState = this.states[ip & 32767];
                                    CompilerAsserts.partialEvaluationConstant((Object)curState);
                                    successors = curState.getSuccessors();
                                    CompilerAsserts.partialEvaluationConstant((Object)successors);
                                    CompilerAsserts.partialEvaluationConstant((int)successors.length);
                                    if (curState instanceof DFAInitialStateNode) {
                                        if (this.isSearching()) {
                                            if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.isForward()) {
                                                throw new AssertionError();
                                            }
                                            for (i = 0; i < this.getPrefixLength(); ++i) {
                                                if (!CompilerDirectives.injectBranchProbability((double)0.25, (boolean)(locals.getIndex() > locals.getRegionFrom()))) {
                                                    if (this.props.canFindStart()) {
                                                        locals.setMatchStart(locals.getIndex());
                                                    }
                                                    this.initNextIndex(locals);
                                                    ip = this.initialStateSuccessor(locals, curState, successors, i);
                                                    continue block5;
                                                }
                                                this.inputSkipIntl(locals, false, codeRange);
                                            }
                                            if (this.props.canFindStart()) {
                                                locals.setMatchStart(locals.getIndex());
                                            }
                                            this.initNextIndex(locals);
                                            atBegin = this.inputAtBegin(locals);
                                        } else {
                                            this.initNextIndex(locals);
                                            atBegin = this.inputAtBegin(locals);
                                            for (i = 0; i < this.getPrefixLength(); ++i) {
                                                if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.isForward()) {
                                                    throw new AssertionError();
                                                }
                                                if (locals.getIndex() >= locals.getFromIndex()) {
                                                    if (CompilerDirectives.injectBranchProbability((double)0.75, (boolean)atBegin)) {
                                                        ip = this.initialStateSuccessor(locals, curState, successors, i);
                                                        continue block5;
                                                    }
                                                    ip = this.initialStateSuccessor(locals, curState, successors, i + successors.length / 2);
                                                    continue block5;
                                                }
                                                this.inputSkipIntl(locals, true, codeRange);
                                            }
                                        }
                                        if (CompilerDirectives.injectBranchProbability((double)0.75, (boolean)atBegin)) {
                                            ip = this.initialStateSuccessor(locals, curState, successors, this.getPrefixLength());
                                            continue;
                                        }
                                        ip = this.initialStateSuccessor(locals, curState, successors, this.getPrefixLength() + successors.length / 2);
                                        continue;
                                    }
                                    if (!(curState instanceof DFAStateNode)) break block94;
                                    state = (DFAStateNode)curState;
                                    if (ip > 32768) {
                                        i = ip >> 16;
                                        ip = this.execTransition(locals, state, i);
                                        continue;
                                    }
                                    if (CompilerDirectives.hasNextTier()) {
                                        locals.incLoopCount(this);
                                    }
                                    this.inputAdvance(locals);
                                    state.beforeFindSuccessor(locals, this);
                                    canDoIndexOf = this.isForward() != false && state.canDoIndexOf(codeRange) != false;
                                    CompilerAsserts.partialEvaluationConstant((boolean)canDoIndexOf);
                                    if (canDoIndexOf && CompilerDirectives.injectBranchProbability((double)0.99, (boolean)this.inputHasNext(locals))) {
                                        indexOfNodeId = state.getIndexOfNodeId();
                                        indexOfNode = this.getIndexOfNode(indexOfNodeId);
                                        indexOfParameter = this.indexOfParameters[indexOfNodeId];
                                        CompilerAsserts.partialEvaluationConstant((int)indexOfNodeId);
                                        CompilerAsserts.partialEvaluationConstant((Object)indexOfNode);
                                        CompilerAsserts.partialEvaluationConstant((Object)indexOfParameter);
                                        indexOfResult = InputOps.indexOf(locals.getInput(), locals.getIndex(), this.getMaxIndex(locals), indexOfParameter, this.getEncoding(), indexOfNode);
                                        postLoopIndex = indexOfResult < 0 ? this.getMaxIndex(locals) : indexOfResult;
                                        state.afterIndexOf(locals, this, locals.getIndex(), postLoopIndex, codeRange);
                                        if (!TRegexDFAExecutorNode.$assertionsDisabled && locals.getIndex() != postLoopIndex) {
                                            throw new AssertionError();
                                        }
                                        v0 = twoSuccessors = successors.length == 2;
                                        if (twoSuccessors && CompilerDirectives.injectBranchProbability((double)0.99, (boolean)(indexOfResult >= 0))) {
                                            successor = state.getLoopToSelf() + 1 & 1;
                                            CompilerAsserts.partialEvaluationConstant((int)successor);
                                            this.inputIncNextIndexRaw(locals, this.inputGetCodePointSize(locals, codeRange));
                                            ip = this.execTransition(locals, state, successor);
                                            continue;
                                        }
                                    }
                                    if (CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (boolean)(this.inputHasNext(locals) == false))) {
                                        state.atEnd(locals, this);
                                        if (this.isBackward() && state.hasBackwardPrefixState() && locals.getIndex() > locals.getRegionFrom()) {
                                            if (!TRegexDFAExecutorNode.$assertionsDisabled && locals.getIndex() != locals.getFromIndex()) {
                                                throw new AssertionError();
                                            }
                                            locals.setCurMinIndex(locals.getRegionFrom());
                                            ip = TRegexDFAExecutorNode.transitionMatch(state, ((BackwardDFAStateNode)state).getBackwardPrefixStateIndex());
                                            continue;
                                        }
                                        break block93;
                                    }
                                    treeTransitionMatching = state.treeTransitionMatching();
                                    CompilerAsserts.partialEvaluationConstant((boolean)treeTransitionMatching);
                                    if (treeTransitionMatching) {
                                        c = this.inputReadAndDecode(locals, codeRange);
                                        treeSuccessor = state.getTreeMatcher().checkMatchTree(c);
                                        for (i = 0; i < successors.length; ++i) {
                                            if (i != treeSuccessor) continue;
                                            ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                            continue block5;
                                        }
                                        break block93;
                                    }
                                    matchers = state.getSequentialMatchers();
                                    CompilerAsserts.partialEvaluationConstant((Object)matchers);
                                    isSimpleMatchers = matchers instanceof SequentialMatchers.SimpleSequentialMatchers;
                                    isUTF8 = matchers instanceof SequentialMatchers.UTF8SequentialMatchers;
                                    CompilerAsserts.partialEvaluationConstant((boolean)isSimpleMatchers);
                                    CompilerAsserts.partialEvaluationConstant((boolean)isUTF8);
                                    if (!isSimpleMatchers) break block95;
                                    c = this.inputReadAndDecode(locals, codeRange);
                                    cMatchers = ((SequentialMatchers.SimpleSequentialMatchers)matchers).getMatchers();
                                    if (cMatchers != null) {
                                        for (i = 0; i < cMatchers.length; ++i) {
                                            if (!TRegexDFAExecutorNode.match(cMatchers, i, c)) continue;
                                            ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                            continue block5;
                                        }
                                    }
                                    break block96;
                                }
                                if (!isUTF8) break block97;
                                utf8Matchers = (SequentialMatchers.UTF8SequentialMatchers)matchers;
                                ascii = utf8Matchers.getAscii();
                                enc2 = utf8Matchers.getEnc2();
                                enc3 = utf8Matchers.getEnc3();
                                enc4 = utf8Matchers.getEnc4();
                                maxBytes = utf8Matchers.getMaxBytes();
                                CompilerAsserts.partialEvaluationConstant((int)maxBytes);
                                c = this.inputReadRaw(locals);
                                isAscii = codeRange == TruffleString.CodeRange.ASCII;
                                CompilerAsserts.partialEvaluationConstant((boolean)isAscii);
                                if (!isAscii && !CompilerDirectives.injectBranchProbability((double)0.7, (boolean)(c < 128))) break block98;
                                this.inputIncNextIndexRaw(locals);
                                if (ascii != null) {
                                    for (i = 0; i < ascii.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(ascii, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                }
                                break block96;
                            }
                            this.getBMPProfile().enter();
                            codepoint = 0;
                            if (this.isBackward()) {
                                codepoint = c & 63;
                                if (!TRegexDFAExecutorNode.$assertionsDisabled && c >> 6 != 2) {
                                    throw new AssertionError();
                                }
                                for (i = 1; i < 4; ++i) {
                                    c = this.inputReadRaw((TRegexExecutorLocals)locals, locals.getIndex() - i);
                                    if (i >= 3 || c >> 6 != 2) break;
                                    codepoint |= (c & 63) << 6 * i;
                                }
                            }
                            nBytes = Integer.numberOfLeadingZeros(~(c << 24));
                            if (!(TRegexDFAExecutorNode.$assertionsDisabled || 1 < nBytes && nBytes < 5)) {
                                throw new AssertionError(nBytes);
                            }
                            this.inputIncNextIndexRaw(locals, nBytes);
                            if (maxBytes <= 1 || nBytes > maxBytes) break block96;
                            if (this.isBackward()) {
                                codepoint |= (c & 255 >>> nBytes) << 6 * (nBytes - 1);
                            }
                            if (this.isForward()) {
                                index = locals.getIndex();
                                codepoint = (c & 255 >>> nBytes) << 6 | this.inputReadRaw((TRegexExecutorLocals)locals, ++index) & 63;
                                if (maxBytes > 2 && nBytes > 2) {
                                    codepoint = codepoint << 6 | this.inputReadRaw((TRegexExecutorLocals)locals, ++index) & 63;
                                }
                                if (maxBytes > 3 && nBytes > 3) {
                                    this.getAstralProfile().enter();
                                    codepoint = codepoint << 6 | this.inputReadRaw((TRegexExecutorLocals)locals, ++index) & 63;
                                }
                            }
                            switch (nBytes - 2) {
                                case 0: {
                                    if (enc2 == null) ** break;
                                    for (i = 0; i < enc2.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(enc2, i, codepoint)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                    break block96;
                                }
                                case 1: {
                                    if (enc3 == null) ** break;
                                    for (i = 0; i < enc3.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(enc3, i, codepoint)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                    break block96;
                                }
                                case 2: {
                                    if (enc4 == null) ** break;
                                    this.getAstralProfile().enter();
                                    for (i = 0; i < enc4.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(enc4, i, codepoint)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                    ** break;
                                }
                            }
lbl202:
                            // 5 sources

                            break block96;
                        }
                        codeRangeIsSubsetOfLatin1 = codeRange.isSubsetOf(TruffleString.CodeRange.LATIN_1);
                        CompilerAsserts.partialEvaluationConstant((boolean)codeRangeIsSubsetOfLatin1);
                        isUTF16Raw = matchers instanceof SequentialMatchers.UTF16RawSequentialMatchers;
                        CompilerAsserts.partialEvaluationConstant((boolean)isUTF16Raw);
                        if (isUTF16Raw) {
                            c = this.inputReadAndDecode(locals, codeRange);
                            ascii = ((SequentialMatchers.UTF16RawSequentialMatchers)matchers).getAscii();
                            latin1 = ((SequentialMatchers.UTF16RawSequentialMatchers)matchers).getLatin1();
                            bmp = ((SequentialMatchers.UTF16RawSequentialMatchers)matchers).getBmp();
                            hasLatin1 = latin1 != null;
                            doLatin1 = bmp == null || codeRangeIsSubsetOfLatin1 != false;
                            CompilerAsserts.partialEvaluationConstant((boolean)hasLatin1);
                            CompilerAsserts.partialEvaluationConstant((boolean)doLatin1);
                            if (hasLatin1 && (doLatin1 || CompilerDirectives.injectBranchProbability((double)0.7, (boolean)(c < 256)))) {
                                byteMatchers = TRegexDFAExecutorNode.asciiOrLatin1Matchers(codeRange, ascii, latin1);
                                for (i = 0; i < byteMatchers.length; ++i) {
                                    if (!TRegexDFAExecutorNode.match(byteMatchers, i, c)) continue;
                                    ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                    continue block5;
                                }
                            } else if (bmp != null) {
                                this.getBMPProfile().enter();
                                for (i = 0; i < bmp.length; ++i) {
                                    if (!TRegexDFAExecutorNode.match(bmp, i, c)) continue;
                                    ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                    continue block5;
                                }
                            }
                        } else {
                            if (!TRegexDFAExecutorNode.$assertionsDisabled && !(matchers instanceof SequentialMatchers.UTF16Or32SequentialMatchers)) {
                                throw new AssertionError();
                            }
                            utf16Or32Matchers = (SequentialMatchers.UTF16Or32SequentialMatchers)matchers;
                            ascii = utf16Or32Matchers.getAscii();
                            latin1 = utf16Or32Matchers.getLatin1();
                            bmp = utf16Or32Matchers.getBmp();
                            astral = utf16Or32Matchers.getAstral();
                            c = this.inputReadRaw(locals);
                            this.inputIncNextIndexRaw(locals);
                            isCodeRangeValid = codeRange == TruffleString.CodeRange.VALID;
                            CompilerAsserts.partialEvaluationConstant((boolean)isCodeRangeValid);
                            if (this.isUTF16()) {
                                mustDecode = codeRange.isSupersetOf(TruffleString.CodeRange.VALID) != false && state.utf16MustDecode() != false;
                                CompilerAsserts.partialEvaluationConstant((boolean)mustDecode);
                                if (mustDecode && CompilerDirectives.injectBranchProbability((double)0.1, (boolean)this.inputUTF16IsHighSurrogate(c)) && (isCodeRangeValid || CompilerDirectives.injectBranchProbability((double)0.75, (boolean)this.inputHasNext(locals, locals.getNextIndex())))) {
                                    this.getAstralProfile().enter();
                                    c2 = this.inputReadRaw((TRegexExecutorLocals)locals, locals.getNextIndex());
                                    if (isCodeRangeValid || CompilerDirectives.injectBranchProbability((double)0.75, (boolean)this.inputUTF16IsLowSurrogate(c2))) {
                                        if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.inputUTF16IsLowSurrogate(c2)) {
                                            throw new AssertionError();
                                        }
                                        locals.setNextIndex(this.inputIncRaw(locals.getNextIndex()));
                                        if (astral != null) {
                                            c = this.inputUTF16ToCodePoint(c, c2);
                                        }
                                    }
                                    if (astral != null) {
                                        for (i = 0; i < astral.length; ++i) {
                                            if (!TRegexDFAExecutorNode.match(astral, i, c)) continue;
                                            ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                            continue block5;
                                        }
                                    }
                                } else if (latin1 != null && (bmp == null || codeRangeIsSubsetOfLatin1 || CompilerDirectives.injectBranchProbability((double)0.7, (boolean)(c < 256)))) {
                                    byteMatchers = TRegexDFAExecutorNode.asciiOrLatin1Matchers(codeRange, ascii, latin1);
                                    for (i = 0; i < byteMatchers.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(byteMatchers, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                } else if (bmp != null && codeRange.isSupersetOf(TruffleString.CodeRange.BMP)) {
                                    this.getBMPProfile().enter();
                                    for (i = 0; i < bmp.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(bmp, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                }
                            } else {
                                if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.isUTF32()) {
                                    throw new AssertionError();
                                }
                                if (latin1 != null && (codeRangeIsSubsetOfLatin1 || CompilerDirectives.injectBranchProbability((double)0.7, (boolean)(c < 256)))) {
                                    byteMatchers = TRegexDFAExecutorNode.asciiOrLatin1Matchers(codeRange, ascii, latin1);
                                    for (i = 0; i < byteMatchers.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(byteMatchers, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                } else if (bmp != null && (codeRange == TruffleString.CodeRange.BMP || CompilerDirectives.injectBranchProbability((double)0.2, (boolean)(c <= 65535)) && (isCodeRangeValid || CompilerDirectives.injectBranchProbability((double)0.2, (boolean)(Character.isSurrogate((char)c) == false))))) {
                                    this.getBMPProfile().enter();
                                    for (i = 0; i < bmp.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(bmp, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                } else if (astral != null && codeRange.isSupersetOf(TruffleString.CodeRange.VALID)) {
                                    this.getAstralProfile().enter();
                                    for (i = 0; i < astral.length; ++i) {
                                        if (!TRegexDFAExecutorNode.match(astral, i, c)) continue;
                                        ip = TRegexDFAExecutorNode.transitionMatch(state, i);
                                        continue block5;
                                    }
                                }
                            }
                        }
                    }
                    ip = TRegexDFAExecutorNode.transitionNoMatch(state);
                    continue;
                }
                if (!TRegexDFAExecutorNode.$assertionsDisabled && !(curState instanceof DFAFindInnerLiteralStateNode)) {
                    throw new AssertionError();
                }
                if (!TRegexDFAExecutorNode.$assertionsDisabled && !this.isForward()) {
                    throw new AssertionError();
                }
                this.inputAdvance(locals);
                state = (DFAFindInnerLiteralStateNode)curState;
lbl309:
                // 2 sources

                while (!CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (boolean)(this.inputHasNext(locals) == false))) {
                    locals.setIndex(state.executeInnerLiteralSearch(locals, this));
                    if (!CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (boolean)(locals.getIndex() < 0))) {
                        if (this.innerLiteralPrefixMatcher != null && !CompilerDirectives.injectBranchProbability((double)0.99, (boolean)TRegexDFAExecutorNode.prefixMatcherMatches(frame, this.innerLiteralPrefixMatcher, locals, codeRange, this.canFindStart()))) break block5;
                        if (this.innerLiteralPrefixMatcher == null) {
                            if (this.isSimpleCG()) {
                                locals.getCGData().results[0] = locals.getIndex();
                            } else if (this.canFindStart()) {
                                locals.setMatchStart(locals.getIndex());
                            }
                        }
                        this.inputIncRaw(locals, state.getInnerLiteral().getLiteral().encodedLength());
                        locals.setNextIndex(locals.getIndex());
                        ip = successors[0];
                        continue block5;
                    }
                    break block93;
                }
                break block93;
                break;
            }
            this.inputIncRaw(locals);
            ** GOTO lbl309
        }
        if (this.recordExecution()) {
            this.debugRecorder.finishRecording();
        }
        if (this.isSimpleCG()) {
            result = this.props.isSimpleCGMustCopy() != false ? locals.getCGData().currentResult : locals.getCGData().results;
            return (int[])(locals.getResultInt() == 0 ? result : null);
        }
        if (this.isGenericCG()) {
            return locals.getResultInt() == 0 ? locals.getCGData().currentResult : null;
        }
        if (this.isForward() && this.canFindStart()) {
            return (long)locals.getResultInt() | (long)locals.getMatchStart() << 32;
        }
        return (long)locals.getResultInt();
    }

    private static boolean prefixMatcherMatches(VirtualFrame frame, TRegexExecutorBaseNode prefixMatcher, TRegexDFAExecutorLocals locals, TruffleString.CodeRange codeRange, boolean canFindStart) {
        Object result = prefixMatcher.execute(frame, locals.toInnerLiteralBackwardLocals(), codeRange);
        if (prefixMatcher.isSimpleCG()) {
            return result != null;
        }
        if (canFindStart) {
            locals.setMatchStart((int)((Long)result).longValue());
        }
        return (int)((Long)result).longValue() != -2;
    }

    private static CharMatcher[] asciiOrLatin1Matchers(TruffleString.CodeRange codeRange, CharMatcher[] ascii, CharMatcher[] latin1) {
        return codeRange == TruffleString.CodeRange.ASCII && ascii != null ? ascii : latin1;
    }

    private short initialStateSuccessor(TRegexDFAExecutorLocals locals, DFAAbstractStateNode curState, short[] successors, int i) {
        DFASimpleCG simpleCG;
        if (this.isGenericCG()) {
            locals.setLastIndex();
            short lastTransition = ((DFAInitialStateNode)curState).getCgLastTransition()[i];
            if (lastTransition >= 0) {
                locals.setLastTransition(lastTransition);
            }
        } else if (this.isSimpleCG() && (simpleCG = ((DFAInitialStateNode)curState).getSimpleCG()) != null) {
            simpleCG.getTransitions()[i].apply(locals.getCGData().results, locals.getIndex(), this.getProperties().tracksLastGroup(), this.isForward());
        }
        return successors[i];
    }

    private void initNextIndex(TRegexDFAExecutorLocals locals) {
        locals.setNextIndex(locals.getIndex());
        if (this.recordExecution()) {
            this.getDebugRecorder().setInitialIndex(locals.getIndex());
        }
    }

    private static boolean match(CharMatcher[] matchers, int i, int c) {
        return matchers[i] != null && matchers[i].match(c);
    }

    private static int transitionMatch(DFAStateNode state, int i) {
        CompilerAsserts.partialEvaluationConstant((Object)state);
        return state.getId() | 0x8000 | i << 16;
    }

    private static int transitionNoMatch(DFAStateNode state) {
        CompilerAsserts.partialEvaluationConstant((Object)state);
        return state.getId() | 0x8000 | state.getSequentialMatchers().getNoMatchSuccessor() << 16;
    }

    private int execTransition(TRegexDFAExecutorLocals locals, DFAStateNode state, int i) {
        CompilerAsserts.partialEvaluationConstant((Object)state);
        CompilerAsserts.partialEvaluationConstant((int)i);
        if (this.recordExecution()) {
            this.debugRecorder.recordTransition(locals.getIndex(), state.getId(), i);
        }
        state.successorFound(locals, this, i);
        return state.successors[i];
    }

    @Override
    public int getMinIndex(TRegexExecutorLocals locals) {
        return this.isForward() ? super.getMinIndex(locals) : ((TRegexDFAExecutorLocals)locals).getCurMinIndex();
    }

    private static boolean validArgs(TRegexDFAExecutorLocals locals) {
        int initialIndex = locals.getIndex();
        int fromIndex = locals.getFromIndex();
        int maxIndex = locals.getMaxIndex();
        int regionFrom = locals.getRegionFrom();
        int regionTo = locals.getRegionTo();
        return 0 <= regionFrom && regionFrom <= fromIndex && fromIndex <= maxIndex && maxIndex <= regionTo && regionFrom <= initialIndex && initialIndex <= regionTo;
    }

    private static int[] initResultOrder(int maxNumberOfNFAStates, int numberOfCaptureGroups, TRegexDFAExecutorProperties props) {
        int[] resultOrder = new int[maxNumberOfNFAStates];
        for (int i = 0; i < maxNumberOfNFAStates; ++i) {
            resultOrder[i] = i * (numberOfCaptureGroups * 2 + (props.tracksLastGroup() ? 1 : 0));
        }
        return resultOrder;
    }

    public TRegexDFAExecutorProperties getProperties() {
        return this.props;
    }

    public int getMaxNumberOfNFAStates() {
        return this.maxNumberOfNFAStates;
    }

    public int getCGTrackingCost() {
        int cost = 0;
        for (DFAAbstractStateNode s : this.states) {
            if (!(s instanceof CGTrackingDFAStateNode)) continue;
            cost += ((CGTrackingDFAStateNode)s).getCGTrackingCost();
        }
        return cost;
    }
}

