/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api;

import java.util.List;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.extensions.ExtensionSpecification;
import net.algart.executors.api.extensions.InstalledExtensions;

public class CommonPlatformInformation
extends Executor
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_ID = "id";
    public static final String OUTPUT_NAME = "name";
    public static final String OUTPUT_DESCRIPTION = "description";
    public static final String OUTPUT_TECHNOLOGIES = "technologies";
    public static final String OUTPUT_LANGUAGE = "language";
    public static final String OUTPUT_ROOT_FOLDER = "root_folder";
    public static final String OUTPUT_SPECIFICATIONS_FOLDER = "specifications_folder";
    public static final String OUTPUT_MODULES_FOLDER = "modules_folder";
    public static final String OUTPUT_LIBRARIES_FOLDER = "libraries_folder";
    public static final String OUTPUT_RESOURCES_FOLDER = "resources_folder";
    private static final List<String> ALL_OUTPUT_PORTS = List.of(DEFAULT_OUTPUT_PORT, "id", "name", "description", "technologies", "language", "root_folder", "specifications_folder", "modules_folder", "libraries_folder", "resources_folder");

    public CommonPlatformInformation() {
        ALL_OUTPUT_PORTS.forEach(this::addOutputScalar);
    }

    @Override
    public void process() {
        String id = this.platformId();
        ExtensionSpecification.Platform platform = InstalledExtensions.allInstalledPlatformsMap().get(id);
        if (platform == null) {
            ALL_OUTPUT_PORTS.forEach(s -> this.getScalar((String)s).remove());
            this.getScalar().setTo("Platform \"" + id + "\" not found");
        } else {
            this.getScalar().setTo(platform.jsonString());
            this.getScalar(OUTPUT_ID).setTo(platform.getId());
            this.getScalar(OUTPUT_NAME).setTo(platform.getName());
            this.getScalar(OUTPUT_DESCRIPTION).setTo(platform.getDescription());
            this.getScalar(OUTPUT_TECHNOLOGIES).setTo(String.join((CharSequence)"\n", platform.getTechnologies()));
            this.getScalar(OUTPUT_LANGUAGE).setTo(platform.getLanguage());
            this.getScalar(OUTPUT_ROOT_FOLDER).setTo(platform.getFolders().getRoot());
            this.getScalar(OUTPUT_SPECIFICATIONS_FOLDER).setTo(platform.specificationsFolderOrNull());
            this.getScalar(OUTPUT_MODULES_FOLDER).setTo(platform.modulesFolderOrNull());
            this.getScalar(OUTPUT_LIBRARIES_FOLDER).setTo(platform.librariesFolderOrNull());
            this.getScalar(OUTPUT_RESOURCES_FOLDER).setTo(platform.resourcesFolderOrNull());
        }
    }

    protected String platformId() {
        return this.getPlatformId();
    }
}

