/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.extensions;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import net.algart.json.AbstractConvertibleToJson;
import net.algart.json.Jsons;

public final class ExtensionSpecification
extends AbstractConvertibleToJson {
    private static final boolean SUPPORT_OLD_MODELS_SYNTAX = true;
    public static final String APP_NAME = "executors-extension";
    public static final String CURRENT_VERSION = "1.0";
    public static final String DEFAULT_EXTENSION_FILE_NAME = "extension.json";
    private final Path specificationFile;
    private String version = "1.0";
    private List<Platform> platforms = new ArrayList<Platform>();

    public ExtensionSpecification() {
        this.specificationFile = null;
    }

    private ExtensionSpecification(JsonObject json, Path file) {
        Objects.requireNonNull(json, "Null extension JSON");
        if (!APP_NAME.equals(json.getString("app", null))) {
            throw new JsonException("JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + " is not an executor configuration: no \"app\":\"executors-extension\" element");
        }
        this.specificationFile = file;
        this.version = json.getString("version", CURRENT_VERSION);
        for (JsonObject platformJson : Jsons.reqJsonObjects(json, "platforms")) {
            this.platforms.add(new Platform(platformJson, file));
        }
    }

    public static ExtensionSpecification of(JsonObject specificationJson) {
        return new ExtensionSpecification(specificationJson, null);
    }

    public static ExtensionSpecification read(Path specificationFile) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        JsonObject json = Jsons.readJson(specificationFile);
        return new ExtensionSpecification(json, specificationFile);
    }

    public static ExtensionSpecification readIfValid(Path specificationFile) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        JsonObject json = Jsons.readJson(specificationFile);
        Objects.requireNonNull(json, "Null extension JSON");
        if (!APP_NAME.equals(json.getString("app", null))) {
            return null;
        }
        return new ExtensionSpecification(json, specificationFile);
    }

    public static ExtensionSpecification readFromFolder(Path extensionFolder) throws IOException {
        Objects.requireNonNull(extensionFolder, "Null extensionFolder");
        if (!Files.isDirectory(extensionFolder, new LinkOption[0])) {
            throw new FileNotFoundException("Extension folder \"" + String.valueOf(extensionFolder) + "\" is not an existing directory");
        }
        Path specificationFile = ExtensionSpecification.defaultExtensionSpecificationFile(extensionFolder);
        if (!Files.exists(specificationFile, new LinkOption[0])) {
            throw new FileNotFoundException("Extension specification file \"" + String.valueOf(specificationFile) + "\" does not exist in " + String.valueOf(extensionFolder));
        }
        return ExtensionSpecification.read(specificationFile);
    }

    public void write(Path specificationFile, OpenOption ... options) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        Files.writeString(specificationFile, (CharSequence)this.jsonString(), options);
    }

    public static Path defaultExtensionSpecificationFile(Path extensionFolder) {
        Objects.requireNonNull(extensionFolder, "Null extensionFolder");
        return extensionFolder.resolve(DEFAULT_EXTENSION_FILE_NAME).toAbsolutePath();
    }

    public static boolean isExtensionSpecification(JsonObject specificationJson) {
        Objects.requireNonNull(specificationJson, "Null specificationJson");
        return APP_NAME.equals(specificationJson.getString("app", null));
    }

    public static boolean isExtensionFolder(Path extensionFolder) {
        return Files.isDirectory(extensionFolder, new LinkOption[0]) && Files.exists(ExtensionSpecification.defaultExtensionSpecificationFile(extensionFolder), new LinkOption[0]);
    }

    public static List<Path> allExtensionFolders(Path extensionRoot) throws IOException {
        Objects.requireNonNull(extensionRoot, "Null extensionRoot");
        try (Stream<Path> walk = Files.walk(extensionRoot, new FileVisitOption[0]);){
            List<Path> list = walk.sorted().filter(ExtensionSpecification::isExtensionFolder).toList();
            return list;
        }
    }

    public Path getSpecificationFile() {
        return this.specificationFile;
    }

    public String getVersion() {
        return this.version;
    }

    public ExtensionSpecification setVersion(String version) {
        this.version = Objects.requireNonNull(version, "Null version");
        return this;
    }

    public List<Platform> getPlatforms() {
        return Collections.unmodifiableList(this.platforms);
    }

    public ExtensionSpecification setPlatforms(List<Platform> platforms) {
        this.platforms = new ArrayList<Platform>((Collection)ExtensionSpecification.nonNull(platforms));
        return this;
    }

    @Override
    public void checkCompleteness() {
        this.checkNull(this.platforms, "platforms");
    }

    public String toString() {
        return "ExtensionSpecification{specificationFile=" + String.valueOf(this.specificationFile) + ", version='" + this.version + "', platforms=" + String.valueOf(this.platforms) + "}";
    }

    @Override
    public void buildJson(JsonObjectBuilder builder) {
        builder.add("app", APP_NAME);
        if (!this.version.equals(CURRENT_VERSION)) {
            builder.add("version", this.version);
        }
        JsonArrayBuilder platformsBuilder = Json.createArrayBuilder();
        for (Platform platform : this.platforms) {
            platformsBuilder.add((JsonValue)platform.toJson());
        }
        builder.add("platforms", (JsonValue)platformsBuilder.build());
    }

    public static final class Platform
    extends AbstractConvertibleToJson {
        public static final String JVM_TECHNOLOGY = "jvm";
        public static final String DEFAULT_NAME = "Unnamed";
        private static final AtomicLong DYNAMIC_ID_INDEX = new AtomicLong(0L);
        private Path file;
        private String id = Platform.makeUniqueId();
        private String category = null;
        private String name = "Unnamed";
        private String description = null;
        private Set<String> tags = new LinkedHashSet<String>();
        private Set<String> technologies;
        private boolean jvmTechnology;
        private String language = null;
        private Folders folders = new Folders();
        private Configuration configuration = new Configuration();
        private List<Dependency> dependencies = new ArrayList<Dependency>();
        private boolean immutable = false;

        public Platform() {
        }

        public Platform(JsonObject json, Path file) {
            JsonArray dependenciesJson;
            List<String> technologies;
            this.file = file;
            this.setId(json.getString("id", this.id));
            this.setCategory(json.getString("category", null));
            this.setName(json.getString("name", this.name));
            this.setDescription(json.getString("description", null));
            List<String> tags = Jsons.getStrings(json, "tags", file);
            if (tags != null) {
                this.tags.addAll(tags);
            }
            if ((technologies = Jsons.getStrings(json, "technologies", file)) == null) {
                String technology = json.getString("technology", null);
                if (technology == null) {
                    throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"technologies\" or \"technology\" value must exist");
                }
                technologies = List.of(technology);
            }
            this.setTechnologies(technologies);
            this.setLanguage(json.getString("language", null));
            JsonObject foldersJson = json.getJsonObject("folders");
            if (foldersJson != null) {
                this.setFolders(new Folders(foldersJson, file));
            } else {
                this.setFolders(new Folders().setRoot(file == null ? null : file.getParent()));
            }
            JsonObject configurationJson = json.getJsonObject("configuration");
            if (configurationJson != null) {
                this.setConfiguration(new Configuration(configurationJson, file));
            }
            if ((dependenciesJson = Jsons.getJsonArray(json, "dependencies", file, true)) != null) {
                for (JsonValue jsonValue : dependenciesJson) {
                    this.dependencies.add(new Dependency((JsonObject)jsonValue, file));
                }
            }
        }

        public String getId() {
            return this.id;
        }

        public Platform setId(String id) {
            this.checkImmutable();
            this.id = Platform.nonNull(id);
            return this;
        }

        public String getCategory() {
            return this.category;
        }

        public Platform setCategory(String category) {
            this.category = category;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Platform setName(String name) {
            this.checkImmutable();
            this.name = Platform.nonNull(name);
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Platform setDescription(String description) {
            this.checkImmutable();
            this.description = description;
            return this;
        }

        public Set<String> getTags() {
            return Collections.unmodifiableSet(this.tags);
        }

        public Platform setTags(Collection<String> tags) {
            Objects.requireNonNull(tags, "Null tags");
            this.checkImmutable();
            this.tags = new LinkedHashSet<String>(tags);
            return this;
        }

        public Set<String> getTechnologies() {
            return Collections.unmodifiableSet(this.technologies);
        }

        public Platform setTechnologies(Collection<String> technologies) {
            Objects.requireNonNull(technologies, "Null technologies");
            this.checkImmutable();
            LinkedHashSet<String> technologiesSet = new LinkedHashSet<String>(technologies);
            if (technologiesSet.isEmpty()) {
                throw new IllegalArgumentException("Empty technologies");
            }
            this.technologies = technologiesSet;
            this.jvmTechnology = this.technologies.size() == 1 && this.technologies.contains(JVM_TECHNOLOGY);
            return this;
        }

        public boolean containsTechnology(String technology) {
            Objects.requireNonNull(technology, "Null technology");
            return this.technologies.contains(technology);
        }

        public boolean isJvmTechnology() {
            return this.jvmTechnology;
        }

        public boolean isBuiltIn() {
            return this.isJvmTechnology();
        }

        public String getLanguage() {
            return this.language;
        }

        public Platform setLanguage(String language) {
            this.checkImmutable();
            this.language = language;
            return this;
        }

        public Folders getFolders() {
            return this.folders;
        }

        public Platform setFolders(Folders folders) {
            this.checkImmutable();
            this.folders = Platform.nonNull(folders);
            return this;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public Platform setConfiguration(Configuration configuration) {
            this.checkImmutable();
            this.configuration = Platform.nonNull(configuration);
            return this;
        }

        public List<Dependency> getDependencies() {
            return Collections.unmodifiableList(this.dependencies);
        }

        public Platform setDependencies(List<Dependency> dependencies) {
            this.checkImmutable();
            this.dependencies = new ArrayList<Dependency>((Collection)Platform.nonNull(dependencies));
            return this;
        }

        public boolean hasSpecifications() {
            return this.folders.specifications != null;
        }

        public Path specificationsFolder() {
            return this.folders.resolve(this.folders.specifications, "specifications");
        }

        public Path specificationsFolderOrNull() {
            return this.hasSpecifications() ? this.specificationsFolder() : null;
        }

        public boolean hasModules() {
            return this.folders.modules != null;
        }

        public Path modulesFolder() {
            return this.folders.resolve(this.folders.modules, "modules");
        }

        public Path modulesFolderOrNull() {
            return this.hasModules() ? this.modulesFolder() : null;
        }

        public boolean hasLibraries() {
            return this.folders.libraries != null;
        }

        public Path librariesFolder() {
            return this.folders.resolve(this.folders.libraries, "libraries");
        }

        public Path librariesFolderOrNull() {
            return this.hasLibraries() ? this.librariesFolder() : null;
        }

        public boolean hasResources() {
            return this.folders.resources != null;
        }

        public Path resourcesFolder() {
            return this.folders.resolve(this.folders.resources, "resources");
        }

        public Path resourcesFolderOrNull() {
            return this.hasResources() ? this.resourcesFolder() : null;
        }

        public List<Path> validClassPaths() {
            ArrayList<Path> result = new ArrayList<Path>();
            for (String singleClassPath : this.configuration.getClasspath()) {
                if (singleClassPath == null) continue;
                try {
                    result.add(this.folders.resolve(singleClassPath));
                }
                catch (InvalidPathException invalidPathException) {}
            }
            return result;
        }

        public void setImmutable() {
            this.immutable = true;
            if (this.folders != null) {
                this.folders.immutable = true;
            }
            this.dependencies.forEach(dependency -> {
                dependency.immutable = true;
            });
        }

        public void checkExistingPathsIfRequired() throws IOException {
            if (!this.configuration.isRequireExistingPaths()) {
                return;
            }
            for (Path path : this.validClassPaths()) {
                if (Files.exists(path, new LinkOption[0])) continue;
                throw new IOException("Invalid Java classpath" + (String)(this.file == null ? "" : " in " + String.valueOf(this.file)) + ": it contains non-existing path \"" + String.valueOf(path.toAbsolutePath()) + "\" in the full paths list " + String.valueOf(this.configuration.getClasspath()));
            }
        }

        @Override
        public void checkCompleteness() {
            Platform.nonNull(this.technologies, "technologies");
        }

        public String toString() {
            return "Platform{id='" + this.id + "', category='" + this.category + "', name='" + this.name + "', description='" + this.description + "', tags=" + String.valueOf(this.tags) + ", technologies='" + String.valueOf(this.technologies) + "', jvmTechnology=" + this.jvmTechnology + ", language='" + this.language + "', folders=" + String.valueOf(this.folders) + ", configuration=" + String.valueOf(this.configuration) + ", dependencies=" + String.valueOf(this.dependencies) + ", immutable=" + this.immutable + "}";
        }

        @Override
        public void buildJson(JsonObjectBuilder builder) {
            builder.add("id", this.id);
            if (this.category != null) {
                builder.add("category", this.category);
            }
            builder.add("name", this.name);
            if (this.description != null) {
                builder.add("description", this.description);
            }
            if (!this.tags.isEmpty()) {
                JsonArrayBuilder tagsBuilder = Json.createArrayBuilder();
                for (String tag : this.tags) {
                    tagsBuilder.add(tag);
                }
                builder.add("tags", (JsonValue)tagsBuilder.build());
            }
            if (this.technologies == null || this.technologies.isEmpty()) {
                throw new AssertionError((Object)"setTechnologies/checkCompleteness must check null/empty technologies");
            }
            if (this.technologies.size() == 1) {
                builder.add("technology", this.technologies.iterator().next());
            } else {
                JsonArrayBuilder technologiesBuilder = Json.createArrayBuilder();
                for (String technology : this.technologies) {
                    technologiesBuilder.add(technology);
                }
                builder.add("technologies", (JsonValue)technologiesBuilder.build());
            }
            if (this.language != null) {
                builder.add("language", this.language);
            }
            builder.add("folders", (JsonValue)this.folders.toJson());
            builder.add("configuration", (JsonValue)this.configuration.toJson());
            if (!this.dependencies.isEmpty()) {
                JsonArrayBuilder dependenciesBuilder = Json.createArrayBuilder();
                for (Dependency dependency : this.dependencies) {
                    dependenciesBuilder.add((JsonValue)dependency.toJson());
                }
                builder.add("dependencies", (JsonValue)dependenciesBuilder.build());
            }
        }

        private static String makeUniqueId() {
            return "_dynamic_id_" + DYNAMIC_ID_INDEX.incrementAndGet() + "--006b06cc-70b4-4245-8392-18a580af19ef";
        }

        private void checkImmutable() {
            if (this.immutable) {
                throw new UnsupportedOperationException("This platform is immutable and cannot be changed");
            }
        }

        public static final class Folders
        extends AbstractConvertibleToJson {
            private String specifications = null;
            private String modules = null;
            private String libraries = null;
            private String resources = null;
            private Path root = null;
            private boolean immutable = false;

            public Folders() {
            }

            private Folders(JsonObject json, Path file) {
                String specifications = json.getString("specifications", null);
                if (specifications == null) {
                    specifications = json.getString("models", null);
                }
                this.setSpecifications(specifications);
                this.setModules(json.getString("modules", null));
                this.setLibraries(json.getString("libraries", null));
                this.setResources(json.getString("resources", null));
                if (file != null) {
                    this.setRoot(file.getParent());
                }
            }

            public String getSpecifications() {
                return this.specifications;
            }

            public Folders setSpecifications(String specifications) {
                this.checkImmutable();
                this.specifications = specifications == null ? null : Folders.nonEmpty(specifications);
                return this;
            }

            public String getModules() {
                return this.modules;
            }

            public Folders setModules(String modules) {
                this.checkImmutable();
                this.modules = modules == null ? null : Folders.nonEmpty(modules);
                return this;
            }

            public String getLibraries() {
                return this.libraries;
            }

            public Folders setLibraries(String libraries) {
                this.checkImmutable();
                this.libraries = libraries == null ? null : Folders.nonEmpty(libraries);
                return this;
            }

            public String getResources() {
                return this.resources;
            }

            public Folders setResources(String resources) {
                this.resources = resources;
                return this;
            }

            public Path getRoot() {
                return this.root;
            }

            public Folders setRoot(Path root) {
                this.checkImmutable();
                this.root = root == null ? null : root.toAbsolutePath();
                return this;
            }

            @Override
            public void checkCompleteness() {
            }

            public String toString() {
                return "Folders{specifications='" + this.specifications + "', modules='" + this.modules + "', libraries='" + this.libraries + "', resources='" + this.resources + "', root=" + String.valueOf(this.root) + ", immutable=" + this.immutable + "}";
            }

            @Override
            public void buildJson(JsonObjectBuilder builder) {
                if (this.specifications != null) {
                    builder.add("specifications", this.specifications);
                }
                if (this.modules != null) {
                    builder.add("modules", this.modules);
                }
                if (this.libraries != null) {
                    builder.add("libraries", this.libraries);
                }
                if (this.resources != null) {
                    builder.add("resources", this.resources);
                }
            }

            private void checkImmutable() {
                if (this.immutable) {
                    throw new UnsupportedOperationException("The platform folders set is immutable and cannot be changed");
                }
            }

            private Path resolve(String path, String folderNameForExceptionMessageForNullPath) {
                if (path == null) {
                    throw new IllegalStateException("Folder \"" + folderNameForExceptionMessageForNullPath + "\" is not specified in this platform");
                }
                return this.resolve(path);
            }

            private Path resolve(String path) {
                Objects.requireNonNull(path, "Null path");
                Path p = Paths.get(path, new String[0]);
                if (p.isAbsolute()) {
                    return p;
                }
                if (this.root == null) {
                    throw new IllegalStateException("The folder \"" + path + "\" is relative and cannot be resolved, because the platform root folder is not specified; it is probable when an extension JSON was not loaded from a usual .json-file. You must use absolute paths in this case.");
                }
                return this.root.resolve(p);
            }
        }

        public static final class Configuration {
            private Path file;
            private JsonObject json = Jsons.newEmptyJson();
            private List<String> classpath = Collections.emptyList();
            private boolean requireExistingPaths = false;
            private List<String> vmOptions = null;

            public Configuration() {
            }

            public Configuration(JsonObject json, Path file) {
                this.setJson(json);
                this.file = file;
            }

            public JsonObject getJson() {
                return this.json;
            }

            public Configuration setJson(JsonObject json) {
                this.json = Objects.requireNonNull(json, "Null json");
                JsonArray classPathJson = Jsons.getJsonArray(json, "classpath", this.file);
                this.classpath = classPathJson == null ? Collections.emptyList() : Jsons.toStrings(classPathJson, "classpath", this.file);
                this.requireExistingPaths = json.getBoolean("require_existing_paths", false);
                JsonArray vmOptionsJson = Jsons.getJsonArray(json, "vm_options", this.file);
                this.vmOptions = vmOptionsJson == null ? null : Jsons.toStrings(vmOptionsJson, "vm_options", this.file);
                this.file = null;
                return this;
            }

            public void setJson(String json) {
                this.setJson(Jsons.toJson(json));
            }

            public List<String> getClasspath() {
                return Collections.unmodifiableList(this.classpath);
            }

            public Configuration setClasspath(List<String> classpath) {
                this.classpath = new ArrayList<String>(classpath);
                return this;
            }

            public boolean isRequireExistingPaths() {
                return this.requireExistingPaths;
            }

            public Configuration setRequireExistingPaths(boolean requireExistingPaths) {
                this.requireExistingPaths = requireExistingPaths;
                return this;
            }

            public List<String> getVmOptions() {
                return Collections.unmodifiableList(this.vmOptions);
            }

            public Configuration setVmOptions(List<String> vmOptions) {
                this.vmOptions = vmOptions == null ? null : new ArrayList<String>(vmOptions);
                return this;
            }

            public void checkCompleteness() {
                AbstractConvertibleToJson.checkNull(this.json, "json", this.getClass());
            }

            public JsonObject toJson() {
                this.checkCompleteness();
                return this.json;
            }

            public String toString() {
                return "Configuration{json=<<<" + String.valueOf(this.json) + ">>>, classpath=" + String.valueOf(this.classpath) + ", requireExistingPaths=" + this.requireExistingPaths + ", vmOptions=" + String.valueOf(this.vmOptions) + "}";
            }
        }

        public static final class Dependency
        extends AbstractConvertibleToJson {
            private String id;
            private String name = null;
            private String description = null;
            private boolean immutable = false;

            public Dependency() {
            }

            public Dependency(JsonObject json, Path file) {
                this.setId(Jsons.reqString(json, "id", file));
                this.setName(json.getString("name", null));
                this.setDescription(json.getString("description", null));
            }

            public String getId() {
                return this.id;
            }

            public Dependency setId(String id) {
                this.checkImmutable();
                this.id = Dependency.nonNull(id);
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Dependency setName(String name) {
                this.checkImmutable();
                this.name = name;
                return this;
            }

            public String getDescription() {
                return this.description;
            }

            public Dependency setDescription(String description) {
                this.checkImmutable();
                this.description = description;
                return this;
            }

            @Override
            public void checkCompleteness() {
            }

            public String toString() {
                return "Dependency{id='" + this.id + "', name='" + this.name + "', description='" + this.description + "', immutable=" + this.immutable + "}";
            }

            @Override
            public void buildJson(JsonObjectBuilder builder) {
                builder.add("id", this.id);
                if (this.name != null) {
                    builder.add("name", this.name);
                }
                if (this.description != null) {
                    builder.add("description", this.description);
                }
            }

            private void checkImmutable() {
                if (this.immutable) {
                    throw new UnsupportedOperationException("The platform dependency is immutable and cannot be changed");
                }
            }
        }
    }
}

