/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.algart.executors.api.extensions.ExtensionSpecification;
import net.algart.executors.api.extensions.InstalledExtensions;

public class InstalledPlatformsForTechnology {
    private final String platformTechnology;
    private boolean ready = false;
    private List<ExtensionSpecification.Platform> installedPlatforms = null;
    private List<String> installedSpecificationFolders = null;
    private List<String> installedImplementationFolders = null;
    private final Object lock = new Object();

    private InstalledPlatformsForTechnology(String platformTechnology) {
        this.platformTechnology = Objects.requireNonNull(platformTechnology, "Null platformTechnology");
    }

    public static InstalledPlatformsForTechnology of(String platformTechnology) {
        return new InstalledPlatformsForTechnology(platformTechnology);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExtensionSpecification.Platform> installedPlatforms() {
        Object object = this.lock;
        synchronized (object) {
            this.analysePlatforms();
            return this.installedPlatforms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> installedSpecificationFolders() {
        Object object = this.lock;
        synchronized (object) {
            this.analysePlatforms();
            return this.installedSpecificationFolders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> installedImplementationFolders() {
        Object object = this.lock;
        synchronized (object) {
            this.analysePlatforms();
            return this.installedImplementationFolders;
        }
    }

    private void analysePlatforms() {
        if (!this.ready) {
            ArrayList<ExtensionSpecification.Platform> platforms = new ArrayList<ExtensionSpecification.Platform>();
            ArrayList<String> specificationFolders = new ArrayList<String>();
            ArrayList<String> implementationFolders = new ArrayList<String>();
            for (ExtensionSpecification.Platform platform : InstalledExtensions.allInstalledPlatforms()) {
                if (!platform.containsTechnology(this.platformTechnology)) continue;
                platforms.add(platform);
                if (platform.hasSpecifications()) {
                    specificationFolders.add(platform.specificationsFolder().toString());
                }
                if (platform.hasModules()) {
                    implementationFolders.add(platform.modulesFolder().toString());
                }
                if (!platform.hasLibraries()) continue;
                implementationFolders.add(platform.librariesFolder().toString());
            }
            this.installedPlatforms = Collections.unmodifiableList(platforms);
            this.installedSpecificationFolders = Collections.unmodifiableList(specificationFolders);
            this.installedImplementationFolders = Collections.unmodifiableList(implementationFolders);
            this.ready = true;
        }
    }
}

