/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.algart.executors.api.graalvm.js.core.AbstractCallJS;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.graalvm.GraalPerformer;
import net.algart.graalvm.GraalSourceContainer;
import net.algart.graalvm.JSInterpretation;

public final class CallJSExternalFunction
extends AbstractCallJS {
    private static final boolean USE_FILE_SOURCE = false;
    private final GraalSourceContainer jsFileContainer = GraalSourceContainer.newFileContainer();
    private String jsFile = "";

    public CallJSExternalFunction() {
        this.addOutputScalar("code");
    }

    public String getJsFile() {
        return this.jsFile;
    }

    public CallJSExternalFunction setJsFile(String jsFile) {
        this.jsFile = CallJSExternalFunction.nonEmptyTrimmed(jsFile);
        return this;
    }

    @Override
    protected String code(boolean jsEsmEvalReturnsExports) {
        return JSInterpretation.importJSCode(this.translateJsFile(), this.getMainFunctionName());
    }

    @Override
    protected void compileSource(boolean jsEsmEvalReturnsExports) {
        super.compileSource(jsEsmEvalReturnsExports);
    }

    @Override
    protected void executeSource(GraalPerformer performer) {
        super.executeSource(performer);
    }

    @Override
    protected String executorName() {
        return "JavaScript external function";
    }

    private Path translateJsFile() {
        return PathPropertyReplacement.translatePropertiesAndCurrentDirectory(this.jsFile, this);
    }

    public static String toJsModulePath(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException("Module file does not exist: " + String.valueOf(path));
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IOException("Not a regular file: " + String.valueOf(path));
        }
        String uri = path.toAbsolutePath().normalize().toUri().toString();
        uri = uri.replace("\\", "\\\\").replace("'", "\\'");
        return uri;
    }

    private /* synthetic */ String lambda$compileSource$0() {
        return "Changing file/settings \"" + this.jsFile + "\" detected: rebuilding performer";
    }
}

