/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.core.arrays;

import jakarta.json.JsonObject;
import java.util.Arrays;
import javax.script.ScriptEngine;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptContextContainer;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptException;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptPerformer;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;
import net.algart.json.Jsons;

public final class BlockJSModifyingNamedNumbers
extends NumbersFilter {
    public static final String IN_OUT_TAGS_1 = "tags_1";
    public static final String IN_OUT_TAGS_2 = "tags_2";
    public static final String INPUT_COLUMN_NAMES = "column_names";
    public static final String INPUT_JSON_1 = "o1";
    public static final String INPUT_JSON_2 = "o2";
    public static final String INPUT_JSON_3 = "o3";
    public static final String INPUT_A = "a";
    public static final String INPUT_B = "b";
    public static final String INPUT_C = "c";
    public static final String JSON_1_VARIABLE_ALT = "o";
    private String initializingOperator = "";
    private String mainOperator = "x0 = x1 * p";
    private boolean useColumnNames = true;
    private boolean useK = false;
    private String tags1Name = "tag";
    private String tags2Name = "kind";
    private boolean simpleAccessToJson1 = false;
    private boolean simpleAccessToJson2 = false;
    private boolean simpleAccessToJson3 = false;
    private double p = 0.0;
    private double q = 0.0;
    private double r = 0.0;
    private double s = 0.0;
    private double t = 0.0;
    private double u = 0.0;
    private final JavaScriptContextContainer contextContainer = JavaScriptContextContainer.getInstance();
    private JavaScriptPerformer javaScriptInitializingOperator = null;
    private JavaScriptPerformer javaScriptMainOperator = null;
    private JavaScriptPerformer javaScriptCreateJson = null;

    public BlockJSModifyingNamedNumbers() {
        this.addInputNumbers(IN_OUT_TAGS_1);
        this.addInputNumbers(IN_OUT_TAGS_2);
        this.addInputScalar(INPUT_COLUMN_NAMES);
        this.addInputScalar(INPUT_JSON_1);
        this.addInputScalar(INPUT_JSON_2);
        this.addInputScalar(INPUT_JSON_3);
        this.addInputNumbers(INPUT_A);
        this.addInputNumbers(INPUT_B);
        this.addInputNumbers(INPUT_C);
        this.addOutputNumbers(IN_OUT_TAGS_1);
        this.addOutputNumbers(IN_OUT_TAGS_2);
    }

    public String getInitializingOperator() {
        return this.initializingOperator;
    }

    public BlockJSModifyingNamedNumbers setInitializingOperator(String initializingOperator) {
        this.initializingOperator = BlockJSModifyingNamedNumbers.nonNull(initializingOperator).trim();
        return this;
    }

    public String getMainOperator() {
        return this.mainOperator;
    }

    public BlockJSModifyingNamedNumbers setMainOperator(String mainOperator) {
        this.mainOperator = BlockJSModifyingNamedNumbers.nonNull(mainOperator).trim();
        return this;
    }

    public boolean isUseColumnNames() {
        return this.useColumnNames;
    }

    public BlockJSModifyingNamedNumbers setUseColumnNames(boolean useColumnNames) {
        this.useColumnNames = useColumnNames;
        return this;
    }

    public boolean isUseK() {
        return this.useK;
    }

    public BlockJSModifyingNamedNumbers setUseK(boolean useK) {
        this.useK = useK;
        return this;
    }

    public String getTags1Name() {
        return this.tags1Name;
    }

    public BlockJSModifyingNamedNumbers setTags1Name(String tags1Name) {
        this.tags1Name = BlockJSModifyingNamedNumbers.nonEmpty(tags1Name);
        return this;
    }

    public String getTags2Name() {
        return this.tags2Name;
    }

    public BlockJSModifyingNamedNumbers setTags2Name(String tags2Name) {
        this.tags2Name = BlockJSModifyingNamedNumbers.nonEmpty(tags2Name);
        return this;
    }

    public boolean isSimpleAccessToJson1() {
        return this.simpleAccessToJson1;
    }

    public BlockJSModifyingNamedNumbers setSimpleAccessToJson1(boolean simpleAccessToJson1) {
        this.simpleAccessToJson1 = simpleAccessToJson1;
        return this;
    }

    public boolean isSimpleAccessToJson2() {
        return this.simpleAccessToJson2;
    }

    public BlockJSModifyingNamedNumbers setSimpleAccessToJson2(boolean simpleAccessToJson2) {
        this.simpleAccessToJson2 = simpleAccessToJson2;
        return this;
    }

    public boolean isSimpleAccessToJson3() {
        return this.simpleAccessToJson3;
    }

    public BlockJSModifyingNamedNumbers setSimpleAccessToJson3(boolean simpleAccessToJson3) {
        this.simpleAccessToJson3 = simpleAccessToJson3;
        return this;
    }

    public double getP() {
        return this.p;
    }

    public BlockJSModifyingNamedNumbers setP(double p) {
        this.p = p;
        return this;
    }

    public double getQ() {
        return this.q;
    }

    public BlockJSModifyingNamedNumbers setQ(double q) {
        this.q = q;
        return this;
    }

    public double getR() {
        return this.r;
    }

    public BlockJSModifyingNamedNumbers setR(double r) {
        this.r = r;
        return this;
    }

    public double getS() {
        return this.s;
    }

    public BlockJSModifyingNamedNumbers setS(double s) {
        this.s = s;
        return this;
    }

    public double getT() {
        return this.t;
    }

    public BlockJSModifyingNamedNumbers setT(double t) {
        this.t = t;
        return this;
    }

    public double getU() {
        return this.u;
    }

    public BlockJSModifyingNamedNumbers setU(double u) {
        this.u = u;
        return this;
    }

    @Override
    public void initialize() {
        ScriptEngine context = this.contextContainer.getLocalContext();
        String initializingOperator = this.buildInitializingOperator();
        this.javaScriptInitializingOperator = BlockJSModifyingNamedNumbers.getScript(initializingOperator, this.javaScriptInitializingOperator, context);
        this.putAllInputs(context, true);
        this.javaScriptInitializingOperator.perform();
    }

    @Override
    public SNumbers processNumbers(SNumbers source) {
        SNumbers tags1 = this.getInputNumbers(IN_OUT_TAGS_1, true);
        SNumbers tags2 = this.getInputNumbers(IN_OUT_TAGS_2, true);
        SNumbers result = this.processNumbers(source, tags1, tags2);
        this.getNumbers(IN_OUT_TAGS_1).exchange(tags1);
        this.getNumbers(IN_OUT_TAGS_2).exchange(tags2);
        return result;
    }

    public SNumbers processNumbers(SNumbers source, SNumbers tags1Numbers, SNumbers tags2Numbers) {
        boolean useTags2;
        boolean useTags1 = tags1Numbers != null && tags1Numbers.isInitialized();
        boolean bl = useTags2 = tags2Numbers != null && tags2Numbers.isInitialized();
        if (useTags1 && source.n() != tags1Numbers.n()) {
            throw new IllegalArgumentException("Different lengths of source array and 1st tags array: " + source.n() + " != " + tags1Numbers.n());
        }
        if (useTags2 && source.n() != tags2Numbers.n()) {
            throw new IllegalArgumentException("Different lengths of source array and 2nd tags array: " + source.n() + " != " + tags2Numbers.n());
        }
        ScriptEngine context = this.contextContainer.getLocalContext();
        this.putAllInputs(context, false);
        double[] x = BlockJSModifyingNamedNumbers.createDoubleBlock(source);
        Object tags1 = BlockJSModifyingNamedNumbers.createCompatibleBlock(tags1Numbers);
        Object tags2 = BlockJSModifyingNamedNumbers.createCompatibleBlock(tags2Numbers);
        String[] columnNames = this.getColumnNames(x.length);
        String mainOperator = this.buildMainOperator(columnNames, useTags1, useTags2);
        this.javaScriptMainOperator = BlockJSModifyingNamedNumbers.getScript(mainOperator, this.javaScriptMainOperator, context);
        this.javaScriptMainOperator.putVariable("x", x);
        if (useTags1) {
            this.javaScriptMainOperator.putVariable("tags1", tags1);
        }
        if (useTags2) {
            this.javaScriptMainOperator.putVariable("tags2", tags2);
        }
        this.javaScriptMainOperator.putVariable("x", x);
        int n = source.n();
        for (int k = 0; k < n; ++k) {
            if (this.useK) {
                this.javaScriptMainOperator.putVariable("k", k);
            }
            BlockJSModifyingNamedNumbers.readDoubleBlock(x, source, k);
            if (useTags1) {
                BlockJSModifyingNamedNumbers.readCompatibleBlock(tags1, tags1Numbers, k);
            }
            if (useTags2) {
                BlockJSModifyingNamedNumbers.readCompatibleBlock(tags2, tags2Numbers, k);
            }
            this.javaScriptMainOperator.perform();
            BlockJSModifyingNamedNumbers.writeDoubleBlock(x, source, k);
            if (useTags1) {
                BlockJSModifyingNamedNumbers.writeCompatibleBlock(tags1, tags1Numbers, k);
            }
            if (!useTags2) continue;
            BlockJSModifyingNamedNumbers.writeCompatibleBlock(tags2, tags2Numbers, k);
        }
        return source;
    }

    @Override
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return super.visibleResultsInformation().addPorts(this.getInputPort(INPUT_COLUMN_NAMES));
    }

    private String[] getColumnNames(int blockLength) {
        String[] columnNames = this.getInputScalar(INPUT_COLUMN_NAMES, true).toTrimmedLinesWithoutCommentsArray();
        String[] result = columnNames == null ? new String[blockLength] : Arrays.copyOf(columnNames, blockLength);
        for (int i = 0; i < result.length; ++i) {
            if (result[i] != null) continue;
            result[i] = "x" + i;
        }
        return result;
    }

    private void putAllInputs(ScriptEngine context, boolean alsoUninitialized) {
        this.putInputNumbers(context, INPUT_A, alsoUninitialized);
        this.putInputNumbers(context, INPUT_B, alsoUninitialized);
        this.putInputNumbers(context, INPUT_C, alsoUninitialized);
        this.putInputJson(context, INPUT_JSON_1, JSON_1_VARIABLE_ALT, alsoUninitialized);
        this.putInputJson(context, INPUT_JSON_2, null, alsoUninitialized);
        this.putInputJson(context, INPUT_JSON_3, null, alsoUninitialized);
        context.put("p", this.p);
        context.put("q", this.q);
        context.put("r", this.r);
        context.put("s", this.s);
        context.put("t", this.t);
        context.put("u", this.u);
    }

    private void putInputJson(ScriptEngine context, String inputPortName, String altName, boolean alsoUninitialized) {
        this.javaScriptCreateJson = BlockJSModifyingNamedNumbers.getScript("JSON.parse(jsonString)", this.javaScriptCreateJson, context);
        SScalar scalar = this.getInputScalar(inputPortName, true);
        if (alsoUninitialized || scalar.isInitialized()) {
            Object value;
            context.put("jsonString", scalar.getValue());
            try {
                value = this.javaScriptCreateJson.perform();
            }
            catch (JavaScriptException e) {
                throw new AssertionError("Should not occur!", e);
            }
            context.put(inputPortName, value);
            if (altName != null) {
                context.put(altName, value);
            }
        }
    }

    private void putInputNumbers(ScriptEngine context, String inputPortName, boolean alsoUninitialized) {
        SNumbers numbers = this.getInputNumbers(inputPortName, true);
        double[] value = numbers.toDoubleArray();
        if (alsoUninitialized || value != null) {
            context.put(inputPortName, value);
        }
    }

    private String buildInitializingOperator() {
        JsonObject json1 = Jsons.toJson(this.getInputScalar(INPUT_JSON_1, true).getValue(), true);
        JsonObject json2 = Jsons.toJson(this.getInputScalar(INPUT_JSON_2, true).getValue(), true);
        JsonObject json3 = Jsons.toJson(this.getInputScalar(INPUT_JSON_3, true).getValue(), true);
        StringBuilder sb = new StringBuilder();
        if (this.simpleAccessToJson1) {
            BlockJSModifyingNamedNumbers.addJsonToVariables(sb, json1, INPUT_JSON_1);
        }
        if (this.simpleAccessToJson2) {
            BlockJSModifyingNamedNumbers.addJsonToVariables(sb, json2, INPUT_JSON_2);
        }
        if (this.simpleAccessToJson3) {
            BlockJSModifyingNamedNumbers.addJsonToVariables(sb, json3, INPUT_JSON_3);
        }
        sb.append(this.initializingOperator + "\n");
        return sb.toString();
    }

    private String buildMainOperator(String[] names, boolean useTags1, boolean useTags2) {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.useColumnNames) {
            for (i = 0; i < names.length; ++i) {
                sb.append("var " + names[i] + " = x[" + i + "];\n");
            }
        }
        if (useTags1) {
            sb.append("var " + this.tags1Name + " = tags1[0];\n");
        }
        if (useTags2) {
            sb.append("var " + this.tags2Name + " = tags2[0];\n");
        }
        sb.append(this.mainOperator + "\n");
        if (this.useColumnNames) {
            for (i = 0; i < names.length; ++i) {
                sb.append("x[" + i + "] = " + names[i] + ";\n");
            }
        }
        if (useTags1) {
            sb.append("tags1[0] = " + this.tags1Name + ";\n");
        }
        if (useTags2) {
            sb.append("tags2[0] = " + this.tags2Name + ";\n");
        }
        return sb.toString();
    }

    private static void addJsonToVariables(StringBuilder sb, JsonObject json, String jsonName) {
        for (String key : json.keySet()) {
            sb.append("var " + key + " = " + jsonName + "." + key + ";\n");
        }
    }

    private static double[] createDoubleBlock(SNumbers numbers) {
        return new double[numbers != null && numbers.isInitialized() ? numbers.getBlockLength() : 0];
    }

    private static Object createCompatibleBlock(SNumbers numbers) {
        return numbers != null && numbers.isInitialized() ? numbers.newCompatibleJavaArray(numbers.getArrayLength()) : null;
    }

    private static void readDoubleBlock(double[] block, SNumbers numbers, int k) {
        if (block.length > 0) {
            numbers.getBlockDoubleValues(k, block);
        }
    }

    private static void writeDoubleBlock(double[] block, SNumbers numbers, int k) {
        if (block.length > 0) {
            numbers.setBlockDoubleValues(k, block);
        }
    }

    private static void readCompatibleBlock(Object block, SNumbers numbers, int k) {
        numbers.getBlockValues(k, block);
    }

    private static void writeCompatibleBlock(Object block, SNumbers numbers, int k) {
        numbers.setBlockValues(k, block);
    }

    private static JavaScriptPerformer getScript(String formula, JavaScriptPerformer previous, ScriptEngine context) {
        return JavaScriptPerformer.newInstanceIfChanged(formula, previous, context);
    }
}

