/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.jep;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Objects;
import jep.DirectNDArray;
import jep.NDArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.api.data.SMat;

public class Jep2SMat {
    private Jep2SMat() {
    }

    public static DirectNDArray<Buffer> toNDArray(SMat matrix) {
        Objects.requireNonNull(matrix, "Null matrix");
        if (!matrix.isInitialized()) {
            throw new IllegalArgumentException("Not initialized matrix");
        }
        if (!matrix.getDepth().isOpenCVCompatible()) {
            throw new IllegalArgumentException("Matrix element type is not supported: " + String.valueOf(matrix));
        }
        int dimCount = matrix.getDimCount();
        int[] ndDimensions = new int[dimCount + 1];
        for (int k = 0; k < dimCount; ++k) {
            long dim = matrix.getDim(dimCount - 1 - k);
            if (dim > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Too large matrix: dimension #" + (dimCount - 1 - k) + " >= 2^31");
            }
            ndDimensions[k] = (int)dim;
        }
        ndDimensions[dimCount] = matrix.getNumberOfChannels();
        SMat.Depth depth = matrix.getDepth();
        ByteBuffer byteBuffer = SMat.cloneByteBuffer(matrix.getByteBuffer());
        return new DirectNDArray(depth.asBuffer(byteBuffer), depth.isUnsigned(), ndDimensions);
    }

    public static SMat toSMat(Object ndArray) {
        return Jep2SMat.setToArray(new SMat(), ndArray);
    }

    public static SMat setToArray(SMat result, Object array) {
        Objects.requireNonNull(array, "Null array");
        if (array instanceof NDArray) {
            return Jep2SMat.setTo(result, (NDArray)array);
        }
        if (array instanceof DirectNDArray) {
            return Jep2SMat.setTo(result, (DirectNDArray)array);
        }
        throw new UnsupportedOperationException("Unsupported type of array: " + array.getClass().getCanonicalName() + " (NDArray/DirectNDArray expected)");
    }

    public static SMat setTo(SMat result, DirectNDArray<?> ndArray) {
        Objects.requireNonNull(result, "Null result");
        Objects.requireNonNull(ndArray, "Null ndArray");
        Jep2SMat.setTo(result, (Buffer)ndArray.getData(), ndArray.isUnsigned(), ndArray.getDimensions());
        return result;
    }

    public static SMat setTo(SMat result, NDArray<?> ndArray) {
        Buffer buffer;
        Objects.requireNonNull(result, "Null result");
        Objects.requireNonNull(ndArray, "Null ndArray");
        Object data = ndArray.getData();
        if (data instanceof byte[]) {
            buffer = ByteBuffer.wrap((byte[])data);
        } else if (data instanceof short[]) {
            buffer = ShortBuffer.wrap((short[])data);
        } else if (data instanceof int[]) {
            buffer = IntBuffer.wrap((int[])data);
        } else if (data instanceof long[]) {
            buffer = LongBuffer.wrap((long[])data);
        } else if (data instanceof float[]) {
            buffer = FloatBuffer.wrap((float[])data);
        } else if (data instanceof double[]) {
            buffer = DoubleBuffer.wrap((double[])data);
        } else {
            throw new IllegalArgumentException("Unsupported type of NDArray data: " + data.getClass().getSimpleName());
        }
        Jep2SMat.setTo(result, buffer, ndArray.isUnsigned(), ndArray.getDimensions());
        return result;
    }

    private static void setTo(SMat result, Buffer buffer, boolean unsigned, int[] ndDimensions) {
        long[] dimensions;
        int numberOfChannels;
        SMat.Depth depth;
        if (buffer instanceof ByteBuffer) {
            depth = unsigned ? SMat.Depth.U8 : SMat.Depth.S8;
        } else if (buffer instanceof ShortBuffer) {
            depth = unsigned ? SMat.Depth.U16 : SMat.Depth.S16;
        } else if (buffer instanceof IntBuffer) {
            depth = SMat.Depth.S32;
        } else if (buffer instanceof FloatBuffer) {
            depth = SMat.Depth.F32;
        } else if (buffer instanceof DoubleBuffer) {
            depth = SMat.Depth.F64;
        } else {
            throw new IllegalArgumentException("Unsupported element type of NDArray data: buffer " + buffer.getClass().getSimpleName());
        }
        if (ndDimensions.length == 2 || ndDimensions.length == 3 && ndDimensions[2] == 1) {
            numberOfChannels = 1;
            dimensions = new long[2];
        } else if (ndDimensions.length == 3 && ndDimensions[2] <= 4) {
            numberOfChannels = ndDimensions[2];
            dimensions = new long[2];
        } else {
            numberOfChannels = 1;
            dimensions = new long[ndDimensions.length];
        }
        int bytesPerElement = depth.bitsPerElement() / 8;
        long maxSize = Integer.MAX_VALUE / bytesPerElement;
        long size = numberOfChannels;
        for (int k = 0; k < dimensions.length; ++k) {
            int dim = ndDimensions[dimensions.length - 1 - k];
            if ((size *= (long)dim) > maxSize) {
                throw new TooLargeArrayException("Too large matrix: > " + maxSize + " " + depth.elementType().getSimpleName() + " elements");
            }
            dimensions[k] = dim;
        }
        ByteBuffer resultBuffer = ByteBuffer.allocateDirect((int)(size * (long)bytesPerElement));
        resultBuffer.order(ByteOrder.nativeOrder());
        resultBuffer.rewind();
        buffer = buffer.duplicate();
        buffer.rewind();
        if (buffer instanceof ByteBuffer) {
            resultBuffer.put((ByteBuffer)buffer);
        } else if (buffer instanceof ShortBuffer) {
            resultBuffer.asShortBuffer().put((ShortBuffer)buffer);
        } else if (buffer instanceof IntBuffer) {
            resultBuffer.asIntBuffer().put((IntBuffer)buffer);
        } else if (buffer instanceof FloatBuffer) {
            resultBuffer.asFloatBuffer().put((FloatBuffer)buffer);
        } else if (buffer instanceof DoubleBuffer) {
            resultBuffer.asDoubleBuffer().put((DoubleBuffer)buffer);
        } else {
            throw new AssertionError((Object)"Was already checked little above!");
        }
        result.setAll(dimensions, depth, numberOfChannels, resultBuffer, false);
    }
}

