/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.parameters;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.algart.executors.api.parameters.NoValidParameterException;
import net.algart.external.UsedForExternalCommunication;
import net.algart.json.Jsons;

public class Parameters
implements Map<String, Object> {
    private final Map<String, Object> map = Collections.synchronizedMap(new LinkedHashMap());

    public Parameters() {
    }

    public Parameters(Map<String, Object> m) {
        this.map.putAll(m);
    }

    public boolean getBoolean(String name) throws NoValidParameterException {
        Object o = this.getAndCheckNull(name, "boolean");
        String s = o.toString();
        Boolean result = Parameters.smartParseBoolean(s);
        if (result != null) {
            return result;
        }
        throw new NoValidParameterException("Parameter \"" + name + "\" is not a boolean: \"" + s + "\"");
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        Object o = this.get(name);
        if (o == null) {
            return defaultValue;
        }
        String s = o.toString();
        Boolean result = Parameters.smartParseBoolean(s);
        return result != null ? result : defaultValue;
    }

    @UsedForExternalCommunication
    public Parameters setBoolean(String name, boolean value) {
        Objects.requireNonNull(name, "Null parameter name");
        this.put(name, (Object)value);
        return this;
    }

    public Parameters setBoolean(String name, String value) {
        Objects.requireNonNull(name, "Null parameter name");
        if (value == null) {
            throw new IllegalArgumentException("Cannot set boolean parameter \"" + name + "\" to null value");
        }
        Boolean booleanValue = Parameters.smartParseBoolean(value);
        if (booleanValue == null) {
            throw new NoValidParameterException("Cannot set boolean parameter \"" + name + "\" to non-boolean value \"" + value + "\"");
        }
        this.setBoolean(name, booleanValue);
        return this;
    }

    public int getInteger(String name) throws NoValidParameterException {
        Object o = this.getAndCheckNull(name, "integer");
        if (o instanceof Integer) {
            return (Integer)o;
        }
        String s = o.toString();
        try {
            return Parameters.smartParseInt(s);
        }
        catch (NumberFormatException e) {
            throw new NoValidParameterException("Parameter \"" + name + "\" is not a valid integer value: \"" + s + "\"");
        }
    }

    public int getInteger(String name, int defaultValue) {
        Object o = this.get(name);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        String s = o.toString();
        try {
            return Parameters.smartParseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @UsedForExternalCommunication
    public Parameters setInteger(String name, int value) {
        Objects.requireNonNull(name, "Null parameter name");
        this.put(name, (Object)value);
        return this;
    }

    public Parameters setInteger(String name, String value) {
        Objects.requireNonNull(name, "Null parameter name");
        if (value == null) {
            throw new IllegalArgumentException("Cannot set int parameter \"" + name + "\" to null value");
        }
        try {
            int integerValue = Parameters.smartParseInt(value);
            this.setInteger(name, integerValue);
        }
        catch (NumberFormatException e) {
            throw new NoValidParameterException("Cannot set int parameter \"" + name + "\" to non-integer value \"" + value + "\"");
        }
        return this;
    }

    public long getLong(String name) throws NoValidParameterException {
        Object o = this.getAndCheckNull(name, "long integer");
        if (o instanceof Long) {
            return (Long)o;
        }
        String s = o.toString();
        try {
            return Parameters.smartParseLong(s);
        }
        catch (NumberFormatException e) {
            throw new NoValidParameterException("Parameter \"" + name + "\" is not a valid long integer value: \"" + s + "\"");
        }
    }

    public long getLong(String name, long defaultValue) {
        Object o = this.get(name);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        String s = o.toString();
        try {
            return Parameters.smartParseLong(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @UsedForExternalCommunication
    public Parameters setLong(String name, long value) {
        Objects.requireNonNull(name, "Null parameter name");
        this.put(name, (Object)value);
        return this;
    }

    public Parameters setLong(String name, String value) {
        Objects.requireNonNull(name, "Null parameter name");
        if (value == null) {
            throw new IllegalArgumentException("Cannot set long parameter \"" + name + "\" to null value");
        }
        try {
            long longValue = Parameters.smartParseLong(value);
            this.setLong(name, longValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot set long parameter \"" + name + "\" to non-long value \"" + value + "\"");
        }
        return this;
    }

    public double getDouble(String name) throws NoValidParameterException {
        Object o = this.getAndCheckNull(name, "double");
        if (o instanceof Double) {
            return (Double)o;
        }
        String s = o.toString();
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new NoValidParameterException("Parameter \"" + name + "\" is not a valid double value: \"" + s + "\"");
        }
    }

    public double getDouble(String name, double defaultValue) {
        Object o = this.get(name);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        String s = o.toString();
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @UsedForExternalCommunication
    public Parameters setDouble(String name, double value) {
        Objects.requireNonNull(name, "Null parameter name");
        this.put(name, (Object)value);
        return this;
    }

    public Parameters setDouble(String name, String value) {
        Objects.requireNonNull(name, "Null parameter name");
        if (value == null) {
            throw new IllegalArgumentException("Cannot set double parameter \"" + name + "\" to null value");
        }
        try {
            double doubleValue = Double.parseDouble(value);
            this.setDouble(name, doubleValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot set double parameter \"" + name + "\" to non-double value \"" + value + "\"");
        }
        return this;
    }

    public String getString(String name) throws NoValidParameterException {
        Object o = this.getAndCheckNull(name, "string");
        return o.toString();
    }

    public String getString(String name, String defaultValue) {
        Object o = this.get(name);
        if (o == null) {
            return defaultValue;
        }
        return o.toString();
    }

    @UsedForExternalCommunication
    public Parameters setString(String name, String value) {
        Objects.requireNonNull(name, "Null parameter name");
        this.put(name, (Object)value);
        return this;
    }

    public Parameters set(String name, Object value) {
        this.put(name, value);
        return this;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameters that = (Parameters)o;
        return Objects.equals(this.map, that.map);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.map);
    }

    public JsonValue getJsonValue(String name) {
        return Parameters.smartParseValue(this.get(name));
    }

    public JsonObject toJson() {
        return Parameters.toJson(this);
    }

    private Object getAndCheckNull(String name, String typeTitle) {
        Object result = this.get(name);
        if (result == null) {
            if (!this.containsKey(name)) {
                throw new NoValidParameterException("No required " + typeTitle + " parameter \"" + name + "\"");
            }
            throw new NoValidParameterException("Parameter \"" + name + "\" is null, it is not a valid " + typeTitle + " value");
        }
        return result;
    }

    public static JsonObject toJson(Map<String, Object> parameters) {
        Objects.requireNonNull(parameters, "Null parameters");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            builder.add(entry.getKey(), Parameters.smartParseValue(entry.getValue()));
        }
        return builder.build();
    }

    public static JsonValue smartParseValue(Object o) {
        if (o == null) {
            return JsonValue.NULL;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (o instanceof Float || o instanceof Double) {
            return Jsons.toJsonDoubleValue(((Number)o).doubleValue());
        }
        if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long) {
            return Jsons.toJsonLongValue(((Number)o).longValue());
        }
        return Jsons.toJsonStringValue(o.toString());
    }

    public static Boolean smartParseBoolean(String s) {
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static long smartParseLong(String s) throws NumberFormatException {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            NumberFormatException exception = e;
            double value = Double.parseDouble(s);
            long result = (long)value;
            if ((double)result == value) {
                return result;
            }
            throw exception;
        }
    }

    public static int smartParseInt(String s) throws NumberFormatException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            NumberFormatException exception = e;
            double value = Double.parseDouble(s);
            int result = (int)value;
            if ((double)result == value) {
                return result;
            }
            throw exception;
        }
    }
}

