/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.python;

import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.jep.additions.JepType;
import net.algart.json.AbstractConvertibleToJson;
import net.algart.json.Jsons;

public class PythonSpecification
extends ExecutorSpecification {
    private Python python = null;

    public PythonSpecification() {
    }

    protected PythonSpecification(JsonObject json, Path file) {
        super(json, file);
        JsonObject pythonJson = json.getJsonObject("python");
        if (this.isPythonExecutor() && pythonJson == null) {
            throw new JsonException("Invalid executor configuration JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"python\" section required when \"language\" is \"python\"");
        }
        this.python = pythonJson == null ? null : new Python(pythonJson, file);
    }

    public static PythonSpecification read(Path specificationFile) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        JsonObject json = Jsons.readJson(specificationFile);
        return new PythonSpecification(json, specificationFile);
    }

    public static PythonSpecification readIfValid(Path specificationFile) {
        JsonObject json;
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        try {
            json = Jsons.readJson(specificationFile);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        if (!PythonSpecification.isExecutorSpecification(json)) {
            return null;
        }
        return new PythonSpecification(json, specificationFile);
    }

    public static List<PythonSpecification> readAllIfValid(Path containingJsonPath) throws IOException {
        return PythonSpecification.readAllIfValid(null, containingJsonPath);
    }

    public static List<PythonSpecification> readAllIfValid(List<PythonSpecification> result, Path containingJsonPath) throws IOException {
        return ExecutorSpecification.readAllJsonIfValid(result, containingJsonPath, PythonSpecification::readIfValid);
    }

    public static PythonSpecification of(JsonObject specificationJson) {
        return new PythonSpecification(specificationJson, null);
    }

    public static PythonSpecification of(String specificationString) {
        Objects.requireNonNull(specificationString, "Null specificationString");
        JsonObject executorSpecification = Jsons.toJson(specificationString);
        return new PythonSpecification(executorSpecification, null);
    }

    public static PythonSpecification ofIfValid(String specificationString) {
        Objects.requireNonNull(specificationString, "Null specificationString");
        JsonObject json = Jsons.toJson(specificationString);
        if (!PythonSpecification.isExecutorSpecification(json)) {
            return null;
        }
        return new PythonSpecification(json, null);
    }

    public final boolean isPythonExecutor() {
        return "python".equals(this.getLanguage());
    }

    public Python getPython() {
        return this.python;
    }

    public PythonSpecification setPython(Python python) {
        this.python = python;
        return this;
    }

    @Override
    public void checkCompleteness() {
        super.checkCompleteness();
        if (this.isPythonExecutor()) {
            this.checkNull(this.python, "python");
        }
    }

    @Override
    public String toString() {
        return "PythonSpecification{python=" + String.valueOf(this.python) + "}, extending " + super.toString();
    }

    @Override
    protected void buildLanguageJson(JsonObjectBuilder builder) {
        if (this.python != null) {
            builder.add("python", (JsonValue)this.python.toJson());
        }
        super.buildLanguageJson(builder);
    }

    public static final class Python
    extends AbstractConvertibleToJson {
        public static final String DEFAULT_FUNCTION = "execute";
        private String module;
        private String parametersClass = "pyalgart.api.Parameters";
        private String inputsClass = "pyalgart.api.Inputs";
        private String outputsClass = "pyalgart.api.Outputs";
        private String className = null;
        private String function = "execute";
        private JepType jepType = JepType.NORMAL;

        public Python() {
        }

        private Python(JsonObject json, Path file) {
            this.module = Jsons.reqString(json, "module", file);
            this.parametersClass = json.getString("parameters_class", this.parametersClass);
            this.inputsClass = json.getString("inputs_class", this.inputsClass);
            this.outputsClass = json.getString("outputs_class", this.outputsClass);
            this.className = json.getString("class", null);
            this.function = json.getString("function", this.function);
            String jepType = json.getString("jepType", JepType.NORMAL.typeName());
            this.jepType = JepType.ofOrNull(jepType);
            Jsons.requireNonNull(this.jepType, json, "jepType", "unknown (\"" + jepType + "\")", file);
        }

        public String getModule() {
            return this.module;
        }

        public Python setModule(String module) {
            this.module = Python.nonEmpty(module);
            return this;
        }

        public String getParametersClass() {
            return this.parametersClass;
        }

        public Python setParametersClass(String parametersClass) {
            this.parametersClass = Python.nonEmpty(parametersClass);
            return this;
        }

        public String getInputsClass() {
            return this.inputsClass;
        }

        public Python setInputsClass(String inputsClass) {
            this.inputsClass = Python.nonEmpty(inputsClass);
            return this;
        }

        public String getOutputsClass() {
            return this.outputsClass;
        }

        public Python setOutputsClass(String outputsClass) {
            this.outputsClass = Python.nonEmpty(outputsClass);
            return this;
        }

        public String getClassName() {
            return this.className;
        }

        public Python setClassName(String className) {
            this.className = className;
            return this;
        }

        public String getFunction() {
            return this.function;
        }

        public Python setFunction(String function) {
            this.function = Python.nonEmpty(function);
            return this;
        }

        public JepType getJepType() {
            return this.jepType;
        }

        public Python setJepType(JepType jepType) {
            this.jepType = Python.nonNull(jepType);
            return this;
        }

        public boolean isClassMethod() {
            return this.className != null;
        }

        @Override
        public void checkCompleteness() {
            this.checkNull(this.module, "module");
        }

        public String toString() {
            return "Python{module='" + this.module + "', parametersClass='" + this.parametersClass + "', inputsClass='" + this.inputsClass + "', outputsClass='" + this.outputsClass + "', className='" + this.className + "', function='" + this.function + "', jepType=" + String.valueOf((Object)this.jepType) + "}";
        }

        @Override
        public void buildJson(JsonObjectBuilder builder) {
            builder.add("module", this.module);
            builder.add("parameters_class", this.parametersClass);
            builder.add("inputs_class", this.inputsClass);
            builder.add("outputs_class", this.outputsClass);
            if (this.className != null) {
                builder.add("class", this.className);
            }
            builder.add("function", this.function);
            builder.add("jepType", this.jepType.name());
        }
    }
}

