/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.python.core;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.jep.JepAPI;
import net.algart.executors.api.jep.JepPlatforms;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.jep.JepPerformer;
import net.algart.jep.JepPerformerContainer;
import net.algart.jep.additions.AtomicPyObject;
import net.algart.jep.additions.JepInterpretation;
import net.algart.jep.additions.JepType;

public abstract class AbstractCallPython
extends Executor {
    public static final String INPUT_X1 = "x1";
    public static final String INPUT_X2 = "x2";
    public static final String INPUT_X3 = "x3";
    public static final String INPUT_X4 = "x4";
    public static final String INPUT_X5 = "x5";
    public static final String INPUT_M1 = "m1";
    public static final String INPUT_M2 = "m2";
    public static final String INPUT_M3 = "m3";
    public static final String INPUT_M4 = "m4";
    public static final String INPUT_M5 = "m5";
    public static final String OUTPUT_A = "a";
    public static final String OUTPUT_B = "b";
    public static final String OUTPUT_C = "c";
    public static final String OUTPUT_D = "d";
    public static final String OUTPUT_E = "e";
    public static final String OUTPUT_F = "f";
    public static final String OUTPUT_X1 = "x1";
    public static final String OUTPUT_X2 = "x2";
    public static final String OUTPUT_X3 = "x3";
    public static final String OUTPUT_X4 = "x4";
    public static final String OUTPUT_X5 = "x5";
    public static final String OUTPUT_M1 = "m1";
    public static final String OUTPUT_M2 = "m2";
    public static final String OUTPUT_M3 = "m3";
    public static final String OUTPUT_M4 = "m4";
    public static final String OUTPUT_M5 = "m5";
    public static final String OUTPUT_CODE = "code";
    public static final String OUTPUT_SUPPLIED_PYTHON_ROOTS = "supplied_python_roots";
    private static final List<String> PARAMETERS_NAMES = List.of("a", "b", "c", "d", "e", "f", "p", "q", "r", "s", "t", "u");
    private static final List<String> INPUTS_NAMES = List.of("x1", "x2", "x3", "x4", "x5", "m1", "m2", "m3", "m4", "m5");
    private static final List<String> OUTPUTS_NAMES = List.of(DEFAULT_OUTPUT_PORT, "a", "b", "c", "d", "e", "f", "x1", "x2", "x3", "x4", "x5", "m1", "m2", "m3", "m4", "m5");
    private String mainFunctionName = "execute";
    private String workingDirectory = ".";
    private String a = "";
    private String b = "";
    private String c = "";
    private String d = "";
    private String e = "";
    private String f = "";
    private double p = 0.0;
    private double q = 0.0;
    private double r = 0.0;
    private double s = 0.0;
    private double t = 0.0;
    private double u = 0.0;
    private final JepAPI jepAPI = JepAPI.getInstance();
    private JepType jepType = JepType.NORMAL;
    final JepPerformerContainer normalContainer = JepAPI.newContainer(JepType.NORMAL);
    final JepPerformerContainer globalContainer = JepAPI.newContainer(JepType.GLOBAL);
    final JepPerformerContainer subContainer = JepAPI.newContainer(JepType.SUB_INTERPRETER);
    volatile JepPerformer performer = null;

    public AbstractCallPython() {
        this.useVisibleResultParameter();
        this.addInputNumbers("x1");
        this.addInputNumbers("x2");
        this.addInputNumbers("x3");
        this.addInputNumbers("x4");
        this.addInputNumbers("x5");
        this.addInputMat("m1");
        this.addInputMat("m2");
        this.addInputMat("m3");
        this.addInputMat("m4");
        this.addInputMat("m5");
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_A);
        this.addOutputScalar(OUTPUT_B);
        this.addOutputScalar(OUTPUT_C);
        this.addOutputScalar(OUTPUT_D);
        this.addOutputScalar(OUTPUT_E);
        this.addOutputScalar(OUTPUT_F);
        this.addOutputNumbers("x1");
        this.addOutputNumbers("x2");
        this.addOutputNumbers("x3");
        this.addOutputNumbers("x4");
        this.addOutputNumbers("x5");
        this.addOutputMat("m1");
        this.addOutputMat("m2");
        this.addOutputMat("m3");
        this.addOutputMat("m4");
        this.addOutputMat("m5");
        this.addOutputScalar(OUTPUT_SUPPLIED_PYTHON_ROOTS);
    }

    public final String getMainFunctionName() {
        return this.mainFunctionName;
    }

    public final AbstractCallPython setMainFunctionName(String mainFunctionName) {
        this.mainFunctionName = AbstractCallPython.nonEmptyTrimmed(mainFunctionName).trim();
        return this;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public AbstractCallPython setWorkingDirectory(String workingDirectory) {
        if (!(workingDirectory = AbstractCallPython.nonNull(workingDirectory).trim()).equals(this.workingDirectory)) {
            this.closePython();
            this.workingDirectory = workingDirectory;
        }
        return this;
    }

    public final String getA() {
        return this.a;
    }

    public final AbstractCallPython setA(String a) {
        this.a = a;
        return this;
    }

    public final String getB() {
        return this.b;
    }

    public final AbstractCallPython setB(String b) {
        this.b = b;
        return this;
    }

    public final String getC() {
        return this.c;
    }

    public final AbstractCallPython setC(String c) {
        this.c = c;
        return this;
    }

    public final String getD() {
        return this.d;
    }

    public final AbstractCallPython setD(String d) {
        this.d = d;
        return this;
    }

    public final String getE() {
        return this.e;
    }

    public final AbstractCallPython setE(String e) {
        this.e = e;
        return this;
    }

    public final String getF() {
        return this.f;
    }

    public final AbstractCallPython setF(String f) {
        this.f = f;
        return this;
    }

    public final double getP() {
        return this.p;
    }

    public final AbstractCallPython setP(double p) {
        this.p = p;
        return this;
    }

    public final double getQ() {
        return this.q;
    }

    public final AbstractCallPython setQ(double q) {
        this.q = q;
        return this;
    }

    public final double getR() {
        return this.r;
    }

    public final AbstractCallPython setR(double r) {
        this.r = r;
        return this;
    }

    public final double getS() {
        return this.s;
    }

    public final AbstractCallPython setS(double s) {
        this.s = s;
        return this;
    }

    public final double getT() {
        return this.t;
    }

    public final AbstractCallPython setT(double t) {
        this.t = t;
        return this;
    }

    public final double getU() {
        return this.u;
    }

    public final AbstractCallPython setU(double u) {
        this.u = u;
        return this;
    }

    public final JepType getJepType() {
        return this.jepType;
    }

    public final AbstractCallPython setJepType(JepType jepType) {
        AbstractCallPython.nonNull(jepType);
        if (jepType != this.jepType) {
            this.closePython();
            this.jepType = jepType;
        }
        return this;
    }

    @Override
    public final void initialize() {
        if (!this.isGlobalSynchronizationRequired()) {
            this.initializePython();
        }
    }

    @Override
    public final void process() {
        if (this.isGlobalSynchronizationRequired()) {
            JepInterpretation.executeWithJVMGlobalLock(this::initializePython, this::executePython, this::closePython);
        } else {
            this.executePython();
        }
    }

    @Override
    public final void close() {
        this.closePython();
        super.close();
    }

    protected abstract String code();

    protected Object callFunction(AtomicPyObject pythonParameters, AtomicPyObject pythonInputs, AtomicPyObject pythonOutputs) {
        return this.performer.invokeFunction(this.mainFunctionName, pythonParameters.pyObject(), pythonInputs.pyObject(), pythonOutputs.pyObject());
    }

    protected abstract String executorName();

    private boolean isGlobalSynchronizationRequired() {
        return this.jepType.isJVMGlobal();
    }

    private void initializePython() {
        long t1 = AbstractCallPython.debugTime();
        this.performer = this.container().performer();
        long t2 = AbstractCallPython.debugTime();
        String code = this.code();
        if (!code.isEmpty()) {
            this.jepAPI.initializedGlobalEnvironment(this.performer, this, this.translateWorkingDirectory());
            this.performer.perform(code);
        }
        long t3 = AbstractCallPython.debugTime();
        this.setOutputScalar(OUTPUT_CODE, code);
        this.setOutputScalar(OUTPUT_SUPPLIED_PYTHON_ROOTS, () -> String.join((CharSequence)String.format("%n", new Object[0]), JepPlatforms.pythonRootFolders()));
        AbstractCallPython.logDebug(() -> String.format(Locale.US, "%s (%s) initialized in %.3f ms: %.6f ms getting context + %.6f ms initializing code", new Object[]{this.executorName(), this.jepType, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6}));
    }

    private void executePython() {
        long t4;
        long t3;
        long t2;
        long t1 = AbstractCallPython.debugTime();
        if (this.performer == null) {
            throw new IllegalStateException(String.valueOf(this.getClass()) + " is not initialized");
        }
        try (AtomicPyObject pythonParameters = this.jepAPI.newAPIObject(this.performer, "pyalgart.api.Parameters");
             AtomicPyObject pythonInputs = this.jepAPI.newAPIObject(this.performer, "pyalgart.api.Inputs");
             AtomicPyObject pythonOutputs = this.jepAPI.newAPIObject(this.performer, "pyalgart.api.Outputs");){
            this.jepAPI.loadSystemParameters(this, pythonParameters, this.translateWorkingDirectory());
            this.jepAPI.loadParameters(AbstractCallPython.subMap(this.parameters(), PARAMETERS_NAMES), pythonParameters);
            this.jepAPI.readInputPorts(this.performer, AbstractCallPython.subSet(this.inputPorts(), INPUTS_NAMES), pythonInputs);
            t2 = AbstractCallPython.debugTime();
            Object result = this.callFunction(pythonParameters, pythonInputs, pythonOutputs);
            t3 = AbstractCallPython.debugTime();
            this.jepAPI.writeOutputPorts(this.performer, AbstractCallPython.subSet(this.outputPorts(), OUTPUTS_NAMES), pythonOutputs);
            this.jepAPI.writeOutputPort(this.performer, this.getOutputPort(DEFAULT_OUTPUT_PORT), result, true);
            t4 = AbstractCallPython.debugTime();
        }
        AbstractCallPython.logDebug(() -> String.format(Locale.US, "%s \"%s\" (%s) executed in %.3f ms: %.6f ms loading inputs + %.6f ms calling + %.6f ms returning outputs", new Object[]{this.executorName(), this.mainFunctionName, this.jepType, (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6}));
    }

    private void closePython() {
        this.globalContainer.close();
        this.normalContainer.close();
        this.subContainer.close();
    }

    private JepPerformerContainer container() {
        return switch (this.jepType) {
            default -> throw new MatchException(null, null);
            case JepType.SUB_INTERPRETER -> this.subContainer;
            case JepType.NORMAL -> this.normalContainer;
            case JepType.GLOBAL -> this.globalContainer;
        };
    }

    private Path translateWorkingDirectory() {
        return PathPropertyReplacement.translatePropertiesAndCurrentDirectory(this.workingDirectory, this);
    }

    private static <K, V> Map<K, V> subMap(Map<K, V> map, Collection<K> requestedKeys) {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (K key : requestedKeys) {
            V value = map.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    private static Collection<Port> subSet(Collection<Port> ports, Collection<String> requested) {
        return AbstractCallPython.subMap(ports.stream().collect(Collectors.toMap(Port::getName, p1 -> p1)), requested).values();
    }
}

