/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.settings;

import jakarta.json.JsonObject;
import net.algart.json.Jsons;

public enum SubSettingsInheritanceMode {
    NONE{

        @Override
        public JsonObject inherit(JsonObject parentSettings, JsonObject subSettings) {
            return subSettings;
        }
    }
    ,
    ADD_NEW_TO_PARENT{

        @Override
        public JsonObject inherit(JsonObject parentSettings, JsonObject subSettings) {
            return Jsons.addNonExistingEntries(Jsons.extractSimpleValues(parentSettings), subSettings);
        }
    }
    ,
    OVERRIDE_PARENT{

        @Override
        public JsonObject inherit(JsonObject parentSettings, JsonObject subSettings) {
            return Jsons.overrideEntries(Jsons.extractSimpleValues(parentSettings), subSettings);
        }
    }
    ,
    OVERRIDE_BY_EXISTING_IN_PARENT{

        @Override
        public JsonObject inherit(JsonObject parentSettings, JsonObject subSettings) {
            return Jsons.overrideOnlyExistingInBoth(subSettings, Jsons.extractSimpleValues(parentSettings));
        }
    };


    public abstract JsonObject inherit(JsonObject var1, JsonObject var2);
}

