/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.algart.executors.api.parameters.ParameterValueType;

public enum ControlEditionType {
    VALUE("value", false),
    ENUM("enum", false),
    FILE("file", true),
    FILE_TO_SAVE("file_to_save", true),
    FOLDER("folder", true),
    COLOR("color", false),
    RANGE("range", false);

    private final String editionTypeName;
    private final boolean resources;
    private static final Map<String, ControlEditionType> ALL_TYPES;

    private ControlEditionType(String editionTypeName, boolean resources) {
        this.editionTypeName = editionTypeName;
        this.resources = resources;
    }

    public String editionTypeName() {
        return this.editionTypeName;
    }

    public boolean isResources() {
        return this.resources;
    }

    public boolean isPath() {
        return this.isResources();
    }

    public boolean isEnum() {
        return this == ENUM;
    }

    public static ControlEditionType of(String name) {
        ControlEditionType result = ALL_TYPES.get(name);
        if (result == null) {
            throw new IllegalArgumentException("Unknown control edition type: " + name);
        }
        return result;
    }

    public static ControlEditionType ofOrNull(String name) {
        return ALL_TYPES.get(name);
    }

    public static ControlEditionType defaultEditionType(ParameterValueType valueType) {
        Objects.requireNonNull(valueType, "Null valueType");
        return valueType == ParameterValueType.ENUM_STRING ? ENUM : VALUE;
    }

    public static void main(String[] args) {
        for (ControlEditionType type : ControlEditionType.values()) {
            System.out.printf("%s: %s%n", new Object[]{type.editionTypeName(), ControlEditionType.of(type.editionTypeName())});
        }
    }

    static {
        ALL_TYPES = new LinkedHashMap<String, ControlEditionType>();
        for (ControlEditionType type : ControlEditionType.values()) {
            ALL_TYPES.put(type.editionTypeName, type);
        }
    }
}

