/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import jakarta.json.JsonException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationSet;

public abstract class ExecutorLoader {
    private static final boolean REGISTER_BUILT_IN_EXECUTORS = true;
    private static final System.Logger LOG = System.getLogger(ExecutorLoader.class.getName());
    private final Map<String, Map<String, String>> allSpecifications = new LinkedHashMap<String, Map<String, String>>();
    private final Map<String, Executable> newInstanceMakers = new HashMap<String, Executable>();
    private final String name;

    public ExecutorLoader(String name) {
        this.name = Objects.requireNonNull(name, "Null loader name");
    }

    public static ExecutorLoader getStandardJavaExecutorLoader() {
        return new StandardJavaExecutorLoader();
    }

    public String name() {
        return this.name;
    }

    public ExecutionBlock loadExecutor(String sessionId, ExecutorSpecification specification, CreateMode createMode) throws ClassNotFoundException {
        Objects.requireNonNull(specification, "Null specification");
        Objects.requireNonNull(createMode, "Null createMode)");
        ExecutionBlock executor = this.loadExecutor(sessionId, specification);
        if (executor != null) {
            createMode.customizeExecutor(executor, sessionId, specification);
        }
        return executor;
    }

    protected abstract ExecutionBlock loadExecutor(String var1, ExecutorSpecification var2) throws ClassNotFoundException;

    protected final ExecutionBlock loadStandardJavaExecutor(String ignoredSessionId, ExecutorSpecification specification) throws ClassNotFoundException {
        Object result;
        Objects.requireNonNull(specification, "Null specification");
        Executable newInstance = this.findNewInstance(specification);
        if (newInstance == null) {
            return null;
        }
        try {
            result = !(newInstance instanceof Method) ? ((Constructor)newInstance).newInstance(new Object[0]) : ((Method)newInstance).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JsonException((String)(newInstance instanceof Method ? newInstance.getName() + "() method" : "Constructor") + " of " + String.valueOf(newInstance.getDeclaringClass()) + " cannot create new instance <<<" + String.valueOf(specification) + ">>>", (Throwable)e);
        }
        if (!(result instanceof ExecutionBlock)) {
            throw new IllegalStateException("Object, created by " + (String)(newInstance instanceof Method ? newInstance.getName() + "() method" : "constructor") + " of " + String.valueOf(newInstance.getDeclaringClass()) + ", is NOT AN EXECUTOR\n    (it is " + (result == null ? "null" : result.getClass().getName()) + " and does not extend ExecutionBlock class)\n    <<<" + String.valueOf(specification) + ">>>");
        }
        return (ExecutionBlock)result;
    }

    public void clearSession(String sessionId) {
        if (sessionId != null) {
            this.removeSpecifications(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> allSerializedSpecifications(String sessionId) {
        Objects.requireNonNull(sessionId, "Null sessionId");
        Map<String, Map<String, String>> map = this.allSpecifications;
        synchronized (map) {
            Map<String, String> session = this.allSpecifications.get(sessionId);
            return session == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(session);
        }
    }

    public Set<String> allExecutorIds(String sessionId) {
        return this.allSerializedSpecifications(sessionId).keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> allSessionIds() {
        Map<String, Map<String, String>> map = this.allSpecifications;
        synchronized (map) {
            return new LinkedHashSet<String>(this.allSpecifications.keySet());
        }
    }

    public final ExecutorSpecification getSpecification(String sessionId, String executorId) {
        String serialized = this.serializedSpecification(sessionId, executorId);
        if (serialized == null) {
            return null;
        }
        try {
            return ExecutorSpecification.of(serialized);
        }
        catch (JsonException e) {
            throw new AssertionError("Very strange: all registered specification were serialized via toJson().toString()!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String serializedSpecification(String sessionId, String executorId) {
        Objects.requireNonNull(sessionId, "Null sessionId");
        Objects.requireNonNull(executorId, "Null executorId");
        Map<String, Map<String, String>> map = this.allSpecifications;
        synchronized (map) {
            Map<String, String> session = this.allSpecifications.get(sessionId);
            return session == null ? null : session.get(executorId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSpecification(String sessionId, ExecutorSpecification specification) {
        Objects.requireNonNull(sessionId, "Null sessionId");
        Objects.requireNonNull(specification, "Null specification");
        ExecutorLoader.checkEmptySessionId(sessionId);
        String serialized = specification.toJson().toString().intern();
        Map<String, Map<String, String>> map = this.allSpecifications;
        synchronized (map) {
            this.allSpecifications.computeIfAbsent(sessionId, k -> new LinkedHashMap()).put(specification.getId(), serialized);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSpecifications(String sessionId, Collection<ExecutorSpecification> specifications) {
        Objects.requireNonNull(sessionId, "Null sessionId");
        Objects.requireNonNull(specifications, "Null specifications");
        ExecutorLoader.checkEmptySessionId(sessionId);
        Map<String, Map<String, String>> map = this.allSpecifications;
        synchronized (map) {
            Map serialized = this.allSpecifications.computeIfAbsent(sessionId, k -> new LinkedHashMap());
            for (ExecutorSpecification specification : specifications) {
                Objects.requireNonNull(specification, "Null specification in the collection");
                serialized.put(specification.getId(), specification.toJson().toString().intern());
            }
        }
    }

    public final void addAllStandardJavaExecutorSpecifications() {
        long t1 = System.nanoTime();
        Collection<ExecutorSpecification> allStandard = ExecutorSpecificationSet.allBuiltIn().all();
        long t2 = System.nanoTime();
        LOG.log(System.Logger.Level.INFO, () -> String.format(Locale.US, "Storing descriptions of %d installed built-in executor specifications: %.3f ms", allStandard.size(), (double)(t2 - t1) * 1.0E-6));
        this.setSpecifications("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f", allStandard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeSpecification(String sessionId, String executorId) {
        Objects.requireNonNull(sessionId, "Null sessionId");
        Objects.requireNonNull(executorId, "Null executorId");
        ExecutorLoader.checkEmptySessionId(sessionId);
        Map<String, Map<String, String>> map = this.allSpecifications;
        synchronized (map) {
            Map<String, String> session = this.allSpecifications.get(sessionId);
            if (session != null) {
                return session.remove(executorId) != null;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSpecifications(String sessionId) {
        Objects.requireNonNull(sessionId, "Null sessionId");
        Map<String, Map<String, String>> map = this.allSpecifications;
        synchronized (map) {
            this.allSpecifications.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Executable findNewInstance(ExecutorSpecification specification) throws ClassNotFoundException {
        String executorId = specification.getId();
        Map<String, Executable> map = this.newInstanceMakers;
        synchronized (map) {
            if (this.newInstanceMakers.containsKey(executorId)) {
                return this.newInstanceMakers.get(executorId);
            }
            Executable executable = ExecutorLoader.getNewInstance(specification);
            this.newInstanceMakers.put(executorId, executable);
            return executable;
        }
    }

    private static void checkEmptySessionId(String sessionId) {
        if (sessionId.isEmpty()) {
            throw new IllegalArgumentException("Empty sessionId");
        }
    }

    private static Executable getNewInstance(ExecutorSpecification specification) throws ClassNotFoundException {
        ExecutorSpecification.Java java = specification.getJava();
        if (java == null) {
            return null;
        }
        String className = java.getClassName();
        if (className == null) {
            return null;
        }
        Class<?> executorClass = Class.forName(className);
        String newInstanceMethodName = java.getNewInstanceMethod();
        try {
            if (newInstanceMethodName != null) {
                return executorClass.getMethod(newInstanceMethodName, new Class[0]);
            }
            return executorClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new JsonException("Cannot find " + (String)(newInstanceMethodName != null ? "public static method " + newInstanceMethodName + "() without parameters" : "default public constructor") + " in class " + className + " <<<" + String.valueOf(specification) + ">>>", (Throwable)e);
        }
    }

    public String toString() {
        return this.name + " (" + this.allSpecifications.size() + " sessions" + (this.allSpecifications.containsKey("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f") ? ", including global" : "") + ")";
    }

    private static class StandardJavaExecutorLoader
    extends ExecutorLoader {
        StandardJavaExecutorLoader() {
            super("standard Java executors loader");
        }

        @Override
        public ExecutionBlock loadExecutor(String sessionId, ExecutorSpecification specification) throws ClassNotFoundException {
            return this.loadStandardJavaExecutor(sessionId, specification);
        }

        @Override
        public void clearSession(String sessionId) {
        }
    }
}

