/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.ChainBlock;
import net.algart.executors.api.chains.ChainInputPort;
import net.algart.executors.api.chains.ChainOutputPort;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.parameters.ParameterValueType;
import net.algart.executors.api.settings.SettingsSpecification;
import net.algart.executors.api.system.ControlEditionType;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.ExecutionStage;
import net.algart.executors.api.system.PortSpecification;
import net.algart.json.AbstractConvertibleToJson;
import net.algart.json.Jsons;

public class ExecutorSpecification
extends AbstractConvertibleToJson {
    public static final String EXECUTOR_FILE_PATTERN = ".*\\.json$";
    public static final String APP_NAME = "executor";
    public static final String CURRENT_VERSION = "1.0";
    public static final String SETTINGS = "settings";
    public static final char CATEGORY_SEPARATOR = '.';
    public static final String DYNAMIC_CATEGORY_PREFIX = "$";
    public static final String CATEGORY_PREFIX_DISABLING_DYNAMIC = "$no-prefix$";
    public static final String OUTPUT_EXECUTOR_ID_CAPTION = "Executor\u00a0ID";
    public static final String OUTPUT_EXECUTOR_ID_HINT = "ID of this executor";
    public static final String OUTPUT_PLATFORM_ID_CAPTION = "Platform\u00a0ID";
    public static final String OUTPUT_PLATFORM_ID_HINT = "ID of the platform, where this executor is installed";
    public static final String OUTPUT_RESOURCE_FOLDER_CAPTION = "Resource\u00a0folder";
    public static final String OUTPUT_RESOURCE_FOLDER_ID_HINT = "Resource folder (if exist) of the platform, where this executor is installed";
    private static final Pattern COMPILED_EXECUTOR_FILE_PATTERN = Pattern.compile(".*\\.json$");
    private Path specificationFile = null;
    private String version = "1.0";
    private String platformId = null;
    private String category;
    private String name;
    private String description = null;
    private Set<String> tags = new LinkedHashSet<String>();
    private String id;
    private Options options = null;
    private String language = null;
    private Java java = null;
    private Map<String, PortSpecification> inputPorts = new LinkedHashMap<String, PortSpecification>();
    private Map<String, PortSpecification> outputPorts = new LinkedHashMap<String, PortSpecification>();
    Map<String, ControlSpecification> controls = new LinkedHashMap<String, ControlSpecification>();
    private SettingsSpecification settings = null;
    private SourceInfo sourceInfo = null;
    private boolean javaExecutor = false;
    private boolean chainExecutor = false;
    private final Object controlsLock = new Object();
    private volatile String minimalSpecification = null;

    public ExecutorSpecification() {
    }

    protected ExecutorSpecification(JsonObject json, Path file) {
        if (!ExecutorSpecification.isExecutorSpecification(json)) {
            throw new JsonException("JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + " is not an executor configuration: no \"app\":\"executor\" element");
        }
        this.specificationFile = file;
        this.version = json.getString("version", CURRENT_VERSION);
        this.platformId = json.getString("platform_id", null);
        try {
            JsonObject sourceJson;
            JsonObject settingsJson;
            PortSpecification port;
            JsonObject optionsJson;
            this.id = Jsons.reqStringWithAlias(json, "id", "uuid", file);
            this.category = Jsons.reqString(json, "category", file);
            this.name = Jsons.reqString(json, "name", file);
            this.description = json.getString("description", null);
            JsonArray tags = Jsons.getJsonArray(json, "tags", file);
            if (tags != null) {
                for (JsonValue jsonValue : tags) {
                    if (!(jsonValue instanceof JsonString)) {
                        throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"tags\" array contains non-string element " + String.valueOf(jsonValue));
                    }
                    this.tags.add(((JsonString)jsonValue).getString());
                }
            }
            if ((optionsJson = json.getJsonObject("options")) != null) {
                this.options = new Options(optionsJson, file);
            }
            this.setLanguage(json.getString("language", null));
            JsonObject javaJson = json.getJsonObject("java");
            if (this.javaExecutor && javaJson == null) {
                throw new JsonException("Invalid executor configuration JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"java\" section required when \"language\" is \"java\"");
            }
            Java java = this.java = javaJson == null ? null : new Java(javaJson, file);
            if (json.containsKey((Object)"in_ports")) {
                for (JsonObject jsonObject : Jsons.reqJsonObjects(json, "in_ports", file)) {
                    port = new PortSpecification(jsonObject, file);
                    ExecutorSpecification.putOrException(this.inputPorts, port.getName(), port, file, "in_ports");
                }
            }
            if (json.containsKey((Object)"out_ports")) {
                for (JsonObject jsonObject : Jsons.reqJsonObjects(json, "out_ports", file)) {
                    port = new PortSpecification(jsonObject, file);
                    ExecutorSpecification.putOrException(this.outputPorts, port.getName(), port, file, "out_ports");
                }
            }
            if (json.containsKey((Object)"controls")) {
                for (JsonObject jsonObject : Jsons.reqJsonObjects(json, "controls", file)) {
                    ControlSpecification control = new ControlSpecification(jsonObject, file);
                    ExecutorSpecification.putOrException(this.controls, control.getName(), control, file, "controls");
                }
            }
            if ((settingsJson = json.getJsonObject(SETTINGS)) != null) {
                this.settings = SettingsSpecification.of(settingsJson);
            }
            if ((sourceJson = json.getJsonObject("source")) != null) {
                this.sourceInfo = new SourceInfo(sourceJson, file);
            }
        }
        catch (JsonException e) {
            if (file != null || this.id == null) {
                throw e;
            }
            throw new JsonException("Problem in JSON specification for executor with ID '" + this.id + "'" + (String)(this.name == null ? "" : ", name '" + this.name + "'") + (String)(this.description == null ? "" : ", description '" + this.name + "'"), (Throwable)e);
        }
    }

    public static ExecutorSpecification read(Path specificationFile) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        JsonObject json = Jsons.readJson(specificationFile);
        return new ExecutorSpecification(json, specificationFile);
    }

    public static ExecutorSpecification readIfValid(Path specificationFile) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        JsonObject json = Jsons.readJson(specificationFile);
        if (!ExecutorSpecification.isExecutorSpecification(json)) {
            return null;
        }
        return new ExecutorSpecification(json, specificationFile);
    }

    public void write(Path specificationFile, OpenOption ... options) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        Files.writeString(specificationFile, (CharSequence)this.jsonString(), options);
    }

    public static <T> List<T> readAllJsonIfValid(List<T> result, Path containingJsonPath, Function<Path, T> reader) throws IOException {
        return ExecutorSpecification.readAllIfValid(result, containingJsonPath, true, reader, path -> path.getFileName().toString().toLowerCase().endsWith(".json"));
    }

    public static <S> List<S> readAllIfValid(List<S> result, Path containingJsonPath, boolean recursive, Function<Path, S> reader, Predicate<Path> isAllowedPath) throws IOException {
        S specification;
        Objects.requireNonNull(containingJsonPath, "Null containingJsonPath");
        Objects.requireNonNull(isAllowedPath, "Null isAllowedPath");
        if (result == null) {
            result = new ArrayList<S>();
        }
        if (Files.isDirectory(containingJsonPath, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(containingJsonPath);){
                for (Path file : files.sorted().toList()) {
                    if (!recursive && !Files.isRegularFile(file, new LinkOption[0])) continue;
                    ExecutorSpecification.readAllIfValid(result, file, recursive, reader, isAllowedPath);
                }
            }
        } else if (Files.isRegularFile(containingJsonPath, new LinkOption[0]) && isAllowedPath.test(containingJsonPath) && (specification = reader.apply(containingJsonPath)) != null) {
            result.add(specification);
        }
        return result;
    }

    public static ExecutorSpecification of(JsonObject specificationJson) {
        return new ExecutorSpecification(specificationJson, null);
    }

    public static ExecutorSpecification of(String specificationString) throws JsonException {
        Objects.requireNonNull(specificationString, "Null specificationString");
        JsonObject executorSpecification = Jsons.toJson(specificationString);
        return new ExecutorSpecification(executorSpecification, null);
    }

    public static ExecutorSpecification of(Executor executor, String executorId) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(executorId, "Null executor ID");
        ExecutorSpecification result = new ExecutorSpecification();
        result.setTo(executor);
        result.setId(executorId);
        return result;
    }

    public static boolean isExecutorSpecificationFile(Path specificationFile) {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        return COMPILED_EXECUTOR_FILE_PATTERN.matcher(specificationFile.getFileName().toString().toLowerCase()).matches();
    }

    public static boolean isExecutorSpecification(JsonObject specificationJson) {
        Objects.requireNonNull(specificationJson, "Null executor specification");
        return APP_NAME.equals(specificationJson.getString("app", null));
    }

    public static void checkIdDifference(Collection<? extends ExecutorSpecification> specifications) {
        Objects.requireNonNull(specifications, "Null executor specifications collection");
        HashSet<String> ids = new HashSet<String>();
        for (ExecutorSpecification executorSpecification : specifications) {
            String id = executorSpecification.getId();
            assert (id != null);
            if (ids.add(id)) continue;
            throw new IllegalArgumentException("Two executor JSONs have identical IDs " + id + ", one of them is \"" + executorSpecification.getName() + "\"");
        }
    }

    public final boolean hasSpecificationFile() {
        return this.specificationFile != null;
    }

    public final Path getSpecificationFile() {
        return this.specificationFile;
    }

    public final String getVersion() {
        return this.version;
    }

    public final ExecutorSpecification setVersion(String version) {
        this.version = Objects.requireNonNull(version, "Null version");
        return this;
    }

    public final boolean hasPlatformId() {
        return this.platformId != null;
    }

    public final String getPlatformId() {
        return this.platformId;
    }

    public final ExecutorSpecification setPlatformId(String platformId) {
        this.platformId = platformId;
        return this;
    }

    public final String getCategory() {
        return this.category;
    }

    public final ExecutorSpecification setCategory(String category) {
        this.category = Objects.requireNonNull(category, "Null category");
        return this;
    }

    public final String getName() {
        return this.name;
    }

    public final ExecutorSpecification setName(String name) {
        this.name = Objects.requireNonNull(name, "Null name");
        return this;
    }

    public final String canonicalName() {
        return this.category + "." + this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final ExecutorSpecification setDescription(String description) {
        this.description = description;
        return this;
    }

    public final Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public final ExecutorSpecification setTags(Set<String> tags) {
        Objects.requireNonNull(tags, "Null tags");
        this.tags = new LinkedHashSet<String>(tags);
        return this;
    }

    public final String getId() {
        return this.id;
    }

    public final ExecutorSpecification setId(String id) {
        this.id = Objects.requireNonNull(id, "Null executor ID");
        return this;
    }

    public final Options createOptionsIfAbsent() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    public final Options getOptions() {
        return this.options;
    }

    public final ExecutorSpecification setOptions(Options options) {
        this.options = options;
        return this;
    }

    public final Options.Role getRole() {
        return this.options == null ? null : this.options.getRole();
    }

    public final boolean isRoleSettings() {
        Options.Role role = this.getRole();
        return role != null && role.isSettings();
    }

    public final String getLanguage() {
        return this.language;
    }

    public final ExecutorSpecification setLanguage(String language) {
        this.language = language;
        this.javaExecutor = "java".equals(language);
        this.chainExecutor = "chain".equals(language);
        return this;
    }

    public final boolean isJavaExecutor() {
        return this.javaExecutor;
    }

    public boolean isChainExecutor() {
        return this.chainExecutor;
    }

    public final Java getJava() {
        return this.java;
    }

    public final ExecutorSpecification setJava(Java java) {
        this.java = java;
        return this;
    }

    public final PortSpecification getInputPort(String name) {
        return this.inputPorts.get(name);
    }

    public final Map<String, PortSpecification> getInputPorts() {
        return Collections.unmodifiableMap(this.inputPorts);
    }

    public final ExecutorSpecification setInputPorts(Map<String, PortSpecification> inputPorts) {
        this.inputPorts = ExecutorSpecification.checkInputPorts(inputPorts);
        return this;
    }

    public final PortSpecification getOutputPort(String name) {
        return this.outputPorts.get(name);
    }

    public final Map<String, PortSpecification> getOutputPorts() {
        return Collections.unmodifiableMap(this.outputPorts);
    }

    public final ExecutorSpecification setOutputPorts(Map<String, PortSpecification> outputPorts) {
        this.outputPorts = ExecutorSpecification.checkOutputPorts(outputPorts);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ControlSpecification getControl(String name) {
        Object object = this.controlsLock;
        synchronized (object) {
            return this.controls.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, ControlSpecification> getControls() {
        Object object = this.controlsLock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.controls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExecutorSpecification setControls(Map<String, ControlSpecification> controls) {
        Object object = this.controlsLock;
        synchronized (object) {
            this.controls = ExecutorSpecification.checkControls(controls);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateControlSettingsId(String name, String settingsId) {
        Objects.requireNonNull(name, "Null control name");
        Object object = this.controlsLock;
        synchronized (object) {
            ControlSpecification control = this.controls.get(name);
            if (control == null) {
                throw new IllegalArgumentException("No control with name " + name);
            }
            control.setSettingsId(settingsId);
        }
    }

    public SettingsSpecification getSettings() {
        return this.settings;
    }

    public ExecutorSpecification setSettings(SettingsSpecification settings) {
        this.settings = settings;
        return this;
    }

    public boolean hasSettings() {
        return this.settings != null;
    }

    public final SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public final ExecutorSpecification setSourceInfo(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        return this;
    }

    public boolean hasSourceInfo() {
        return this.sourceInfo != null;
    }

    public final SourceInfo setSourceInfo(Path specificationPath, Path modulePath) {
        this.sourceInfo = new SourceInfo();
        this.sourceInfo.setAbsoluteSpecificationPath(specificationPath);
        this.sourceInfo.setAbsoluteModulePath(modulePath);
        return this.sourceInfo;
    }

    public final SourceInfo setSourceInfoForSpecification() {
        return this.setSourceInfo(this.specificationFile, null);
    }

    public final void updateCategoryPrefix(String categoryPrefix) {
        this.category = ExecutorSpecification.updateCategoryPrefix(this.category, categoryPrefix);
    }

    public final void addTags(Collection<String> tags) {
        Objects.requireNonNull(tags, "Null tags");
        this.tags.addAll(tags);
    }

    public final void addInputPort(PortSpecification port) {
        Objects.requireNonNull(port, "Null input port");
        port.checkCompleteness();
        this.inputPorts.put(port.getName(), port);
    }

    public final void addFirstInputPort(PortSpecification port) {
        Objects.requireNonNull(port, "Null input port");
        port.checkCompleteness();
        LinkedHashMap<String, PortSpecification> inputPorts = new LinkedHashMap<String, PortSpecification>();
        inputPorts.put(port.getName(), port);
        inputPorts.putAll(this.inputPorts);
        this.inputPorts = inputPorts;
    }

    public final void addOutputPort(PortSpecification port) {
        Objects.requireNonNull(port, "Null output port");
        port.checkCompleteness();
        this.outputPorts.put(port.getName(), port);
    }

    public final void addFirstOutputPort(PortSpecification port) {
        Objects.requireNonNull(port, "Null output port");
        port.checkCompleteness();
        LinkedHashMap<String, PortSpecification> outputPorts = new LinkedHashMap<String, PortSpecification>();
        outputPorts.put(port.getName(), port);
        outputPorts.putAll(this.outputPorts);
        this.outputPorts = outputPorts;
    }

    public final void addSystemExecutorIdPort() {
        if (!this.outputPorts.containsKey("_sys___executor_id")) {
            this.addOutputPort(new PortSpecification().setName("_sys___executor_id").setCaption(OUTPUT_EXECUTOR_ID_CAPTION).setHint(OUTPUT_EXECUTOR_ID_HINT).setValueType(DataType.SCALAR).setAdvanced(true));
        }
    }

    public final void addSystemPlatformIdPort() {
        if (!this.outputPorts.containsKey("_sys___platform_id")) {
            this.addOutputPort(new PortSpecification().setName("_sys___platform_id").setCaption(OUTPUT_PLATFORM_ID_CAPTION).setHint(OUTPUT_PLATFORM_ID_HINT).setValueType(DataType.SCALAR).setAdvanced(true));
        }
    }

    public final void addSystemResourceFolderPort() {
        if (!this.outputPorts.containsKey("_sys___resource_folder")) {
            this.addOutputPort(new PortSpecification().setName("_sys___resource_folder").setCaption(OUTPUT_RESOURCE_FOLDER_CAPTION).setHint(OUTPUT_RESOURCE_FOLDER_ID_HINT).setValueType(DataType.SCALAR).setAdvanced(true));
        }
    }

    public final void addControl(ControlSpecification control) {
        Objects.requireNonNull(control, "Null control");
        control.checkCompleteness();
        this.controls.put(control.getName(), control);
    }

    public final void addFirstControl(ControlSpecification control) {
        Objects.requireNonNull(control, "Null control");
        control.checkCompleteness();
        LinkedHashMap<String, ControlSpecification> controls = new LinkedHashMap<String, ControlSpecification>();
        controls.put(control.getName(), control);
        controls.putAll(this.controls);
        this.controls = controls;
    }

    public final boolean isInput() {
        return this.options != null && this.options.behavior != null && this.options.behavior.input;
    }

    public final boolean isOutput() {
        return this.options != null && this.options.behavior != null && this.options.behavior.output;
    }

    public final boolean isData() {
        return this.options != null && this.options.behavior != null && this.options.behavior.data && !this.options.behavior.input && !this.options.behavior.output;
    }

    public final boolean isCopy() {
        return this.options != null && this.options.behavior != null && this.options.behavior.copy;
    }

    public final ParameterValueType dataType() {
        return this.isData() ? this.options.behavior.dataType : null;
    }

    public final ControlEditionType editionType() {
        return this.isData() ? this.options.behavior.editionType : null;
    }

    public final String minimalSpecification() {
        String minimalSpecification = this.minimalSpecification;
        if (minimalSpecification == null) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("app", APP_NAME);
            builder.add("category", this.category);
            builder.add("name", this.name);
            builder.add("id", this.id);
            if (this.java != null) {
                builder.add("java", (JsonValue)this.java.toJson());
            }
            if (this.platformId != null) {
                builder.add("platform_id", this.platformId);
            }
            this.minimalSpecification = minimalSpecification = builder.build().toString();
        }
        return minimalSpecification;
    }

    public final void setTo(Executor executor) {
        Objects.requireNonNull(executor, "Null executor");
        String className = executor.getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        if (this.category == null) {
            this.setCategory(lastDotIndex == -1 ? "" : className.substring(0, lastDotIndex));
        }
        if (this.name == null) {
            this.setName(executor.getClass().getSimpleName());
        }
        if (this.java == null) {
            this.setJava(new Java().setJson(Java.standardJson(className)));
        }
        LinkedHashMap<String, PortSpecification> inputPorts = new LinkedHashMap<String, PortSpecification>(this.inputPorts);
        for (Port port : executor.inputPorts()) {
            String name = port.getName();
            PortSpecification portSpecification = inputPorts.getOrDefault(name, new PortSpecification());
            inputPorts.put(name, portSpecification.setName(name).setValueType(port.getDataType()));
        }
        this.setInputPorts(inputPorts);
        LinkedHashMap<String, PortSpecification> outputPorts = new LinkedHashMap<String, PortSpecification>(this.outputPorts);
        for (Port port : executor.outputPorts()) {
            String name = port.getName();
            PortSpecification portSpecification = outputPorts.getOrDefault(name, new PortSpecification());
            outputPorts.put(name, portSpecification.setName(name).setValueType(port.getDataType()));
        }
        this.setOutputPorts(outputPorts);
        LinkedHashMap<String, ControlSpecification> linkedHashMap = new LinkedHashMap<String, ControlSpecification>(this.controls);
        for (String name : executor.allParameters()) {
            ControlSpecification controlSpecification = linkedHashMap.getOrDefault(name, new ControlSpecification());
            ParameterValueType parameterValueType = executor.parameterControlValueType(name);
            controlSpecification.setName(name).setValueType(parameterValueType);
            if (parameterValueType == ParameterValueType.ENUM_STRING) {
                controlSpecification.setEditionType(ControlEditionType.ENUM);
                Class<?> enumClass = executor.parameterJavaType(name);
                if (enumClass == null || !Enum.class.isAssignableFrom(enumClass)) {
                    throw new AssertionError((Object)("Invalid propertyJavaType method result: not enum (" + String.valueOf(enumClass) + ")"));
                }
                if (controlSpecification.getItems() == null) {
                    String firstEnumName = null;
                    ArrayList<ControlSpecification.EnumItem> items = new ArrayList<ControlSpecification.EnumItem>();
                    for (Enum enumConstant : enumClass.asSubclass(Enum.class).getEnumConstants()) {
                        String enumName = enumConstant.name();
                        if (firstEnumName == null) {
                            firstEnumName = enumName;
                        }
                        items.add(new ControlSpecification.EnumItem().setValue(enumName));
                    }
                    if (firstEnumName == null) {
                        throw new AssertionError((Object)"No constants in enum class: impossible in Java");
                    }
                    controlSpecification.setItems(items);
                    controlSpecification.setDefaultStringValue(firstEnumName);
                }
            } else {
                controlSpecification.setEditionType(ControlEditionType.VALUE);
            }
            linkedHashMap.put(name, controlSpecification);
        }
        this.setControls(linkedHashMap);
    }

    public final void setTo(Chain chain) {
        Objects.requireNonNull(chain, "Null chain");
        this.setCategory(chain.category());
        this.setName(chain.name());
        this.setDescription(chain.description());
        this.setTags(chain.tags());
        this.setId(chain.id());
        this.setLanguage("chain");
        LinkedHashMap<String, PortSpecification> inputPorts = new LinkedHashMap<String, PortSpecification>(this.inputPorts);
        for (ChainBlock chainBlock : chain.getAllInputs()) {
            ChainInputPort inputPort = chainBlock.getActualInputPort(Executor.DEFAULT_INPUT_PORT);
            if (inputPort == null) {
                throw new IllegalArgumentException("Chain contains standard input block without default input port \"" + Executor.DEFAULT_INPUT_PORT + "\": " + String.valueOf(chainBlock));
            }
            String inputName = chainBlock.getStandardInputOutputName();
            if (inputName == null) {
                throw new IllegalArgumentException("Chain contains standard input block with non-initialized input name: " + String.valueOf(chainBlock));
            }
            PortSpecification portSpecification = new PortSpecification();
            portSpecification.setName(inputName);
            portSpecification.setValueType(inputPort.getDataType());
            ExecutorSpecification.setAdditionalFields(portSpecification, chainBlock);
            inputPorts.put(portSpecification.getName(), portSpecification);
        }
        this.setInputPorts(inputPorts);
        LinkedHashMap<String, PortSpecification> outputPorts = new LinkedHashMap<String, PortSpecification>(this.outputPorts);
        for (ChainBlock block : chain.getAllOutputs()) {
            ChainOutputPort outputPort = block.getActualOutputPort(Executor.DEFAULT_OUTPUT_PORT);
            if (outputPort == null) {
                throw new IllegalArgumentException("Chain contains standard output block without default output port \"" + Executor.DEFAULT_OUTPUT_PORT + "\": " + String.valueOf(block));
            }
            String outputName = block.getStandardInputOutputName();
            if (outputName == null) {
                throw new IllegalArgumentException("Chain contains standard output block with non-initialized output name: " + String.valueOf(block));
            }
            PortSpecification portSpecification = new PortSpecification();
            portSpecification.setName(outputName);
            portSpecification.setValueType(outputPort.getDataType());
            ExecutorSpecification.setAdditionalFields(portSpecification, block);
            outputPorts.put(portSpecification.getName(), portSpecification);
        }
        this.setOutputPorts(outputPorts);
        LinkedHashMap<String, ControlSpecification> linkedHashMap = new LinkedHashMap<String, ControlSpecification>(this.controls);
        for (ChainBlock block : chain.getAllData()) {
            ControlEditionType editionType;
            String parameterName = block.getStandardParameterName();
            if (parameterName == null) continue;
            ChainInputPort inputPort = block.getActualInputPort(Executor.DEFAULT_INPUT_PORT);
            if (inputPort == null) {
                throw new IllegalArgumentException("Chain contains standard data block without default input port \"" + Executor.DEFAULT_INPUT_PORT + "\": " + String.valueOf(block));
            }
            if (inputPort.getDataType() != DataType.SCALAR) continue;
            ControlSpecification controlSpecification = linkedHashMap.getOrDefault(parameterName, new ControlSpecification());
            controlSpecification.setName(parameterName);
            ExecutorSpecification specification = block.getExecutorSpecification();
            ParameterValueType valueType = specification != null ? specification.dataType() : null;
            ControlEditionType controlEditionType = editionType = specification != null ? specification.editionType() : null;
            if (valueType == null) {
                valueType = ParameterValueType.STRING;
            }
            controlSpecification.setValueType(valueType);
            controlSpecification.setEditionType(editionType != null ? editionType : ControlEditionType.VALUE);
            String defaultStringValue = null;
            ChainOutputPort outputPort = block.getActualOutputPort(Executor.DEFAULT_OUTPUT_PORT);
            if (outputPort != null && outputPort.getDataType() == DataType.SCALAR) {
                block.reinitialize(false);
                ExecutionBlock executor = block.getExecutor();
                block.copyInputPortsToExecutor();
                executor.execute();
                defaultStringValue = executor.getScalar(Executor.DEFAULT_OUTPUT_PORT).getValue();
            }
            if (defaultStringValue != null) {
                controlSpecification.setDefaultJsonValue(valueType.toJsonValue(defaultStringValue));
            }
            ExecutorSpecification.setAdditionalFields(controlSpecification, block);
            linkedHashMap.put(controlSpecification.getName(), controlSpecification);
        }
        this.setControls(linkedHashMap);
    }

    public final SettingsSpecification toSettingsSpecification() {
        SettingsSpecification result = new SettingsSpecification();
        result.setTo(this);
        return result;
    }

    @Override
    public void checkCompleteness() {
        this.checkNull(this.category, "category");
        this.checkNull(this.name, "name");
        this.checkNull(this.id, "id");
        if (this.javaExecutor) {
            this.checkNull(this.java, "java");
        }
    }

    public final JsonObject toJson(JsonMode mode) {
        this.checkCompleteness();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.buildJson(builder, mode);
        return builder.build();
    }

    public final String jsonString(JsonMode mode) {
        return Jsons.toPrettyString(this.toJson(mode));
    }

    public final JsonObject defaultSettingsJson() {
        this.checkCompleteness();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.buildDefaultSettingsJson(builder, null);
        return builder.build();
    }

    public final String defaultSettingsJsonString() {
        return Jsons.toPrettyString(this.defaultSettingsJson());
    }

    @Override
    public void buildJson(JsonObjectBuilder builder) {
        this.buildJson(builder, JsonMode.FULL);
    }

    public final void buildJson(JsonObjectBuilder builder, JsonMode mode) {
        this.buildJson(builder, mode, null);
    }

    void buildJson(JsonObjectBuilder builder, JsonMode mode, Function<String, JsonObject> subSettingsJsonBuilder) {
        Objects.requireNonNull(builder, "Null builder");
        Objects.requireNonNull(mode, "Null JSON mode");
        builder.add("app", APP_NAME);
        if (!this.version.equals(CURRENT_VERSION)) {
            builder.add("version", this.version);
        }
        if (this.platformId != null) {
            builder.add("platform_id", this.platformId);
        }
        builder.add("category", this.category);
        builder.add("name", this.name);
        if (this.description != null) {
            builder.add("description", this.description);
        }
        if (mode.isTagsIncluded() && !this.tags.isEmpty()) {
            JsonArrayBuilder tagsBuilder = Json.createArrayBuilder();
            for (String string : this.tags) {
                tagsBuilder.add(string);
            }
            builder.add("tags", (JsonValue)tagsBuilder.build());
        }
        builder.add("id", this.id);
        if (mode.isOptionsIncluded() && this.options != null) {
            builder.add("options", (JsonValue)this.options.toJson());
        }
        if (this.language != null) {
            builder.add("language", this.language);
        }
        this.buildLanguageJson(builder);
        if (mode.isPortsIncluded()) {
            JsonArrayBuilder inputPortsBuilder = Json.createArrayBuilder();
            for (PortSpecification portSpecification : this.inputPorts.values()) {
                inputPortsBuilder.add((JsonValue)portSpecification.toJson());
            }
            builder.add("in_ports", (JsonValue)inputPortsBuilder.build());
            JsonArrayBuilder outputPortsBuilder = Json.createArrayBuilder();
            for (PortSpecification port : this.outputPorts.values()) {
                outputPortsBuilder.add((JsonValue)port.toJson());
            }
            builder.add("out_ports", (JsonValue)outputPortsBuilder.build());
        }
        JsonArrayBuilder controlsBuilder = Json.createArrayBuilder();
        for (Map.Entry entry : this.controls.entrySet()) {
            JsonObject subSettingsJson;
            String name = (String)entry.getKey();
            ControlSpecification control = (ControlSpecification)entry.getValue();
            control.checkCompleteness();
            JsonObjectBuilder controlBuilder = Json.createObjectBuilder();
            control.buildJson(controlBuilder);
            if (subSettingsJsonBuilder != null && control.isSubSettings() && (subSettingsJson = subSettingsJsonBuilder.apply(name)) != null) {
                controlBuilder.add(SETTINGS, (JsonValue)subSettingsJson);
            }
            controlsBuilder.add((JsonValue)controlBuilder.build());
        }
        builder.add("controls", (JsonValue)controlsBuilder.build());
        if (mode.isSettingsSectionIncluded() && this.settings != null) {
            builder.add(SETTINGS, (JsonValue)this.settings.toJson(true));
        }
        if (this.sourceInfo != null) {
            builder.add("source", (JsonValue)this.sourceInfo.toJson());
        }
    }

    void buildDefaultSettingsJson(JsonObjectBuilder builder, Function<String, JsonObject> subSettingsJsonBuilder) {
        Objects.requireNonNull(builder, "Null builder");
        for (Map.Entry<String, ControlSpecification> entry : this.controls.entrySet()) {
            String name = entry.getKey();
            ControlSpecification control = entry.getValue();
            control.checkCompleteness();
            if (subSettingsJsonBuilder != null) {
                JsonObject subSettingsJson;
                if (SETTINGS.equals(name)) continue;
                if (control.isSubSettings() && (subSettingsJson = subSettingsJsonBuilder.apply(name)) != null) {
                    builder.add(ControlSpecification.settingsKey(name), (JsonValue)subSettingsJson);
                    continue;
                }
            }
            if (!control.hasDefaultJsonValue()) continue;
            builder.add(name, control.getDefaultJsonValue());
        }
    }

    public String toString() {
        return "ExecutorSpecification{\n  specificationFile=" + String.valueOf(this.specificationFile) + ",\n  version='" + this.version + "',\n  platformId='" + this.platformId + "',\n  category='" + this.category + "',\n  name='" + this.name + "',\n  description=" + (this.description == null ? null : "'" + this.description + "'") + ",\n  tags=" + String.valueOf(this.tags) + ",\n  id='" + this.id + "',\n  options=" + String.valueOf(this.options) + ",\n  language=" + this.language + ",\n  java=" + String.valueOf(this.java) + ",\n  inputPorts=" + String.valueOf(this.inputPorts) + ",\n  outputPorts=" + String.valueOf(this.outputPorts) + ",\n  controls=" + String.valueOf(this.controls) + ",\n  settings=" + String.valueOf(this.settings) + ",\n  javaExecutor=" + this.javaExecutor + ",\n  chainExecutor=" + this.chainExecutor + ",\n  sourceInfo=" + String.valueOf(this.sourceInfo) + "\n}\n";
    }

    public static String updateCategoryPrefix(String category, String categoryPrefix) {
        Objects.requireNonNull(category, "Null category");
        return categoryPrefix != null ? categoryPrefix + "." + category : category;
    }

    public static <K, V> void putOrException(Map<K, V> map, K key, V value, Path file, String mapName) {
        if (map.put(key, value) != null) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": duplicate key \"" + String.valueOf(key) + "\" in \"" + mapName + "\" array");
        }
    }

    public static Map<String, PortSpecification> checkInputPorts(Map<String, PortSpecification> ports) {
        return ExecutorSpecification.checkPorts(ports, "input");
    }

    public static Map<String, PortSpecification> checkOutputPorts(Map<String, PortSpecification> ports) {
        return ExecutorSpecification.checkPorts(ports, "output");
    }

    public static Map<String, ControlSpecification> checkControls(Map<String, ControlSpecification> controls) {
        Objects.requireNonNull(controls, "Null controls");
        controls = new LinkedHashMap<String, ControlSpecification>(controls);
        for (Map.Entry<String, ControlSpecification> control : controls.entrySet()) {
            if (control.getKey() == null) {
                throw new IllegalArgumentException("Illegal control: null key");
            }
            ControlSpecification specification = control.getValue();
            if (specification == null) {
                throw new IllegalArgumentException("Illegal control[" + ExecutorSpecification.quote(control.getKey()) + "]: null");
            }
            if (control.getKey().equals(specification.getName())) continue;
            throw new IllegalArgumentException("Illegal control[" + ExecutorSpecification.quote(control.getKey()) + "]: its name is " + ExecutorSpecification.quote(specification.getName()) + " (must be equal to key " + ExecutorSpecification.quote(control.getKey()) + ")");
        }
        return controls;
    }

    public static <T> List<T> checkNonNullObjects(List<T> objects) {
        if (objects == null) {
            return null;
        }
        objects = new ArrayList<T>(objects);
        int n = objects.size();
        for (int k = 0; k < n; ++k) {
            Objects.requireNonNull(objects.get(k), "Null element #" + k + " in list \"" + String.valueOf(objects) + "\"");
        }
        return objects;
    }

    public static String className(String category, String name) {
        return category + "." + name;
    }

    public static String correctDynamicCategory(String category) {
        return ExecutorSpecification.correctDynamicCategory(category, false);
    }

    public static String correctDynamicCategory(String category, boolean disableDynamicPrefix) {
        if (category == null) {
            return null;
        }
        if (category.startsWith(CATEGORY_PREFIX_DISABLING_DYNAMIC)) {
            int prefixLength = CATEGORY_PREFIX_DISABLING_DYNAMIC.length();
            if (category.length() > prefixLength) {
                return category.substring(prefixLength);
            }
            return category;
        }
        if (disableDynamicPrefix) {
            return category;
        }
        return DYNAMIC_CATEGORY_PREFIX + category;
    }

    public static String quote(String value) {
        return value == null ? null : "\"" + value + "\"";
    }

    protected void buildLanguageJson(JsonObjectBuilder builder) {
        if (this.java != null) {
            builder.add("java", (JsonValue)this.java.toJson());
        }
    }

    private static void setAdditionalFields(ControlSpecification controlSpecification, ChainBlock chainBlock) {
        ChainSpecification.Block block = chainBlock.getBlock();
        if (block != null) {
            ChainSpecification.Block.System system = block.getSystem();
            controlSpecification.setCaption(ExecutorSpecification.makeCaption(chainBlock, system.getCaption()));
            controlSpecification.setDescription(system.getDescription());
        }
    }

    private static void setAdditionalFields(PortSpecification portSpecification, ChainBlock chainBlock) {
        ChainSpecification.Block block = chainBlock.getBlock();
        if (block != null) {
            ChainSpecification.Block.System system = block.getSystem();
            portSpecification.setCaption(ExecutorSpecification.makeCaption(chainBlock, system.getCaption()));
            portSpecification.setHint(system.getDescription());
        }
    }

    private static String makeCaption(ChainBlock chainBlock, String customCaption) {
        String standardCaption = chainBlock.getStandardInputOutputPortCaption();
        if (standardCaption != null && !standardCaption.equals(customCaption)) {
            assert (chainBlock.getSystemName() != null) : "getStandardInputOutputPortCaption() returns non-null " + standardCaption + " for null system name";
            return customCaption;
        }
        return null;
    }

    private static Map<String, PortSpecification> checkPorts(Map<String, PortSpecification> ports, String title) {
        Objects.requireNonNull(ports, "Null " + title + " ports");
        ports = new LinkedHashMap<String, PortSpecification>(ports);
        for (Map.Entry<String, PortSpecification> port : ports.entrySet()) {
            if (port.getKey() == null) {
                throw new IllegalArgumentException("Illegal " + title + " port: null key");
            }
            PortSpecification specification = port.getValue();
            if (specification == null) {
                throw new IllegalArgumentException("Illegal " + title + " port[" + ExecutorSpecification.quote(port.getKey()) + "]: null");
            }
            if (port.getKey().equals(specification.getName())) continue;
            throw new IllegalArgumentException("Illegal " + title + " port[" + ExecutorSpecification.quote(port.getKey()) + "]: its name is " + ExecutorSpecification.quote(specification.getName()) + " (must be equal to key " + ExecutorSpecification.quote(port.getKey()) + ")");
        }
        return ports;
    }

    public static final class Options
    extends AbstractConvertibleToJson {
        private ExecutionStage stage = ExecutionStage.RUN_TIME;
        private Role role = null;
        private Owner owner = null;
        private Service service = null;
        private Behavior behavior = null;
        private Controlling controlling = null;
        private JsonObject extension = null;

        public Options() {
        }

        public Options(JsonObject json, Path file) {
            JsonObject controllingJson;
            JsonObject behaviorJson;
            JsonObject serviceJson;
            JsonObject ownerJson;
            String stage = json.getString("stage", ExecutionStage.RUN_TIME.stageName());
            this.stage = ExecutionStage.ofOrNull(stage);
            Jsons.requireNonNull(this.stage, json, "stage", "unknown (\"" + stage + "\")", file);
            JsonObject roleJson = json.getJsonObject("role");
            if (roleJson != null) {
                this.role = new Role(roleJson, file);
            }
            if ((ownerJson = json.getJsonObject("owner")) != null) {
                this.owner = new Owner(ownerJson, file);
            }
            if ((serviceJson = json.getJsonObject("service")) != null) {
                this.service = new Service(serviceJson, file);
            }
            if ((behaviorJson = json.getJsonObject("behavior")) != null) {
                this.behavior = new Behavior(behaviorJson, file);
            }
            if ((controllingJson = json.getJsonObject("controlling")) != null) {
                this.controlling = new Controlling(controllingJson, file);
            }
            this.extension = json.getJsonObject("extension");
        }

        public ExecutionStage getStage() {
            return this.stage;
        }

        public Options setStage(ExecutionStage stage) {
            this.stage = Objects.requireNonNull(stage, "Null stage");
            return this;
        }

        public Role createRoleIfAbsent() {
            if (this.role == null) {
                this.role = new Role();
            }
            return this.role;
        }

        public Role getRole() {
            return this.role;
        }

        public Options setRole(Role role) {
            this.role = role;
            return this;
        }

        public Owner createOwnerIfAbsent() {
            if (this.owner == null) {
                this.owner = new Owner();
            }
            return this.owner;
        }

        public Owner getOwner() {
            return this.owner;
        }

        public Options setOwner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public Service createServiceIfAbsent() {
            if (this.service == null) {
                this.service = new Service();
            }
            return this.service;
        }

        public Service getService() {
            return this.service;
        }

        public Options setService(Service service) {
            this.service = service;
            return this;
        }

        public Behavior createBehaviorIfAbsent() {
            if (this.behavior == null) {
                this.behavior = new Behavior();
            }
            return this.behavior;
        }

        public Behavior getBehavior() {
            return this.behavior;
        }

        public Options setBehavior(Behavior behavior) {
            this.behavior = behavior;
            return this;
        }

        public Controlling createControllingIfAbsent() {
            if (this.controlling == null) {
                this.controlling = new Controlling();
            }
            return this.controlling;
        }

        public Controlling getControlling() {
            return this.controlling;
        }

        public Options setControlling(Controlling controlling) {
            this.controlling = controlling;
            return this;
        }

        public JsonObject getExtension() {
            return this.extension;
        }

        public Options setExtension(JsonObject extension) {
            this.extension = extension;
            return this;
        }

        @Override
        public void checkCompleteness() {
        }

        public String toString() {
            return "Options{stage=" + String.valueOf((Object)this.stage) + ", role=" + String.valueOf(this.role) + ", owner=" + String.valueOf(this.owner) + ", service=" + String.valueOf(this.service) + ", behavior=" + String.valueOf(this.behavior) + ", controlling=" + String.valueOf(this.controlling) + ", extension=" + String.valueOf(this.extension) + "}";
        }

        @Override
        public void buildJson(JsonObjectBuilder builder) {
            builder.add("stage", this.stage.stageName());
            if (this.role != null) {
                builder.add("role", (JsonValue)this.role.toJson());
            }
            if (this.owner != null) {
                builder.add("owner", (JsonValue)this.owner.toJson());
            }
            if (this.service != null) {
                builder.add("service", (JsonValue)this.service.toJson());
            }
            if (this.behavior != null) {
                builder.add("behavior", (JsonValue)this.behavior.toJson());
            }
            if (this.controlling != null) {
                builder.add("controlling", (JsonValue)this.controlling.toJson());
            }
            if (this.extension != null) {
                builder.add("extension", (JsonValue)this.extension);
            }
        }

        public static final class Role
        extends AbstractConvertibleToJson {
            private String className = null;
            private String resultPort = null;
            private boolean settings = false;
            private boolean main = false;

            public Role() {
            }

            private Role(JsonObject json, Path file) {
                this.className = json.getString("class_name", null);
                this.resultPort = json.getString("result_port", null);
                this.settings = json.getBoolean(ExecutorSpecification.SETTINGS, false);
                this.main = json.getBoolean("main", false);
            }

            public String getClassName() {
                return this.className;
            }

            public Role setClassName(String className) {
                this.className = className;
                return this;
            }

            public String getResultPort() {
                return this.resultPort;
            }

            public Role setResultPort(String resultPort) {
                this.resultPort = resultPort;
                return this;
            }

            public boolean isSettings() {
                return this.settings;
            }

            public Role setSettings(boolean settings) {
                this.settings = settings;
                return this;
            }

            public boolean isMain() {
                return this.main;
            }

            public Role setMain(boolean main) {
                this.main = main;
                return this;
            }

            @Override
            public void checkCompleteness() {
            }

            public boolean equalsClass(String className) {
                if (className == null || this.className == null) {
                    return false;
                }
                return this.className.equals(className);
            }

            public boolean matchesClass(String someEntityName) {
                if (someEntityName == null || this.className == null) {
                    return false;
                }
                return this.className.equals(someEntityName) || this.className.endsWith("." + someEntityName);
            }

            public String toString() {
                return "Role{className='" + this.className + "', resultPort='" + this.resultPort + "', settings=" + this.settings + ", main=" + this.main + "}";
            }

            @Override
            public void buildJson(JsonObjectBuilder builder) {
                if (this.className != null) {
                    builder.add("class_name", this.className);
                }
                if (this.resultPort != null) {
                    builder.add("result_port", this.resultPort);
                }
                builder.add(ExecutorSpecification.SETTINGS, this.settings);
                builder.add("main", this.main);
            }
        }

        public static final class Owner
        extends AbstractConvertibleToJson {
            private String category = null;
            private String name = null;
            private String id = null;
            private String contextId = null;

            public Owner() {
            }

            private Owner(JsonObject json, Path file) {
                this.category = json.getString("category", null);
                this.name = json.getString("name", null);
                this.id = json.getString("id", null);
                this.contextId = json.getString("context_id", null);
            }

            public String getCategory() {
                return this.category;
            }

            public Owner setCategory(String category) {
                this.category = category;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Owner setName(String name) {
                this.name = name;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public Owner setId(String id) {
                this.id = id;
                return this;
            }

            public String getContextId() {
                return this.contextId;
            }

            public Owner setContextId(String contextId) {
                this.contextId = contextId;
                return this;
            }

            @Override
            public void checkCompleteness() {
            }

            public String toString() {
                return "Owner{category='" + this.category + "', name='" + this.name + "', id='" + this.id + "', contextId='" + this.contextId + "'}";
            }

            @Override
            public void buildJson(JsonObjectBuilder builder) {
                if (this.category != null) {
                    builder.add("category", this.category);
                }
                if (this.name != null) {
                    builder.add("name", this.name);
                }
                if (this.id != null) {
                    builder.add("id", this.id);
                }
                if (this.contextId != null) {
                    builder.add("context_id", this.contextId);
                }
            }
        }

        public static final class Service
        extends AbstractConvertibleToJson {
            private String settingsId = null;

            public Service() {
            }

            private Service(JsonObject json, Path file) {
                this.settingsId = json.getString("settings_id", null);
            }

            public String getSettingsId() {
                return this.settingsId;
            }

            public Service setSettingsId(String settingsId) {
                this.settingsId = settingsId;
                return this;
            }

            @Override
            public void checkCompleteness() {
            }

            public String toString() {
                return "Service{settingsId='" + this.settingsId + "'}";
            }

            @Override
            public void buildJson(JsonObjectBuilder builder) {
                if (this.settingsId != null) {
                    builder.add("settings_id", this.settingsId);
                }
            }
        }

        public static final class Behavior
        extends AbstractConvertibleToJson {
            private boolean input = false;
            private boolean output = false;
            private boolean data = false;
            private boolean copy = false;
            private ParameterValueType dataType = null;
            private ControlEditionType editionType = ControlEditionType.VALUE;

            public Behavior() {
            }

            public Behavior(JsonObject json, Path file) {
                String editionType;
                this.input = json.getBoolean("input", false);
                this.output = json.getBoolean("output", false);
                this.data = json.getBoolean("data", false);
                this.copy = json.getBoolean("copy", false);
                String dataType = json.getString("data_type", null);
                if (dataType != null) {
                    this.dataType = ParameterValueType.ofOrNull(dataType);
                    Jsons.requireNonNull(this.dataType, json, "data_type", "unknown (\"" + dataType + "\")", file);
                }
                if ((editionType = json.getString("edition_type", null)) != null) {
                    this.editionType = ControlEditionType.ofOrNull(editionType);
                    Jsons.requireNonNull(this.editionType, json, "edition_type", "unknown (\"" + editionType + "\")", file);
                }
            }

            public boolean isInput() {
                return this.input;
            }

            public Behavior setInput(boolean input) {
                this.input = input;
                return this;
            }

            public boolean isOutput() {
                return this.output;
            }

            public Behavior setOutput(boolean output) {
                this.output = output;
                return this;
            }

            public boolean isData() {
                return this.data;
            }

            public Behavior setData(boolean data) {
                this.data = data;
                return this;
            }

            public boolean isCopy() {
                return this.copy;
            }

            public Behavior setCopy(boolean copy) {
                this.copy = copy;
                return this;
            }

            public ParameterValueType getDataType() {
                return this.dataType;
            }

            public Behavior setDataType(ParameterValueType dataType) {
                this.dataType = dataType;
                return this;
            }

            public ControlEditionType getEditionType() {
                return this.editionType;
            }

            public Behavior setEditionType(ControlEditionType editionType) {
                this.editionType = editionType;
                return this;
            }

            @Override
            public void checkCompleteness() {
            }

            public String toString() {
                return "Behavior{input=" + this.input + ", output=" + this.output + ", data=" + this.data + ", copy=" + this.copy + (String)(this.dataType == null ? "" : ", dataType=" + String.valueOf((Object)this.dataType)) + (String)(this.editionType == null ? "" : ", editionType=" + String.valueOf((Object)this.editionType)) + "}";
            }

            @Override
            public void buildJson(JsonObjectBuilder builder) {
                builder.add("input", this.input);
                builder.add("output", this.output);
                builder.add("data", this.data);
                builder.add("copy", this.copy);
                if (this.dataType != null) {
                    builder.add("data_type", this.dataType.typeName());
                }
                if (this.editionType != null) {
                    builder.add("edition_type", this.editionType.editionTypeName());
                }
            }
        }

        public static final class Controlling
        extends AbstractConvertibleToJson {
            private boolean grouping = false;
            private String groupSelector = null;

            public Controlling() {
            }

            private Controlling(JsonObject json, Path file) {
                this.grouping = json.getBoolean("grouping", false);
                this.groupSelector = json.getString("group_selector", null);
            }

            public boolean isGrouping() {
                return this.grouping;
            }

            public Controlling setGrouping(boolean grouping) {
                this.grouping = grouping;
                return this;
            }

            public String getGroupSelector() {
                return this.groupSelector;
            }

            public Controlling setGroupSelector(String groupSelector) {
                this.groupSelector = groupSelector;
                return this;
            }

            @Override
            public void checkCompleteness() {
            }

            public String toString() {
                return "Controlling{grouping=" + this.grouping + ", groupSelector='" + this.groupSelector + "'}";
            }

            @Override
            public void buildJson(JsonObjectBuilder builder) {
                builder.add("grouping", this.grouping);
                if (this.groupSelector != null) {
                    builder.add("group_selector", this.groupSelector);
                }
            }
        }
    }

    public static final class Java {
        public static final String JAVA_LANGUAGE = "java";
        public static final String JAVA_CONF_NAME = "java";
        public static final String CLASS_PROPERTY_NAME = "class";
        public static final String NEW_INSTANCE_METHOD_PROPERTY_NAME = "new_instance_method";
        private JsonObject json;
        private Path file;
        private String className = null;
        private String newInstanceMethod = null;
        private Class<?> executorClass = null;

        public Java() {
        }

        public Java(JsonObject json, Path file) {
            this.file = file;
            this.setJson(json);
        }

        public JsonObject getJson() {
            return this.json;
        }

        public Java setJson(JsonObject json) {
            this.json = Objects.requireNonNull(json, "Null json");
            this.className = Jsons.reqString(json, CLASS_PROPERTY_NAME, this.file);
            this.newInstanceMethod = json.getString(NEW_INSTANCE_METHOD_PROPERTY_NAME, null);
            this.file = null;
            return this;
        }

        public void setJson(String json) {
            this.setJson(Jsons.toJson(json));
        }

        public String getClassName() {
            return this.className;
        }

        public String getNewInstanceMethod() {
            return this.newInstanceMethod;
        }

        public Class<?> executorClass() {
            this.resolveSupportedExecutor();
            return this.executorClass;
        }

        public void resolveSupportedExecutor() {
            if (this.executorClass == null && this.className != null) {
                try {
                    this.executorClass = Class.forName(this.className);
                }
                catch (ClassNotFoundException e) {
                    throw new JsonException("Invalid JSON" + (String)(this.file == null ? "" : " " + String.valueOf(this.file)) + ": execution block class " + this.className + " not found <<<" + String.valueOf(this.json) + ">>>", (Throwable)e);
                }
            }
        }

        public void checkCompleteness() {
            AbstractConvertibleToJson.checkNull(this.json, "json", this.getClass());
        }

        public JsonObject toJson() {
            this.checkCompleteness();
            return this.json;
        }

        public String toString() {
            return "<<<" + String.valueOf(this.json) + ">>>";
        }

        public static JsonObject standardJson(String className) {
            return Json.createObjectBuilder().add(CLASS_PROPERTY_NAME, className).build();
        }
    }

    public static final class SourceInfo
    extends AbstractConvertibleToJson {
        private String languageName = null;
        private String specificationPath = null;
        private String modulePath = null;

        public SourceInfo() {
        }

        private SourceInfo(JsonObject json, Path file) {
            this.languageName = json.getString("language_name", null);
            this.specificationPath = json.getString("specification_path", null);
            this.modulePath = json.getString("module_path", null);
        }

        public String getLanguageName() {
            return this.languageName;
        }

        public SourceInfo setLanguageName(String languageName) {
            this.languageName = languageName;
            return this;
        }

        public String getSpecificationPath() {
            return this.specificationPath;
        }

        public SourceInfo setSpecificationPath(String specificationPath) {
            this.specificationPath = specificationPath;
            return this;
        }

        public SourceInfo setAbsoluteSpecificationPath(Path specificationPath) {
            return this.setSpecificationPath(specificationPath == null ? null : specificationPath.toAbsolutePath().toString());
        }

        public String getModulePath() {
            return this.modulePath;
        }

        public SourceInfo setModulePath(String modulePath) {
            this.modulePath = modulePath;
            return this;
        }

        public SourceInfo setAbsoluteModulePath(Path modulePath) {
            return this.setModulePath(modulePath == null ? null : modulePath.toAbsolutePath().toString());
        }

        @Override
        public void checkCompleteness() {
        }

        public String toString() {
            return "SourceInfo{languageName='" + this.languageName + "', specificationPath='" + this.specificationPath + "', modulePath='" + this.modulePath + "'}";
        }

        @Override
        public void buildJson(JsonObjectBuilder builder) {
            if (this.languageName != null) {
                builder.add("language_name", this.languageName);
            }
            if (this.specificationPath != null) {
                builder.add("specification_path", this.specificationPath);
            }
            if (this.modulePath != null) {
                builder.add("module_path", this.modulePath);
            }
        }
    }

    public static enum JsonMode {
        FULL,
        MEDIUM,
        CONTROLS_ONLY;


        public boolean isSettingsSectionIncluded() {
            return this == FULL;
        }

        public boolean isTagsIncluded() {
            return this != CONTROLS_ONLY;
        }

        public boolean isOptionsIncluded() {
            return this != CONTROLS_ONLY;
        }

        public boolean isPortsIncluded() {
            return this != CONTROLS_ONLY;
        }
    }
}

