/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.matrices;

import java.util.ArrayList;
import java.util.List;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.ChannelOperation;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesOperation;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.multimatrix.MultiMatrix;

public abstract class SeveralMultiMatricesChannelOperation
extends SeveralMultiMatricesOperation
implements ChannelOperation {
    private int minimalRequiredNumberOfChannels = 0;
    private boolean fillAlphaWithMaxValue = true;
    private MultiMatrix sampleMultiMatrix = null;
    private Class<?> sampleElementType = null;
    private Class<? extends PArray> sampleType = null;
    private int indexOfSampleInputForEqualizing = 0;
    private int currentChannel = 0;
    private int numberOfChannels = 0;

    protected SeveralMultiMatricesChannelOperation(String ... predefinedInputPortNames) {
        super(predefinedInputPortNames);
    }

    public int getMinimalRequiredNumberOfChannels() {
        return this.minimalRequiredNumberOfChannels;
    }

    public SeveralMultiMatricesChannelOperation setMinimalRequiredNumberOfChannels(int minimalRequiredNumberOfChannels) {
        this.minimalRequiredNumberOfChannels = SeveralMultiMatricesChannelOperation.nonNegative(minimalRequiredNumberOfChannels);
        return this;
    }

    public boolean isFillAlphaWithMaxValue() {
        return this.fillAlphaWithMaxValue;
    }

    public SeveralMultiMatricesChannelOperation setFillAlphaWithMaxValue(boolean fillAlphaWithMaxValue) {
        this.fillAlphaWithMaxValue = fillAlphaWithMaxValue;
        return this;
    }

    @Override
    public final int currentChannel() {
        return this.currentChannel;
    }

    @Override
    public final int numberOfChannels() {
        return this.numberOfChannels;
    }

    protected final Class<?> sampleElementType() {
        return this.sampleElementType;
    }

    protected final Class<? extends PArray> sampleType() {
        return this.sampleType;
    }

    protected final MultiMatrix sampleMultiMatrix() {
        return this.sampleMultiMatrix;
    }

    protected final int indexOfSampleInputForEqualizing() {
        return this.indexOfSampleInputForEqualizing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMatrix process(List<MultiMatrix> sources) {
        this.indexOfSampleInputForEqualizing = this.findSampleInputForEqualizing(sources);
        if (this.indexOfSampleInputForEqualizing >= sources.size()) {
            throw new IllegalStateException("Invalid sample input matrix index " + this.indexOfSampleInputForEqualizing);
        }
        this.sampleMultiMatrix = sources.get(this.indexOfSampleInputForEqualizing);
        if (this.sampleMultiMatrix == null) {
            throw new IllegalArgumentException("The input matrix #" + this.indexOfSampleInputForEqualizing + " is not initialized, but it is required");
        }
        try {
            this.numberOfChannels = Math.max(this.sampleMultiMatrix.numberOfChannels(), this.minimalRequiredNumberOfChannels);
            this.sampleElementType = this.sampleMultiMatrix.elementType();
            this.sampleType = this.sampleMultiMatrix.arrayType();
            Class<?> resultElementType = this.sampleMultiMatrix.elementType();
            double resultMax = this.sampleMultiMatrix.maxPossibleValue();
            ArrayList<List<Matrix<? extends PArray>>> sourceMultiMatrices = new ArrayList<List<Matrix<? extends PArray>>>();
            for (MultiMatrix source : sources) {
                List<Matrix<? extends PArray>> channels;
                if (source == null) {
                    channels = null;
                } else {
                    channels = source.asOtherNumberOfChannels(this.numberOfChannels, this.fillAlphaWithMaxValue).allChannels();
                    assert (channels.size() == this.numberOfChannels);
                }
                sourceMultiMatrices.add(channels);
            }
            ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
            boolean equalize = this.equalizePrecision();
            this.currentChannel = 0;
            while (this.currentChannel < this.numberOfChannels) {
                ArrayList<Matrix<? extends PArray>> sourceMatrices = new ArrayList<Matrix<? extends PArray>>();
                for (List list : sourceMultiMatrices) {
                    if (list == null) {
                        sourceMatrices.add(null);
                        continue;
                    }
                    Matrix sourceMatrix = (Matrix)list.get(this.currentChannel);
                    Class elementType = sourceMatrix.elementType();
                    double max = ((PArray)sourceMatrix.array()).maxPossibleValue(1.0);
                    if (equalize && elementType != resultElementType) {
                        sourceMatrix = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{resultMax / max}), this.sampleType, (Matrix)sourceMatrix);
                    }
                    sourceMatrices.add((Matrix<? extends PArray>)sourceMatrix);
                }
                Matrix<? extends PArray> resultChannel = this.processChannel(sourceMatrices);
                result.add(resultChannel);
                ++this.currentChannel;
            }
            MultiMatrix multiMatrix = MultiMatrix.of(result);
            return multiMatrix;
        }
        finally {
            this.sampleMultiMatrix = null;
        }
    }

    protected abstract Matrix<? extends PArray> processChannel(List<Matrix<? extends PArray>> var1);

    protected boolean equalizePrecision() {
        return true;
    }

    protected int findSampleInputForEqualizing(List<MultiMatrix> sources) {
        return 0;
    }
}

