/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.numbers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SNumbers;
import net.algart.math.IRange;

public abstract class SeveralNumbersOperation
extends Executor {
    public static final String INPUT_PORT_PREFIX = "input_";
    public static final String INDEX_IN_BLOCK_ARGUMENT_PREFIX = "indexInBlock";
    private final String[] predefinedInputPortNames;
    private final Map<Integer, Integer> indexInBlock = new HashMap<Integer, Integer>();
    private int lengthInBlock = 0;
    private boolean replaceColumnRangeInInput = false;

    public final int getIndexInBlock(int index) {
        return this.indexInBlock.getOrDefault(index, 0);
    }

    public final SeveralNumbersOperation setIndexInBlock(int index, int indexInBlock) {
        this.indexInBlock.put(index, indexInBlock);
        return this;
    }

    public final int getLengthInBlock() {
        return this.lengthInBlock;
    }

    public final SeveralNumbersOperation setLengthInBlock(int lengthInBlock) {
        this.lengthInBlock = SeveralNumbersOperation.nonNegative(lengthInBlock);
        return this;
    }

    public final boolean isReplaceColumnRangeInInput() {
        return this.replaceColumnRangeInInput;
    }

    public final SeveralNumbersOperation setReplaceColumnRangeInInput(boolean replaceColumnRangeInInput) {
        this.replaceColumnRangeInInput = replaceColumnRangeInInput;
        return this;
    }

    @Override
    public void onChangeParameter(String name) {
        Integer index = this.indexInBlockArgumentNameToInputIndex(name);
        if (index != null) {
            this.setIndexInBlock(index, this.parameters().getInteger(name));
        } else {
            super.onChangeParameter(name);
        }
    }

    protected SeveralNumbersOperation(String ... predefinedInputPortNames) {
        Objects.requireNonNull(predefinedInputPortNames, "Null predefinedInputPortNames");
        this.predefinedInputPortNames = (String[])predefinedInputPortNames.clone();
        for (String port : predefinedInputPortNames) {
            this.addInputNumbers(port);
        }
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    @Override
    public void process() {
        Integer requiredNumberOfInputs = this.requiredNumberOfInputs();
        ArrayList<SNumbers> sourceList = new ArrayList<SNumbers>();
        for (int k = 0; requiredNumberOfInputs == null || k < requiredNumberOfInputs; ++k) {
            String portName = this.inputPortName(k);
            if (requiredNumberOfInputs == null && !this.hasInputPort(portName)) break;
            sourceList.add(this.getInputNumbers(portName, this.allowUninitializedInput(k)));
        }
        this.setStartProcessingTimeStamp();
        SNumbers result = this.process(sourceList.toArray(new SNumbers[0]));
        this.setEndProcessingTimeStamp();
        this.getNumbers().exchange(result);
    }

    public final SNumbers process(SNumbers ... inputs) {
        Objects.requireNonNull(inputs, "Null inputs array");
        Integer requiredNumberOfInputs = this.requiredNumberOfInputs();
        int n = Math.max(inputs.length, requiredNumberOfInputs == null ? 0 : requiredNumberOfInputs);
        Integer requiredBlockLength = this.requiredBlockLength();
        boolean blockLengthEqualityRequired = this.blockLengthEqualityRequired() || requiredBlockLength != null;
        ArrayList<SNumbers> inputList = new ArrayList<SNumbers>();
        int firstBlockLength = -1;
        int firstNumberOfBlocks = -1;
        SNumbers firstInputWithRange = null;
        IRange firstInputRange = null;
        for (int k = 0; k < n; ++k) {
            SNumbers input;
            SNumbers sNumbers = input = k < inputs.length ? inputs[k] : null;
            if (input == null || !input.isInitialized()) {
                inputList.add(null);
                continue;
            }
            IRange columnRange = this.selectedColumnRange(k);
            if (columnRange != null) {
                if (firstInputWithRange == null) {
                    firstInputWithRange = input;
                    firstInputRange = columnRange;
                }
                input = input.columnRange((int)columnRange.min(), (int)columnRange.size());
            }
            if (firstBlockLength == -1) {
                firstBlockLength = input.getBlockLength();
                if (requiredBlockLength != null && firstBlockLength != requiredBlockLength) {
                    throw new IllegalArgumentException("Illegal block length in source number arrays: " + firstBlockLength + " != " + requiredBlockLength + " (required block length)");
                }
                firstNumberOfBlocks = input.n();
            } else {
                if (firstBlockLength != input.getBlockLength() && blockLengthEqualityRequired) {
                    throw new IllegalArgumentException("Different block length in source number arrays: " + input.getBlockLength() + " != " + firstBlockLength);
                }
                if (firstNumberOfBlocks != input.n() && this.numberOfBlocksEqualityRequired()) {
                    throw new IllegalArgumentException("Different lengths of source number arrays: " + input.n() + " != " + firstNumberOfBlocks);
                }
            }
            inputList.add(input);
        }
        if (firstBlockLength == -1 && !this.allowAllUninitializedInputs()) {
            throw new IllegalArgumentException("No initialized input arrays");
        }
        SNumbers result = this.processNumbers(inputList);
        if (this.replaceColumnRangeInInput() && firstInputWithRange != null) {
            assert (firstBlockLength != -1);
            SNumbers corrected = firstInputWithRange.toPrecision(result.elementType());
            corrected.replaceColumnRange((int)firstInputRange.min(), result, 0, firstBlockLength);
            result = corrected;
        }
        return result;
    }

    protected abstract SNumbers processNumbers(List<SNumbers> var1);

    protected Integer requiredNumberOfInputs() {
        return this.predefinedInputPortNames.length == 0 ? null : Integer.valueOf(this.predefinedInputPortNames.length);
    }

    protected boolean allowUninitializedInput(int inputIndex) {
        return true;
    }

    protected boolean allowAllUninitializedInputs() {
        return false;
    }

    protected String inputPortName(int inputIndex) {
        return inputIndex < this.predefinedInputPortNames.length ? this.predefinedInputPortNames[inputIndex] : INPUT_PORT_PREFIX + (inputIndex + 1);
    }

    protected String indexInBlockArgumentName(int inputIndex) {
        Object port;
        if (inputIndex < this.predefinedInputPortNames.length && (port = this.predefinedInputPortNames[inputIndex]) != null) {
            if (((String)port).length() > 0) {
                port = ((String)port).substring(0, 1).toUpperCase() + ((String)port).substring(1);
            }
            return INDEX_IN_BLOCK_ARGUMENT_PREFIX + (String)port;
        }
        return INDEX_IN_BLOCK_ARGUMENT_PREFIX + (inputIndex + 1);
    }

    protected Integer indexInBlockArgumentNameToInputIndex(String argumentName) {
        if (argumentName == null) {
            return null;
        }
        for (int k = 0; k < this.predefinedInputPortNames.length; ++k) {
            if (!argumentName.equals(this.indexInBlockArgumentName(k))) continue;
            return k;
        }
        if (argumentName.startsWith(INDEX_IN_BLOCK_ARGUMENT_PREFIX)) {
            try {
                return Integer.parseInt(argumentName.substring(INDEX_IN_BLOCK_ARGUMENT_PREFIX.length())) - 1;
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return null;
    }

    protected boolean numberOfBlocksEqualityRequired() {
        return true;
    }

    protected boolean blockLengthEqualityRequired() {
        return true;
    }

    protected Integer requiredBlockLength() {
        return null;
    }

    protected IRange selectedColumnRange(int inputIndex) {
        if (this.lengthInBlock <= 0) {
            return null;
        }
        int start = this.getIndexInBlock(inputIndex);
        return IRange.valueOf((long)start, (long)(start + this.lengthInBlock - 1));
    }

    protected boolean replaceColumnRangeInInput() {
        return this.replaceColumnRangeInInput;
    }
}

