/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.files;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public enum FileSortOrder {
    STANDARD(Collections::sort),
    SUBDIRECTORIES_FIRST(paths -> paths.sort((o1, o2) -> {
        boolean file2;
        boolean file1 = Files.isRegularFile(o1, new LinkOption[0]);
        return file1 != (file2 = Files.isRegularFile(o2, new LinkOption[0])) ? (file2 ? -1 : 1) : o1.compareTo((Path)o2);
    })),
    SUBDIRECTORIES_LAST(paths -> paths.sort((o1, o2) -> {
        boolean file2;
        boolean file1 = Files.isRegularFile(o1, new LinkOption[0]);
        return file1 != (file2 = Files.isRegularFile(o2, new LinkOption[0])) ? (file1 ? -1 : 1) : o1.compareTo((Path)o2);
    }));

    private final Consumer<List<Path>> sorter;

    private FileSortOrder(Consumer<List<Path>> sorter) {
        this.sorter = sorter;
    }

    public void sort(List<Path> files) {
        Objects.requireNonNull(files, "Null files");
        this.sorter.accept(files);
    }
}

