/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.logic.ifelse.numbers;

import net.algart.executors.api.Executor;
import net.algart.executors.api.data.Port;
import net.algart.executors.modules.core.logic.ConditionStyle;

public final class IfScalarThenNumbers
extends Executor {
    public static final String INPUT_CONDITION = "if";
    public static final String INPUT_PORT_FALSE = "false";
    public static final String INPUT_PORT_TRUE = "true";
    public static final String OUTPUT_CONDITION = "if";
    private ConditionStyle conditionStyle = ConditionStyle.JAVA_LIKE;
    private boolean defaultCondition = false;
    private boolean requireInput = true;

    public IfScalarThenNumbers() {
        this.addInputScalar("if");
        this.addInputNumbers(INPUT_PORT_FALSE);
        this.addInputNumbers(INPUT_PORT_TRUE);
        this.addOutputScalar("if");
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public ConditionStyle getConditionStyle() {
        return this.conditionStyle;
    }

    public IfScalarThenNumbers setConditionStyle(ConditionStyle conditionStyle) {
        this.conditionStyle = IfScalarThenNumbers.nonNull(conditionStyle);
        return this;
    }

    public boolean isDefaultCondition() {
        return this.defaultCondition;
    }

    public IfScalarThenNumbers setDefaultCondition(boolean defaultCondition) {
        this.defaultCondition = defaultCondition;
        return this;
    }

    public boolean isRequireInput() {
        return this.requireInput;
    }

    public IfScalarThenNumbers setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    @Override
    public void process() {
        boolean condition = this.condition();
        this.getNumbers().exchange(this.getInputNumbers(IfScalarThenNumbers.portName(condition), !this.requireInput));
        this.getScalar("if").setTo(condition);
    }

    @Override
    public Boolean checkInputNecessary(Port inputPort) {
        if (inputPort == null) {
            return null;
        }
        String inputPortName = inputPort.getName();
        if ("if".equals(inputPortName)) {
            return null;
        }
        return IfScalarThenNumbers.portName(this.condition()).equals(inputPortName);
    }

    public boolean condition() {
        String conditionString = this.getInputScalar("if", true).getValue();
        return this.conditionStyle.toBoolean(conditionString, this.defaultCondition);
    }

    private static String portName(boolean condition) {
        return condition ? INPUT_PORT_TRUE : INPUT_PORT_FALSE;
    }
}

