/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.logic.ifelse.scalars;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SScalar;

public final class SwitchScalar
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_SELECTOR = "selector_input";
    public static final String INPUT_PORT_PREFIX = "x";
    private int selector = 0;
    private boolean requireInput = true;

    public SwitchScalar() {
        this.addInputScalar(INPUT_SELECTOR);
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public int getSelector() {
        return this.selector;
    }

    public SwitchScalar setSelector(int selector) {
        this.selector = SwitchScalar.nonNegative(selector);
        return this;
    }

    public boolean isRequireInput() {
        return this.requireInput;
    }

    public SwitchScalar setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    @Override
    public void process() {
        int selector = SwitchScalar.nonNegative(this.selector(), "selector index");
        this.getScalar().setTo(selector == 0 ? this.firstInitialized() : this.getInputScalar(this.portName(selector), !this.requireInput));
    }

    @Override
    public Boolean checkInputNecessary(Port inputPort) {
        if (inputPort == null) {
            return null;
        }
        String inputPortName = inputPort.getName();
        if (INPUT_SELECTOR.equals(inputPortName)) {
            return null;
        }
        int selector = this.selector();
        return selector == 0 || this.portName(selector).equals(inputPortName);
    }

    public int selector() {
        String inputSelector = this.getInputScalar(INPUT_SELECTOR, true).getValue();
        return inputSelector != null && !inputSelector.isEmpty() ? Integer.parseInt(inputSelector) : this.selector;
    }

    private SScalar firstInitialized() {
        int k = 1;
        while (true) {
            String portName;
            if (!this.hasInputPort(portName = this.portName(k))) {
                throw new IllegalArgumentException("No initialized input scalar found");
            }
            SScalar data = this.getInputScalar(portName, true);
            if (data.isInitialized()) {
                return data;
            }
            ++k;
        }
    }

    private String portName(int index) {
        return INPUT_PORT_PREFIX + index;
    }
}

