/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.arithmetic;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import net.algart.arrays.Arrays;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.OptionalArguments;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesChannelOperation;
import net.algart.executors.modules.core.scalars.arithmetic.ProductOfTwoPowers;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.functions.PowerFunc;

public final class MatrixSumOfPowers
extends SeveralMultiMatricesChannelOperation {
    private double power = 2.0;
    private double powerOfSum = 0.5;
    private Mode mode = Mode.SUM;
    private double customDividerOfSum = 1.0;

    public MatrixSumOfPowers() {
        super(new String[0]);
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    public void setPower(String power) {
        this.setPower(ProductOfTwoPowers.smartParseDouble(power));
    }

    public double getPowerOfSum() {
        return this.powerOfSum;
    }

    public void setPowerOfSum(double powerOfSum) {
        this.powerOfSum = powerOfSum;
    }

    public void setPowerOfSum(String powerOfSum) {
        this.setPowerOfSum(ProductOfTwoPowers.smartParseDouble(powerOfSum));
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = MatrixSumOfPowers.nonNull(mode);
    }

    public double getCustomDividerOfSum() {
        return this.customDividerOfSum;
    }

    public void setCustomDividerOfSum(double customDividerOfSum) {
        this.customDividerOfSum = customDividerOfSum;
    }

    @Override
    protected Matrix<? extends PArray> processChannel(List<Matrix<? extends PArray>> m) {
        double scale = Arrays.maxPossibleValue(this.sampleType(), (double)1.0);
        List<Matrix<? extends PArray>> nonNull = new OptionalArguments<Matrix<? extends PArray>>(m).extract();
        int n = nonNull.size();
        PowerFunc powerFunc = PowerFunc.getInstance((double)this.power, (double)(1.0 / StrictMath.pow(scale, this.power)));
        double mult = this.mode == Mode.SUM ? 1.0 : (this.mode == Mode.MEAN ? 1.0 / (double)n : 1.0 / this.customDividerOfSum);
        LinearFunc averagingFunc = LinearFunc.getInstance((double)0.0, (double[])DoubleStream.generate(() -> mult).limit(n).toArray());
        PowerFunc sumPowerFunc = PowerFunc.getInstance((double)this.powerOfSum, (double)scale);
        if (this.currentChannel() == 0) {
            MatrixSumOfPowers.logDebug(() -> "Sum of powers ((m1^" + this.power + "+...+mN^" + this.power + ") * " + mult + ")^" + this.powerOfSum + ", N=" + n + " for matrices " + this.numberOfChannels() + "x" + ((Matrix)nonNull.get(0)).dimX() + "x" + ((Matrix)nonNull.get(0)).dimY());
        }
        List powered = nonNull.stream().map(matrix -> Matrices.asFuncMatrix((Func)powerFunc, DoubleArray.class, (Matrix)matrix)).collect(Collectors.toList());
        Matrix sum = Matrices.asFuncMatrix((Func)averagingFunc, DoubleArray.class, powered);
        return Matrices.clone((Matrix)Matrices.asFuncMatrix((Func)sumPowerFunc, this.sampleType(), (Matrix)sum));
    }

    public static enum Mode {
        SUM,
        MEAN,
        CUSTOM_DIVIDER;

    }
}

