/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import java.util.ArrayList;
import java.util.List;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.core.common.ChannelOperation;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesOperation;
import net.algart.multimatrix.MultiMatrix;

public final class ApplyMask
extends SeveralMultiMatricesOperation {
    public static final String INPUT_MASK = "mask";
    private MaskingMode maskingMode = MaskingMode.FILL_BACKGROUND;
    private String filler = "0";

    public ApplyMask() {
        super(DEFAULT_INPUT_PORT, INPUT_MASK);
    }

    public MaskingMode getMaskingMode() {
        return this.maskingMode;
    }

    public ApplyMask setMaskingMode(MaskingMode maskingMode) {
        this.maskingMode = ApplyMask.nonNull(maskingMode);
        return this;
    }

    public String getFiller() {
        return this.filler;
    }

    public ApplyMask setFiller(String filler) {
        this.filler = ApplyMask.nonEmpty(filler);
        return this;
    }

    @Override
    public MultiMatrix process(List<MultiMatrix> sources) {
        MultiMatrix source = sources.get(0);
        MultiMatrix mask = sources.get(1);
        if (mask == null) {
            return source;
        }
        source.checkDimensionEquality(mask, "source", INPUT_MASK);
        BitArray maskArray = (BitArray)mask.nonZeroRGBMatrix().array();
        ArrayList<Matrix> result = new ArrayList<Matrix>();
        double maxPossibleValue = source.maxPossibleValue();
        int n = source.numberOfChannels();
        for (int k = 0; k < n; ++k) {
            Matrix<? extends PArray> m = source.channel(k);
            Matrix clone = Matrices.clone(m);
            double filler = ChannelOperation.colorChannel(this.filler, maxPossibleValue, k, n);
            switch (this.maskingMode.ordinal()) {
                case 0: {
                    Arrays.unpackZeroBits((UpdatablePArray)((UpdatablePArray)clone.array()), (BitArray)maskArray, (double)filler);
                    break;
                }
                case 1: {
                    Arrays.unpackUnitBits((UpdatablePArray)((UpdatablePArray)clone.array()), (BitArray)maskArray, (double)filler);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported mode " + String.valueOf((Object)this.maskingMode)));
                }
            }
            result.add(clone);
        }
        return MultiMatrix.of(result);
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex >= 1;
    }

    public static enum MaskingMode {
        FILL_BACKGROUND,
        FILL_FOREGROUND;

    }
}

