/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.OptionalArguments;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesOperation;
import net.algart.multimatrix.MultiMatrix;

public final class MergeChannelsGroups
extends SeveralMultiMatricesOperation {
    private boolean requireInput = true;
    private ResultElementType resultElementType = ResultElementType.FIRST_INPUT;

    public MergeChannelsGroups() {
        super(new String[0]);
    }

    public boolean isRequireInput() {
        return this.requireInput;
    }

    public MergeChannelsGroups setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    public ResultElementType getResultElementType() {
        return this.resultElementType;
    }

    public void setResultElementType(ResultElementType resultElementType) {
        this.resultElementType = MergeChannelsGroups.nonNull(resultElementType);
    }

    @Override
    public MultiMatrix process(List<MultiMatrix> sources) {
        Objects.requireNonNull(sources, "Null sources");
        sources = new OptionalArguments<MultiMatrix>(sources).extract();
        if (sources.isEmpty()) {
            if (this.requireInput) {
                throw new IllegalArgumentException("No source matrices");
            }
            return null;
        }
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
        Class<?> firstElementType = null;
        for (MultiMatrix source : sources) {
            if (firstElementType == null) {
                firstElementType = source.elementType();
            }
            switch (this.resultElementType.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    source = source.asPrecision(firstElementType);
                    break;
                }
                default: {
                    source = source.asPrecision(this.resultElementType.elementType);
                }
            }
            result.addAll(source.allChannels());
        }
        return MultiMatrix.of(result);
    }

    @Override
    protected boolean resultRequired() {
        return false;
    }

    public static enum ResultElementType {
        REQUIRE_IDENTICAL(null),
        FIRST_INPUT(null),
        INT(Integer.TYPE),
        FLOAT(Float.TYPE),
        DOUBLE(Double.TYPE);

        final Class<?> elementType;

        private ResultElementType(Class<?> elementType) {
            this.elementType = elementType;
        }
    }
}

