/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.io;

import java.util.List;
import java.util.Locale;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.api.LogLevel;
import net.algart.executors.modules.core.common.matrices.MultiMatrixToScalar;
import net.algart.executors.modules.core.scalars.io.WriteScalar;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;

public final class PrintSubMatrix
extends MultiMatrixToScalar {
    private static final int MAX_STRING_LENGTH = 50000;
    private long startX = 0L;
    private long startY = 0L;
    private long startZ = 0L;
    private long sizeX = 100L;
    private long sizeY = 100L;
    private long sizeZ = 1L;
    private boolean printLineIndexes = true;
    private String delimiter = " ";
    private String format = "%3s";
    private LogLevel logLevel = LogLevel.INFO;
    private String file = "";

    public long getStartX() {
        return this.startX;
    }

    public PrintSubMatrix setStartX(long startX) {
        this.startX = PrintSubMatrix.nonNegative(startX);
        return this;
    }

    public long getStartY() {
        return this.startY;
    }

    public PrintSubMatrix setStartY(long startY) {
        this.startY = PrintSubMatrix.nonNegative(startY);
        return this;
    }

    public long getStartZ() {
        return this.startZ;
    }

    public PrintSubMatrix setStartZ(long startZ) {
        this.startZ = startZ;
        return this;
    }

    public long getSizeX() {
        return this.sizeX;
    }

    public PrintSubMatrix setSizeX(long sizeX) {
        this.sizeX = PrintSubMatrix.positive(sizeX);
        return this;
    }

    public long getSizeY() {
        return this.sizeY;
    }

    public PrintSubMatrix setSizeY(long sizeY) {
        this.sizeY = PrintSubMatrix.positive(sizeY);
        return this;
    }

    public long getSizeZ() {
        return this.sizeZ;
    }

    public PrintSubMatrix setSizeZ(long sizeZ) {
        this.sizeZ = sizeZ;
        return this;
    }

    public boolean isPrintLineIndexes() {
        return this.printLineIndexes;
    }

    public PrintSubMatrix setPrintLineIndexes(boolean printLineIndexes) {
        this.printLineIndexes = printLineIndexes;
        return this;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public PrintSubMatrix setDelimiter(String delimiter) {
        this.delimiter = PrintSubMatrix.nonNull(delimiter);
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public PrintSubMatrix setFormat(String format) {
        this.format = PrintSubMatrix.nonNull(format);
        return this;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public PrintSubMatrix setLogLevel(LogLevel logLevel) {
        this.logLevel = PrintSubMatrix.nonNull(logLevel);
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public PrintSubMatrix setFile(String file) {
        this.file = PrintSubMatrix.nonNull(file);
        return this;
    }

    @Override
    public Object process(MultiMatrix source) {
        StringBuilder sb = new StringBuilder();
        if (source == null) {
            sb.append("No input matrix");
        } else {
            List<Matrix<? extends PArray>> sourceChannels = source.allChannels();
            long sizeX = Math.min(this.sizeX, Math.max(0L, source.dim(0) - this.startX));
            long sizeY = Math.min(this.sizeY, Math.max(0L, source.dim(1) - this.startY));
            long sizeZ = Math.min(this.sizeZ, Math.max(0L, source.dim(2) - this.startZ));
            sb.append(String.format("Printing matrix elements %dx%dx%d from (%d,%d,%d) for %s%n", sizeX, sizeY, sizeZ, this.startX, this.startY, this.startZ, source));
            for (int k = 0; k < sourceChannels.size(); ++k) {
                sb.append(String.format("Channel #%d:%n", k));
                Matrix channel = sourceChannels.get(k);
                if (source.bitsPerElement() <= 16) {
                    channel = Matrices.asFuncMatrix((Func)Func.IDENTITY, IntArray.class, channel);
                }
                long[] position = new long[channel.dimCount()];
                long[] sizes = new long[position.length];
                JArrays.fill((long[])sizes, (long)1L);
                position[0] = this.startX;
                sizes[0] = sizeX;
                int z = 0;
                while ((long)z < sizeZ) {
                    if (source.dim(2) > 1L) {
                        sb.append(String.format("z=%d:%n", this.startZ + (long)z));
                    }
                    if (position.length >= 3) {
                        position[2] = this.startZ + (long)z;
                    }
                    for (long y = 0L; y < sizeY; ++y) {
                        Array array;
                        Object javaArray;
                        if (position.length >= 2) {
                            position[1] = this.startY + y;
                        }
                        if (this.printLineIndexes) {
                            sb.append(String.format(Locale.US, "  y=%d: ", this.startY + y));
                        }
                        String s = (javaArray = (array = channel.subMatr(position, sizes, Matrix.ContinuationMode.NAN_CONSTANT).array()).ja()) instanceof int[] ? JArrays.toString((int[])((int[])javaArray), (Locale)Locale.US, (String)this.format, (String)this.delimiter, (int)50000) : (javaArray instanceof long[] ? JArrays.toString((long[])((long[])javaArray), (Locale)Locale.US, (String)this.format, (String)this.delimiter, (int)50000) : (javaArray instanceof float[] ? JArrays.toString((float[])((float[])javaArray), (Locale)Locale.US, (String)this.format, (String)this.delimiter, (int)50000) : (javaArray instanceof double[] ? JArrays.toString((double[])((double[])javaArray), (Locale)Locale.US, (String)this.format, (String)this.delimiter, (int)50000) : Arrays.toString((Array)array, (String)this.delimiter, (int)50000))));
                        sb.append(s).append(String.format("%n", new Object[0]));
                    }
                    ++z;
                }
            }
        }
        String result = sb.toString();
        this.logLevel.log(result);
        if (!this.file.isEmpty()) {
            WriteScalar.getInstance().setFile(this.file).writeString(result);
        }
        return result;
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }
}

