/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.misc;

import net.algart.arrays.Histogram;
import net.algart.math.Range;

public enum LimitInterpretation {
    ABSOLUTE_VALUE(false, false){

        @Override
        public double translateLimit(double limit, Range range, double scale, long[] histogram) {
            return limit * scale;
        }
    }
    ,
    VALUE_BETWEEN_MIN_AND_MAX(true, false){

        @Override
        public double translateLimit(double limit, Range range, double scale, long[] histogram) {
            return range.min() + limit * range.size();
        }
    }
    ,
    PERCENTILE_BETWEEN_MIN_AND_MAX(true, true){

        @Override
        public double translateLimit(double limit, Range range, double scale, long[] histogram) {
            long sum = Histogram.sumOf((long[])histogram);
            return range.min() + Histogram.percentile((long[])histogram, (long)sum, (double)limit) * range.size() / ((double)histogram.length - 1.0);
        }
    };

    private final boolean useRange;
    private final boolean useHistogram;

    private LimitInterpretation(boolean useRange, boolean useHistogram) {
        this.useRange = useRange;
        this.useHistogram = useHistogram;
    }

    public abstract double translateLimit(double var1, Range var3, double var4, long[] var6);

    public boolean isUseRange() {
        return this.useRange;
    }

    public boolean isUseHistogram() {
        return this.useHistogram;
    }
}

