/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import java.util.Locale;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;

public final class ExtractNumbersColumns
extends Executor
implements ReadOnlyExecutionInput {
    private int indexInBlock = 0;
    private int lengthInBlock = 1;

    public ExtractNumbersColumns() {
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public int getIndexInBlock() {
        return this.indexInBlock;
    }

    public ExtractNumbersColumns setIndexInBlock(int indexInBlock) {
        this.indexInBlock = ExtractNumbersColumns.nonNegative(indexInBlock);
        return this;
    }

    public int getLengthInBlock() {
        return this.lengthInBlock;
    }

    public ExtractNumbersColumns setLengthInBlock(int lengthInBlock) {
        this.lengthInBlock = ExtractNumbersColumns.nonNegative(lengthInBlock);
        return this;
    }

    @Override
    public void process() {
        SNumbers source = this.getInputNumbers();
        int lengthInBlock = this.lengthInBlock != 0 ? this.lengthInBlock : Math.max(1, source.getBlockLength() - this.indexInBlock);
        long t1 = ExtractNumbersColumns.debugTime();
        this.getNumbers().setToColumnRange(source, this.indexInBlock, lengthInBlock);
        long t2 = ExtractNumbersColumns.debugTime();
        ExtractNumbersColumns.logDebug(() -> String.format(Locale.US, "Extracting column%s (elements #%d%s from each block) of number array %s: %.3f ms (%.1f ns/block)", lengthInBlock == 1 ? "" : "s", this.indexInBlock, lengthInBlock == 1 ? "" : ".." + (this.indexInBlock + lengthInBlock - 1), source, (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / (double)source.n()));
    }
}

