/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.json.Jsons;

public final class NumbersToJson
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_KEYS = "keys";
    public static final String OUTPUT_JSON = "json";
    private JsonValueType jsonValueType = JsonValueType.DOUBLE;
    private double startValue = 1.0;
    private double increment = 1.0;

    public NumbersToJson() {
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addInputScalar(INPUT_KEYS);
        this.setDefaultOutputScalar(OUTPUT_JSON);
    }

    public JsonValueType getJsonValueType() {
        return this.jsonValueType;
    }

    public NumbersToJson setJsonValueType(JsonValueType jsonValueType) {
        this.jsonValueType = NumbersToJson.nonNull(jsonValueType);
        return this;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public NumbersToJson setStartValue(double startValue) {
        this.startValue = startValue;
        return this;
    }

    public double getIncrement() {
        return this.increment;
    }

    public NumbersToJson setIncrement(double increment) {
        this.increment = increment;
        return this;
    }

    @Override
    public void process() {
        SNumbers numbers = this.getInputNumbers(true);
        String[] keys = this.getInputScalar(INPUT_KEYS).toTrimmedLinesWithoutCommentsArray();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        int n = numbers.getArrayLength();
        double currentValue = this.startValue;
        int index = 0;
        for (String key : keys) {
            double value = index < n ? numbers.getValue(index) : currentValue;
            this.jsonValueType.add(builder, key, value);
            ++index;
            currentValue += this.increment;
        }
        JsonObject result = builder.build();
        this.getScalar(OUTPUT_JSON).setTo(Jsons.toPrettyString(result));
    }

    public static enum JsonValueType {
        DOUBLE{

            @Override
            void add(JsonObjectBuilder builder, String key, double value) {
                builder.add(key, value);
            }
        }
        ,
        INTEGER{

            @Override
            void add(JsonObjectBuilder builder, String key, double value) {
                builder.add(key, Math.round(value));
            }
        }
        ,
        BOOLEAN{

            @Override
            void add(JsonObjectBuilder builder, String key, double value) {
                builder.add(key, value != 0.0);
            }
        }
        ,
        STRING{

            @Override
            void add(JsonObjectBuilder builder, String key, double value) {
                long longValue = (long)value;
                builder.add(key, value == (double)longValue ? String.valueOf(longValue) : String.valueOf(value));
            }
        };


        abstract void add(JsonObjectBuilder var1, String var2, double var3);
    }
}

