/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;

public final class SplitNumbersColumns
extends Executor
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_PORT_PREFIX = "output_";
    private boolean requireInput = true;

    public SplitNumbersColumns() {
        this.useVisibleResultParameter();
        this.addInputNumbers(DEFAULT_INPUT_PORT);
    }

    public boolean isRequireInput() {
        return this.requireInput;
    }

    public SplitNumbersColumns setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    @Override
    public void process() {
        SNumbers numbers = this.getInputNumbers(!this.requireInput);
        if (!numbers.isInitialized()) {
            return;
        }
        int m = numbers.getBlockLength();
        for (int k = 0; k < m; ++k) {
            String portName = this.outputPortName(k);
            if (!this.isOutputNecessary(portName)) continue;
            this.getNumbers(portName).setTo(numbers.column(k));
        }
    }

    private String outputPortName(int outputIndex) {
        return OUTPUT_PORT_PREFIX + (outputIndex + 1);
    }
}

