/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.creation;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;

public final class CreateIntegerRectangle
extends Executor
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_SIZE_X = "size_x";
    public static final String OUTPUT_SIZE_Y = "size_y";
    private long minX = -4611686018427387903L;
    private long maxX = 0x3FFFFFFFFFFFFFFFL;
    private Long sizeX = null;
    private long minY = -4611686018427387903L;
    private long maxY = 0x3FFFFFFFFFFFFFFFL;
    private Long sizeY = null;

    public CreateIntegerRectangle() {
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public long getMinX() {
        return this.minX;
    }

    public CreateIntegerRectangle setMinX(long minX) {
        this.minX = minX;
        return this;
    }

    public CreateIntegerRectangle setMinX(String minX) {
        return this.setMinX(CreateIntegerRectangle.longOrDefault(minX, -4611686018427387903L));
    }

    public long getMaxX() {
        return this.maxX;
    }

    public CreateIntegerRectangle setMaxX(long maxX) {
        this.maxX = maxX;
        return this;
    }

    public CreateIntegerRectangle setMaxX(String maxX) {
        return this.setMaxX(CreateIntegerRectangle.longOrDefault(maxX, 0x3FFFFFFFFFFFFFFFL));
    }

    public Long getSizeX() {
        return this.sizeX;
    }

    public CreateIntegerRectangle setSizeX(Long sizeX) {
        this.sizeX = sizeX;
        return this;
    }

    public long getMinY() {
        return this.minY;
    }

    public CreateIntegerRectangle setMinY(long minY) {
        this.minY = minY;
        return this;
    }

    public CreateIntegerRectangle setMinY(String minY) {
        return this.setMinY(CreateIntegerRectangle.longOrDefault(minY, -4611686018427387903L));
    }

    public long getMaxY() {
        return this.maxY;
    }

    public CreateIntegerRectangle setMaxY(long maxY) {
        this.maxY = maxY;
        return this;
    }

    public CreateIntegerRectangle setMaxY(String maxY) {
        return this.setMaxY(CreateIntegerRectangle.longOrDefault(maxY, 0x3FFFFFFFFFFFFFFFL));
    }

    public Long getSizeY() {
        return this.sizeY;
    }

    public CreateIntegerRectangle setSizeY(Long sizeY) {
        this.sizeY = sizeY;
        return this;
    }

    @Override
    public void process() {
        SNumbers input = this.getInputNumbers(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            CreateIntegerRectangle.logDebug(() -> "Copying number array: " + String.valueOf(input));
            this.getNumbers().setTo(input);
        } else {
            this.getNumbers().exchange(this.rectangularArea());
        }
    }

    SNumbers rectangularArea() {
        long x1 = this.minX;
        long x2 = this.maxX;
        if (this.sizeX != null) {
            x2 = x1 + this.sizeX - 1L;
        }
        IRange rangeX = IRange.valueOf((long)x1, (long)x2);
        this.getScalar(OUTPUT_SIZE_X).setTo(rangeX.size());
        long y1 = this.minY;
        long y2 = this.maxY;
        if (this.sizeY != null) {
            y2 = y1 + this.sizeY - 1L;
        }
        IRange rangeY = IRange.valueOf((long)y1, (long)y2);
        this.getScalar(OUTPUT_SIZE_Y).setTo(rangeY.size());
        return SNumbers.of(IRectangularArea.valueOf((IRange[])new IRange[]{rangeX, rangeY}));
    }
}

