/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.io;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.io.WriteFileOperation;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.json.Jsons;

public final class WriteRawNumbers
extends WriteFileOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_COLUMN_NAMES = "column_names";
    public static final String METADATA_FILE_SUFFIX = ".meta";
    private boolean requireInput = false;
    private boolean clearFileOnReset = false;
    private boolean appendToExistingFile = false;
    private boolean deleteFileIfNonInitialized = false;
    private String copyOfPreviousFileIfNonInitialized = "";
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private boolean writeMetadataFile = false;
    private IndexingBase columnsIndexingBaseInMetadata = IndexingBase.ZERO_BASED;
    private String columnNames = "";

    public WriteRawNumbers() {
        this.addFileOperationPorts();
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addInputScalar(INPUT_COLUMN_NAMES);
    }

    public static WriteRawNumbers getInstance() {
        return new WriteRawNumbers();
    }

    @Override
    public WriteRawNumbers setFile(String file) {
        super.setFile(file);
        return this;
    }

    public boolean requireInput() {
        return this.requireInput;
    }

    public WriteRawNumbers setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    public boolean isClearFileOnReset() {
        return this.clearFileOnReset;
    }

    public WriteRawNumbers setClearFileOnReset(boolean clearFileOnReset) {
        this.clearFileOnReset = clearFileOnReset;
        return this;
    }

    public boolean isAppendToExistingFile() {
        return this.appendToExistingFile;
    }

    public WriteRawNumbers setAppendToExistingFile(boolean appendToExistingFile) {
        this.appendToExistingFile = appendToExistingFile;
        return this;
    }

    public boolean isDeleteFileIfNonInitialized() {
        return this.deleteFileIfNonInitialized;
    }

    public WriteRawNumbers setDeleteFileIfNonInitialized(boolean deleteFileIfNonInitialized) {
        this.deleteFileIfNonInitialized = deleteFileIfNonInitialized;
        return this;
    }

    public String getCopyOfPreviousFileIfNonInitialized() {
        return this.copyOfPreviousFileIfNonInitialized;
    }

    public WriteRawNumbers setCopyOfPreviousFileIfNonInitialized(String copyOfPreviousFileIfNonInitialized) {
        this.copyOfPreviousFileIfNonInitialized = WriteRawNumbers.nonNull(copyOfPreviousFileIfNonInitialized);
        return this;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public WriteRawNumbers setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = WriteRawNumbers.nonNull(byteOrder);
        return this;
    }

    public boolean isWriteMetadataFile() {
        return this.writeMetadataFile;
    }

    public WriteRawNumbers setWriteMetadataFile(boolean writeMetadataFile) {
        this.writeMetadataFile = writeMetadataFile;
        return this;
    }

    public IndexingBase getColumnsIndexingBaseInMetadata() {
        return this.columnsIndexingBaseInMetadata;
    }

    public WriteRawNumbers setColumnsIndexingBaseInMetadata(IndexingBase columnsIndexingBaseInMetadata) {
        this.columnsIndexingBaseInMetadata = WriteRawNumbers.nonNull(columnsIndexingBaseInMetadata);
        return this;
    }

    public String getColumnNames() {
        return this.columnNames;
    }

    public WriteRawNumbers setColumnNames(String columnNames) {
        this.columnNames = WriteRawNumbers.nonNull(columnNames);
        return this;
    }

    public String columnNamesOrNull() {
        String result = this.columnNames.trim();
        return result.isEmpty() ? null : result;
    }

    @Override
    public void initialize() {
        if (this.clearFileOnReset) {
            this.completeFilePath().toFile().delete();
        }
    }

    @Override
    public void process() {
        SNumbers numbers = this.getInputNumbers(this.deleteFileIfNonInitialized || !this.requireInput);
        if (this.requireInput || numbers.isInitialized()) {
            this.writeRaw(numbers);
        }
    }

    public void writeRaw(SNumbers numbers) {
        block13: {
            Path rawFile = this.completeFilePath();
            Path metadataFile = Paths.get(String.valueOf(rawFile) + METADATA_FILE_SUFFIX, new String[0]);
            try {
                boolean exists = Files.exists(rawFile, new LinkOption[0]);
                if (!numbers.isInitialized() && this.deleteFileIfNonInitialized) {
                    if (exists) {
                        String copyOfPreviousFile = this.copyOfPreviousFileIfNonInitialized.trim();
                        if (!copyOfPreviousFile.isEmpty()) {
                            Files.copy(rawFile, Paths.get(copyOfPreviousFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        }
                        WriteRawNumbers.logDebug(() -> "Removing file " + String.valueOf(rawFile.toAbsolutePath()));
                        Files.delete(rawFile);
                        if (this.writeMetadataFile && Files.exists(metadataFile, new LinkOption[0])) {
                            WriteRawNumbers.logDebug(() -> "Removing metadata file " + String.valueOf(metadataFile.toAbsolutePath()));
                            Files.delete(metadataFile);
                        }
                    }
                    break block13;
                }
                WriteRawNumbers.logDebug(() -> "Writing number array (" + String.valueOf(numbers) + ") to file " + String.valueOf(rawFile.toAbsolutePath()));
                try (FileOutputStream stream = new FileOutputStream(rawFile.toFile(), this.appendToExistingFile);){
                    this.writeRaw(stream, numbers);
                }
                if (this.writeMetadataFile) {
                    String columnNames = this.getInputScalar(INPUT_COLUMN_NAMES, true).getValue();
                    if (columnNames == null) {
                        columnNames = this.columnNamesOrNull();
                    }
                    String[] columnNamesArray = columnNames == null ? null : SScalar.splitJsonOrTrimmedLinesWithoutCommentsArray(columnNames);
                    JsonObject metadata = this.createMetadata(numbers, columnNamesArray);
                    WriteRawNumbers.logDebug(() -> "Writing metadata to file " + String.valueOf(metadataFile.toAbsolutePath()));
                    Files.writeString(metadataFile, (CharSequence)Jsons.toPrettyString(metadata), new OpenOption[0]);
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public void writeRaw(FileOutputStream outputStream, SNumbers numbers) throws IOException {
        Objects.requireNonNull(numbers, "Null numbers");
        Objects.requireNonNull(outputStream, "Null outputStream argument");
        Objects.requireNonNull(numbers, "Null numbers argument");
        outputStream.getChannel().write(numbers.toByteBuffer(this.byteOrder.order()));
    }

    public JsonObject createMetadata(SNumbers numbers, String[] columnNames) {
        return this.createMetadata(numbers, this.byteOrder, columnNames);
    }

    public JsonObject createMetadata(SNumbers numbers, ByteOrder byteOrder, String[] columnNames) {
        Objects.requireNonNull(numbers, "Null numbers");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("blockLength", numbers.getBlockLength());
        builder.add("n", numbers.n());
        builder.add("elementType", numbers.elementType().getSimpleName());
        builder.add("byteOrder", byteOrder.name());
        builder.add("order", byteOrder.order().toString());
        if (columnNames != null) {
            JsonArrayBuilder columnNamesBuilder = Json.createArrayBuilder();
            JsonObjectBuilder columnIndexesBuilder = Json.createObjectBuilder();
            for (int k = 0; k < columnNames.length; ++k) {
                columnNamesBuilder.add(columnNames[k]);
                columnIndexesBuilder.add(columnNames[k], this.columnsIndexingBaseInMetadata.start + k);
            }
            builder.add("columnNames", (JsonValue)columnNamesBuilder.build());
            builder.add("columnIndexes", (JsonValue)columnIndexesBuilder.build());
        }
        return builder.build();
    }

    @Override
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return this.defaultVisibleResultsInformation(Port.Type.INPUT, DEFAULT_INPUT_PORT).addPorts(this.getInputPort(INPUT_COLUMN_NAMES));
    }

    public static int getMetadataBlockLength(JsonObject metadata) {
        return Jsons.reqInt(metadata, "blockLength");
    }

    public static Class<?> getMetadataElementType(JsonObject metadata) {
        String elementTypeName = Jsons.reqString(metadata, "elementType");
        for (Class<?> elementType : SNumbers.SUPPORTED_ELEMENT_TYPES) {
            if (!elementType.getSimpleName().equals(elementTypeName)) continue;
            return elementType;
        }
        throw new JsonException("Unknown element type \"" + elementTypeName + "\"");
    }

    public static java.nio.ByteOrder getMetadataByteOrder(JsonObject metadata) {
        return ByteOrder.toByteOrder(Jsons.reqString(metadata, "order"));
    }

    public static List<String> getMetadataColumnNames(JsonObject metadata) {
        JsonArray columnNames = metadata.getJsonArray("columnNames");
        if (columnNames == null) {
            return null;
        }
        return columnNames.stream().map(jsonValue -> {
            if (!(jsonValue instanceof JsonString)) {
                throw new JsonException("Invalid type \"" + String.valueOf(jsonValue.getValueType()) + "\" of header \"" + String.valueOf(jsonValue) + "\"");
            }
            return ((JsonString)jsonValue).getString();
        }).collect(Collectors.toList());
    }

    public static JsonObject getMetadataColumnIndexes(JsonObject metadata) {
        return metadata.getJsonObject("columnIndexes");
    }

    public static enum ByteOrder {
        BIG_ENDIAN(java.nio.ByteOrder.BIG_ENDIAN),
        LITTLE_ENDIAN(java.nio.ByteOrder.LITTLE_ENDIAN),
        NATIVE(java.nio.ByteOrder.nativeOrder());

        private final java.nio.ByteOrder order;
        private static final String BIG_ENDIAN_NAME;
        private static final String LITTLE_ENDIAN_NAME;

        private ByteOrder(java.nio.ByteOrder order) {
            this.order = order;
        }

        public java.nio.ByteOrder order() {
            return this.order;
        }

        public static java.nio.ByteOrder toByteOrder(String name) {
            Objects.requireNonNull(name, "Null name");
            if (BIG_ENDIAN_NAME.equals(name)) {
                return java.nio.ByteOrder.BIG_ENDIAN;
            }
            if (LITTLE_ENDIAN_NAME.equals(name)) {
                return java.nio.ByteOrder.LITTLE_ENDIAN;
            }
            throw new IllegalArgumentException("Illegal byte order: " + name);
        }

        static {
            BIG_ENDIAN_NAME = java.nio.ByteOrder.BIG_ENDIAN.toString();
            LITTLE_ENDIAN_NAME = java.nio.ByteOrder.LITTLE_ENDIAN.toString();
        }
    }
}

