/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

import java.util.Arrays;
import java.util.Objects;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;

public final class InvertTable
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String INPUT_TABLE = "table";
    public static final String OUTPUT_TABLE = "table";
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;

    public InvertTable() {
        this.setDefaultInputNumbers("table");
        this.setDefaultOutputNumbers("table");
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public InvertTable setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = InvertTable.nonNull(indexingBase);
        return this;
    }

    @Override
    protected SNumbers processNumbers(SNumbers table) {
        Objects.requireNonNull(table, "Null table");
        return SNumbers.ofArray(InvertTable.invert(table.toIntArray(), this.indexingBase.start), 1);
    }

    public static int[] invert(int[] table, int indexingBase) {
        Objects.requireNonNull(table, "Null table");
        if (indexingBase < 0) {
            throw new IllegalArgumentException("Indexing base cannot be negative: " + indexingBase);
        }
        int max = 0;
        for (int v : table) {
            if (v <= max) continue;
            max = v;
        }
        int[] result = new int[max - indexingBase + 1];
        Arrays.fill(result, -1);
        for (int k = 0; k < table.length; ++k) {
            int index = table[k] - indexingBase;
            if (index < 0 || result[index] != -1) continue;
            result[index] = k + indexingBase;
        }
        return result;
    }
}

