/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SNumbers;

public final class SetNumber
extends Executor {
    private int blockIndex = 0;
    private int indexInBlock = 0;
    private Integer rawIndex = null;
    private double value = 0.0;

    public int getBlockIndex() {
        return this.blockIndex;
    }

    public SetNumber setBlockIndex(int blockIndex) {
        this.blockIndex = SetNumber.nonNegative(blockIndex);
        return this;
    }

    public int getIndexInBlock() {
        return this.indexInBlock;
    }

    public SetNumber setIndexInBlock(int indexInBlock) {
        this.indexInBlock = SetNumber.nonNegative(indexInBlock);
        return this;
    }

    public Integer getRawIndex() {
        return this.rawIndex;
    }

    public SetNumber setRawIndex(Integer rawIndex) {
        this.rawIndex = rawIndex == null ? null : Integer.valueOf(SetNumber.nonNegative(rawIndex));
        return this;
    }

    public double getValue() {
        return this.value;
    }

    public SetNumber setValue(double value) {
        this.value = value;
        return this;
    }

    @Override
    public void process() {
        SNumbers numbers = this.getInputNumbers();
        int indexInArray = this.rawIndex != null ? this.rawIndex : this.blockIndex * numbers.getBlockLength() + this.indexInBlock;
        numbers.setValue(indexInArray, this.value);
        this.getNumbers().exchange(numbers);
    }
}

