/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.arithmetic;

import net.algart.executors.api.Executor;
import net.algart.executors.modules.core.logic.ConditionStyle;

public final class CompareTwoNumbers
extends Executor {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    public static final String OUTPUT_EQUAL = "equal";
    public static final String OUTPUT_NON_EQUAL = "non_equal";
    public static final String OUTPUT_LESS = "less";
    public static final String OUTPUT_LESS_OR_EQUAL = "less_or_equal";
    public static final String OUTPUT_GREATER = "greater";
    public static final String OUTPUT_GREATER_OR_EQUAL = "greater_or_equal";
    private ConditionStyle booleanStyle = ConditionStyle.JAVA_LIKE;
    private double defaultX = 0.0;
    private double defaultY = 0.0;

    public CompareTwoNumbers() {
        this.addInputScalar(INPUT_X);
        this.addInputScalar(INPUT_Y);
        this.addOutputScalar(OUTPUT_EQUAL);
        this.addOutputScalar(OUTPUT_NON_EQUAL);
        this.addOutputScalar(OUTPUT_LESS);
        this.addOutputScalar(OUTPUT_LESS_OR_EQUAL);
        this.addOutputScalar(OUTPUT_GREATER);
        this.addOutputScalar(OUTPUT_GREATER_OR_EQUAL);
        this.useVisibleResultParameter();
    }

    public ConditionStyle getBooleanStyle() {
        return this.booleanStyle;
    }

    public CompareTwoNumbers setBooleanStyle(ConditionStyle booleanStyle) {
        this.booleanStyle = CompareTwoNumbers.nonNull(booleanStyle);
        return this;
    }

    public double getDefaultX() {
        return this.defaultX;
    }

    public CompareTwoNumbers setDefaultX(double defaultX) {
        this.defaultX = defaultX;
        return this;
    }

    public double getDefaultY() {
        return this.defaultY;
    }

    public CompareTwoNumbers setDefaultY(double defaultY) {
        this.defaultY = defaultY;
        return this;
    }

    @Override
    public void process() {
        double x = this.getInputScalar(INPUT_X, true).toDoubleOrDefault(this.defaultX);
        double y = this.getInputScalar(INPUT_Y, true).toDoubleOrDefault(this.defaultY);
        this.booleanStyle.setScalar(this.getScalar(OUTPUT_EQUAL), x == y);
        this.booleanStyle.setScalar(this.getScalar(OUTPUT_NON_EQUAL), x != y);
        this.booleanStyle.setScalar(this.getScalar(OUTPUT_LESS), x < y);
        this.booleanStyle.setScalar(this.getScalar(OUTPUT_LESS_OR_EQUAL), x <= y);
        this.booleanStyle.setScalar(this.getScalar(OUTPUT_GREATER), x > y);
        this.booleanStyle.setScalar(this.getScalar(OUTPUT_GREATER_OR_EQUAL), x >= y);
    }
}

