/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.arithmetic;

import net.algart.executors.api.Executor;

abstract class MinMaxNumber
extends Executor {
    public static final String INPUT_PORT_PREFIX = "x";
    private double threshold;

    public MinMaxNumber(double threshold) {
        this.threshold = threshold;
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public void process() {
        String portName;
        double result = this.threshold;
        int k = 0;
        while (this.hasInputPort(portName = INPUT_PORT_PREFIX + (k + 1))) {
            String input = this.getInputScalar(portName, true).getValue();
            if (input != null) {
                result = this.combine(result, Double.parseDouble(input));
            }
            ++k;
        }
        this.getScalar().setTo(result);
    }

    abstract double combine(double var1, double var3);
}

