/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.logical;

import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.logic.ConditionStyle;

abstract class AbstractBoolean
extends Executor {
    private ConditionStyle booleanStyle = ConditionStyle.JAVA_LIKE;
    private boolean commonInputStyle = true;
    private boolean defaultInput = false;

    public AbstractBoolean() {
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public ConditionStyle getBooleanStyle() {
        return this.booleanStyle;
    }

    public AbstractBoolean setBooleanStyle(ConditionStyle booleanStyle) {
        this.booleanStyle = AbstractBoolean.nonNull(booleanStyle);
        return this;
    }

    public boolean isCommonInputStyle() {
        return this.commonInputStyle;
    }

    public AbstractBoolean setCommonInputStyle(boolean commonInputStyle) {
        this.commonInputStyle = commonInputStyle;
        return this;
    }

    public boolean isDefaultInput() {
        return this.defaultInput;
    }

    public AbstractBoolean setDefaultInput(boolean defaultInput) {
        this.defaultInput = defaultInput;
        return this;
    }

    @Override
    public void process() {
        this.booleanStyle.setScalar(this.getScalar(), this.processBooleans());
    }

    public boolean toBoolean(String inputString) {
        return this.commonInputStyle ? SScalar.toCommonBoolean(inputString, this.defaultInput) : this.booleanStyle.toBoolean(inputString, this.defaultInput);
    }

    abstract boolean processBooleans();
}

